package net.abstractfactory.plum.view.web.component.container.window.dialog;

import java.util.Map;

import net.abstractfactory.plum.view.component.Button;
import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.component.Label;
import net.abstractfactory.plum.view.component.containers.Panel;
import net.abstractfactory.plum.view.component.containers.window.Dialog;
import net.abstractfactory.plum.view.component.containers.window.Window;
import net.abstractfactory.plum.view.event.AbstractViewAction;
import net.abstractfactory.plum.view.event.ViewAction;
import net.abstractfactory.plum.view.event.WebEvent;
import net.abstractfactory.plum.view.web.component.AbstractTemplateWebComponent;
import net.abstractfactory.plum.view.web.component.ComponentElements;
import net.abstractfactory.plum.view.web.component.WebComponent;
import net.abstractfactory.plum.view.web.component.builder.AbstractConditionBuilder;
import net.abstractfactory.plum.view.web.component.builder.ConditionalComponentBuilderCollection;
import net.abstractfactory.plum.view.web.component.builder.WebViewBuilder;

import org.jsoup.nodes.Element;

public class WebDialogCloseButton extends AbstractTemplateWebComponent {

	private static Element componentHtmlTemplate;

	private final String BUTTON = "button";
	Element buttonElement;

	public WebDialogCloseButton(String id, Component component,
			Element templateTemplate) {
		super(id, component, templateTemplate);

	}

	private Button getButton() {
		return (Button) getComponent();
	}

	public void createHtmlElement() {

		ComponentElements componentElements = findAndCloneElement(
				getComponentHtmlTemplate(true), true);

		htmlOuterElement = componentElements.getOuter();
		htmlInnerElement = componentElements.getInner();

		buttonElement = htmlOuterElement;

		buttonElement.appendText(null2Empty(getComponent().getCaption()));

		String onclick = String.format("_plum_post('%s','%s','click')", getId(),
				BUTTON);
		buttonElement.attr("onclick", onclick);

		if (getButton().isDisabled())
			buttonElement.attr("disabled", "disabled");

		buttonElement.attr("name", getFullInputName(BUTTON));

	}

	@Override
	public ViewAction processEvent(WebEvent event,
			Map<String, Object> parameters) {
		if (event == WebEvent.CLICK) {

			return new AbstractViewAction(event.name()) {

				@Override
				public void execute(Component view) {
					Button btn = (Button) view;
					btn.click();

				}
			};

		} else
			throw new RuntimeException("unknow event:" + event);

	}

	@Override
	public Element getComponentHtmlTemplate() {

		return componentHtmlTemplate;
	}

	@Override
	public void setComponentHtmlTemplate(Element element) {
		componentHtmlTemplate = element;

	}

	@Override
	public String getComponentType() {

		return "dialogCloseButton";
	}

	private static class ComponentBuilder extends AbstractConditionBuilder {
		
		@Override
		public Class getComponentClass() {			 
			return Button.class;
		}
		
		@Override
		public boolean isMatch(Component component) {
			boolean nameResult = checkNames(component, Window.NAME_CLOSE_BUTTON);

			if (nameResult) {
				boolean checkClass = checkClasses(component, Button.class,
						Panel.class, Dialog.class);

				return checkClass;
			} else
				return false;
		}

		@Override
		public WebComponent visit(WebViewBuilder builder, Component component) {
			return builder.commonVisitWithoutPreprocess(
					WebDialogCloseButton.class, component);
		}

	}

	public static void registerBuilder(
			ConditionalComponentBuilderCollection collection) {

		collection.add(new ComponentBuilder());

	}
}
