package net.abstractfactory.plum.view.web.component.container.window.dialog;

import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.component.containers.window.Dialog;
import net.abstractfactory.plum.view.component.containers.window.Window;
import net.abstractfactory.plum.view.web.CSSAttributes;
import net.abstractfactory.plum.view.web.component.AbstractTemplateWebComponent;
import net.abstractfactory.plum.view.web.component.ComponentElements;
import net.abstractfactory.plum.view.web.component.builder.ConditionalComponentBuilderCollection;

import org.jsoup.nodes.Element;

public class WebDialog extends AbstractTemplateWebComponent {

	private static Element componentHtmlTemplate;
	private Element middleElement;
	private Element titleElement;

	private String title;

	// private Element mask;

	public WebDialog(String id, Component component, Element templateTemplate) {
		super(id, component, templateTemplate);

		Window window = (Window) component;

		this.title = window.getTitle();
	}

	protected Dialog getDialog() {
		return (Dialog) component;
	}

	public void createHtmlElement() {

		ComponentElements componentElements = findAndCloneElement(getComponentHtmlTemplate(true), true);

		htmlOuterElement = componentElements.getOuter();
		middleElement = findElementByClass("middle");
		htmlInnerElement = componentElements.getInner();

		// mask = findElementByClass("mask");

		String styleContent = htmlOuterElement.attr("style");
		CSSAttributes style = new CSSAttributes(styleContent);
		style.set("display", "block");
		htmlOuterElement.attr("style", style.toCssText());

		// mask.attr("style")
		// CSSAttributes style = new
		// CSSAttributes(htmlOuterElement.attr("style"));

		// mask.attr("style", style.toCssText());

	}

	@Override
	public void init() {
		createHtmlElement();

		updateIdInHtml(id);

		// style
		CSSAttributes attrs = createCommonStyles();
		applyStyle(middleElement, attrs);

		if (getComponent().isDisabled())
			htmlOuterElement.attr("disabled", "disabled");

	}

	public String getTitle() {
		return title;
	}

	@Override
	public Element getComponentHtmlTemplate() {

		return componentHtmlTemplate;
	}

	@Override
	public void setComponentHtmlTemplate(Element element) {
		componentHtmlTemplate = element;

	}

	@Override
	public String getComponentType() {

		return "dialog";
	}

	public static void registerBuilder(ConditionalComponentBuilderCollection collection) {

		WebDialogTitlePanel.registerBuilder(collection);
		WebDialogContentPanel.registerBuilder(collection);
	}
}
