package net.abstractfactory.plum.view.web.component.container.window;

import java.util.Map;

import net.abstractfactory.plum.view.component.Button;
import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.component.containers.window.Window;
import net.abstractfactory.plum.view.event.AbstractViewAction;
import net.abstractfactory.plum.view.event.ViewAction;
import net.abstractfactory.plum.view.event.WebEvent;
import net.abstractfactory.plum.view.web.component.AbstractTemplateWebComponent;
import net.abstractfactory.plum.view.web.component.ComponentElements;

import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class WebWindow extends AbstractTemplateWebComponent {

	private static Element componentHtmlTemplate;

	private String title;
	
	private Element childrenElement;

	public WebWindow(String id, Component component, Element templateTemplate) {
		super(id, component, templateTemplate);


		this.title = getWindow().getTitle();
	}

	protected Window getWindow() {
		return (Window) component;
	}

	public void createHtmlElement() {

		ComponentElements componentElements = findAndCloneElement(
				getComponentHtmlTemplate(true), true);

		htmlOuterElement = componentElements.getOuter();
		htmlInnerElement = componentElements.getInner();

		childrenElement = findElementByClass("children");
	}

	public String getTitle() {
		return title;
	}

	@Override
	public Element getComponentHtmlTemplate() {

		return componentHtmlTemplate;
	}

	@Override
	public void setComponentHtmlTemplate(Element element) {
		componentHtmlTemplate = element;

	}

	@Override
	public String getComponentType() {

		return "window";
	}
}
