package net.abstractfactory.plum.view.web.component.container.window;

import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.component.Label;
import net.abstractfactory.plum.view.component.containers.Panel;
import net.abstractfactory.plum.view.component.containers.window.MainWindow;
import net.abstractfactory.plum.view.component.containers.window.Window;
import net.abstractfactory.plum.view.web.component.AbstractWebComponent;
import net.abstractfactory.plum.view.web.component.WebComponent;
import net.abstractfactory.plum.view.web.component.builder.AbstractConditionBuilder;
import net.abstractfactory.plum.view.web.component.builder.ConditionalComponentBuilderCollection;
import net.abstractfactory.plum.view.web.component.builder.WebViewBuilder;

import org.jsoup.nodes.Element;
import org.jsoup.parser.Tag;

/**
 * hide it
 * 
 * @author jack
 *
 */
public class WebMainWindowTitlePanel extends AbstractWebComponent {
	public WebMainWindowTitlePanel(String id, Component component) {
		super(id, component);
	}

	protected Window getWindow() {
		return (Window) component;
	}

	public void createHtmlElement() {

		Element div = new Element(Tag.valueOf("div"), "");
		div.attr("class", "panel main-window-title-panel");
		div.attr("style", "display:none");

		htmlOuterElement = div;
		htmlInnerElement = div;
	}

	private static class ComponentBuilder extends AbstractConditionBuilder {
		@Override
		public Class getComponentClass() {			 
			return Panel.class;
		}
		@Override
		public boolean isMatch(Component component) {
			return checkClasses(component, Panel.class, MainWindow.class)
					&& checkNames(component, Window.NAME_TITLE_PANEL);

		}

		@Override
		public WebComponent visit(WebViewBuilder builder, Component component) {
			return builder.commonVisitWithoutPreprocess(
					WebMainWindowTitlePanel.class, component);
		}

	}

	public static void registerBuilder(
			ConditionalComponentBuilderCollection collection) {

		collection.add(new ComponentBuilder());

	}

}
