package net.abstractfactory.plum.view.web.component.container;

import java.util.Map;

import net.abstractfactory.plum.view.component.Button;
import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.event.AbstractViewAction;
import net.abstractfactory.plum.view.event.ViewAction;
import net.abstractfactory.plum.view.event.WebEvent;
import net.abstractfactory.plum.view.layout.HorizontalBox;
import net.abstractfactory.plum.view.web.component.AbstractWebComponent;

import org.jsoup.nodes.Element;
import org.jsoup.parser.Tag;
import org.w3c.dom.html.HTMLElement;

public class WebScreen extends AbstractWebComponent {
	public WebScreen(String id, Component component) {
		super(id, component);
	}

	public void createHtmlElement() {

		htmlOuterElement = new Element(Tag.valueOf("div"), "");		
		htmlInnerElement = htmlOuterElement;
		
		Element div = htmlOuterElement;
		div.addClass("container-fluid");		
	}
	
	@Override
	public ViewAction processEvent(WebEvent event,
			final Map<String, Object> parameters) {
		if (event == WebEvent.RESIZE) {

			return new AbstractViewAction(event.name()) {

				@Override
				public void execute(Component view) {
					String width = (String)parameters.get("width");
					String height = (String)parameters.get("height");
					
					//logger.debug("screen resized to "+width+","+height);

				}
			};

		} else
			throw new RuntimeException("unknow event:" + event);

	}

}
