package net.abstractfactory.plum.view.web.component.builder;

import org.apache.commons.lang3.StringUtils;

import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.component.containers.Panel;
import net.abstractfactory.plum.view.web.component.WebComponent;
import net.abstractfactory.plum.view.web.component.container.window.dialog.WebDialogTitlePanel;

public abstract class AbstractConditionBuilder implements
		ConditionalWebComponentBuilder {

	protected boolean checkClasses(Component component,
			Class<? extends Component>... classes) {
		boolean result = true;

		Component parent = component;

		for (int i = 0; i < classes.length; i++) {
			if (parent == null) {
				result = false;
				break;
			}

			Class<? extends Component> cls = classes[i];

			if (!cls.isAssignableFrom(parent.getClass())) {
				result = false;
				break;
			}

			parent = (Component) parent.getParent();
		}
		return result;
	}

	/**
	 * component name from this to ancesters
	 * 
	 * @param component
	 * @param names
	 * @return
	 */
	protected boolean checkNames(Component component, String... names) {
		boolean result = true;

		Component parent = component;
		for (int i = 0; i < names.length; i++) {
			if (parent == null) {
				result = false;
				break;
			}

			String name = names[i];

			if (!StringUtils.equals(name, parent.getName())) {
				result = false;
				break;
			}

			parent = (Component) parent.getParent();
			i++;
		}
		return result;
	}

	@Override
	public WebComponent visit(WebViewBuilder builder, Component component) {
		return builder.commonVisit(WebDialogTitlePanel.class, Panel.class,
				component);
	}

}
