package net.abstractfactory.plum.view.web.component;

import java.util.List;
import java.util.Map;

import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.component.tab.Tab;
import net.abstractfactory.plum.view.component.tab.Tabs;
import net.abstractfactory.plum.view.event.AbstractViewAction;
import net.abstractfactory.plum.view.event.ViewAction;
import net.abstractfactory.plum.view.event.WebEvent;

import org.apache.log4j.Logger;
import org.jsoup.nodes.Element;

/**
 * 
 * @author jack
 *
 */
public class WebTabs extends AbstractTemplateWebComponent {
	static Logger logger = Logger.getLogger(WebTabs.class);

	private static final String PARAMETER_INDEX = "index";

	private static Element componentHtmlTemplate;

	private Element header;
	private Element headerItemActive;
	private Element headerItemInactive;

	private Element body;
	private Element bodyItemActive;
	private Element bodyItemInactive;

	public WebTabs(String id, Component component, Element templateTemplate) {
		super(id, component, templateTemplate);

	}

	public Tabs getTabs() {
		return (Tabs) getComponent();
	}

	public void createHtmlElement() {

		ComponentElements componentElements = findAndCloneElement(
				getComponentHtmlTemplate(true), true);

		htmlOuterElement = componentElements.getOuter();
		htmlInnerElement = componentElements.getInner();

		header = findElementByClass("header");

		headerItemActive = findElementByClass("header-item-active");
		headerItemInactive = findElementByClass("header-item-inactive");

		body = findElementByClass("body");

		bodyItemActive = findElementByClass("body-item-active");
		bodyItemActive = findElementByClass("body-item-inactive");

		// build web component begins
		header.empty();

		List<Tab> items = getTabs().getItems();
		int activeIndex = getTabs().getActiveIndex();

		for (int i = 0; i < items.size(); i++) {
			Tab item = items.get(i);

			Element headerItem;
			if (i == activeIndex) {
				headerItem = headerItemActive.clone();
				// body.appendChild(headerItem)
			} else {
				headerItem = headerItemInactive.clone();
			}
			Element link = headerItem.getElementsByClass("link").first();
			link.text(item.getCaption());

			String params = String.format("%s=%d", PARAMETER_INDEX, i);

			String onChange = String.format("_plum_post('%s','%s','%s','%s')",
					getId(), "link", WebEvent.CLICK.name().toLowerCase(),
					params);
			link.attr("onClick", onChange);

			header.appendChild(headerItem);
		}

	}

	protected ViewAction onTabChange(final int newIndex) {

		return new AbstractViewAction(WebEvent.CLICK.name()) {

			@Override
			public void execute(Component view) {

				Tabs tabs = (Tabs) view;
				tabs.setActiveTab(newIndex, true);

			}
		};

	}

	@Override
	public ViewAction processEvent(WebEvent event,
			Map<String, Object> parameters) {
		if (event == WebEvent.CLICK) {
			String strIndex = (String) parameters.get(PARAMETER_INDEX);
			Integer index = Integer.valueOf(strIndex);
			return onTabChange(index);

		} else
			throw new RuntimeException("unknow event:" + event);

	}

	@Override
	public Element getComponentHtmlTemplate() {

		return componentHtmlTemplate;
	}

	@Override
	public void setComponentHtmlTemplate(Element element) {
		componentHtmlTemplate = element;

	}

	@Override
	public String getComponentType() {

		return "Tabs";
	}
}
