package net.abstractfactory.plum.view.web.component;

import java.util.Map;

import net.abstractfactory.plum.view.component.Button;
import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.component.tab.Tab;
import net.abstractfactory.plum.view.event.AbstractViewAction;
import net.abstractfactory.plum.view.event.ViewAction;
import net.abstractfactory.plum.view.event.WebEvent;

import org.jsoup.nodes.Element;

public class WebTab extends AbstractTemplateWebComponent {

	private static Element componentHtmlTemplate;

	// private final String BUTTON = "button";
	// Element buttonElement;

	public WebTab(String id, Component component, Element templateTemplate) {
		super(id, component, templateTemplate);

	}

	private Tab getTab() {
		return (Tab) getComponent();
	}

	public void createHtmlElement() {

		ComponentElements componentElements = findAndCloneElement(
				getComponentHtmlTemplate(true), true);

		htmlOuterElement = componentElements.getOuter();
		htmlInnerElement = componentElements.getInner();


	}

	@Override
	public ViewAction processEvent(WebEvent event,
			Map<String, Object> parameters) {
		if (event == WebEvent.CLICK) {

			return new AbstractViewAction(event.name()) {

				@Override
				public void execute(Component view) {
					Button btn = (Button) view;
					btn.click();

				}
			};

		} else
			throw new RuntimeException("unknow event:" + event);

	}

	@Override
	public Element getComponentHtmlTemplate() {

		return componentHtmlTemplate;
	}

	@Override
	public void setComponentHtmlTemplate(Element element) {
		componentHtmlTemplate = element;
	}

	@Override
	public String getComponentType() {
		return "tab";
	}
}
