package net.abstractfactory.plum.view.web.component;

import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.component.containers.Panel;

import org.jsoup.nodes.Element;
import org.jsoup.parser.Tag;

public class WebPanel extends AbstractWebComponent {
	public WebPanel(String id, Component component) {
		super(id, component);
	}

	protected Panel getPanel() {
		return (Panel) component;
	}

	public void createHtmlElement() {

		Element div = new Element(Tag.valueOf("div"), "");
		div.attr("class", "panel");

		htmlOuterElement = div;
		htmlInnerElement = div;
		
		if(!getPanel().isVisible())
			htmlOuterElement.addClass("hide");
	}

}
