package net.abstractfactory.plum.view.web.component;

import org.apache.commons.lang3.StringEscapeUtils;
import org.jsoup.nodes.Element;

import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.component.HyperLink;

public class WebHyperLink extends AbstractTemplateWebComponent {

	private static Element componentHtmlTemplate;

	private final String LINK = "a";
	Element linkElement;

	public WebHyperLink(String id, Component component, Element templateTemplate) {
		super(id, component, templateTemplate);

	}

	private HyperLink getHyperLink() {
		return (HyperLink) getComponent();
	}

	public void createHtmlElement() {

		ComponentElements componentElements = findAndCloneElement(getComponentHtmlTemplate(true), true);

		htmlOuterElement = componentElements.getOuter();
		// htmlInnerElement = componentElements.getInner();

		linkElement = htmlOuterElement;

		String text = null2Empty(getHyperLink().getTitle());
		text = StringEscapeUtils.escapeHtml4(text);
		linkElement.text(text);

		linkElement.attr("href", getHyperLink().getUrl());

		// applyEvents(linkElement, LINK, Button.EVENT_CLICK);

	}

	@Override
	public Element getComponentHtmlTemplate() {

		return componentHtmlTemplate;
	}

	@Override
	public void setComponentHtmlTemplate(Element element) {
		componentHtmlTemplate = element;

	}

	@Override
	public String getComponentType() {

		return "hyperlink";
	}
}
