package net.abstractfactory.plum.view.web.component;

import java.io.IOException;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import net.abstractfactory.common.ListValueMap;
import net.abstractfactory.common.TreeNode;
import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.event.ViewAction;
import net.abstractfactory.plum.view.event.WebEvent;

import org.jsoup.nodes.Element;

public interface WebComponent {

	String getId();
	
	void setId(String id);

	Component getComponent();

	void createHtmlElement();

	Element getHtmlOuterElement();

	WebComponent getParentWebComponent();
	
	List<WebComponent> getChildrenWebComponents();
	
	void replaceChild(WebComponent oldChild,WebComponent newChild);
	
	void addChild(TreeNode node);

	ViewAction processEvent(WebEvent event,
			ListValueMap<String, Object> parameters);

	void writeFile(HttpServletRequest req, HttpServletResponse response,
			String shortName) throws IOException;

	String getOwnHash();
	void setOwnHash(String ownHash);
	String getChildrenIdsHash();
	void setChildrenIdsHash(String ChildrenIdsHash);
}