package net.abstractfactory.plum.view.web.component;

import java.util.Map;

import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

import net.abstractfactory.plum.input.value.File;
import net.abstractfactory.plum.view.component.Component;

public abstract class AbstractTemplateWebComponent extends AbstractWebComponent {
	/**
	 * theme template is a web page , which contains all components.
	 */
	protected Element themeTemplate;

	public AbstractTemplateWebComponent(String id, Component component,
			Element themeTemplate) {
		super(id, component);

		this.themeTemplate = themeTemplate;
	}

	/**
	 * get class level HTML template. it is shared by all instance of the
	 * subclasses.
	 */
	public abstract Element getComponentHtmlTemplate();

	public abstract void setComponentHtmlTemplate(Element componentHtmlTemplate);

	/**
	 * e.g. window, menuBar,etc.
	 * 
	 * @return
	 */
	public abstract String getComponentType();

	/**
	 * create it if not exists.
	 * 
	 * @return
	 */
	public Element getComponentHtmlTemplate(boolean createIfNotExists) {
		if (getComponentHtmlTemplate() == null && createIfNotExists) {
			ComponentElements componentTemplate = findAndCloneElement(
					themeTemplate, false);

			setComponentHtmlTemplate(componentTemplate.getOuter());
		}

		return getComponentHtmlTemplate();
	}

	/**
	 * find the html elements for the web component.
	 * 
	 * @param element
	 * @param componentName
	 * @return
	 */
	protected ComponentElements findAndCloneElement(Element template,
			boolean emptyInnerHtml) {

		String outerClass = getOuterClass();

		Element outer = null;
		Element inner = null;

		// step 1: try find outer element
		Elements elements = template.getElementsByClass(outerClass);
		if (elements == null || elements.isEmpty())
			throw new RuntimeException("unable to find by class: " + outerClass);

		outer = elements.first().clone();
		// Element form = outer.getElementsByTag("form").first();

		// step 2: try find inner element, which is optional.
		Elements inners = outer.getElementsByClass(getInnerClass());
		if (inners != null)
			inner = inners.first();

		ComponentElements componentElements = new ComponentElements(outer,
				inner);

		// clear children
		if (inner != null && emptyInnerHtml)
			inner.empty();

		return componentElements;
	}

	protected String getOuterClass() {
		return getElementClass("outer");
	}

	protected String getInnerClass() {
		return getElementClass("inner");
	}

	protected String getElementClass(String shortName) {
		return getComponentType() + "-" + shortName;
	}

	protected Element findElementByClass(Element element, String shortName) {
		String className = getElementClass(shortName);
		Elements elements = element.getElementsByClass(className);
		if (elements != null)
			return elements.first();
		else
			return null;
	}

	protected Element findElementByClass(String shortName) {
		return findElementByClass(htmlOuterElement, shortName);
	}
	
	public void createHtmlElement() {

		ComponentElements componentElements = findAndCloneElement(
				getComponentHtmlTemplate(true), true);

		htmlOuterElement = componentElements.getOuter();
		htmlInnerElement = componentElements.getInner();

	}

	/**
	 * 
	 * somehow when parse multipart form post, no way to distinguish a empty
	 * file field and string field.
	 * 
	 * @param parameters
	 * @param name
	 * @return
	 */
	protected File getParameterAsFile(Map<String, Object> parameters, String name) {
		Object value = parameters.get(name);

		if (value instanceof File) {
			return (File) value;
		} else {
			return null;
		}
	}
}
