package net.abstractfactory.plum.view.web;

import java.io.IOException;
import java.io.InputStream;

import net.abstractfactory.plum.input.value.AbstractFile;

import org.apache.commons.fileupload.FileItem;

public class WebUploadFile extends AbstractFile {
	private FileItem fileItem;

	public WebUploadFile(FileItem fileItem) {
		this.fileItem = fileItem;

		size = fileItem.getSize();
		contentType = fileItem.getContentType();
	}

	@Override
	public InputStream getInputStream() throws IOException {

		return fileItem.getInputStream();
	}

	@Override
	public String getName() {

		return fileItem.getName();
	}

}
