package net.abstractfactory.plum.view.web;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

import net.abstractfactory.plum.view.component.containers.window.Window;
import net.abstractfactory.plum.view.web.component.WebComponent;
import net.abstractfactory.plum.view.web.component.container.window.WebWindow;

import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

/**
 * load DOM from template page.
 * 
 * others clone nodes from this class.
 * 
 * @author jack
 *
 */
public class WebTemplatePage {

	
	private Document document;

	Element head;
	Element body;

	public WebTemplatePage(String file) {
		InputStream stream = getClass().getResourceAsStream(file);
		try {
			document = Jsoup.parse(stream, "utf-8", "");
		} catch (IOException e) {
			throw new RuntimeException(e);

		}
		head = document.getElementsByTag("head").get(0);
		body = document.getElementsByTag("body").get(0);

	}

	public Document getDocument() {
		return document;
	}

}
