package net.abstractfactory.plum.view.web;

import java.util.HashMap;
import java.util.Map;

import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

import net.abstractfactory.plum.view.client.ViewSyncMode;
import net.abstractfactory.plum.view.component.Component;
import net.abstractfactory.plum.view.web.component.WebComponent;
import net.abstractfactory.plum.view.web.component.input.WebCheckBox;

public class WebPageView {
	static final String START_JS = "_plum_start_js";

	// index for all web components
	private Map<String, WebComponent> webComponentMap = new HashMap<String, WebComponent>();
	// index for all check boxes
	private Map<String, WebCheckBox> webCheckBoxMap = new HashMap<String, WebCheckBox>();

	private Map<Component, WebComponent> componentToWebComponentMap = new HashMap<Component, WebComponent>();

	private Map<String, String> nodeHashes = new HashMap<String, String>();

	private WebComponent rootContentWebComponent;

	private Document doc;
	private String sessionId;

	Element head;
	Element body;
	Element form;
	Element startJs;

	String activeElementId;
	/**
	 * used for view pushing
	 */
	private String version;

	private ViewSyncMode viewSyncMode;

	public WebPageView(Document document, String pushTopic, ViewSyncMode viewSyncMode) {
		this.doc = document;
		this.sessionId = sessionId;
		this.viewSyncMode = viewSyncMode;

		head = doc.getElementsByTag("head").get(0);
		body = doc.getElementsByTag("body").get(0);
		form = body.getElementsByTag("form").get(0);
		startJs = body.getElementById(START_JS);

		// body.empty();

		// remove all except scripts
		for (Element e : body.children()) {
			if (!e.tagName().equalsIgnoreCase("script") && !e.attr("keep").equals("true"))
				e.remove();
		}

		// replace JS code
		String jsData = startJs.data().replaceAll("#topic#", pushTopic).replaceAll("#viewSyncMode#",
				viewSyncMode.name());
		startJs.empty();
		startJs.appendChild(new DataNode(jsData, ""));

	}

	public Map<String, WebComponent> getWebComponentMap() {
		return webComponentMap;
	}

	public Map<String, WebCheckBox> getWebCheckBoxMap() {
		return webCheckBoxMap;
	}

	public Map<Component, WebComponent> getComponentToWebComponentMap() {
		return componentToWebComponentMap;
	}

	public Map<String, String> getNodeHashes() {
		return nodeHashes;
	}

	public void setRootContentWebComponent(WebComponent rootContentWebComponent, String title) {
		this.rootContentWebComponent = rootContentWebComponent;

		if (title != null)
			doc.title(title);

		// Element form = formTemplate.clone();
		body.prependChild(form);
		form.prependChild(rootContentWebComponent.getHtmlOuterElement());
	}

	public WebComponent getRootContentWebComponent() {
		return rootContentWebComponent;
	}

	public Document getDoc() {
		return doc;
	}

	public String getActiveElementId() {
		return activeElementId;
	}

	public void setActiveElementId(String activeElementId) {
		this.activeElementId = activeElementId;		
	}

	public String getVersion() {
		return version;
	}

	public void setVersion(String version) {
		this.version = version;

		form.getElementById("_plum_view_version").val(version);
	}
}
