package net.abstractfactory.plum.view.web;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import net.abstractfactory.common.ListValueMap;

import org.apache.log4j.Logger;

/**
 * populate PLUM specific HTML FORM elements.
 * 
 * @author jack
 *
 */
public class PlumForm {
	private Logger logger = Logger.getLogger(getClass());

	public static final String SPECIAL_PARAMETER_PREFIX = "_plum_";

	static final String COMPONENT = SPECIAL_PARAMETER_PREFIX + "component";
	static final String TAG = SPECIAL_PARAMETER_PREFIX + "tag";
	static final String EVENT = SPECIAL_PARAMETER_PREFIX + "event";
	public static final String EVENT_PARAMETER = SPECIAL_PARAMETER_PREFIX + "event_parameter";
	public static final String VIEW_VERSION = SPECIAL_PARAMETER_PREFIX + "view_version";
	public static final String ACTIVE_COMPONENT = SPECIAL_PARAMETER_PREFIX + "active_component";

	static Set<String> specialParameterNames = new HashSet<String>();

	static {
		specialParameterNames.add(COMPONENT);
		specialParameterNames.add(TAG);
		specialParameterNames.add(EVENT);
		specialParameterNames.add(EVENT_PARAMETER);
		specialParameterNames.add(VIEW_VERSION);
		specialParameterNames.add(ACTIVE_COMPONENT);
	}

	private Map<String, String> specialParameters = new HashMap<String, String>();

	public PlumForm(ListValueMap<String, Object> parameterMap) {
		processComponentInputs(parameterMap);
	}

	// group by web component
	private Map<String, ListValueMap<String, Object>> componentParameters;

	private void processComponentInputs(ListValueMap<String, Object> parameterMap) {
		componentParameters = new HashMap<String, ListValueMap<String, Object>>();

		for (String name : parameterMap.keySet()) {

			List<Object> value = parameterMap.get(name);

			if (logger.isDebugEnabled()) {
				StringBuilder sb = new StringBuilder();
				for (Object obj : value)
					sb.append(obj.toString() + ",");

				logger.debug(name + "=" + sb.toString());
			}

			if (name.startsWith(SPECIAL_PARAMETER_PREFIX)) {
				if (specialParameterNames.contains(name)) {
					specialParameters.put(name, (String) value.get(0));
				}

				continue;
			}

			InputTagName inputTagName = InputTagName.valueOf(name);
			if (inputTagName == null)
				throw new RuntimeException("invalid input tag name:" + name);

			String componentId = inputTagName.getComponentId();
			String tagName = inputTagName.getWebTagName();

			ListValueMap<String, Object> parameters = componentParameters.get(componentId);
			if (parameters == null) {
				parameters = new ListValueMap<String, Object>();
				componentParameters.put(componentId, parameters);
			}
			parameters.put(tagName, value);
		}

	}

	public Map<String, String> getSpecialParameters() {
		return specialParameters;
	}

	public Map<String, ListValueMap<String, Object>> getComponentParameters() {
		return componentParameters;
	}

	public String getComponentId() {
		return specialParameters.get(PlumForm.COMPONENT);
	}

	public String getTag() {
		return specialParameters.get(PlumForm.TAG);
	}

	public String getEvent() {
		return specialParameters.get(PlumForm.EVENT);
	}

	public String getEventParameter() {
		return specialParameters.get(PlumForm.EVENT_PARAMETER);
	}

	public String getViewVersion() {
		return specialParameters.get(PlumForm.VIEW_VERSION);
	}

	public String getActiveComponentId() {
		return specialParameters.get(PlumForm.ACTIVE_COMPONENT);
	}
}
