package net.abstractfactory.plum.view.web;

public class InputTagName {
	private String componentId;
	private String webTagName;

	public InputTagName(String componentId, String webTagName) {
		this.componentId = componentId;
		this.webTagName = webTagName;
	}

	public static InputTagName valueOf(String inputName) {
		String[] ss = inputName.split("_");
		if (ss.length == 2) {
			String compId = ss[0];
			String inputId = ss[1];

			return new InputTagName(compId, inputId);
		} else
			return null;
	}
	
	public String getComponentId() {
		return componentId;
	}
	
	public String getWebTagName() {
		return webTagName;
	}
}