package net.abstractfactory.plum.view.web;

import java.util.HashMap;
import java.util.Map;

public class CSSAttributes {
	private Map<String, String> map = new HashMap<String, String>();

	public CSSAttributes() {
	}

	public CSSAttributes(String text) {
		String[] segments = text.split(";");
		for (String seg : segments) {

			if (!seg.trim().isEmpty()) {
				CSSAttribute attr = new CSSAttribute(seg);
				add(attr);
			}
		}
	}

	public void add(CSSAttribute attr) {
		map.put(attr.getName(), attr.getValue());
	}

	public void remove(String name) {
		map.remove(name);
	}

	public void set(String name, String value) {
		map.put(name, value);
	}

	public String get(String name) {
		return map.get(name);
	}

	public String toCssText() {
		StringBuilder sb = new StringBuilder();
		for (String name : map.keySet()) {
			String value = map.get(name);

			sb.append(name);
			sb.append(":");
			sb.append(value);
			sb.append(";");
		}
		return sb.toString();
	}

	public boolean isEmpty() {
		return map.isEmpty();
	}

	public static void main(String[] args) {
		CSSAttributes ca = new CSSAttributes(
				"display:block; background-color:grey; overflow-x: hidden; overflow-y: auto; ");

	}
}
