/*
 * Decompiled with CFR 0.152.
 */
package moe.sdl.yabapi.util.encoding;

import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import moe.sdl.yabapi.util.encoding.Base64;
import moe.sdl.yabapi.util.encoding.RSA;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0016J\u0018\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lmoe/sdl/yabapi/util/encoding/RSAProvider;", "Lmoe/sdl/yabapi/util/encoding/RSA;", "()V", "cipher", "Ljavax/crypto/Cipher;", "keyFactory", "Ljava/security/KeyFactory;", "decryptWithPrivateKey", "", "privateKey", "data", "encryptWithPublicKey", "publicKey", "getPrivateKey", "Ljava/security/PrivateKey;", "string", "getPublicKey", "Ljava/security/PublicKey;", "yabapi-core"})
public final class RSAProvider
implements RSA {
    @NotNull
    public static final RSAProvider INSTANCE = new RSAProvider();
    @NotNull
    private static final KeyFactory keyFactory;
    @NotNull
    private static final Cipher cipher;

    private RSAProvider() {
    }

    private final PublicKey getPublicKey(String string) {
        PublicKey publicKey = keyFactory.generatePublic(new X509EncodedKeySpec(new Base64(null, 1, null).base64Decode(string)));
        Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"keyFactory.generatePubli\u2026().base64Decode(string)))");
        return publicKey;
    }

    private final PrivateKey getPrivateKey(String string) {
        PrivateKey privateKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(new Base64(null, 1, null).base64Decode(string)));
        Intrinsics.checkNotNullExpressionValue((Object)privateKey, (String)"keyFactory.generatePriva\u2026().base64Decode(string)))");
        return privateKey;
    }

    @Override
    @NotNull
    public String encryptWithPublicKey(@NotNull String publicKey, @NotNull String data2) {
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        cipher.init(1, this.getPublicKey(publicKey));
        String string = data2;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = cipher.doFinal(byArray);
        Base64 base64 = new Base64(null, 1, null);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"final");
        return base64.base64Encode(byArray2);
    }

    @Override
    @NotNull
    public String decryptWithPrivateKey(@NotNull String privateKey, @NotNull String data2) {
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        cipher.init(2, this.getPrivateKey(privateKey));
        byte[] byArray = cipher.doFinal(new Base64(null, 1, null).base64Decode(data2));
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"final");
        return new String(byArray, Charsets.UTF_8);
    }

    static {
        Object object = KeyFactory.getInstance("RSA");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getInstance(\"RSA\")");
        keyFactory = object;
        object = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getInstance(\"RSA/ECB/PKCS1Padding\")");
        cipher = object;
    }
}

