/*
 * Decompiled with CFR 0.152.
 */
package moe.pine.spring.cache.interceptors;

import java.time.Clock;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import moe.pine.spring.cache.interceptors.CacheHeader;
import moe.pine.spring.cache.interceptors.CacheHeaders;
import moe.pine.spring.cache.interceptors.CachePolicy;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.HandlerInterceptor;

public class CacheInterceptor
implements HandlerInterceptor {
    public static final List<CacheHeader> DEFAULT_HEADERS = Collections.unmodifiableList(Arrays.asList(CacheHeaders.CACHE_CONTROL, CacheHeaders.PRAGMA));
    private final CachePolicy cachePolicy;
    private final List<CacheHeader> cacheHeaders;
    private final Clock clock;

    public CacheInterceptor(CachePolicy cachePolicy) {
        this(cachePolicy, DEFAULT_HEADERS);
    }

    public CacheInterceptor(CachePolicy cachePolicy, List<CacheHeader> cacheHeaders) {
        this(cachePolicy, cacheHeaders, Clock.systemDefaultZone());
    }

    public CacheInterceptor(CachePolicy cachePolicy, List<CacheHeader> cacheHeaders, Clock clock) {
        this.cachePolicy = cachePolicy;
        this.cacheHeaders = cacheHeaders;
        this.clock = clock;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        for (CacheHeader cacheHeader : this.getCacheHeaders()) {
            String name = cacheHeader.getName();
            if (!StringUtils.hasLength((String)name)) continue;
            Optional<String> valueOpt = cacheHeader.buildValue(this.getCachePolicy(), this.getClock());
            valueOpt.ifPresent(value -> response.addHeader(name, value));
        }
        return true;
    }

    protected CachePolicy getCachePolicy() {
        return this.cachePolicy;
    }

    protected List<CacheHeader> getCacheHeaders() {
        return this.cacheHeaders;
    }

    protected Clock getClock() {
        return this.clock;
    }
}

