/*
 * Decompiled with CFR 0.152.
 */
package moe.pine.spring.cache.interceptors;

import java.time.Clock;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import moe.pine.spring.cache.interceptors.CacheHeader;
import moe.pine.spring.cache.interceptors.CachePolicy;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public final class CacheHeaders {
    public static final CacheHeader CACHE_CONTROL = new CacheHeaderImpl("Cache-Control", new CacheControlValueBuilder());
    public static final CacheHeader PRAGMA = new CacheHeaderImpl("Pragma", new PragmaValueBuilder());
    public static final CacheHeader EXPIRES = new CacheHeaderImpl("Expires", new ExpiresValueBuilder());

    private CacheHeaders() {
    }

    static class ExpiresValueBuilder
    implements CacheHeaderValueBuilder {
        ExpiresValueBuilder() {
        }

        @Override
        public String build(CachePolicy cachePolicy, Clock clock) {
            Long maxAge = cachePolicy.getMaxAge();
            if (maxAge != null) {
                OffsetDateTime dt = OffsetDateTime.now(clock).plusSeconds(maxAge).withOffsetSameInstant(ZoneOffset.UTC);
                return dt.format(DateTimeFormatter.RFC_1123_DATE_TIME);
            }
            return null;
        }
    }

    static class PragmaValueBuilder
    implements CacheHeaderValueBuilder {
        PragmaValueBuilder() {
        }

        @Override
        public String build(CachePolicy cachePolicy, Clock clock) {
            if (cachePolicy.isNoCache()) {
                return "no-cache";
            }
            return null;
        }
    }

    static class CacheControlValueBuilder
    implements CacheHeaderValueBuilder {
        CacheControlValueBuilder() {
        }

        @Override
        public String build(CachePolicy cachePolicy, Clock clock) {
            CachePolicy.MaxStale maxStale;
            ArrayList<String> directives = new ArrayList<String>();
            if (cachePolicy.isPublic()) {
                directives.add("public");
            }
            if (cachePolicy.isPrivate()) {
                directives.add("private");
            }
            if (cachePolicy.isNoCache()) {
                directives.add("no-cache");
            }
            if (cachePolicy.isOnlyIfCached()) {
                directives.add("only-if-cached");
            }
            if (cachePolicy.getMaxAge() != null) {
                directives.add("max-age=" + cachePolicy.getMaxAge());
            }
            if (cachePolicy.getSMaxAge() != null) {
                directives.add("s-maxage=" + cachePolicy.getSMaxAge());
            }
            if ((maxStale = cachePolicy.getMaxStale()) != null) {
                Long seconds = maxStale.getSeconds();
                if (seconds != null) {
                    directives.add("max-stale=" + seconds);
                } else {
                    directives.add("max-stale");
                }
            }
            if (cachePolicy.getMinFresh() != null) {
                directives.add("min-fresh=" + cachePolicy.getMinFresh());
            }
            if (cachePolicy.getStaleWhileRevalidate() != null) {
                directives.add("stale-while-revalidate=" + cachePolicy.getStaleWhileRevalidate());
            }
            if (cachePolicy.getStaleIfError() != null) {
                directives.add("stale-if-error=" + cachePolicy.getStaleIfError());
            }
            if (cachePolicy.isMustRevalidate()) {
                directives.add("must-revalidate");
            }
            if (cachePolicy.isProxyRevalidate()) {
                directives.add("proxy-revalidate");
            }
            if (cachePolicy.isImmutable()) {
                directives.add("immutable");
            }
            if (cachePolicy.isNoStore()) {
                directives.add("no-store");
            }
            if (cachePolicy.isNoTransform()) {
                directives.add("no-transform");
            }
            return String.join((CharSequence)", ", directives);
        }
    }

    static class CacheHeaderImpl
    implements CacheHeader {
        private final String name;
        private final CacheHeaderValueBuilder valueBuilder;

        CacheHeaderImpl(String name, CacheHeaderValueBuilder valueBuilder) {
            this.name = name;
            this.valueBuilder = valueBuilder;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Optional<String> buildValue(CachePolicy cachePolicy, Clock clock) {
            String value = this.valueBuilder.build(cachePolicy, clock);
            if (!StringUtils.hasLength((String)value)) {
                return Optional.empty();
            }
            return Optional.of(value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheHeaderImpl that = (CacheHeaderImpl)o;
            return this.name.equals(that.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }

        public String toString() {
            return "CacheHeader{name='" + this.name + '\'' + '}';
        }
    }

    @FunctionalInterface
    static interface CacheHeaderValueBuilder {
        @Nullable
        public String build(CachePolicy var1, Clock var2);
    }
}

