/*
 * Decompiled with CFR 0.152.
 */
package moe.icyr.spring.starter.filesystem.api;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Base64;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import moe.icyr.spring.starter.filesystem.api.entity.FileInfo;
import moe.icyr.spring.starter.filesystem.api.entity.FileSystemProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileSystem
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(FileSystem.class);
    private static final Pattern base64UrlPrefixPattern = Pattern.compile("^data:\\w+/?\\w*;base64,");
    private static final String base64UrlPrefixReplaceString = "data:\\w+/?\\w*;base64,";
    private static final ResourceBundle message = ResourceBundle.getBundle("Message");
    protected final FileSystemProperty property;

    public FileSystem(FileSystemProperty property) {
        this.property = this.validateProperty(property);
        this.init(this.property);
        this.connect();
    }

    public FileSystemProperty validateProperty(FileSystemProperty property) {
        if (property == null) {
            throw new IllegalArgumentException(message.getString("fs.property.valid.not.null"));
        }
        if (property.getType() == null) {
            throw new IllegalArgumentException(message.getString("fs.property.type.valid.fail"));
        }
        if (property.getIp() == null || property.getIp().trim().length() == 0) {
            throw new IllegalArgumentException(message.getString("fs.property.ip.valid.fail"));
        }
        if (property.getPort() == null || property.getPort() < 0 || property.getPort() > 65535) {
            throw new IllegalArgumentException(message.getString("fs.property.port.valid.fail"));
        }
        if (property.getUsername() == null || property.getUsername().trim().length() == 0) {
            throw new IllegalArgumentException(message.getString("fs.property.username.valid.fail"));
        }
        if (property.getPassword() == null) {
            property.setPassword("");
        }
        return property;
    }

    protected abstract void init(FileSystemProperty var1);

    protected abstract boolean connect();

    public abstract void disconnect();

    public Collection<FileInfo> list(String path) {
        return this.list(path, false, false);
    }

    public abstract Collection<FileInfo> list(String var1, boolean var2, boolean var3);

    public FileInfo peekFile(String path, String filename) {
        return null;
    }

    public boolean upload(InputStream input, StringBuffer path, StringBuffer filename) {
        return this.upload(input, path.toString(), filename.toString());
    }

    public boolean upload(byte[] bytes, StringBuffer path, StringBuffer filename) {
        return this._upload(bytes, (Object)path, (Object)filename);
    }

    public boolean upload(String base64, StringBuffer path, StringBuffer filename) {
        return this._upload(base64, (Object)path, (Object)filename);
    }

    public abstract boolean upload(InputStream var1, String var2, String var3);

    public boolean upload(byte[] bytes, String path, String filename) {
        return this._upload(bytes, (Object)path, (Object)filename);
    }

    public boolean upload(String base64, String path, String filename) {
        return this._upload(base64, (Object)path, (Object)filename);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean _upload(byte[] bytes, Object path, Object filename) {
        try (ByteArrayInputStream stream = new ByteArrayInputStream(bytes);){
            if (path instanceof StringBuffer && filename instanceof StringBuffer) {
                boolean bl = this.upload((InputStream)stream, (StringBuffer)path, (StringBuffer)filename);
                return bl;
            }
            if (path instanceof String && filename instanceof String) {
                boolean bl = this.upload((InputStream)stream, (String)path, (String)filename);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            log.error(message.getString("fs.upload.fail.io").replace("${path}", String.valueOf(path)).replace("${filename}", String.valueOf(filename)).replace("${length}", bytes == null ? "-1" : Integer.toString(bytes.length)), (Throwable)e);
            return false;
        }
    }

    private boolean _upload(String base64, Object path, Object filename) {
        byte[] bytes = this._base64ToBytes(base64, path, filename);
        if (bytes == null) {
            return false;
        }
        if (path instanceof StringBuffer && filename instanceof StringBuffer) {
            return this.upload(bytes, (StringBuffer)path, (StringBuffer)filename);
        }
        if (path instanceof String && filename instanceof String) {
            return this.upload(bytes, (String)path, (String)filename);
        }
        return false;
    }

    private byte[] _base64ToBytes(String base64, Object path, Object filename) {
        if (base64UrlPrefixPattern.matcher(base64).find()) {
            base64 = base64.replaceFirst(base64UrlPrefixReplaceString, "");
        }
        try {
            return Base64.getDecoder().decode(base64);
        }
        catch (Exception e) {
            log.error(message.getString("fs.upload.fail.base64").replace("${path}", String.valueOf(path)).replace("${filename}", String.valueOf(filename)), (Throwable)e);
            return null;
        }
    }

    public abstract boolean createDirectory(String var1);

    public String downloadBase64(String path, String filename) {
        byte[] bytes = this.downloadBytes(path, filename);
        if (bytes == null) {
            return null;
        }
        return new String(Base64.getEncoder().encode(bytes));
    }

    public byte[] downloadBytes(String path, String filename) {
        ByteArrayOutputStream stream = this.downloadStream(path, filename);
        if (stream == null) {
            return null;
        }
        return stream.toByteArray();
    }

    public abstract ByteArrayOutputStream downloadStream(String var1, String var2);

    public abstract boolean deleteFile(String var1, String var2);

    @Override
    public void close() {
        this.disconnect();
    }

    public boolean appenderUpload(String base64, StringBuffer path, StringBuffer filename, long fileSize, long fileOffset) {
        byte[] bytes = this._base64ToBytes(base64, path.toString(), filename.toString());
        if (bytes == null) {
            return false;
        }
        return this.appenderUpload(bytes, path, filename, fileSize, fileOffset);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean appenderUpload(byte[] bytes, StringBuffer path, StringBuffer filename, long fileSize, long fileOffset) {
        try (ByteArrayInputStream stream = new ByteArrayInputStream(bytes);){
            boolean bl = this.appenderUpload(stream, path, filename, fileSize, fileOffset);
            return bl;
        }
        catch (Exception e) {
            log.error(message.getString("fs.upload.fail.io").replace("${path}", String.valueOf(path)).replace("${filename}", String.valueOf(filename)).replace("${length}", bytes == null ? "-1" : Integer.toString(bytes.length)), (Throwable)e);
            return false;
        }
    }

    public boolean appenderUpload(InputStream input, StringBuffer path, StringBuffer filename, long fileSize, long fileOffset) {
        return false;
    }
}

