/*
 * Decompiled with CFR 0.152.
 */
package ml.sparkling.graph.operators.partitioning;

import ml.sparkling.graph.operators.partitioning.CommunityBasedPartitioning;
import ml.sparkling.graph.operators.partitioning.PartitioningUtils$;
import org.apache.log4j.Logger;
import org.apache.spark.SparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.graphx.Edge;
import org.apache.spark.graphx.EdgeContext;
import org.apache.spark.graphx.Graph;
import org.apache.spark.graphx.Graph$;
import org.apache.spark.graphx.PartitionStrategy;
import org.apache.spark.graphx.TripletFields;
import org.apache.spark.graphx.VertexRDD;
import org.apache.spark.rdd.RDD;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;

public final class PropagationBasedPartitioning$ {
    public static final PropagationBasedPartitioning$ MODULE$;
    private final Logger logger;

    static {
        new PropagationBasedPartitioning$();
    }

    public Logger logger() {
        return this.logger;
    }

    public <VD, ED> Graph<VD, ED> partitionGraphBy(Graph<VD, ED> graph, int numParts, int checkpointingFrequency, ClassTag<VD> evidence$1, ClassTag<ED> evidence$2, SparkContext sc) {
        int numberOfPartitions = numParts == -1 ? sc.defaultParallelism() : numParts;
        Serializable x$7 = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(long x0$1, VD x1$1) {
                Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToLong((long)x0$1), x1$1);
                if (tuple2 != null) {
                    long vId;
                    long l = vId = tuple2._1$mcJ$sp();
                    return l;
                }
                throw new MatchError((Object)tuple2);
            }
        };
        ClassTag x$8 = ClassTag$.MODULE$.apply(Long.TYPE);
        Null$ x$9 = graph.mapVertices$default$3((Function2)x$7);
        Graph operationGraph = graph.mapVertices((Function2)x$7, x$8, null);
        VertexRDD oldComponents = operationGraph.vertices();
        long numberOfComponents = Graph$.MODULE$.graphToGraphOps(graph, evidence$1, evidence$2).numVertices();
        long oldNumberOfComponents = Long.MAX_VALUE;
        int iteration = 0;
        while (numberOfComponents > (long)numberOfPartitions && numberOfComponents != 1L && oldNumberOfComponents != numberOfComponents || oldNumberOfComponents > Integer.MAX_VALUE) {
            this.logger().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Propagation based partitioning: iteration:", ", last number of components:", ", current number of components:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)iteration), BoxesRunTime.boxToLong((long)oldNumberOfComponents), BoxesRunTime.boxToLong((long)numberOfComponents)})));
            ++iteration;
            oldComponents = (VertexRDD)operationGraph.vertices().cache();
            Graph qual$1 = operationGraph;
            Serializable x$10 = new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(EdgeContext<Object, ED, Object> ctx) {
                    if (BoxesRunTime.unboxToLong((Object)ctx.srcAttr()) < BoxesRunTime.unboxToLong((Object)ctx.dstAttr())) {
                        ctx.sendToDst(ctx.srcAttr());
                    } else if (BoxesRunTime.unboxToLong((Object)ctx.dstAttr()) < BoxesRunTime.unboxToLong((Object)ctx.srcAttr())) {
                        ctx.sendToSrc(ctx.dstAttr());
                    }
                }
            };
            Serializable x$11 = new Serializable(){
                public static final long serialVersionUID = 0L;

                public final long apply(long x$1, long x$2) {
                    return this.apply$mcJJJ$sp(x$1, x$2);
                }

                public long apply$mcJJJ$sp(long x$1, long x$2) {
                    return Math.min(x$1, x$2);
                }
            };
            TripletFields x$12 = qual$1.aggregateMessages$default$3();
            VertexRDD newIds = (VertexRDD)qual$1.aggregateMessages((Function1)x$10, (Function2)x$11, x$12, ClassTag$.MODULE$.apply(Long.TYPE)).cache();
            operationGraph = operationGraph.outerJoinVertices((RDD)newIds, (Function3)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final long apply(long x0$2, long x1$2, Option<Object> x2$1) {
                    Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToLong((long)x0$2), (Object)BoxesRunTime.boxToLong((long)x1$2), x2$1);
                    if (tuple3 != null) {
                        long oldData = BoxesRunTime.unboxToLong((Object)tuple3._2());
                        Option newData = (Option)tuple3._3();
                        long l = BoxesRunTime.unboxToLong((Object)newData.getOrElse((Function0)new Serializable(this, oldData){
                            public static final long serialVersionUID = 0L;
                            private final long oldData$1;

                            public final long apply() {
                                return this.apply$mcJ$sp();
                            }

                            public long apply$mcJ$sp() {
                                return this.oldData$1;
                            }
                            {
                                this.oldData$1 = oldData$1;
                            }
                        }));
                        return l;
                    }
                    throw new MatchError((Object)tuple3);
                }
            }, ClassTag$.MODULE$.apply(Long.TYPE), ClassTag$.MODULE$.apply(Long.TYPE), Predef.$eq$colon$eq$.MODULE$.tpEquals()).cache();
            oldNumberOfComponents = numberOfComponents;
            numberOfComponents = operationGraph.vertices().map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final long apply(Tuple2<Object, Object> x$1) {
                    return x$1._2$mcJ$sp();
                }
            }, ClassTag$.MODULE$.apply(Long.TYPE)).distinct().count();
            if (iteration % checkpointingFrequency != 0) continue;
            oldComponents.checkpoint();
            operationGraph.checkpoint();
            operationGraph.vertices().foreachPartition((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(Iterator<Tuple2<Object, Object>> x$2) {
                }
            });
            operationGraph.edges().foreachPartition((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(Iterator<Edge<ED>> x$3) {
                }
            });
            oldComponents.foreachPartition((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(Iterator<Tuple2<Object, Object>> x$4) {
                }
            });
        }
        Tuple2 tuple2 = new Tuple2((Object)oldComponents, (Object)BoxesRunTime.boxToLong((long)oldNumberOfComponents));
        if (tuple2 != null) {
            int x$16;
            Serializable x$15;
            Serializable x$14;
            Map x$13;
            Map vertexToCommunityId;
            Tuple2 tuple22;
            VertexRDD communities = (VertexRDD)tuple2._1();
            long numberOfCommunities = tuple2._2$mcJ$sp();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)communities, (Object)BoxesRunTime.boxToLong((long)numberOfCommunities));
            VertexRDD communities2 = (VertexRDD)tuple23._1();
            long numberOfCommunities2 = tuple23._2$mcJ$sp();
            Tuple2<Map<Object, Object>, Object> tuple24 = PartitioningUtils$.MODULE$.coarsePartitions(numberOfPartitions, numberOfCommunities2, (Map<Object, Object>)(vertexToCommunityId = (Map)communities2.treeAggregate((Object)(x$13 = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)), (Function2)(x$14 = new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Map<Object, Object> apply(Map<Object, Object> agg, Tuple2<Object, Object> data) {
                    return agg.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToLong((long)data._1$mcJ$sp())), (Object)BoxesRunTime.boxToLong((long)data._2$mcJ$sp())));
                }
            }), (Function2)(x$15 = new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Map<Object, Object> apply(Map<Object, Object> agg1, Map<Object, Object> agg2) {
                    return agg1.$plus$plus(agg2);
                }
            }), x$16 = communities2.treeAggregate$default$4((Object)x$13), ClassTag$.MODULE$.apply(Map.class))));
            if (tuple24 != null) {
                Tuple2 tuple25;
                Map vertexMap = (Map)tuple24._1();
                int newNumberOfCummunities = tuple24._2$mcI$sp();
                Tuple2 tuple26 = tuple25 = new Tuple2((Object)vertexMap, (Object)BoxesRunTime.boxToInteger((int)newNumberOfCummunities));
                Map vertexMap2 = (Map)tuple26._1();
                int newNumberOfCummunities2 = tuple26._2$mcI$sp();
                CommunityBasedPartitioning.ByComponentIdPartitionStrategy strategy = new CommunityBasedPartitioning.ByComponentIdPartitionStrategy((Broadcast<Map<Object, Object>>)sc.broadcast((Object)vertexMap2, ClassTag$.MODULE$.apply(Map.class)));
                this.logger().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partitioning graph using coarsed map with ", " entries (", " before coarse) and ", " partitions"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)vertexMap2.size()), BoxesRunTime.boxToInteger((int)vertexToCommunityId.size()), BoxesRunTime.boxToLong((long)numberOfCommunities2)})));
                return graph.partitionBy((PartitionStrategy)strategy, newNumberOfCummunities2);
            }
            throw new MatchError(tuple24);
        }
        throw new MatchError((Object)tuple2);
    }

    public <VD, ED> int partitionGraphBy$default$2() {
        return -1;
    }

    public <VD, ED> int partitionGraphBy$default$3() {
        return 10;
    }

    private PropagationBasedPartitioning$() {
        MODULE$ = this;
        this.logger = Logger.getLogger(this.getClass());
    }
}

