/*
 * Decompiled with CFR 0.152.
 */
package ml.sparkling.graph.operators.partitioning;

import ml.sparkling.graph.api.operators.algorithms.community.CommunityDetection;
import ml.sparkling.graph.operators.partitioning.CommunityBasedPartitioning;
import ml.sparkling.graph.operators.partitioning.PartitioningUtils$;
import org.apache.log4j.Logger;
import org.apache.spark.SparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.graphx.Graph;
import org.apache.spark.graphx.PartitionStrategy;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import scala.Function1;
import scala.Function2;
import scala.Int$;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class CommunityBasedPartitioning$ {
    public static final CommunityBasedPartitioning$ MODULE$;
    private final transient Logger logger;

    static {
        new CommunityBasedPartitioning$();
    }

    public Logger logger() {
        return this.logger;
    }

    public <VD, ED> Graph<VD, ED> partitionGraphBy(Graph<VD, ED> graph, Function1<Graph<VD, ED>, Graph<Object, ED>> communityDetectionMethod, int numParts, ClassTag<VD> evidence$1, ClassTag<ED> evidence$2, SparkContext sc) {
        int numberOfPartitions = numParts == -1 ? sc.defaultParallelism() : numParts;
        Graph communities = (Graph)communityDetectionMethod.apply(graph);
        int numberOfCommunities = Predef$.MODULE$.longArrayOps((long[])RDD$.MODULE$.rddToPairRDDFunctions((RDD)communities.vertices(), ClassTag$.MODULE$.apply(Long.TYPE), ClassTag$.MODULE$.apply(Long.TYPE), (Ordering)Ordering.Long$.MODULE$).values().distinct().collect()).size();
        Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        Serializable x$4 = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Map<Object, Object> apply(Map<Object, Object> agg, Tuple2<Object, Object> data) {
                return agg.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToLong((long)data._1$mcJ$sp())), (Object)BoxesRunTime.boxToLong((long)data._2$mcJ$sp())));
            }
        };
        Serializable x$5 = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Map<Object, Object> apply(Map<Object, Object> agg1, Map<Object, Object> agg2) {
                return agg1.$plus$plus(agg2);
            }
        };
        int x$6 = communities.vertices().treeAggregate$default$4((Object)x$3);
        Map vertexToCommunityId = (Map)communities.vertices().treeAggregate((Object)x$3, (Function2)x$4, (Function2)x$5, x$6, ClassTag$.MODULE$.apply(Map.class));
        Tuple2<Map<Object, Object>, Object> tuple2 = PartitioningUtils$.MODULE$.coarsePartitions(numberOfPartitions, Int$.MODULE$.int2long(numberOfCommunities), (Map<Object, Object>)vertexToCommunityId);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Map coarsedVertexMap = (Map)tuple2._1();
            int coarsedNumberOfPartitions = tuple2._2$mcI$sp();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)coarsedVertexMap, (Object)BoxesRunTime.boxToInteger((int)coarsedNumberOfPartitions));
            Map coarsedVertexMap2 = (Map)tuple23._1();
            int coarsedNumberOfPartitions2 = tuple23._2$mcI$sp();
            CommunityBasedPartitioning.ByComponentIdPartitionStrategy strategy = new CommunityBasedPartitioning.ByComponentIdPartitionStrategy((Broadcast<Map<Object, Object>>)sc.broadcast((Object)coarsedVertexMap2, ClassTag$.MODULE$.apply(Map.class)));
            this.logger().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partitioning graph using coarsed map with ", " entries (", " before coarse) and ", " partitions"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)coarsedVertexMap2.size()), BoxesRunTime.boxToInteger((int)vertexToCommunityId.size()), BoxesRunTime.boxToInteger((int)coarsedNumberOfPartitions2)})));
            return graph.partitionBy((PartitionStrategy)strategy, coarsedNumberOfPartitions2);
        }
        throw new MatchError(tuple2);
    }

    public <VD, ED> int partitionGraphBy$default$3() {
        return -1;
    }

    public <VD, ED> Graph<VD, ED> partitionGraphUsing(Graph<VD, ED> graph, CommunityDetection.CommunityDetectionAlgorithm communityDetectionMethod, int numParts, ClassTag<VD> evidence$3, ClassTag<ED> evidence$4, SparkContext sc) {
        return this.partitionGraphBy(graph, (Function1<Graph<VD, ED>, Graph<Object, ED>>)new Serializable(communityDetectionMethod, evidence$3, evidence$4){
            public static final long serialVersionUID = 0L;
            private final CommunityDetection.CommunityDetectionAlgorithm communityDetectionMethod$1;
            private final ClassTag evidence$3$1;
            private final ClassTag evidence$4$1;

            public final Graph<Object, ED> apply(Graph<VD, ED> x$2) {
                return this.communityDetectionMethod$1.detectCommunities(x$2, this.evidence$3$1, this.evidence$4$1);
            }
            {
                this.communityDetectionMethod$1 = communityDetectionMethod$1;
                this.evidence$3$1 = evidence$3$1;
                this.evidence$4$1 = evidence$4$1;
            }
        }, numParts, evidence$3, evidence$4, sc);
    }

    public <VD, ED> int partitionGraphUsing$default$3() {
        return -1;
    }

    private CommunityBasedPartitioning$() {
        MODULE$ = this;
        this.logger = Logger.getLogger(this.getClass());
    }
}

