/*
 * Decompiled with CFR 0.152.
 */
package ml.sparkling.graph.operators.algorithms.shortestpaths;

import it.unimi.dsi.fastutil.longs.Long2DoubleOpenHashMap;
import java.util.Map;
import java.util.Set;
import ml.sparkling.graph.api.operators.IterativeComputation;
import ml.sparkling.graph.operators.algorithms.shortestpaths.ShortestPathsAlgorithm$;
import ml.sparkling.graph.operators.algorithms.shortestpaths.pathprocessors.PathProcessor;
import ml.sparkling.graph.operators.algorithms.shortestpaths.pathprocessors.SingleVertexProcessor;
import ml.sparkling.graph.operators.algorithms.shortestpaths.pathprocessors.fastutils.FastUtilWithDistance;
import ml.sparkling.graph.operators.algorithms.shortestpaths.pathprocessors.fastutils.FastUtilWithPath;
import ml.sparkling.graph.operators.predicates.AllPathPredicate$;
import ml.sparkling.graph.operators.predicates.ByIdPredicate;
import ml.sparkling.graph.operators.predicates.ByIdsPredicate;
import org.apache.log4j.Logger;
import org.apache.spark.graphx.EdgeContext;
import org.apache.spark.graphx.EdgeDirection;
import org.apache.spark.graphx.EdgeTriplet;
import org.apache.spark.graphx.Graph;
import org.apache.spark.graphx.Graph$;
import org.apache.spark.graphx.GraphOps;
import org.apache.spark.graphx.VertexRDD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Set$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ScalaRunTime$;

public final class ShortestPathsAlgorithm$
implements Product,
Serializable {
    public static final ShortestPathsAlgorithm$ MODULE$;
    private final Logger logger;

    static {
        new ShortestPathsAlgorithm$();
    }

    public Logger logger() {
        return this.logger;
    }

    public <VD, ED, PT> Graph<PT, ED> computeAllPathsUsing(Graph<VD, ED> graph, IterativeComputation.VertexPredicate<VD> vertexPredicate, boolean treatAsUndirected, PathProcessor<VD, ED, PT> pathProcessor, ClassTag<ED> evidence$1, ClassTag<PT> evidence$2, Numeric<ED> num) {
        VertexRDD initDistances;
        VertexRDD x$4 = initDistances = graph.aggregateMessages((Function1)new Serializable(vertexPredicate, treatAsUndirected, pathProcessor, num){
            public static final long serialVersionUID = 0L;
            private final IterativeComputation.VertexPredicate vertexPredicate$1;
            private final boolean treatAsUndirected$1;
            private final PathProcessor pathProcessor$1;
            private final Numeric num$1;

            public final void apply(EdgeContext<VD, ED, PT> edgeContext) {
                if (this.vertexPredicate$1.apply(edgeContext.dstId(), edgeContext.dstAttr())) {
                    PS edgeOut = this.pathProcessor$1.putNewPath(this.pathProcessor$1.getNewContainerForPaths(), edgeContext.dstId(), edgeContext.attr(), this.num$1);
                    edgeContext.sendToSrc(edgeOut);
                }
                if (this.treatAsUndirected$1 && this.vertexPredicate$1.apply(edgeContext.srcId(), edgeContext.srcAttr())) {
                    PS edgeIn = this.pathProcessor$1.putNewPath(this.pathProcessor$1.getNewContainerForPaths(), edgeContext.srcId(), edgeContext.attr(), this.num$1);
                    edgeContext.sendToDst(edgeIn);
                }
            }
            {
                this.vertexPredicate$1 = vertexPredicate$1;
                this.treatAsUndirected$1 = treatAsUndirected$1;
                this.pathProcessor$1 = pathProcessor$1;
                this.num$1 = num$1;
            }
        }, (Function2)new Serializable(pathProcessor, num){
            public static final long serialVersionUID = 0L;
            private final PathProcessor pathProcessor$1;
            private final Numeric num$1;

            public final PT apply(PT map1, PT map2) {
                return this.pathProcessor$1.mergePathContainers(map1, map2, this.num$1);
            }
            {
                this.pathProcessor$1 = pathProcessor$1;
                this.num$1 = num$1;
            }
        }, graph.aggregateMessages$default$3(), evidence$2);
        Serializable x$5 = new Serializable(pathProcessor){
            public static final long serialVersionUID = 0L;
            public final PathProcessor pathProcessor$1;

            public final PT apply(long vId, VD old, Option<PT> newValue) {
                return (PT)newValue.getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.4 $outer;

                    public final PT apply() {
                        return (PT)this.$outer.pathProcessor$1.getNewContainerForPaths();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.pathProcessor$1 = pathProcessor$1;
            }
        };
        ClassTag<PT> x$6 = evidence$2;
        ClassTag<PT> x$7 = evidence$2;
        Null$ x$8 = graph.outerJoinVertices$default$5((RDD)x$4, (Function3)x$5);
        Graph initMap = graph.outerJoinVertices((RDD)x$4, (Function3)x$5, x$6, x$7, null);
        GraphOps qual$1 = Graph$.MODULE$.graphToGraphOps(initMap, evidence$2, evidence$1);
        PT x$9 = pathProcessor.EMPTY_CONTAINER();
        int x$10 = qual$1.pregel$default$2();
        EdgeDirection x$11 = qual$1.pregel$default$3();
        Serializable x$12 = new Serializable(pathProcessor, num){
            public static final long serialVersionUID = 0L;
            private final PathProcessor pathProcessor$1;
            private final Numeric num$1;

            public final PT apply(long vId, PT data, PT message) {
                return ShortestPathsAlgorithm$.MODULE$.ml$sparkling$graph$operators$algorithms$shortestpaths$ShortestPathsAlgorithm$$vertexProgram(this.pathProcessor$1, vId, data, message, this.num$1);
            }
            {
                this.pathProcessor$1 = pathProcessor$1;
                this.num$1 = num$1;
            }
        };
        Serializable x$13 = new Serializable(treatAsUndirected, pathProcessor, num){
            public static final long serialVersionUID = 0L;
            private final boolean treatAsUndirected$1;
            private final PathProcessor pathProcessor$1;
            private final Numeric num$1;

            public final Iterator<Tuple2<Object, PT>> apply(EdgeTriplet<PT, ED> edge) {
                return ShortestPathsAlgorithm$.MODULE$.ml$sparkling$graph$operators$algorithms$shortestpaths$ShortestPathsAlgorithm$$sendMessage(this.treatAsUndirected$1, this.pathProcessor$1, edge, this.num$1);
            }
            {
                this.treatAsUndirected$1 = treatAsUndirected$1;
                this.pathProcessor$1 = pathProcessor$1;
                this.num$1 = num$1;
            }
        };
        Serializable x$14 = new Serializable(pathProcessor, num){
            public static final long serialVersionUID = 0L;
            private final PathProcessor pathProcessor$1;
            private final Numeric num$1;

            public final PT apply(PT map1, PT map2) {
                return this.pathProcessor$1.mergePathContainers(map1, map2, this.num$1);
            }
            {
                this.pathProcessor$1 = pathProcessor$1;
                this.num$1 = num$1;
            }
        };
        return qual$1.pregel(x$9, x$10, x$11, (Function3)x$12, (Function1)x$13, (Function2)x$14, evidence$2);
    }

    public <VD, ED> Graph<Long2DoubleOpenHashMap, ED> computeShortestPathsLengths(Graph<VD, ED> graph, IterativeComputation.VertexPredicate<VD> vertexPredicate, boolean treatAsUndirected, ClassTag<ED> evidence$3, Numeric<ED> num) {
        return this.computeAllPathsUsing(graph, vertexPredicate, treatAsUndirected, new FastUtilWithDistance(), evidence$3, ClassTag$.MODULE$.apply(Long2DoubleOpenHashMap.class), num);
    }

    public <VD, ED> Graph<Object, ED> computeSingleShortestPathsLengths(Graph<VD, ED> graph, long vertexId, boolean treatAsUndirected, ClassTag<ED> evidence$4, Numeric<ED> num) {
        return this.computeAllPathsUsing(graph, new ByIdPredicate(vertexId), treatAsUndirected, new SingleVertexProcessor(vertexId), evidence$4, ClassTag$.MODULE$.Double(), num);
    }

    public <VD, ED> boolean computeSingleShortestPathsLengths$default$3() {
        return false;
    }

    public <VD, ED> Graph<Map<Long, Set<java.util.List<Double>>>, ED> computeShortestPaths(Graph<VD, ED> graph, IterativeComputation.VertexPredicate<VD> vertexPredicate, boolean treatAsUndirected, ClassTag<ED> evidence$5, Numeric<ED> num) {
        return this.computeAllPathsUsing(graph, vertexPredicate, treatAsUndirected, new FastUtilWithPath(), evidence$5, ClassTag$.MODULE$.apply(Map.class), num);
    }

    public <VD, ED> AllPathPredicate$ computeShortestPathsLengths$default$2() {
        return AllPathPredicate$.MODULE$;
    }

    public <VD, ED> boolean computeShortestPathsLengths$default$3() {
        return false;
    }

    public <VD, ED> AllPathPredicate$ computeShortestPaths$default$2() {
        return AllPathPredicate$.MODULE$;
    }

    public <VD, ED> boolean computeShortestPaths$default$3() {
        return false;
    }

    public <VD, ED> Graph<Long2DoubleOpenHashMap, ED> computeShortestPathsLengthsIterative(Graph<VD, ED> graph, Function1<Graph<VD, ED>, Object> bucketSizeProvider, boolean treatAsUndirected, int checkpointingFrequency, ClassTag<VD> evidence$6, ClassTag<ED> evidence$7, Numeric<ED> num) {
        long bucketSize = BoxesRunTime.unboxToLong((Object)bucketSizeProvider.apply(graph));
        this.logger().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Computing APSP using iterative approach with bucket of size ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)bucketSize)})));
        graph.cache();
        long[] vertexIds = (long[])graph.vertices().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(Tuple2<Object, VD> x0$1) {
                Tuple2<Object, VD> tuple2 = x0$1;
                if (tuple2 != null) {
                    long vId;
                    long l = vId = tuple2._1$mcJ$sp();
                    return l;
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(Long.TYPE)).collect();
        Serializable x$15 = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Long2DoubleOpenHashMap apply(long vId, VD data) {
                return new Long2DoubleOpenHashMap();
            }
        };
        ClassTag x$16 = ClassTag$.MODULE$.apply(Long2DoubleOpenHashMap.class);
        Null$ x$17 = graph.mapVertices$default$3((Function2)x$15);
        Graph outGraph = graph.mapVertices((Function2)x$15, x$16, null);
        outGraph.cache();
        List vertices = Predef$.MODULE$.longArrayOps(vertexIds).grouped((int)bucketSize).toList();
        int numberOfIterations = vertices.size();
        Tuple2 tuple2 = (Tuple2)vertices.foldLeft((Object)new Tuple2((Object)outGraph, (Object)BoxesRunTime.boxToInteger((int)1)), (Function2)new anonfun.10(graph, treatAsUndirected, checkpointingFrequency, evidence$7, num, numberOfIterations));
        if (tuple2 != null) {
            Graph out;
            Graph graph2;
            Graph out2 = graph2 = (out = (Graph)tuple2._1());
            return out2;
        }
        throw new MatchError((Object)tuple2);
    }

    public <VD, ED> boolean computeShortestPathsLengthsIterative$default$3() {
        return false;
    }

    public <VD, ED> int computeShortestPathsLengthsIterative$default$4() {
        return 20;
    }

    public <VD, ED, PT> Iterator<Tuple2<Object, PT>> ml$sparkling$graph$operators$algorithms$shortestpaths$ShortestPathsAlgorithm$$sendMessage(boolean treatAsUndirected, PathProcessor<VD, ED, PT> pathProcessor, EdgeTriplet<PT, ED> edge, Numeric<ED> num) {
        Iterator iterator;
        if (treatAsUndirected) {
            Object extendedDst = pathProcessor.extendPaths(edge.srcId(), edge.dstAttr(), edge.dstId(), edge.attr(), num);
            Object mergedSrc = pathProcessor.mergePathContainers(extendedDst, edge.srcAttr(), num);
            Iterator itSrc = edge.srcAttr().equals(mergedSrc) ? package$.MODULE$.Iterator().empty() : package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToLong((long)edge.srcId()), extendedDst)}));
            Object extendedSrc = pathProcessor.extendPaths(edge.dstId(), edge.srcAttr(), edge.srcId(), edge.attr(), num);
            Object mergedDst = pathProcessor.mergePathContainers(extendedSrc, edge.dstAttr(), num);
            Iterator itDst = edge.dstAttr().equals(mergedDst) ? package$.MODULE$.Iterator().empty() : package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToLong((long)edge.dstId()), extendedSrc)}));
            iterator = itSrc.$plus$plus((Function0)new Serializable(itDst){
                public static final long serialVersionUID = 0L;
                private final Iterator itDst$1;

                public final Iterator<Tuple2<Object, PT>> apply() {
                    return this.itDst$1;
                }
                {
                    this.itDst$1 = itDst$1;
                }
            });
        } else {
            Object extendedDst = pathProcessor.extendPaths(edge.srcId(), edge.dstAttr(), edge.dstId(), edge.attr(), num);
            Object merged = pathProcessor.mergePathContainers(extendedDst, edge.srcAttr(), num);
            iterator = edge.srcAttr().equals(merged) ? package$.MODULE$.Iterator().empty() : package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToLong((long)edge.srcId()), extendedDst)}));
        }
        return iterator;
    }

    public <VD, ED, PT> PT ml$sparkling$graph$operators$algorithms$shortestpaths$ShortestPathsAlgorithm$$vertexProgram(PathProcessor<VD, ED, PT> pathProcessor, long vId, PT data, PT message, Numeric<ED> num) {
        return pathProcessor.mergePathContainers(data, message, num);
    }

    public <VD, ED> void computeAPSPToDirectory(Graph<VD, ED> graph, String outDirectory, boolean treatAsUndirected, long bucketSize, ClassTag<VD> evidence$8, ClassTag<ED> evidence$9, Numeric<ED> num) {
        RDD qual$2 = graph.vertices().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(Tuple2<Object, VD> x$3) {
                return x$3._1$mcJ$sp();
            }
        }, ClassTag$.MODULE$.apply(Long.TYPE));
        Serializable x$18 = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(long k) {
                return this.apply$mcJJ$sp(k);
            }

            public long apply$mcJJ$sp(long k) {
                return k;
            }
        };
        boolean x$19 = qual$2.sortBy$default$2();
        int x$20 = qual$2.sortBy$default$3();
        long[] vertices = (long[])qual$2.sortBy((Function1)x$18, x$19, x$20, (Ordering)Ordering.Long$.MODULE$, ClassTag$.MODULE$.apply(Long.TYPE)).collect();
        List verticesGroups = Predef$.MODULE$.longArrayOps(vertices).grouped((int)bucketSize).zipWithIndex().toList();
        int numberOfIterations = verticesGroups.length();
        graph.cache();
        verticesGroups.foreach((Function1)new Serializable(graph, outDirectory, treatAsUndirected, evidence$9, num, numberOfIterations){
            public static final long serialVersionUID = 0L;
            private final Graph graph$2;
            private final String outDirectory$1;
            private final boolean treatAsUndirected$3;
            private final ClassTag evidence$9$1;
            private final Numeric num$3;
            private final int numberOfIterations$2;

            public final Graph<Long2DoubleOpenHashMap, ED> apply(Tuple2<long[], Object> x0$3) {
                Tuple2<long[], Object> tuple2 = x0$3;
                if (tuple2 != null) {
                    long[] group = (long[])tuple2._1();
                    int iteration = tuple2._2$mcI$sp();
                    ShortestPathsAlgorithm$.MODULE$.logger().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Shortest Paths iteration ", " from  ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(iteration + 1)), BoxesRunTime.boxToInteger((int)this.numberOfIterations$2)})));
                    Graph<Long2DoubleOpenHashMap, ED> shortestPaths = ShortestPathsAlgorithm$.MODULE$.computeShortestPathsLengths(this.graph$2, new ByIdsPredicate((scala.collection.immutable.Set<Object>)Predef$.MODULE$.longArrayOps(group).toSet()), this.treatAsUndirected$3, this.evidence$9$1, this.num$3);
                    VertexRDD x$21 = shortestPaths.vertices();
                    Serializable x$22 = new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<VD, Long2DoubleOpenHashMap> apply(long vId, VD data, Option<Long2DoubleOpenHashMap> newData) {
                            return new Tuple2(data, newData.getOrElse((Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final Long2DoubleOpenHashMap apply() {
                                    return new Long2DoubleOpenHashMap();
                                }
                            }));
                        }
                    };
                    ClassTag x$23 = ClassTag$.MODULE$.apply(Long2DoubleOpenHashMap.class);
                    ClassTag x$24 = ClassTag$.MODULE$.apply(Tuple2.class);
                    Null$ x$25 = this.graph$2.outerJoinVertices$default$5((RDD)x$21, (Function3)x$22);
                    Graph joinedGraph = this.graph$2.outerJoinVertices((RDD)x$21, (Function3)x$22, x$23, x$24, null);
                    RDD$.MODULE$.rddToPairRDDFunctions((RDD)joinedGraph.vertices(), ClassTag$.MODULE$.apply(Long.TYPE), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Long$.MODULE$).values().map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(Tuple2<VD, Long2DoubleOpenHashMap> x0$4) {
                            Tuple2<VD, Long2DoubleOpenHashMap> tuple2 = x0$4;
                            if (tuple2 != null) {
                                Object vertex = tuple2._1();
                                Long2DoubleOpenHashMap data = (Long2DoubleOpenHashMap)tuple2._2();
                                if (data != null) {
                                    Long2DoubleOpenHashMap long2DoubleOpenHashMap = data;
                                    String dataStr = ((TraversableOnce)JavaConversions$.MODULE$.asScalaSet((Set)long2DoubleOpenHashMap.entrySet()).map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply(Map.Entry<Long, Double> e) {
                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e.getKey(), e.getValue()}));
                                        }
                                    }, Set$.MODULE$.canBuildFrom())).mkString(";");
                                    String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ";", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{vertex, dataStr}));
                                    return string;
                                }
                            }
                            throw new MatchError(tuple2);
                        }
                    }, ClassTag$.MODULE$.apply(String.class)).saveAsTextFile(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/from_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.outDirectory$1, Predef$.MODULE$.longArrayOps(group).head()})));
                    Graph graph = shortestPaths.unpersist(false);
                    return graph;
                }
                throw new MatchError(tuple2);
            }
            {
                this.graph$2 = graph$2;
                this.outDirectory$1 = outDirectory$1;
                this.treatAsUndirected$3 = treatAsUndirected$3;
                this.evidence$9$1 = evidence$9$1;
                this.num$3 = num$3;
                this.numberOfIterations$2 = numberOfIterations$2;
            }
        });
        graph.vertices().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<Object, VD> t) {
                return List$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)t._1$mcJ$sp()), t._2()})).mkString(";");
            }
        }, ClassTag$.MODULE$.apply(String.class)).saveAsTextFile(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/index"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{outDirectory})));
    }

    public String productPrefix() {
        return "ShortestPathsAlgorithm";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ShortestPathsAlgorithm$;
    }

    public int hashCode() {
        return -505855637;
    }

    public String toString() {
        return "ShortestPathsAlgorithm";
    }

    private Object readResolve() {
        return MODULE$;
    }

    private ShortestPathsAlgorithm$() {
        MODULE$ = this;
        Product.class.$init$((Product)this);
        this.logger = Logger.getLogger(this.getClass());
    }
}

