/*
 * Decompiled with CFR 0.152.
 */
package ml.sparkling.graph.operators.algorithms.community.pscan;

import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.Set;
import ml.sparkling.graph.api.operators.algorithms.community.CommunityDetection;
import ml.sparkling.graph.operators.measures.utils.CollectionsUtils$;
import ml.sparkling.graph.operators.measures.utils.NeighboursUtils$;
import org.apache.log4j.Logger;
import org.apache.spark.graphx.Edge;
import org.apache.spark.graphx.EdgeTriplet;
import org.apache.spark.graphx.Graph;
import org.apache.spark.graphx.Graph$;
import org.apache.spark.graphx.GraphOps;
import org.apache.spark.graphx.VertexRDD;
import org.apache.spark.rdd.RDD;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ScalaRunTime$;

public final class PSCAN$
implements CommunityDetection.CommunityDetectionAlgorithm,
Product,
Serializable {
    public static final PSCAN$ MODULE$;
    private final long defaultComponentId;
    private final Logger logger;

    static {
        new PSCAN$();
    }

    public long defaultComponentId() {
        return this.defaultComponentId;
    }

    public Logger logger() {
        return this.logger;
    }

    public <VD, ED> Graph<Object, ED> computeConnectedComponents(Graph<VD, ED> graph, double epsilon, ClassTag<VD> evidence$1, ClassTag<ED> evidence$2) {
        Graph<LongOpenHashSet, ED> neighbours = NeighboursUtils$.MODULE$.getWithNeighbours(graph, true, NeighboursUtils$.MODULE$.getWithNeighbours$default$3(), evidence$1, evidence$2);
        Graph edgesWithSimilarity = neighbours.mapTriplets((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(EdgeTriplet<LongOpenHashSet, ED> edge) {
                int sizeOfIntersection = CollectionsUtils$.MODULE$.intersectSize((Set)edge.srcAttr(), (Set)edge.dstAttr());
                double denominator = Math.sqrt(((LongOpenHashSet)edge.srcAttr()).size() * ((LongOpenHashSet)edge.dstAttr()).size());
                return (double)sizeOfIntersection / denominator;
            }
        }, ClassTag$.MODULE$.Double()).cache();
        GraphOps qual$1 = Graph$.MODULE$.graphToGraphOps(edgesWithSimilarity, ClassTag$.MODULE$.apply(LongOpenHashSet.class), ClassTag$.MODULE$.Double());
        Serializable x$4 = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Graph<LongOpenHashSet, Object> apply(Graph<LongOpenHashSet, Object> g) {
                return g;
            }
        };
        Serializable x$5 = new Serializable(epsilon){
            public static final long serialVersionUID = 0L;
            private final double epsilon$1;

            public final boolean apply(EdgeTriplet<LongOpenHashSet, Object> edge) {
                return edge.attr$mcD$sp() >= this.epsilon$1;
            }
            {
                this.epsilon$1 = epsilon$1;
            }
        };
        Function2 x$6 = qual$1.filter$default$3();
        Graph cutOffGraph = qual$1.filter((Function1)x$4, (Function1)x$5, x$6, ClassTag$.MODULE$.apply(LongOpenHashSet.class), ClassTag$.MODULE$.Double()).cache();
        Graph componentsGraph = Graph$.MODULE$.graphToGraphOps(cutOffGraph, ClassTag$.MODULE$.apply(LongOpenHashSet.class), ClassTag$.MODULE$.Double()).connectedComponents();
        VertexRDD x$7 = componentsGraph.vertices();
        Serializable x$8 = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(long vId, VD oldData, Option<Object> newData) {
                return BoxesRunTime.unboxToLong((Object)newData.getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply() {
                        return this.apply$mcJ$sp();
                    }

                    public long apply$mcJ$sp() {
                        return PSCAN$.MODULE$.defaultComponentId();
                    }
                }));
            }
        };
        ClassTag x$9 = ClassTag$.MODULE$.apply(Long.TYPE);
        ClassTag x$10 = ClassTag$.MODULE$.apply(Long.TYPE);
        Null$ x$11 = graph.outerJoinVertices$default$5((RDD)x$7, (Function3)x$8);
        return graph.outerJoinVertices((RDD)x$7, (Function3)x$8, x$9, x$10, null);
    }

    public <VD, ED> double computeConnectedComponents$default$2() {
        return 0.05;
    }

    /*
     * WARNING - void declaration
     */
    public <VD, ED> Graph<Object, ED> computeConnectedComponentsUsing(Graph<VD, ED> graph, int requiredNumberOfComponents, ClassTag<VD> evidence$3, ClassTag<ED> evidence$4) {
        Graph<LongOpenHashSet, ED> neighbours = NeighboursUtils$.MODULE$.getWithNeighbours(graph, true, NeighboursUtils$.MODULE$.getWithNeighbours$default$3(), evidence$3, evidence$4);
        Graph edgesWithSimilarity = neighbours.mapTriplets((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(EdgeTriplet<LongOpenHashSet, ED> edge) {
                int sizeOfIntersection = CollectionsUtils$.MODULE$.intersectSize((Set)edge.srcAttr(), (Set)edge.dstAttr());
                double denominator = Math.sqrt(((LongOpenHashSet)edge.srcAttr()).size() * ((LongOpenHashSet)edge.dstAttr()).size());
                return (double)sizeOfIntersection / denominator;
            }
        }, ClassTag$.MODULE$.Double()).cache();
        RDD qual$2 = edgesWithSimilarity.edges().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Edge<Object> x$1) {
                return x$1.attr$mcD$sp();
            }
        }, ClassTag$.MODULE$.Double()).distinct();
        Serializable x$12 = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double t) {
                return this.apply$mcDD$sp(t);
            }

            public double apply$mcDD$sp(double t) {
                return t;
            }
        };
        boolean x$13 = qual$2.sortBy$default$2();
        int x$14 = qual$2.sortBy$default$3();
        double[] edgesWeights = (double[])qual$2.sortBy((Function1)x$12, x$13, x$14, (Ordering)Ordering.Double$.MODULE$, ClassTag$.MODULE$.Double()).collect();
        boolean min = false;
        int max = edgesWeights.length - 1;
        int wholeMax = edgesWeights.length - 1;
        Serializable x$15 = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(long vId, LongOpenHashSet x$2) {
                return vId;
            }
        };
        ClassTag x$16 = ClassTag$.MODULE$.apply(Long.TYPE);
        Null$ x$17 = edgesWithSimilarity.mapVertices$default$3((Function2)x$15);
        Graph components = edgesWithSimilarity.mapVertices((Function2)x$15, x$16, null);
        long numberOfComponents = Graph$.MODULE$.graphToGraphOps(graph, evidence$3, evidence$4).numVertices();
        boolean found = false;
        this.logger().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Will try to find optimal epsilon value from ", " edges weights"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)edgesWeights.length)})));
        while (true) {
            boolean bl;
            void var14_14;
            long l;
            void var6_6;
            void var7_11;
            int n;
            int n2;
            if (found) {
                this.logger().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Using PSCAN with  ", " components (", " required)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)numberOfComponents), BoxesRunTime.boxToInteger((int)requiredNumberOfComponents)})));
                VertexRDD x$21 = components.vertices();
                Serializable x$22 = new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final long apply(long vId, VD oldData, Option<Object> newData) {
                        return BoxesRunTime.unboxToLong((Object)newData.getOrElse((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final long apply() {
                                return this.apply$mcJ$sp();
                            }

                            public long apply$mcJ$sp() {
                                return PSCAN$.MODULE$.defaultComponentId();
                            }
                        }));
                    }
                };
                ClassTag x$23 = ClassTag$.MODULE$.apply(Long.TYPE);
                ClassTag x$24 = ClassTag$.MODULE$.apply(Long.TYPE);
                Null$ x$25 = graph.outerJoinVertices$default$5((RDD)x$21, (Function3)x$22);
                return graph.outerJoinVertices((RDD)x$21, (Function3)x$22, x$23, x$24, null);
            }
            int index = (int)Math.floor((double)(n2 + n) / 2.0);
            void cutOffValue = var7_11[index];
            this.logger().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Evaluating PSCAN for epsilon=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)cutOffValue)})));
            GraphOps qual$3 = Graph$.MODULE$.graphToGraphOps((Graph)var6_6, ClassTag$.MODULE$.apply(LongOpenHashSet.class), ClassTag$.MODULE$.Double());
            Serializable x$18 = new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Graph<LongOpenHashSet, Object> apply(Graph<LongOpenHashSet, Object> g) {
                    return g;
                }
            };
            Serializable x$19 = new Serializable((double)cutOffValue){
                public static final long serialVersionUID = 0L;
                private final double cutOffValue$1;

                public final boolean apply(EdgeTriplet<LongOpenHashSet, Object> edge) {
                    return edge.attr$mcD$sp() > this.cutOffValue$1;
                }
                {
                    this.cutOffValue$1 = cutOffValue$1;
                }
            };
            Function2 x$20 = qual$3.filter$default$3();
            Graph cutOffGraph = qual$3.filter((Function1)x$18, (Function1)x$19, x$20, ClassTag$.MODULE$.apply(LongOpenHashSet.class), ClassTag$.MODULE$.Double()).cache();
            Graph componentsGraph = Graph$.MODULE$.graphToGraphOps(cutOffGraph, ClassTag$.MODULE$.apply(LongOpenHashSet.class), ClassTag$.MODULE$.Double()).connectedComponents();
            long currentNumberOfComponents = componentsGraph.vertices().map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final long apply(Tuple2<Object, Object> x$3) {
                    return x$3._2$mcJ$sp();
                }
            }, ClassTag$.MODULE$.apply(Long.TYPE)).distinct().count();
            this.logger().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PSCAN resulted in ", " components (", " required)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)currentNumberOfComponents), BoxesRunTime.boxToInteger((int)requiredNumberOfComponents)})));
            if (currentNumberOfComponents >= (long)requiredNumberOfComponents && (Math.abs((long)requiredNumberOfComponents - currentNumberOfComponents) < Math.abs((long)requiredNumberOfComponents - l) || l < (long)requiredNumberOfComponents)) {
                Graph graph2 = componentsGraph;
                l = currentNumberOfComponents;
            }
            if (n2 == n || index == 0 || index == var14_14) {
                bl = true;
                continue;
            }
            if (currentNumberOfComponents < (long)requiredNumberOfComponents) {
                int oldMin = n2;
                if (oldMin != (n2 = index - 1)) continue;
                bl = true;
                continue;
            }
            if (currentNumberOfComponents > (long)requiredNumberOfComponents) {
                int oldMax = n;
                if (oldMax != (n = index - 1)) continue;
                bl = true;
                continue;
            }
            bl = true;
        }
    }

    public <VD, ED> int computeConnectedComponentsUsing$default$2() {
        return 32;
    }

    public <VD, ED> Graph<Object, ED> detectCommunities(Graph<VD, ED> graph, ClassTag<VD> evidence$5, ClassTag<ED> evidence$6) {
        return this.computeConnectedComponents(graph, this.computeConnectedComponents$default$2(), evidence$5, evidence$6);
    }

    public String productPrefix() {
        return "PSCAN";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof PSCAN$;
    }

    public int hashCode() {
        return 76420813;
    }

    public String toString() {
        return "PSCAN";
    }

    private Object readResolve() {
        return MODULE$;
    }

    private PSCAN$() {
        MODULE$ = this;
        Product.class.$init$((Product)this);
        this.defaultComponentId = -1L;
        this.logger = Logger.getLogger(this.getClass());
    }
}

