/*
 * Decompiled with CFR 0.152.
 */
package me.wuwenbin.sql.factory;

import java.lang.reflect.Field;
import me.wuwenbin.sql.annotation.SQLColumn;
import me.wuwenbin.sql.annotation.SQLTable;
import me.wuwenbin.sql.exception.DeletePkNotExistException;
import me.wuwenbin.sql.exception.DeleteSQLConditionsNullException;
import me.wuwenbin.sql.exception.NotSetPrimaryKeyException;
import me.wuwenbin.sql.exception.SQLTableNotFoundException;
import me.wuwenbin.sql.exception.UpdateColumnNullException;
import me.wuwenbin.sql.exception.UpdatePkNotExistException;
import me.wuwenbin.sql.util.SQLBuilderUtils;
import me.wuwenbin.sql.util.SQLDefineUtils;

public final class SQLBeanBuilder {
    private Class<?> beanClass;
    private Class<SQLTable> sqlTableClass = SQLTable.class;
    private Class<SQLColumn> sqlColumnClass = SQLColumn.class;
    private final String SPACE = " ";
    private final String FROM = " FROM ";
    private final String WHERE = " WHERE ";
    private final String AND = " AND ";
    private final String OR = " OR ";
    private final String selectPre = "SELECT ";
    private final String insertPre = "INSERT INTO ";
    private final String updatePre = "UPDATE ";
    private final String deletePre = "DELETE FROM ";

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public void setBeanClass(Class<?> beanClass) {
        this.beanClass = beanClass;
    }

    public SQLBeanBuilder(Class<?> beanClass) {
        this.beanClass = beanClass;
    }

    public String countAll() throws SQLTableNotFoundException {
        if (!SQLBuilderUtils.SQLTableIsExist(this.beanClass)) {
            throw new SQLTableNotFoundException(this.beanClass);
        }
        String tableName = this.beanClass.getAnnotation(this.sqlTableClass).value();
        StringBuilder sb = new StringBuilder("SELECT ");
        sb.append("COUNT(*)").append(" FROM ").append(tableName).toString();
        return SQLBuilderUtils.dealSQL(sb.toString());
    }

    public String countAndByRouters(int ... routers) throws SQLTableNotFoundException {
        if (!SQLBuilderUtils.SQLTableIsExist(this.beanClass)) {
            throw new SQLTableNotFoundException(this.beanClass);
        }
        String tableName = this.beanClass.getAnnotation(this.sqlTableClass).value();
        StringBuilder sb = new StringBuilder("SELECT ");
        sb.append("COUNT(*)").append(" FROM ").append(tableName);
        if (routers != null && routers.length > 0) {
            sb.append(" WHERE ").append("1=1");
            Field[] fields = SQLBuilderUtils.getAllFieldsExceptObject(this.beanClass);
            this.assembleCountSQL(sb, fields, " AND ", tableName, routers);
        }
        return SQLBuilderUtils.dealSQL(sb.toString());
    }

    public String countOrByRouters(int ... routers) throws SQLTableNotFoundException {
        if (!SQLBuilderUtils.SQLTableIsExist(this.beanClass)) {
            throw new SQLTableNotFoundException(this.beanClass);
        }
        String tableName = this.beanClass.getAnnotation(this.sqlTableClass).value();
        StringBuilder sb = new StringBuilder("SELECT ");
        sb.append("COUNT(*)").append(" FROM ").append(tableName);
        if (routers != null && routers.length > 0) {
            sb.append(" WHERE ").append("1<>1");
            Field[] fields = SQLBuilderUtils.getAllFieldsExceptObject(this.beanClass);
            this.assembleCountSQL(sb, fields, " OR ", tableName, routers);
        }
        return SQLBuilderUtils.dealSQL(sb.toString());
    }

    public String selectPartByRoutersAnd(int[] selectColumnsRouters, int ... conditionRouters) throws SQLTableNotFoundException {
        if (!SQLBuilderUtils.SQLTableIsExist(this.beanClass)) {
            throw new SQLTableNotFoundException(this.beanClass);
        }
        String tableName = this.beanClass.getAnnotation(this.sqlTableClass).value();
        StringBuilder sb = new StringBuilder("SELECT ");
        Field[] fields = SQLBuilderUtils.getAllFieldsExceptObject(this.beanClass);
        this.assembleSelectSQL(selectColumnsRouters, tableName, sb, fields);
        sb.append(" FROM ").append(tableName);
        if (conditionRouters != null && conditionRouters.length > 0) {
            sb.append(" WHERE ").append("1=1");
            this.assembleCountSQL(sb, fields, " AND ", tableName, conditionRouters);
        }
        return SQLBuilderUtils.dealSQL(sb.toString());
    }

    public String selectAllByRoutersAnd(int ... routers) throws SQLTableNotFoundException {
        return this.selectPartByRoutersAnd(null, routers);
    }

    public String selectAll() throws SQLTableNotFoundException {
        return this.selectAllByRoutersAnd(new int[0]);
    }

    public String selectAllByPk() throws SQLTableNotFoundException, NotSetPrimaryKeyException {
        return this.selectPartByPk(new int[0]);
    }

    public String selectPartByPk(int ... routers) throws SQLTableNotFoundException, NotSetPrimaryKeyException {
        if (!SQLBuilderUtils.SQLTableIsExist(this.beanClass)) {
            throw new SQLTableNotFoundException(this.beanClass);
        }
        StringBuilder sb = new StringBuilder("SELECT ");
        String tableName = this.beanClass.getAnnotation(this.sqlTableClass).value();
        Field[] fields = SQLBuilderUtils.getAllFieldsExceptObject(this.beanClass);
        this.assembleSelectSQL(routers, tableName, sb, fields);
        sb.append(" FROM ").append(tableName);
        boolean hasSetPk = false;
        for (Field field : fields) {
            if (!field.isAnnotationPresent(this.sqlColumnClass) || !field.getAnnotation(this.sqlColumnClass).pk()) continue;
            hasSetPk = true;
            String column = SQLDefineUtils.java2SQL(field.getAnnotation(this.sqlColumnClass).value(), field.getName());
            sb.append(" WHERE ").append(tableName).append(".").append(column).append(" = :").append(field.getName());
        }
        if (!hasSetPk) {
            throw new NotSetPrimaryKeyException(this.beanClass);
        }
        return SQLBuilderUtils.dealSQL(sb.toString());
    }

    public String insertRoutersPk(boolean insertPk, int ... routers) throws SQLTableNotFoundException {
        if (!SQLBuilderUtils.SQLTableIsExist(this.beanClass)) {
            throw new SQLTableNotFoundException(this.beanClass);
        }
        StringBuilder sb = new StringBuilder("INSERT INTO ");
        String tableName = this.beanClass.getAnnotation(this.sqlTableClass).value();
        Field[] fields = SQLBuilderUtils.getAllFieldsExceptObject(this.beanClass);
        sb.append(tableName);
        StringBuilder values = new StringBuilder("(");
        if (routers != null && routers.length > 0) {
            sb.append("(");
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                if (!field.isAnnotationPresent(this.sqlColumnClass)) continue;
                if (insertPk && field.getAnnotation(this.sqlColumnClass).pk()) {
                    String pkColumn = SQLDefineUtils.java2SQL(field.getAnnotation(this.sqlColumnClass).value(), field.getName());
                    values.append(":").append(field.getName()).append(", ");
                    sb.append(pkColumn).append(", ");
                }
                if (!SQLBuilderUtils.fieldRoutersInParamRouters(field.getAnnotation(this.sqlColumnClass).routers(), routers) || field.getAnnotation(this.sqlColumnClass).pk()) continue;
                String column = SQLDefineUtils.java2SQL(field.getAnnotation(this.sqlColumnClass).value(), field.getName());
                values.append(":").append(field.getName()).append(", ");
                sb.append(column).append(", ");
            }
            sb.append(") VALUES").append((CharSequence)values).append(")");
        } else {
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                if (field.isAnnotationPresent(this.sqlColumnClass)) {
                    if (insertPk && field.getAnnotation(this.sqlColumnClass).pk()) {
                        values.append(":").append(field.getName()).append(", ");
                    }
                    if (field.getAnnotation(this.sqlColumnClass).pk()) continue;
                    values.append(":").append(field.getName()).append(", ");
                    continue;
                }
                values.append(":").append(field.getName()).append(", ");
            }
            sb.append(" VALUES").append((CharSequence)values).append(")");
        }
        return SQLBuilderUtils.dealSQL(sb.toString());
    }

    public String insertAllPk(boolean insertPk) throws SQLTableNotFoundException {
        return this.insertRoutersPk(insertPk, new int[0]);
    }

    public String insertAllWithPk() throws SQLTableNotFoundException {
        return this.insertRoutersPk(true, new int[0]);
    }

    public String insertAllWithoutPk() throws SQLTableNotFoundException {
        return this.insertRoutersPk(false, new int[0]);
    }

    public String insertRoutersWithPk(int ... routers) throws SQLTableNotFoundException {
        return this.insertRoutersPk(true, routers);
    }

    public String insertRoutersWithoutPk(int ... routers) throws SQLTableNotFoundException {
        return this.insertRoutersPk(false, routers);
    }

    public String updateRoutersByRouterArray(int[] updateRouters, int[] conditionRouters) throws SQLTableNotFoundException, UpdateColumnNullException {
        if (!SQLBuilderUtils.SQLTableIsExist(this.beanClass)) {
            throw new SQLTableNotFoundException(this.beanClass);
        }
        String tableName = this.beanClass.getAnnotation(this.sqlTableClass).value();
        StringBuilder sb = new StringBuilder("UPDATE ").append(tableName);
        Field[] fields = SQLBuilderUtils.getAllFieldsExceptObject(this.beanClass);
        if (updateRouters != null && updateRouters.length > 0) {
            sb.append(" SET ");
            for (Field field : fields) {
                if (!field.isAnnotationPresent(this.sqlColumnClass) || !SQLBuilderUtils.fieldRoutersInParamRouters(field.getAnnotation(this.sqlColumnClass).routers(), updateRouters)) continue;
                String column = SQLDefineUtils.java2SQL(field.getAnnotation(this.sqlColumnClass).value(), field.getName());
                sb.append(column).append(" = :").append(field.getName()).append(", ");
            }
        } else {
            throw new UpdateColumnNullException();
        }
        if (conditionRouters != null && conditionRouters.length > 0) {
            sb.append(" WHERE ");
            this.assembleWhereSQL(sb, fields, conditionRouters);
        }
        return SQLBuilderUtils.dealSQL(sb.toString());
    }

    public String updateRoutersByRouters(int[] updateRouters, int ... conditionRouters) throws SQLTableNotFoundException, UpdateColumnNullException {
        return this.updateRoutersByRouterArray(updateRouters, conditionRouters);
    }

    public String updateRoutersByPk(int ... updateRouters) throws SQLTableNotFoundException, UpdateColumnNullException, UpdatePkNotExistException {
        if (!SQLBuilderUtils.SQLTableIsExist(this.beanClass)) {
            throw new SQLTableNotFoundException(this.beanClass);
        }
        String tableName = this.beanClass.getAnnotation(this.sqlTableClass).value();
        StringBuilder sb = new StringBuilder("UPDATE ").append(tableName);
        Field[] fields = SQLBuilderUtils.getAllFieldsExceptObject(this.beanClass);
        String pkColumn = null;
        String pkField = null;
        if (updateRouters != null && updateRouters.length > 0) {
            sb.append(" SET ");
            for (Field field : fields) {
                if (!field.isAnnotationPresent(this.sqlColumnClass)) continue;
                if (field.getAnnotation(this.sqlColumnClass).pk()) {
                    pkField = field.getName();
                    pkColumn = SQLDefineUtils.java2SQL(field.getAnnotation(this.sqlColumnClass).value(), pkField);
                }
                if (!SQLBuilderUtils.fieldRoutersInParamRouters(field.getAnnotation(this.sqlColumnClass).routers(), updateRouters)) continue;
                String column = SQLDefineUtils.java2SQL(field.getAnnotation(this.sqlColumnClass).value(), field.getName());
                sb.append(column).append(" = :").append(field.getName()).append(", ");
            }
        } else {
            throw new UpdateColumnNullException();
        }
        sb.replace(sb.length() - 2, sb.length(), "");
        if (pkColumn == null || pkField == null) {
            throw new UpdatePkNotExistException();
        }
        sb.append(" WHERE ").append(pkColumn).append(" = :").append(pkField);
        return SQLBuilderUtils.dealSQL(sb.toString());
    }

    public String deleteByPk() throws SQLTableNotFoundException, DeletePkNotExistException {
        if (!SQLBuilderUtils.SQLTableIsExist(this.beanClass)) {
            throw new SQLTableNotFoundException(this.beanClass);
        }
        String tableName = this.beanClass.getAnnotation(this.sqlTableClass).value();
        StringBuilder sb = new StringBuilder("DELETE FROM ").append(tableName);
        Field[] fields = SQLBuilderUtils.getAllFieldsExceptObject(this.beanClass);
        boolean hasPk = false;
        sb.append(" WHERE ");
        for (Field field : fields) {
            if (!field.isAnnotationPresent(this.sqlColumnClass) || !field.getAnnotation(this.sqlColumnClass).pk()) continue;
            hasPk = true;
            String pkColumn = SQLDefineUtils.java2SQL(field.getAnnotation(this.sqlColumnClass).value(), field.getName());
            sb.append(pkColumn).append(" = :").append(field.getName()).append(" AND ");
        }
        if (!hasPk) {
            throw new DeletePkNotExistException();
        }
        return SQLBuilderUtils.dealSQL(sb.toString());
    }

    public String deleteByRouters(int ... routers) throws SQLTableNotFoundException, DeleteSQLConditionsNullException {
        if (!SQLBuilderUtils.SQLTableIsExist(this.beanClass)) {
            throw new SQLTableNotFoundException(this.beanClass);
        }
        String tableName = this.beanClass.getAnnotation(this.sqlTableClass).value();
        StringBuilder sb = new StringBuilder("DELETE FROM ").append(tableName);
        Field[] fields = SQLBuilderUtils.getAllFieldsExceptObject(this.beanClass);
        if (routers == null || routers.length <= 0) {
            throw new DeleteSQLConditionsNullException();
        }
        sb.append(" WHERE ");
        this.assembleWhereSQL(sb, fields, routers);
        return SQLBuilderUtils.dealSQL(sb.toString());
    }

    private void assembleCountSQL(StringBuilder sb, Field[] fields, String andOr, String tableName, int ... routers) {
        for (Field field : fields) {
            if (!field.isAnnotationPresent(this.sqlColumnClass) || !SQLBuilderUtils.fieldRoutersInParamRouters(field.getAnnotation(this.sqlColumnClass).routers(), routers)) continue;
            String column = SQLDefineUtils.java2SQL(field.getAnnotation(this.sqlColumnClass).value(), field.getName());
            sb.append(andOr).append(tableName).append(".").append(column).append("= ").append(":").append(field.getName());
        }
    }

    private void assembleSelectSQL(int[] selectColumnsRouters, String tableName, StringBuilder sb, Field[] fields) {
        if (selectColumnsRouters != null && selectColumnsRouters.length > 0) {
            for (Field field : fields) {
                if (!field.isAnnotationPresent(this.sqlColumnClass) || !SQLBuilderUtils.fieldRoutersInParamRouters(field.getAnnotation(this.sqlColumnClass).routers(), selectColumnsRouters)) continue;
                String column = SQLDefineUtils.java2SQL(field.getAnnotation(this.sqlColumnClass).value(), field.getName());
                sb.append(tableName).append(".").append(column).append(", ");
            }
        } else {
            sb.append(tableName).append(".").append("*");
        }
    }

    private void assembleWhereSQL(StringBuilder sb, Field[] fields, int[] routers) {
        for (Field field : fields) {
            if (!field.isAnnotationPresent(this.sqlColumnClass) || !SQLBuilderUtils.fieldRoutersInParamRouters(field.getAnnotation(this.sqlColumnClass).routers(), routers)) continue;
            String column = SQLDefineUtils.java2SQL(field.getAnnotation(this.sqlColumnClass).value(), field.getName());
            sb.append(column).append(" = :").append(field.getName()).append(" AND ");
        }
    }
}

