/*
 * Decompiled with CFR 0.152.
 */
package me.tfeng.toolbox.mongodb;

import com.google.common.collect.ImmutableMap;
import com.mongodb.DBObject;
import com.mongodb.util.JSON;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.bson.types.BSONTimestamp;
import org.bson.types.ObjectId;

public class MongoDbTypeConverter {
    public static final Map<Pair<Class<?>, Class<?>>, Converter<?, ?>> CONVERTER_MAP = ImmutableMap.builder().put((Object)ImmutablePair.of(BSONTimestamp.class, Long.class), (Object)new BSONTimestampToLongConverter()).put((Object)ImmutablePair.of(BSONTimestamp.class, String.class), (Object)new BSONTimestampToStringConverter()).put((Object)ImmutablePair.of(Date.class, Long.class), (Object)new DateToLongConverter()).put((Object)ImmutablePair.of(Date.class, String.class), (Object)new DateToStringConverter()).put((Object)ImmutablePair.of(ObjectId.class, String.class), (Object)new ObjectIdToStringConverter()).build();
    public static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    public static final Pattern TIMESTAMP_PATTERN = Pattern.compile("\\(([0-9]+),\\s*([0-9]+)\\)");

    public static <S, T> T convertFromMongoDbType(Class<T> clazz, S s) {
        if (s == null) {
            return null;
        }
        if (clazz.isInstance(s)) {
            return clazz.cast(s);
        }
        Converter<?, ?> converter = CONVERTER_MAP.get(ImmutablePair.of(s.getClass(), clazz));
        if (converter != null) {
            return (T)converter.convertFromMongoDbType(s);
        }
        if (String.class.isAssignableFrom(clazz) && s instanceof DBObject) {
            return clazz.cast(JSON.serialize(s));
        }
        return null;
    }

    public static <S, T> S convertToMongoDbType(Class<S> clazz, T t) {
        if (t == null) {
            return null;
        }
        if (clazz.isInstance(t)) {
            return clazz.cast(t);
        }
        Converter<?, ?> converter = CONVERTER_MAP.get(ImmutablePair.of(clazz, t.getClass()));
        if (converter != null) {
            return (S)converter.convertToMongoDbType(t);
        }
        if (DBObject.class.isAssignableFrom(clazz) && t instanceof String) {
            return clazz.cast(JSON.parse((String)((String)t)));
        }
        return null;
    }

    static {
        DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public static class ObjectIdToStringConverter
    implements Converter<ObjectId, String> {
        @Override
        public String convertFromMongoDbType(ObjectId objectId) {
            return objectId.toString();
        }

        @Override
        public ObjectId convertToMongoDbType(String string) {
            return new ObjectId(string);
        }
    }

    public static class DateToStringConverter
    implements Converter<Date, String> {
        @Override
        public String convertFromMongoDbType(Date date) {
            return DATE_FORMAT.format(date);
        }

        @Override
        public Date convertToMongoDbType(String string) {
            try {
                return DATE_FORMAT.parse(string);
            }
            catch (ParseException parseException) {
                throw new RuntimeException("String does not confirm to date format: " + string);
            }
        }
    }

    public static class DateToLongConverter
    implements Converter<Date, Long> {
        @Override
        public Long convertFromMongoDbType(Date date) {
            return date.getTime();
        }

        @Override
        public Date convertToMongoDbType(Long l) {
            return new Date(l);
        }
    }

    public static class BSONTimestampToStringConverter
    implements Converter<BSONTimestamp, String> {
        @Override
        public String convertFromMongoDbType(BSONTimestamp bSONTimestamp) {
            return "(" + bSONTimestamp.getTime() + ", " + bSONTimestamp.getInc() + ")";
        }

        @Override
        public BSONTimestamp convertToMongoDbType(String string) {
            Matcher matcher = TIMESTAMP_PATTERN.matcher(string);
            if (!matcher.matches()) {
                throw new RuntimeException("Invalid BSONTimestamp " + string);
            }
            int n = Integer.parseInt(matcher.group(1));
            int n2 = Integer.parseInt(matcher.group(2));
            return new BSONTimestamp(n, n2);
        }
    }

    public static class BSONTimestampToLongConverter
    implements Converter<BSONTimestamp, Long> {
        @Override
        public Long convertFromMongoDbType(BSONTimestamp bSONTimestamp) {
            int n = bSONTimestamp.getInc();
            if (n < 0 || n >= 1000) {
                throw new RuntimeException("Overflow occurs while converting BSONTimestamp into long: " + bSONTimestamp);
            }
            return (long)bSONTimestamp.getTime() * 1000L + (long)n;
        }

        @Override
        public BSONTimestamp convertToMongoDbType(Long l) {
            return new BSONTimestamp((int)(l / 1000L), (int)(l % 1000L));
        }
    }

    public static interface Converter<S, T> {
        public T convertFromMongoDbType(S var1);

        public S convertToMongoDbType(T var1);
    }
}

