/*
 * Decompiled with CFR 0.152.
 */
package me.tfeng.toolbox.mongodb;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.avro.io.Decoder;
import org.apache.avro.util.Utf8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingDecoder
extends Decoder {
    private static final Logger LOG = LoggerFactory.getLogger(LoggingDecoder.class);
    private final Decoder decoder;

    public LoggingDecoder(Decoder decoder) throws IOException {
        this.decoder = decoder;
    }

    public long arrayNext() throws IOException {
        long l = this.decoder.arrayNext();
        LOG.info("arrayNext() = " + l);
        return l;
    }

    public long mapNext() throws IOException {
        long l = this.decoder.mapNext();
        LOG.info("mapNext() = " + l);
        return l;
    }

    public long readArrayStart() throws IOException {
        long l = this.decoder.readArrayStart();
        LOG.info("readArrayStart() = " + l);
        return l;
    }

    public boolean readBoolean() throws IOException {
        boolean bl = this.decoder.readBoolean();
        LOG.info("readBoolean() = " + bl);
        return bl;
    }

    public ByteBuffer readBytes(ByteBuffer byteBuffer) throws IOException {
        ByteBuffer byteBuffer2 = this.decoder.readBytes(byteBuffer);
        LOG.info("readBytes(...) = ...");
        return byteBuffer2;
    }

    public double readDouble() throws IOException {
        double d = this.decoder.readDouble();
        LOG.info("readDouble() = " + d);
        return d;
    }

    public int readEnum() throws IOException {
        int n = this.decoder.readEnum();
        LOG.info("readEnum() = " + n);
        return n;
    }

    public void readFixed(byte[] byArray, int n, int n2) throws IOException {
        this.decoder.readFixed(byArray, n, n2);
        LOG.info("readFixed(..., " + n + ", " + n2 + ")");
    }

    public float readFloat() throws IOException {
        float f = this.decoder.readFloat();
        LOG.info("readFloat() = " + f);
        return f;
    }

    public int readIndex() throws IOException {
        int n = this.decoder.readIndex();
        LOG.info("readIndex() = " + n);
        return n;
    }

    public int readInt() throws IOException {
        int n = this.decoder.readInt();
        LOG.info("readInt() = " + n);
        return n;
    }

    public long readLong() throws IOException {
        long l = this.decoder.readLong();
        LOG.info("readLong() = " + l);
        return l;
    }

    public long readMapStart() throws IOException {
        long l = this.decoder.readMapStart();
        LOG.info("readMapStart() = " + l);
        return l;
    }

    public void readNull() throws IOException {
        this.decoder.readNull();
        LOG.info("readNull()");
    }

    public String readString() throws IOException {
        String string = this.decoder.readString();
        LOG.info("readString() = " + string);
        return string;
    }

    public Utf8 readString(Utf8 utf8) throws IOException {
        Utf8 utf82 = this.decoder.readString(utf8);
        LOG.info("readString(" + utf8 + ") = " + utf82);
        return utf82;
    }

    public long skipArray() throws IOException {
        long l = this.decoder.skipArray();
        LOG.info("skipArray() = " + l);
        return l;
    }

    public void skipBytes() throws IOException {
        this.decoder.skipBytes();
        LOG.info("skipBytes()");
    }

    public void skipFixed(int n) throws IOException {
        this.decoder.skipFixed(n);
        LOG.info("skipFixed(" + n + ")");
    }

    public long skipMap() throws IOException {
        long l = this.decoder.skipMap();
        LOG.info("skipMap() = " + l);
        return l;
    }

    public void skipString() throws IOException {
        this.decoder.skipString();
        LOG.info("skipString()");
    }
}

