/*
 * Decompiled with CFR 0.152.
 */
package me.qoomon.maven.gitversioning;

import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.google.common.collect.Maps;
import com.google.inject.Key;
import com.google.inject.OutOfScopeException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import me.qoomon.UncheckedExceptions;
import me.qoomon.gitversioning.GitRepoSituation;
import me.qoomon.gitversioning.GitUtil;
import me.qoomon.gitversioning.GitVersionDetails;
import me.qoomon.gitversioning.GitVersioning;
import me.qoomon.gitversioning.PropertyDescription;
import me.qoomon.gitversioning.PropertyValueDescription;
import me.qoomon.gitversioning.VersionDescription;
import me.qoomon.maven.gitversioning.BuildProperties;
import me.qoomon.maven.gitversioning.Configuration;
import me.qoomon.maven.gitversioning.GAV;
import me.qoomon.maven.gitversioning.MavenUtil;
import me.qoomon.maven.gitversioning.VersioningMojo;
import org.apache.maven.building.Source;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.building.DefaultModelProcessor;
import org.apache.maven.session.scope.internal.SessionScope;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;

@Component(role=org.apache.maven.model.building.ModelProcessor.class)
public class ModelProcessor
extends DefaultModelProcessor {
    private final Logger logger;
    private final SessionScope sessionScope;
    private boolean initialized = false;
    private MavenSession mavenSession;
    private Configuration config;
    private GitVersionDetails gitVersionDetails;
    private final Map<String, Model> virtualProjectModelCache = new HashMap<String, Model>();

    @Inject
    public ModelProcessor(Logger logger, SessionScope sessionScope) {
        this.logger = logger;
        this.sessionScope = sessionScope;
    }

    public Model read(File input, Map<String, ?> options) throws IOException {
        Model projectModel = super.read(input, options);
        return this.processModel(projectModel, options);
    }

    public Model read(Reader input, Map<String, ?> options) throws IOException {
        Model projectModel = super.read(input, options);
        return this.processModel(projectModel, options);
    }

    public Model read(InputStream input, Map<String, ?> options) throws IOException {
        Model projectModel = super.read(input, options);
        return this.processModel(projectModel, options);
    }

    private Model processModel(Model projectModel, Map<String, ?> options) throws IOException {
        try {
            if (!this.initialized) {
                this.logger.info("");
                this.logger.info("--- " + BuildProperties.projectArtifactId() + ":" + BuildProperties.projectVersion() + " ---");
                try {
                    this.mavenSession = (MavenSession)this.sessionScope.scope(Key.get(MavenSession.class), null).get();
                }
                catch (OutOfScopeException ex) {
                    this.mavenSession = null;
                }
                this.initialized = true;
            }
            if (this.mavenSession == null) {
                this.logger.warn("skip - no maven session present");
                return projectModel;
            }
            Source pomSource = (Source)options.get("org.apache.maven.model.building.source");
            if (pomSource != null) {
                projectModel.setPomFile(new File(pomSource.getLocation()));
            }
            return this.processModel(projectModel);
        }
        catch (Exception e) {
            throw new IOException("Git Versioning Model Processor", e);
        }
    }

    private Model processModel(Model projectModel) {
        String projectId;
        Model virtualProjectModel;
        if (!MavenUtil.isProjectPom(projectModel.getPomFile())) {
            this.logger.debug("skip - unrelated pom location - " + projectModel.getPomFile());
            return projectModel;
        }
        if (projectModel.getPomFile().getName().equals(".git-versioned-pom.xml")) {
            this.logger.debug("skip - git versioned pom - " + projectModel.getPomFile());
            return projectModel;
        }
        GAV projectGav = GAV.of(projectModel);
        if (projectGav.getVersion() == null) {
            this.logger.debug("skip - invalid model - 'version' is missing - " + projectModel.getPomFile());
            return projectModel;
        }
        if (this.config == null) {
            File mvnDir = this.findMvnDir(projectModel);
            File configFile = new File(mvnDir, BuildProperties.projectArtifactId() + ".xml");
            this.config = this.loadConfig(configFile);
        }
        if (this.gitVersionDetails == null) {
            this.gitVersionDetails = this.getGitVersionDetails(this.config, projectModel);
        }
        if ((virtualProjectModel = this.virtualProjectModelCache.get(projectId = projectModel.getGroupId() + ":" + projectModel.getArtifactId())) == null) {
            this.logger.info(projectGav.getArtifactId() + " - set project version to " + this.gitVersionDetails.getVersion() + " (" + this.gitVersionDetails.getCommitRefType() + ":" + this.gitVersionDetails.getCommitRefName() + ")");
            virtualProjectModel = projectModel.clone();
            if (projectModel.getVersion() != null) {
                this.logger.debug(" replace project version");
                virtualProjectModel.setVersion(this.gitVersionDetails.getVersion());
            }
            virtualProjectModel.addProperty("git.commit", this.gitVersionDetails.getCommit());
            virtualProjectModel.addProperty("git.ref", this.gitVersionDetails.getCommitRefName());
            virtualProjectModel.addProperty("git." + this.gitVersionDetails.getCommitRefType(), this.gitVersionDetails.getCommitRefName());
            for (Map.Entry<String, String> entry : this.gitVersionDetails.getMetaData().entrySet()) {
                virtualProjectModel.addProperty("git.ref." + entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> property : this.gitVersionDetails.getProperties().entrySet()) {
                this.logger.info(projectGav.getArtifactId() + " - set property " + property.getKey() + " to " + property.getValue() + " (" + this.gitVersionDetails.getCommitRefType() + ":" + this.gitVersionDetails.getCommitRefName() + ")");
                virtualProjectModel.addProperty(property.getKey(), property.getValue());
            }
            Parent parent = projectModel.getParent();
            if (parent != null) {
                if (parent.getVersion() == null) {
                    this.logger.warn("skip - invalid model - parent 'version' is missing - " + projectModel.getPomFile());
                    return projectModel;
                }
                Model parentModel = this.getParentModel(projectModel);
                if (parentModel != null && MavenUtil.isProjectPom(parentModel.getPomFile())) {
                    if (projectModel.getVersion() != null) {
                        virtualProjectModel.setVersion(null);
                        this.logger.warn("Do not set version tag in a multi module project module: " + projectModel.getPomFile());
                        if (!projectModel.getVersion().equals(parent.getVersion())) {
                            throw new IllegalStateException("'version' has to be equal to parent 'version'");
                        }
                    }
                    this.logger.debug(" replace parent version");
                    virtualProjectModel.getParent().setVersion(this.gitVersionDetails.getVersion());
                }
            }
            boolean updatePomOption = this.getUpdatePomOption(this.config, this.gitVersionDetails);
            this.addBuildPlugin(virtualProjectModel, updatePomOption);
            this.virtualProjectModelCache.put(projectId, virtualProjectModel);
        }
        return virtualProjectModel;
    }

    private GitVersionDetails getGitVersionDetails(Configuration config, Model projectModel) {
        String providedTag;
        GitRepoSituation repoSituation = GitUtil.situation(projectModel.getPomFile());
        String providedBranch = this.getOption("git.branch");
        if (providedBranch != null) {
            repoSituation.setHeadBranch(providedBranch.isEmpty() ? null : providedBranch);
        }
        if ((providedTag = this.getOption("git.tag")) != null) {
            repoSituation.setHeadTags(providedTag.isEmpty() ? Collections.emptyList() : Collections.singletonList(providedTag));
        }
        return GitVersioning.determineVersion(repoSituation, Optional.ofNullable(config.commit).map(it -> new VersionDescription(null, it.versionFormat, this.convertPropertyDescription(it.property))).orElse(new VersionDescription()), config.branch.stream().map(it -> new VersionDescription(it.pattern, it.versionFormat, this.convertPropertyDescription(it.property))).collect(Collectors.toList()), config.tag.stream().map(it -> new VersionDescription(it.pattern, it.versionFormat, this.convertPropertyDescription(it.property))).collect(Collectors.toList()), GAV.of(projectModel).getVersion(), (Map<String, String>)Maps.fromProperties((Properties)projectModel.getProperties()));
    }

    private List<PropertyDescription> convertPropertyDescription(List<Configuration.PropertyDescription> confPropertyDescription) {
        return confPropertyDescription.stream().map(prop -> new PropertyDescription(prop.pattern, new PropertyValueDescription(prop.value.pattern, prop.value.format))).collect(Collectors.toList());
    }

    private Model getParentModel(Model projectModel) {
        GAV parentGav;
        if (projectModel.getParent() == null) {
            return null;
        }
        File parentPomPath = new File(projectModel.getProjectDirectory(), projectModel.getParent().getRelativePath());
        File parentPom = parentPomPath.isDirectory() ? new File(parentPomPath, "pom.xml") : parentPomPath;
        if (!parentPom.exists()) {
            return null;
        }
        Model parentModel = (Model)UncheckedExceptions.unchecked(() -> MavenUtil.readModel(parentPom));
        GAV parentModelGav = GAV.of(parentModel);
        if (!parentModelGav.equals(parentGav = GAV.of(projectModel.getParent()))) {
            return null;
        }
        return parentModel;
    }

    private File findMvnDir(Model projectModel) {
        File mvnDir = new File(projectModel.getProjectDirectory(), ".mvn");
        if (mvnDir.exists()) {
            this.logger.debug("Found .mvn directory in project directory - " + mvnDir.toString());
            return mvnDir;
        }
        Model parentModel = this.getParentModel(projectModel);
        while (parentModel != null && MavenUtil.isProjectPom(parentModel.getPomFile())) {
            File mvnDir2 = new File(parentModel.getProjectDirectory(), ".mvn");
            if (mvnDir2.exists()) {
                this.logger.debug("Found .mvn directory in parent project hierarchy - " + mvnDir2.toString());
                return mvnDir2;
            }
            parentModel = this.getParentModel(parentModel);
        }
        File gitDir = ((FileRepositoryBuilder)new FileRepositoryBuilder().findGitDir(projectModel.getProjectDirectory())).getGitDir();
        File parentDir = projectModel.getProjectDirectory().getParentFile();
        while (!parentDir.equals(gitDir)) {
            File mvnDir3 = new File(parentDir, ".mvn");
            if (mvnDir3.exists()) {
                this.logger.debug("Found .mvn directory in git directory hierarchy - " + mvnDir3.toString());
                return mvnDir3;
            }
            parentDir = parentDir.getParentFile();
        }
        this.logger.warn("Could not find .mvn directory!");
        return null;
    }

    private void addBuildPlugin(Model model, boolean updatePomOption) {
        this.logger.debug(model.getArtifactId() + " temporary add build plugin");
        Plugin plugin = VersioningMojo.asPlugin();
        PluginExecution execution = new PluginExecution();
        execution.setId("git-versioning");
        execution.getGoals().add("git-versioning");
        plugin.getExecutions().add(execution);
        if (model.getBuild() == null) {
            model.setBuild(new Build());
        }
        model.getBuild().getPlugins().add(plugin);
        model.getProperties().setProperty(VersioningMojo.propertyKeyPrefix + "updatePom", Boolean.toString(updatePomOption));
    }

    private String getOption(String name) {
        String value = this.mavenSession.getUserProperties().getProperty(name);
        if (value == null) {
            value = System.getenv("VERSIONING_" + name.replaceAll("\\.", "_").toUpperCase());
        }
        return value;
    }

    private Configuration loadConfig(File configFile) {
        if (!configFile.exists()) {
            return new Configuration();
        }
        this.logger.debug("load config from " + configFile);
        return (Configuration)UncheckedExceptions.unchecked(() -> (Configuration)new XmlMapper().readValue(configFile, Configuration.class));
    }

    private boolean getUpdatePomOption(Configuration config, GitVersionDetails gitVersionDetails) {
        boolean updatePomOption;
        boolean bl = updatePomOption = config.updatePom != null && config.updatePom != false;
        if (gitVersionDetails.getCommitRefType().equals("tag")) {
            updatePomOption = config.tag.stream().filter(it -> Pattern.matches(it.pattern, gitVersionDetails.getCommitRefName())).findFirst().map(it -> it.updatePom).orElse(updatePomOption);
        } else if (gitVersionDetails.getCommitRefType().equals("branch")) {
            updatePomOption = config.branch.stream().filter(it -> Pattern.matches(it.pattern, gitVersionDetails.getCommitRefName())).findFirst().map(it -> it.updatePom).orElse(updatePomOption);
        } else if (config.commit != null) {
            updatePomOption = Optional.ofNullable(config.commit.updatePom).orElse(updatePomOption);
        }
        return updatePomOption;
    }
}

