/*
 * Decompiled with CFR 0.152.
 */
package me.qoomon.maven.gitversioning;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

final class MavenUtil {
    MavenUtil() {
    }

    static Model readModel(File pomFile) throws IOException {
        Model model;
        FileInputStream inputStream = new FileInputStream(pomFile);
        try {
            Model model2 = new MavenXpp3Reader().read((InputStream)inputStream);
            model2.setPomFile(pomFile);
            model = model2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (XmlPullParserException e) {
                throw new RuntimeException(e);
            }
        }
        ((InputStream)inputStream).close();
        return model;
    }

    static void writeModel(File pomFile, Model model) throws IOException {
        try (FileWriter fileWriter = new FileWriter(pomFile);){
            new MavenXpp3Writer().write((Writer)fileWriter, model);
        }
    }

    static boolean isProjectPom(File pomFile) {
        return pomFile != null && pomFile.exists() && pomFile.isFile() && pomFile.getName().endsWith(".xml");
    }
}

