/*
 * Decompiled with CFR 0.152.
 */
package me.qoomon.gitversioning;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class StringUtil {
    public static String substituteText(String text, Map<String, String> substitutionMap) {
        String result = text;
        Pattern placeholderPattern = Pattern.compile("\\$\\{(.+?)}");
        Matcher placeholderMatcher = placeholderPattern.matcher(text);
        while (placeholderMatcher.find()) {
            String substitutionKey = placeholderMatcher.group(1);
            String substitutionValue = substitutionMap.get(substitutionKey);
            if (substitutionValue == null) continue;
            result = result.replaceAll("\\$\\{" + substitutionKey + "}", substitutionValue);
        }
        return result;
    }

    public static Map<String, String> valueGroupMap(String regex, String text) {
        HashMap<String, String> result = new HashMap<String, String>();
        Pattern groupPattern = Pattern.compile(regex);
        Matcher groupMatcher = groupPattern.matcher(text);
        if (groupMatcher.find()) {
            for (int i = 1; i <= groupMatcher.groupCount(); ++i) {
                result.put(String.valueOf(i), groupMatcher.group(i));
            }
            StringUtil.patternGroupNames(groupPattern).forEach(groupName -> result.put((String)groupName, groupMatcher.group((String)groupName)));
        }
        return result;
    }

    private static Set<String> patternGroupNames(Pattern groupPattern) {
        HashSet<String> groupNames = new HashSet<String>();
        Pattern groupNamePattern = Pattern.compile("\\(\\?<(?<name>[a-zA-Z][a-zA-Z0-9]*)>");
        Matcher groupNameMatcher = groupNamePattern.matcher(groupPattern.toString());
        while (groupNameMatcher.find()) {
            String groupName = groupNameMatcher.group("name");
            groupNames.add(groupName);
        }
        return groupNames;
    }
}

