/*
 * Decompiled with CFR 0.152.
 */
package me.qoomon.gitversioning;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import me.qoomon.gitversioning.GitRepoSituation;
import me.qoomon.gitversioning.GitVersionDetails;
import me.qoomon.gitversioning.PropertyDescription;
import me.qoomon.gitversioning.StringUtil;
import me.qoomon.gitversioning.VersionDescription;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;

public final class GitVersioning {
    public static final String VERSION_DATE_TIME_FORMAT = "yyyyMMdd.HHmmss";
    public static final String NO_COMMIT_DATE = "00000000.000000";

    private GitVersioning() {
    }

    @Nonnull
    public static GitVersionDetails determineVersion(GitRepoSituation repoSituation, VersionDescription commitVersionDescription, List<VersionDescription> branchVersionDescriptions, List<VersionDescription> tagVersionDescriptions, String currentVersion, Map<String, String> currentProperties) {
        Objects.requireNonNull(repoSituation);
        Objects.requireNonNull(commitVersionDescription);
        Objects.requireNonNull(branchVersionDescriptions);
        Objects.requireNonNull(tagVersionDescriptions);
        String gitRefType = "commit";
        String gitRefName = repoSituation.getHeadCommit();
        VersionDescription versionDescription = commitVersionDescription;
        if (repoSituation.getHeadBranch() != null) {
            for (VersionDescription branchVersionDescription : branchVersionDescriptions) {
                Optional<String> versionBranch = Optional.of(repoSituation.getHeadBranch()).filter(branch -> branch.matches(branchVersionDescription.getPattern()));
                if (!versionBranch.isPresent()) continue;
                gitRefType = "branch";
                gitRefName = versionBranch.get();
                versionDescription = branchVersionDescription;
                break;
            }
        } else if (!repoSituation.getHeadTags().isEmpty()) {
            for (VersionDescription tagVersionDescription : tagVersionDescriptions) {
                Optional<String> versionTag = repoSituation.getHeadTags().stream().filter(tag -> tag.matches(tagVersionDescription.getPattern())).max(Comparator.comparing(DefaultArtifactVersion::new));
                if (!versionTag.isPresent()) continue;
                gitRefType = "tag";
                gitRefName = versionTag.get();
                versionDescription = tagVersionDescription;
                break;
            }
        }
        Map<String, String> refFields = StringUtil.valueGroupMap(versionDescription.getPattern(), gitRefName);
        HashMap<String, String> versionDataMap = new HashMap<String, String>();
        versionDataMap.put("version", currentVersion);
        versionDataMap.put("version.release", currentVersion.replaceFirst("-SNAPSHOT$", ""));
        versionDataMap.put("commit", repoSituation.getHeadCommit());
        versionDataMap.put("commit.short", repoSituation.getHeadCommit().substring(0, 7));
        versionDataMap.put("commit.timestamp", Long.toString(repoSituation.getHeadCommitTimestamp()));
        versionDataMap.put("commit.timestamp.datetime", GitVersioning.formatHeadCommitTimestamp(repoSituation.getHeadCommitTimestamp()));
        versionDataMap.put("ref", gitRefName);
        versionDataMap.put(gitRefType, gitRefName);
        versionDataMap.putAll(refFields);
        String gitVersion = StringUtil.substituteText(versionDescription.getVersionFormat(), versionDataMap).replace("/", "-");
        Map<String, String> gitProperties = GitVersioning.determineProperties(currentProperties, versionDescription.getPropertyDescriptions(), versionDataMap);
        return new GitVersionDetails(repoSituation.isClean(), repoSituation.getHeadCommit(), gitRefType, gitRefName, refFields, gitVersion, gitProperties);
    }

    private static Map<String, String> determineProperties(Map<String, String> currentProperties, List<PropertyDescription> propertyDescriptions, Map<String, String> versionDataMap) {
        HashMap<String, String> gitProperties = new HashMap<String, String>(currentProperties);
        for (Map.Entry<String, String> property : currentProperties.entrySet()) {
            Optional<PropertyDescription> propertyDescription = propertyDescriptions.stream().filter(it -> ((String)property.getKey()).matches(it.getPattern())).findFirst();
            if (!propertyDescription.isPresent() || !property.getValue().matches(propertyDescription.get().getValueDescription().getPattern())) continue;
            Map<String, String> propertyFields = StringUtil.valueGroupMap(propertyDescription.get().getValueDescription().getPattern(), property.getValue());
            HashMap<String, String> propertyDataMap = new HashMap<String, String>(versionDataMap);
            propertyDataMap.putAll(propertyFields);
            String gitPropertyValue = StringUtil.substituteText(propertyDescription.get().getValueDescription().getFormat(), propertyDataMap);
            gitProperties.put(property.getKey(), gitPropertyValue);
        }
        return gitProperties;
    }

    private static String formatHeadCommitTimestamp(long headCommitDate) {
        if (headCommitDate == 0L) {
            return NO_COMMIT_DATE;
        }
        return DateTimeFormatter.ofPattern(VERSION_DATE_TIME_FORMAT).withZone(ZoneOffset.UTC).format(Instant.ofEpochSecond(headCommitDate));
    }
}

