/*
 * Copyright (c) 2021 Proton Technologies AG
 * This file is part of Proton Technologies AG and ProtonCore.
 *
 * ProtonCore is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * ProtonCore is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with ProtonCore.  If not, see <https://www.gnu.org/licenses/>.
 */

package me.proton.core.accountmanager.presentation.compose

import androidx.compose.runtime.Composable
import androidx.compose.runtime.Stable
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.setValue

@Stable
class AccountPrimaryState(
    isDialogEnabled: Boolean = true
) {
    var isDialogEnabled by mutableStateOf(isDialogEnabled)
    var isDialogShowing by mutableStateOf(false)

    fun showDialog() {
        isDialogShowing = true
    }

    fun dismissDialog() {
        isDialogShowing = false
    }
}

@Composable
fun rememberAccountPrimaryState(
    isDialogEnabled: Boolean = true,
): AccountPrimaryState = remember {
    AccountPrimaryState(isDialogEnabled)
}
