package me.proton.core.usersettings.data.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;
import me.proton.core.data.room.db.CommonConverters;
import me.proton.core.domain.entity.UserId;
import me.proton.core.usersettings.data.entity.PasswordEntity;
import me.proton.core.usersettings.data.entity.RecoverySettingEntity;
import me.proton.core.usersettings.data.entity.TwoFAEntity;
import me.proton.core.usersettings.data.entity.UserSettingsEntity;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class UserSettingsDao_Impl extends UserSettingsDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<UserSettingsEntity> __insertionAdapterOfUserSettingsEntity;

  private final CommonConverters __commonConverters = new CommonConverters();

  private final EntityDeletionOrUpdateAdapter<UserSettingsEntity> __deletionAdapterOfUserSettingsEntity;

  private final EntityDeletionOrUpdateAdapter<UserSettingsEntity> __updateAdapterOfUserSettingsEntity;

  private final SharedSQLiteStatement __preparedStmtOfDelete;

  private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

  public UserSettingsDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfUserSettingsEntity = new EntityInsertionAdapter<UserSettingsEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR IGNORE INTO `UserSettingsEntity` (`userId`,`news`,`locale`,`logAuth`,`density`,`weekStart`,`dateFormat`,`timeFormat`,`earlyAccess`,`deviceRecovery`,`telemetry`,`crashReports`,`email_value`,`email_status`,`email_notify`,`email_reset`,`phone_value`,`phone_status`,`phone_notify`,`phone_reset`,`password_mode`,`password_expirationTime`,`twoFA_enabled`,`twoFA_allowed`,`twoFA_expirationTime`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final UserSettingsEntity entity) {
        final String _tmp = __commonConverters.fromUserIdToString(entity.getUserId());
        if (_tmp == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, _tmp);
        }
        if (entity.getNews() == null) {
          statement.bindNull(2);
        } else {
          statement.bindLong(2, entity.getNews());
        }
        if (entity.getLocale() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getLocale());
        }
        if (entity.getLogAuth() == null) {
          statement.bindNull(4);
        } else {
          statement.bindLong(4, entity.getLogAuth());
        }
        if (entity.getDensity() == null) {
          statement.bindNull(5);
        } else {
          statement.bindLong(5, entity.getDensity());
        }
        if (entity.getWeekStart() == null) {
          statement.bindNull(6);
        } else {
          statement.bindLong(6, entity.getWeekStart());
        }
        if (entity.getDateFormat() == null) {
          statement.bindNull(7);
        } else {
          statement.bindLong(7, entity.getDateFormat());
        }
        if (entity.getTimeFormat() == null) {
          statement.bindNull(8);
        } else {
          statement.bindLong(8, entity.getTimeFormat());
        }
        final Integer _tmp_1 = entity.getEarlyAccess() == null ? null : (entity.getEarlyAccess() ? 1 : 0);
        if (_tmp_1 == null) {
          statement.bindNull(9);
        } else {
          statement.bindLong(9, _tmp_1);
        }
        final Integer _tmp_2 = entity.getDeviceRecovery() == null ? null : (entity.getDeviceRecovery() ? 1 : 0);
        if (_tmp_2 == null) {
          statement.bindNull(10);
        } else {
          statement.bindLong(10, _tmp_2);
        }
        final Integer _tmp_3 = entity.getTelemetry() == null ? null : (entity.getTelemetry() ? 1 : 0);
        if (_tmp_3 == null) {
          statement.bindNull(11);
        } else {
          statement.bindLong(11, _tmp_3);
        }
        final Integer _tmp_4 = entity.getCrashReports() == null ? null : (entity.getCrashReports() ? 1 : 0);
        if (_tmp_4 == null) {
          statement.bindNull(12);
        } else {
          statement.bindLong(12, _tmp_4);
        }
        final RecoverySettingEntity _tmpEmail = entity.getEmail();
        if (_tmpEmail != null) {
          if (_tmpEmail.getValue() == null) {
            statement.bindNull(13);
          } else {
            statement.bindString(13, _tmpEmail.getValue());
          }
          if (_tmpEmail.getStatus() == null) {
            statement.bindNull(14);
          } else {
            statement.bindLong(14, _tmpEmail.getStatus());
          }
          if (_tmpEmail.getNotify() == null) {
            statement.bindNull(15);
          } else {
            statement.bindLong(15, _tmpEmail.getNotify());
          }
          if (_tmpEmail.getReset() == null) {
            statement.bindNull(16);
          } else {
            statement.bindLong(16, _tmpEmail.getReset());
          }
        } else {
          statement.bindNull(13);
          statement.bindNull(14);
          statement.bindNull(15);
          statement.bindNull(16);
        }
        final RecoverySettingEntity _tmpPhone = entity.getPhone();
        if (_tmpPhone != null) {
          if (_tmpPhone.getValue() == null) {
            statement.bindNull(17);
          } else {
            statement.bindString(17, _tmpPhone.getValue());
          }
          if (_tmpPhone.getStatus() == null) {
            statement.bindNull(18);
          } else {
            statement.bindLong(18, _tmpPhone.getStatus());
          }
          if (_tmpPhone.getNotify() == null) {
            statement.bindNull(19);
          } else {
            statement.bindLong(19, _tmpPhone.getNotify());
          }
          if (_tmpPhone.getReset() == null) {
            statement.bindNull(20);
          } else {
            statement.bindLong(20, _tmpPhone.getReset());
          }
        } else {
          statement.bindNull(17);
          statement.bindNull(18);
          statement.bindNull(19);
          statement.bindNull(20);
        }
        final PasswordEntity _tmpPassword = entity.getPassword();
        if (_tmpPassword.getMode() == null) {
          statement.bindNull(21);
        } else {
          statement.bindLong(21, _tmpPassword.getMode());
        }
        if (_tmpPassword.getExpirationTime() == null) {
          statement.bindNull(22);
        } else {
          statement.bindLong(22, _tmpPassword.getExpirationTime());
        }
        final TwoFAEntity _tmpTwoFA = entity.getTwoFA();
        if (_tmpTwoFA != null) {
          if (_tmpTwoFA.getEnabled() == null) {
            statement.bindNull(23);
          } else {
            statement.bindLong(23, _tmpTwoFA.getEnabled());
          }
          if (_tmpTwoFA.getAllowed() == null) {
            statement.bindNull(24);
          } else {
            statement.bindLong(24, _tmpTwoFA.getAllowed());
          }
          if (_tmpTwoFA.getExpirationTime() == null) {
            statement.bindNull(25);
          } else {
            statement.bindLong(25, _tmpTwoFA.getExpirationTime());
          }
        } else {
          statement.bindNull(23);
          statement.bindNull(24);
          statement.bindNull(25);
        }
      }
    };
    this.__deletionAdapterOfUserSettingsEntity = new EntityDeletionOrUpdateAdapter<UserSettingsEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "DELETE FROM `UserSettingsEntity` WHERE `userId` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final UserSettingsEntity entity) {
        final String _tmp = __commonConverters.fromUserIdToString(entity.getUserId());
        if (_tmp == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, _tmp);
        }
      }
    };
    this.__updateAdapterOfUserSettingsEntity = new EntityDeletionOrUpdateAdapter<UserSettingsEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR ABORT `UserSettingsEntity` SET `userId` = ?,`news` = ?,`locale` = ?,`logAuth` = ?,`density` = ?,`weekStart` = ?,`dateFormat` = ?,`timeFormat` = ?,`earlyAccess` = ?,`deviceRecovery` = ?,`telemetry` = ?,`crashReports` = ?,`email_value` = ?,`email_status` = ?,`email_notify` = ?,`email_reset` = ?,`phone_value` = ?,`phone_status` = ?,`phone_notify` = ?,`phone_reset` = ?,`password_mode` = ?,`password_expirationTime` = ?,`twoFA_enabled` = ?,`twoFA_allowed` = ?,`twoFA_expirationTime` = ? WHERE `userId` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final UserSettingsEntity entity) {
        final String _tmp = __commonConverters.fromUserIdToString(entity.getUserId());
        if (_tmp == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, _tmp);
        }
        if (entity.getNews() == null) {
          statement.bindNull(2);
        } else {
          statement.bindLong(2, entity.getNews());
        }
        if (entity.getLocale() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getLocale());
        }
        if (entity.getLogAuth() == null) {
          statement.bindNull(4);
        } else {
          statement.bindLong(4, entity.getLogAuth());
        }
        if (entity.getDensity() == null) {
          statement.bindNull(5);
        } else {
          statement.bindLong(5, entity.getDensity());
        }
        if (entity.getWeekStart() == null) {
          statement.bindNull(6);
        } else {
          statement.bindLong(6, entity.getWeekStart());
        }
        if (entity.getDateFormat() == null) {
          statement.bindNull(7);
        } else {
          statement.bindLong(7, entity.getDateFormat());
        }
        if (entity.getTimeFormat() == null) {
          statement.bindNull(8);
        } else {
          statement.bindLong(8, entity.getTimeFormat());
        }
        final Integer _tmp_1 = entity.getEarlyAccess() == null ? null : (entity.getEarlyAccess() ? 1 : 0);
        if (_tmp_1 == null) {
          statement.bindNull(9);
        } else {
          statement.bindLong(9, _tmp_1);
        }
        final Integer _tmp_2 = entity.getDeviceRecovery() == null ? null : (entity.getDeviceRecovery() ? 1 : 0);
        if (_tmp_2 == null) {
          statement.bindNull(10);
        } else {
          statement.bindLong(10, _tmp_2);
        }
        final Integer _tmp_3 = entity.getTelemetry() == null ? null : (entity.getTelemetry() ? 1 : 0);
        if (_tmp_3 == null) {
          statement.bindNull(11);
        } else {
          statement.bindLong(11, _tmp_3);
        }
        final Integer _tmp_4 = entity.getCrashReports() == null ? null : (entity.getCrashReports() ? 1 : 0);
        if (_tmp_4 == null) {
          statement.bindNull(12);
        } else {
          statement.bindLong(12, _tmp_4);
        }
        final RecoverySettingEntity _tmpEmail = entity.getEmail();
        if (_tmpEmail != null) {
          if (_tmpEmail.getValue() == null) {
            statement.bindNull(13);
          } else {
            statement.bindString(13, _tmpEmail.getValue());
          }
          if (_tmpEmail.getStatus() == null) {
            statement.bindNull(14);
          } else {
            statement.bindLong(14, _tmpEmail.getStatus());
          }
          if (_tmpEmail.getNotify() == null) {
            statement.bindNull(15);
          } else {
            statement.bindLong(15, _tmpEmail.getNotify());
          }
          if (_tmpEmail.getReset() == null) {
            statement.bindNull(16);
          } else {
            statement.bindLong(16, _tmpEmail.getReset());
          }
        } else {
          statement.bindNull(13);
          statement.bindNull(14);
          statement.bindNull(15);
          statement.bindNull(16);
        }
        final RecoverySettingEntity _tmpPhone = entity.getPhone();
        if (_tmpPhone != null) {
          if (_tmpPhone.getValue() == null) {
            statement.bindNull(17);
          } else {
            statement.bindString(17, _tmpPhone.getValue());
          }
          if (_tmpPhone.getStatus() == null) {
            statement.bindNull(18);
          } else {
            statement.bindLong(18, _tmpPhone.getStatus());
          }
          if (_tmpPhone.getNotify() == null) {
            statement.bindNull(19);
          } else {
            statement.bindLong(19, _tmpPhone.getNotify());
          }
          if (_tmpPhone.getReset() == null) {
            statement.bindNull(20);
          } else {
            statement.bindLong(20, _tmpPhone.getReset());
          }
        } else {
          statement.bindNull(17);
          statement.bindNull(18);
          statement.bindNull(19);
          statement.bindNull(20);
        }
        final PasswordEntity _tmpPassword = entity.getPassword();
        if (_tmpPassword.getMode() == null) {
          statement.bindNull(21);
        } else {
          statement.bindLong(21, _tmpPassword.getMode());
        }
        if (_tmpPassword.getExpirationTime() == null) {
          statement.bindNull(22);
        } else {
          statement.bindLong(22, _tmpPassword.getExpirationTime());
        }
        final TwoFAEntity _tmpTwoFA = entity.getTwoFA();
        if (_tmpTwoFA != null) {
          if (_tmpTwoFA.getEnabled() == null) {
            statement.bindNull(23);
          } else {
            statement.bindLong(23, _tmpTwoFA.getEnabled());
          }
          if (_tmpTwoFA.getAllowed() == null) {
            statement.bindNull(24);
          } else {
            statement.bindLong(24, _tmpTwoFA.getAllowed());
          }
          if (_tmpTwoFA.getExpirationTime() == null) {
            statement.bindNull(25);
          } else {
            statement.bindLong(25, _tmpTwoFA.getExpirationTime());
          }
        } else {
          statement.bindNull(23);
          statement.bindNull(24);
          statement.bindNull(25);
        }
        final String _tmp_5 = __commonConverters.fromUserIdToString(entity.getUserId());
        if (_tmp_5 == null) {
          statement.bindNull(26);
        } else {
          statement.bindString(26, _tmp_5);
        }
      }
    };
    this.__preparedStmtOfDelete = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "DELETE FROM UserSettingsEntity WHERE userId = ?";
        return _query;
      }
    };
    this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "DELETE FROM UserSettingsEntity";
        return _query;
      }
    };
  }

  @Override
  public Object insertOrIgnore(final UserSettingsEntity[] entities,
      final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfUserSettingsEntity.insert(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object delete(final UserSettingsEntity[] entities, final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __deletionAdapterOfUserSettingsEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object update(final UserSettingsEntity[] entities,
      final Continuation<? super Integer> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      @NonNull
      public Integer call() throws Exception {
        int _total = 0;
        __db.beginTransaction();
        try {
          _total += __updateAdapterOfUserSettingsEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return _total;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object insertOrUpdate(final UserSettingsEntity[] entities,
      final Continuation<? super Unit> $completion) {
    return RoomDatabaseKt.withTransaction(__db, (__cont) -> UserSettingsDao_Impl.super.insertOrUpdate(entities, __cont), $completion);
  }

  @Override
  public Object delete(final UserId userId, final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDelete.acquire();
        int _argIndex = 1;
        final String _tmp = __commonConverters.fromUserIdToString(userId);
        if (_tmp == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, _tmp);
        }
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfDelete.release(_stmt);
        }
      }
    }, arg1);
  }

  @Override
  public Object deleteAll(final Continuation<? super Unit> arg0) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteAll.acquire();
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfDeleteAll.release(_stmt);
        }
      }
    }, arg0);
  }

  @Override
  public Flow<UserSettingsEntity> observeByUserId(final UserId userId) {
    final String _sql = "SELECT * FROM UserSettingsEntity WHERE userId = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    final String _tmp = __commonConverters.fromUserIdToString(userId);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp);
    }
    return CoroutinesRoom.createFlow(__db, false, new String[] {"UserSettingsEntity"}, new Callable<UserSettingsEntity>() {
      @Override
      @Nullable
      public UserSettingsEntity call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
          final int _cursorIndexOfNews = CursorUtil.getColumnIndexOrThrow(_cursor, "news");
          final int _cursorIndexOfLocale = CursorUtil.getColumnIndexOrThrow(_cursor, "locale");
          final int _cursorIndexOfLogAuth = CursorUtil.getColumnIndexOrThrow(_cursor, "logAuth");
          final int _cursorIndexOfDensity = CursorUtil.getColumnIndexOrThrow(_cursor, "density");
          final int _cursorIndexOfWeekStart = CursorUtil.getColumnIndexOrThrow(_cursor, "weekStart");
          final int _cursorIndexOfDateFormat = CursorUtil.getColumnIndexOrThrow(_cursor, "dateFormat");
          final int _cursorIndexOfTimeFormat = CursorUtil.getColumnIndexOrThrow(_cursor, "timeFormat");
          final int _cursorIndexOfEarlyAccess = CursorUtil.getColumnIndexOrThrow(_cursor, "earlyAccess");
          final int _cursorIndexOfDeviceRecovery = CursorUtil.getColumnIndexOrThrow(_cursor, "deviceRecovery");
          final int _cursorIndexOfTelemetry = CursorUtil.getColumnIndexOrThrow(_cursor, "telemetry");
          final int _cursorIndexOfCrashReports = CursorUtil.getColumnIndexOrThrow(_cursor, "crashReports");
          final int _cursorIndexOfValue = CursorUtil.getColumnIndexOrThrow(_cursor, "email_value");
          final int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "email_status");
          final int _cursorIndexOfNotify = CursorUtil.getColumnIndexOrThrow(_cursor, "email_notify");
          final int _cursorIndexOfReset = CursorUtil.getColumnIndexOrThrow(_cursor, "email_reset");
          final int _cursorIndexOfValue_1 = CursorUtil.getColumnIndexOrThrow(_cursor, "phone_value");
          final int _cursorIndexOfStatus_1 = CursorUtil.getColumnIndexOrThrow(_cursor, "phone_status");
          final int _cursorIndexOfNotify_1 = CursorUtil.getColumnIndexOrThrow(_cursor, "phone_notify");
          final int _cursorIndexOfReset_1 = CursorUtil.getColumnIndexOrThrow(_cursor, "phone_reset");
          final int _cursorIndexOfMode = CursorUtil.getColumnIndexOrThrow(_cursor, "password_mode");
          final int _cursorIndexOfExpirationTime = CursorUtil.getColumnIndexOrThrow(_cursor, "password_expirationTime");
          final int _cursorIndexOfEnabled = CursorUtil.getColumnIndexOrThrow(_cursor, "twoFA_enabled");
          final int _cursorIndexOfAllowed = CursorUtil.getColumnIndexOrThrow(_cursor, "twoFA_allowed");
          final int _cursorIndexOfExpirationTime_1 = CursorUtil.getColumnIndexOrThrow(_cursor, "twoFA_expirationTime");
          final UserSettingsEntity _result;
          if (_cursor.moveToFirst()) {
            final UserId _tmpUserId;
            final String _tmp_1;
            if (_cursor.isNull(_cursorIndexOfUserId)) {
              _tmp_1 = null;
            } else {
              _tmp_1 = _cursor.getString(_cursorIndexOfUserId);
            }
            _tmpUserId = __commonConverters.fromStringToUserId(_tmp_1);
            final Integer _tmpNews;
            if (_cursor.isNull(_cursorIndexOfNews)) {
              _tmpNews = null;
            } else {
              _tmpNews = _cursor.getInt(_cursorIndexOfNews);
            }
            final String _tmpLocale;
            if (_cursor.isNull(_cursorIndexOfLocale)) {
              _tmpLocale = null;
            } else {
              _tmpLocale = _cursor.getString(_cursorIndexOfLocale);
            }
            final Integer _tmpLogAuth;
            if (_cursor.isNull(_cursorIndexOfLogAuth)) {
              _tmpLogAuth = null;
            } else {
              _tmpLogAuth = _cursor.getInt(_cursorIndexOfLogAuth);
            }
            final Integer _tmpDensity;
            if (_cursor.isNull(_cursorIndexOfDensity)) {
              _tmpDensity = null;
            } else {
              _tmpDensity = _cursor.getInt(_cursorIndexOfDensity);
            }
            final Integer _tmpWeekStart;
            if (_cursor.isNull(_cursorIndexOfWeekStart)) {
              _tmpWeekStart = null;
            } else {
              _tmpWeekStart = _cursor.getInt(_cursorIndexOfWeekStart);
            }
            final Integer _tmpDateFormat;
            if (_cursor.isNull(_cursorIndexOfDateFormat)) {
              _tmpDateFormat = null;
            } else {
              _tmpDateFormat = _cursor.getInt(_cursorIndexOfDateFormat);
            }
            final Integer _tmpTimeFormat;
            if (_cursor.isNull(_cursorIndexOfTimeFormat)) {
              _tmpTimeFormat = null;
            } else {
              _tmpTimeFormat = _cursor.getInt(_cursorIndexOfTimeFormat);
            }
            final Boolean _tmpEarlyAccess;
            final Integer _tmp_2;
            if (_cursor.isNull(_cursorIndexOfEarlyAccess)) {
              _tmp_2 = null;
            } else {
              _tmp_2 = _cursor.getInt(_cursorIndexOfEarlyAccess);
            }
            _tmpEarlyAccess = _tmp_2 == null ? null : _tmp_2 != 0;
            final Boolean _tmpDeviceRecovery;
            final Integer _tmp_3;
            if (_cursor.isNull(_cursorIndexOfDeviceRecovery)) {
              _tmp_3 = null;
            } else {
              _tmp_3 = _cursor.getInt(_cursorIndexOfDeviceRecovery);
            }
            _tmpDeviceRecovery = _tmp_3 == null ? null : _tmp_3 != 0;
            final Boolean _tmpTelemetry;
            final Integer _tmp_4;
            if (_cursor.isNull(_cursorIndexOfTelemetry)) {
              _tmp_4 = null;
            } else {
              _tmp_4 = _cursor.getInt(_cursorIndexOfTelemetry);
            }
            _tmpTelemetry = _tmp_4 == null ? null : _tmp_4 != 0;
            final Boolean _tmpCrashReports;
            final Integer _tmp_5;
            if (_cursor.isNull(_cursorIndexOfCrashReports)) {
              _tmp_5 = null;
            } else {
              _tmp_5 = _cursor.getInt(_cursorIndexOfCrashReports);
            }
            _tmpCrashReports = _tmp_5 == null ? null : _tmp_5 != 0;
            final RecoverySettingEntity _tmpEmail;
            if (!(_cursor.isNull(_cursorIndexOfValue) && _cursor.isNull(_cursorIndexOfStatus) && _cursor.isNull(_cursorIndexOfNotify) && _cursor.isNull(_cursorIndexOfReset))) {
              final String _tmpValue;
              if (_cursor.isNull(_cursorIndexOfValue)) {
                _tmpValue = null;
              } else {
                _tmpValue = _cursor.getString(_cursorIndexOfValue);
              }
              final Integer _tmpStatus;
              if (_cursor.isNull(_cursorIndexOfStatus)) {
                _tmpStatus = null;
              } else {
                _tmpStatus = _cursor.getInt(_cursorIndexOfStatus);
              }
              final Integer _tmpNotify;
              if (_cursor.isNull(_cursorIndexOfNotify)) {
                _tmpNotify = null;
              } else {
                _tmpNotify = _cursor.getInt(_cursorIndexOfNotify);
              }
              final Integer _tmpReset;
              if (_cursor.isNull(_cursorIndexOfReset)) {
                _tmpReset = null;
              } else {
                _tmpReset = _cursor.getInt(_cursorIndexOfReset);
              }
              _tmpEmail = new RecoverySettingEntity(_tmpValue,_tmpStatus,_tmpNotify,_tmpReset);
            } else {
              _tmpEmail = null;
            }
            final RecoverySettingEntity _tmpPhone;
            if (!(_cursor.isNull(_cursorIndexOfValue_1) && _cursor.isNull(_cursorIndexOfStatus_1) && _cursor.isNull(_cursorIndexOfNotify_1) && _cursor.isNull(_cursorIndexOfReset_1))) {
              final String _tmpValue_1;
              if (_cursor.isNull(_cursorIndexOfValue_1)) {
                _tmpValue_1 = null;
              } else {
                _tmpValue_1 = _cursor.getString(_cursorIndexOfValue_1);
              }
              final Integer _tmpStatus_1;
              if (_cursor.isNull(_cursorIndexOfStatus_1)) {
                _tmpStatus_1 = null;
              } else {
                _tmpStatus_1 = _cursor.getInt(_cursorIndexOfStatus_1);
              }
              final Integer _tmpNotify_1;
              if (_cursor.isNull(_cursorIndexOfNotify_1)) {
                _tmpNotify_1 = null;
              } else {
                _tmpNotify_1 = _cursor.getInt(_cursorIndexOfNotify_1);
              }
              final Integer _tmpReset_1;
              if (_cursor.isNull(_cursorIndexOfReset_1)) {
                _tmpReset_1 = null;
              } else {
                _tmpReset_1 = _cursor.getInt(_cursorIndexOfReset_1);
              }
              _tmpPhone = new RecoverySettingEntity(_tmpValue_1,_tmpStatus_1,_tmpNotify_1,_tmpReset_1);
            } else {
              _tmpPhone = null;
            }
            final PasswordEntity _tmpPassword;
            final Integer _tmpMode;
            if (_cursor.isNull(_cursorIndexOfMode)) {
              _tmpMode = null;
            } else {
              _tmpMode = _cursor.getInt(_cursorIndexOfMode);
            }
            final Integer _tmpExpirationTime;
            if (_cursor.isNull(_cursorIndexOfExpirationTime)) {
              _tmpExpirationTime = null;
            } else {
              _tmpExpirationTime = _cursor.getInt(_cursorIndexOfExpirationTime);
            }
            _tmpPassword = new PasswordEntity(_tmpMode,_tmpExpirationTime);
            final TwoFAEntity _tmpTwoFA;
            if (!(_cursor.isNull(_cursorIndexOfEnabled) && _cursor.isNull(_cursorIndexOfAllowed) && _cursor.isNull(_cursorIndexOfExpirationTime_1))) {
              final Integer _tmpEnabled;
              if (_cursor.isNull(_cursorIndexOfEnabled)) {
                _tmpEnabled = null;
              } else {
                _tmpEnabled = _cursor.getInt(_cursorIndexOfEnabled);
              }
              final Integer _tmpAllowed;
              if (_cursor.isNull(_cursorIndexOfAllowed)) {
                _tmpAllowed = null;
              } else {
                _tmpAllowed = _cursor.getInt(_cursorIndexOfAllowed);
              }
              final Integer _tmpExpirationTime_1;
              if (_cursor.isNull(_cursorIndexOfExpirationTime_1)) {
                _tmpExpirationTime_1 = null;
              } else {
                _tmpExpirationTime_1 = _cursor.getInt(_cursorIndexOfExpirationTime_1);
              }
              _tmpTwoFA = new TwoFAEntity(_tmpEnabled,_tmpAllowed,_tmpExpirationTime_1);
            } else {
              _tmpTwoFA = null;
            }
            _result = new UserSettingsEntity(_tmpUserId,_tmpEmail,_tmpPhone,_tmpPassword,_tmpTwoFA,_tmpNews,_tmpLocale,_tmpLogAuth,_tmpDensity,_tmpWeekStart,_tmpDateFormat,_tmpTimeFormat,_tmpEarlyAccess,_tmpDeviceRecovery,_tmpTelemetry,_tmpCrashReports);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object getByUserId(final UserId userId,
      final Continuation<? super UserSettingsEntity> arg1) {
    final String _sql = "SELECT * FROM UserSettingsEntity WHERE userId = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    final String _tmp = __commonConverters.fromUserIdToString(userId);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp);
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<UserSettingsEntity>() {
      @Override
      @Nullable
      public UserSettingsEntity call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
          final int _cursorIndexOfNews = CursorUtil.getColumnIndexOrThrow(_cursor, "news");
          final int _cursorIndexOfLocale = CursorUtil.getColumnIndexOrThrow(_cursor, "locale");
          final int _cursorIndexOfLogAuth = CursorUtil.getColumnIndexOrThrow(_cursor, "logAuth");
          final int _cursorIndexOfDensity = CursorUtil.getColumnIndexOrThrow(_cursor, "density");
          final int _cursorIndexOfWeekStart = CursorUtil.getColumnIndexOrThrow(_cursor, "weekStart");
          final int _cursorIndexOfDateFormat = CursorUtil.getColumnIndexOrThrow(_cursor, "dateFormat");
          final int _cursorIndexOfTimeFormat = CursorUtil.getColumnIndexOrThrow(_cursor, "timeFormat");
          final int _cursorIndexOfEarlyAccess = CursorUtil.getColumnIndexOrThrow(_cursor, "earlyAccess");
          final int _cursorIndexOfDeviceRecovery = CursorUtil.getColumnIndexOrThrow(_cursor, "deviceRecovery");
          final int _cursorIndexOfTelemetry = CursorUtil.getColumnIndexOrThrow(_cursor, "telemetry");
          final int _cursorIndexOfCrashReports = CursorUtil.getColumnIndexOrThrow(_cursor, "crashReports");
          final int _cursorIndexOfValue = CursorUtil.getColumnIndexOrThrow(_cursor, "email_value");
          final int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "email_status");
          final int _cursorIndexOfNotify = CursorUtil.getColumnIndexOrThrow(_cursor, "email_notify");
          final int _cursorIndexOfReset = CursorUtil.getColumnIndexOrThrow(_cursor, "email_reset");
          final int _cursorIndexOfValue_1 = CursorUtil.getColumnIndexOrThrow(_cursor, "phone_value");
          final int _cursorIndexOfStatus_1 = CursorUtil.getColumnIndexOrThrow(_cursor, "phone_status");
          final int _cursorIndexOfNotify_1 = CursorUtil.getColumnIndexOrThrow(_cursor, "phone_notify");
          final int _cursorIndexOfReset_1 = CursorUtil.getColumnIndexOrThrow(_cursor, "phone_reset");
          final int _cursorIndexOfMode = CursorUtil.getColumnIndexOrThrow(_cursor, "password_mode");
          final int _cursorIndexOfExpirationTime = CursorUtil.getColumnIndexOrThrow(_cursor, "password_expirationTime");
          final int _cursorIndexOfEnabled = CursorUtil.getColumnIndexOrThrow(_cursor, "twoFA_enabled");
          final int _cursorIndexOfAllowed = CursorUtil.getColumnIndexOrThrow(_cursor, "twoFA_allowed");
          final int _cursorIndexOfExpirationTime_1 = CursorUtil.getColumnIndexOrThrow(_cursor, "twoFA_expirationTime");
          final UserSettingsEntity _result;
          if (_cursor.moveToFirst()) {
            final UserId _tmpUserId;
            final String _tmp_1;
            if (_cursor.isNull(_cursorIndexOfUserId)) {
              _tmp_1 = null;
            } else {
              _tmp_1 = _cursor.getString(_cursorIndexOfUserId);
            }
            _tmpUserId = __commonConverters.fromStringToUserId(_tmp_1);
            final Integer _tmpNews;
            if (_cursor.isNull(_cursorIndexOfNews)) {
              _tmpNews = null;
            } else {
              _tmpNews = _cursor.getInt(_cursorIndexOfNews);
            }
            final String _tmpLocale;
            if (_cursor.isNull(_cursorIndexOfLocale)) {
              _tmpLocale = null;
            } else {
              _tmpLocale = _cursor.getString(_cursorIndexOfLocale);
            }
            final Integer _tmpLogAuth;
            if (_cursor.isNull(_cursorIndexOfLogAuth)) {
              _tmpLogAuth = null;
            } else {
              _tmpLogAuth = _cursor.getInt(_cursorIndexOfLogAuth);
            }
            final Integer _tmpDensity;
            if (_cursor.isNull(_cursorIndexOfDensity)) {
              _tmpDensity = null;
            } else {
              _tmpDensity = _cursor.getInt(_cursorIndexOfDensity);
            }
            final Integer _tmpWeekStart;
            if (_cursor.isNull(_cursorIndexOfWeekStart)) {
              _tmpWeekStart = null;
            } else {
              _tmpWeekStart = _cursor.getInt(_cursorIndexOfWeekStart);
            }
            final Integer _tmpDateFormat;
            if (_cursor.isNull(_cursorIndexOfDateFormat)) {
              _tmpDateFormat = null;
            } else {
              _tmpDateFormat = _cursor.getInt(_cursorIndexOfDateFormat);
            }
            final Integer _tmpTimeFormat;
            if (_cursor.isNull(_cursorIndexOfTimeFormat)) {
              _tmpTimeFormat = null;
            } else {
              _tmpTimeFormat = _cursor.getInt(_cursorIndexOfTimeFormat);
            }
            final Boolean _tmpEarlyAccess;
            final Integer _tmp_2;
            if (_cursor.isNull(_cursorIndexOfEarlyAccess)) {
              _tmp_2 = null;
            } else {
              _tmp_2 = _cursor.getInt(_cursorIndexOfEarlyAccess);
            }
            _tmpEarlyAccess = _tmp_2 == null ? null : _tmp_2 != 0;
            final Boolean _tmpDeviceRecovery;
            final Integer _tmp_3;
            if (_cursor.isNull(_cursorIndexOfDeviceRecovery)) {
              _tmp_3 = null;
            } else {
              _tmp_3 = _cursor.getInt(_cursorIndexOfDeviceRecovery);
            }
            _tmpDeviceRecovery = _tmp_3 == null ? null : _tmp_3 != 0;
            final Boolean _tmpTelemetry;
            final Integer _tmp_4;
            if (_cursor.isNull(_cursorIndexOfTelemetry)) {
              _tmp_4 = null;
            } else {
              _tmp_4 = _cursor.getInt(_cursorIndexOfTelemetry);
            }
            _tmpTelemetry = _tmp_4 == null ? null : _tmp_4 != 0;
            final Boolean _tmpCrashReports;
            final Integer _tmp_5;
            if (_cursor.isNull(_cursorIndexOfCrashReports)) {
              _tmp_5 = null;
            } else {
              _tmp_5 = _cursor.getInt(_cursorIndexOfCrashReports);
            }
            _tmpCrashReports = _tmp_5 == null ? null : _tmp_5 != 0;
            final RecoverySettingEntity _tmpEmail;
            if (!(_cursor.isNull(_cursorIndexOfValue) && _cursor.isNull(_cursorIndexOfStatus) && _cursor.isNull(_cursorIndexOfNotify) && _cursor.isNull(_cursorIndexOfReset))) {
              final String _tmpValue;
              if (_cursor.isNull(_cursorIndexOfValue)) {
                _tmpValue = null;
              } else {
                _tmpValue = _cursor.getString(_cursorIndexOfValue);
              }
              final Integer _tmpStatus;
              if (_cursor.isNull(_cursorIndexOfStatus)) {
                _tmpStatus = null;
              } else {
                _tmpStatus = _cursor.getInt(_cursorIndexOfStatus);
              }
              final Integer _tmpNotify;
              if (_cursor.isNull(_cursorIndexOfNotify)) {
                _tmpNotify = null;
              } else {
                _tmpNotify = _cursor.getInt(_cursorIndexOfNotify);
              }
              final Integer _tmpReset;
              if (_cursor.isNull(_cursorIndexOfReset)) {
                _tmpReset = null;
              } else {
                _tmpReset = _cursor.getInt(_cursorIndexOfReset);
              }
              _tmpEmail = new RecoverySettingEntity(_tmpValue,_tmpStatus,_tmpNotify,_tmpReset);
            } else {
              _tmpEmail = null;
            }
            final RecoverySettingEntity _tmpPhone;
            if (!(_cursor.isNull(_cursorIndexOfValue_1) && _cursor.isNull(_cursorIndexOfStatus_1) && _cursor.isNull(_cursorIndexOfNotify_1) && _cursor.isNull(_cursorIndexOfReset_1))) {
              final String _tmpValue_1;
              if (_cursor.isNull(_cursorIndexOfValue_1)) {
                _tmpValue_1 = null;
              } else {
                _tmpValue_1 = _cursor.getString(_cursorIndexOfValue_1);
              }
              final Integer _tmpStatus_1;
              if (_cursor.isNull(_cursorIndexOfStatus_1)) {
                _tmpStatus_1 = null;
              } else {
                _tmpStatus_1 = _cursor.getInt(_cursorIndexOfStatus_1);
              }
              final Integer _tmpNotify_1;
              if (_cursor.isNull(_cursorIndexOfNotify_1)) {
                _tmpNotify_1 = null;
              } else {
                _tmpNotify_1 = _cursor.getInt(_cursorIndexOfNotify_1);
              }
              final Integer _tmpReset_1;
              if (_cursor.isNull(_cursorIndexOfReset_1)) {
                _tmpReset_1 = null;
              } else {
                _tmpReset_1 = _cursor.getInt(_cursorIndexOfReset_1);
              }
              _tmpPhone = new RecoverySettingEntity(_tmpValue_1,_tmpStatus_1,_tmpNotify_1,_tmpReset_1);
            } else {
              _tmpPhone = null;
            }
            final PasswordEntity _tmpPassword;
            final Integer _tmpMode;
            if (_cursor.isNull(_cursorIndexOfMode)) {
              _tmpMode = null;
            } else {
              _tmpMode = _cursor.getInt(_cursorIndexOfMode);
            }
            final Integer _tmpExpirationTime;
            if (_cursor.isNull(_cursorIndexOfExpirationTime)) {
              _tmpExpirationTime = null;
            } else {
              _tmpExpirationTime = _cursor.getInt(_cursorIndexOfExpirationTime);
            }
            _tmpPassword = new PasswordEntity(_tmpMode,_tmpExpirationTime);
            final TwoFAEntity _tmpTwoFA;
            if (!(_cursor.isNull(_cursorIndexOfEnabled) && _cursor.isNull(_cursorIndexOfAllowed) && _cursor.isNull(_cursorIndexOfExpirationTime_1))) {
              final Integer _tmpEnabled;
              if (_cursor.isNull(_cursorIndexOfEnabled)) {
                _tmpEnabled = null;
              } else {
                _tmpEnabled = _cursor.getInt(_cursorIndexOfEnabled);
              }
              final Integer _tmpAllowed;
              if (_cursor.isNull(_cursorIndexOfAllowed)) {
                _tmpAllowed = null;
              } else {
                _tmpAllowed = _cursor.getInt(_cursorIndexOfAllowed);
              }
              final Integer _tmpExpirationTime_1;
              if (_cursor.isNull(_cursorIndexOfExpirationTime_1)) {
                _tmpExpirationTime_1 = null;
              } else {
                _tmpExpirationTime_1 = _cursor.getInt(_cursorIndexOfExpirationTime_1);
              }
              _tmpTwoFA = new TwoFAEntity(_tmpEnabled,_tmpAllowed,_tmpExpirationTime_1);
            } else {
              _tmpTwoFA = null;
            }
            _result = new UserSettingsEntity(_tmpUserId,_tmpEmail,_tmpPhone,_tmpPassword,_tmpTwoFA,_tmpNews,_tmpLocale,_tmpLogAuth,_tmpDensity,_tmpWeekStart,_tmpDateFormat,_tmpTimeFormat,_tmpEarlyAccess,_tmpDeviceRecovery,_tmpTelemetry,_tmpCrashReports);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, arg1);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
