package me.proton.core.user.data.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;
import me.proton.core.crypto.android.keystore.CryptoConverters;
import me.proton.core.crypto.common.keystore.EncryptedByteArray;
import me.proton.core.data.room.db.CommonConverters;
import me.proton.core.key.domain.entity.key.KeyId;
import me.proton.core.user.data.db.UserConverters;
import me.proton.core.user.data.entity.AddressKeyEntity;
import me.proton.core.user.domain.entity.AddressId;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class AddressKeyDao_Impl extends AddressKeyDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<AddressKeyEntity> __insertionAdapterOfAddressKeyEntity;

  private final UserConverters __userConverters = new UserConverters();

  private final CryptoConverters __cryptoConverters = new CryptoConverters();

  private final CommonConverters __commonConverters = new CommonConverters();

  private final EntityDeletionOrUpdateAdapter<AddressKeyEntity> __deletionAdapterOfAddressKeyEntity;

  private final EntityDeletionOrUpdateAdapter<AddressKeyEntity> __updateAdapterOfAddressKeyEntity;

  private final SharedSQLiteStatement __preparedStmtOfDeleteAllByAddressId;

  public AddressKeyDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfAddressKeyEntity = new EntityInsertionAdapter<AddressKeyEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR IGNORE INTO `AddressKeyEntity` (`addressId`,`keyId`,`version`,`privateKey`,`isPrimary`,`isUnlockable`,`flags`,`passphrase`,`token`,`signature`,`fingerprint`,`fingerprints`,`activation`,`active`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final AddressKeyEntity entity) {
        final String _tmp = __userConverters.fromAddressIdToString(entity.getAddressId());
        if (_tmp == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, _tmp);
        }
        final String _tmp_1 = __userConverters.fromKeyIdToString(entity.getKeyId());
        if (_tmp_1 == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, _tmp_1);
        }
        statement.bindLong(3, entity.getVersion());
        if (entity.getPrivateKey() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getPrivateKey());
        }
        final int _tmp_2 = entity.isPrimary() ? 1 : 0;
        statement.bindLong(5, _tmp_2);
        final int _tmp_3 = entity.isUnlockable() ? 1 : 0;
        statement.bindLong(6, _tmp_3);
        statement.bindLong(7, entity.getFlags());
        final byte[] _tmp_4 = __cryptoConverters.fromEncryptedByteArrayToByteArray(entity.getPassphrase());
        if (_tmp_4 == null) {
          statement.bindNull(8);
        } else {
          statement.bindBlob(8, _tmp_4);
        }
        if (entity.getToken() == null) {
          statement.bindNull(9);
        } else {
          statement.bindString(9, entity.getToken());
        }
        if (entity.getSignature() == null) {
          statement.bindNull(10);
        } else {
          statement.bindString(10, entity.getSignature());
        }
        if (entity.getFingerprint() == null) {
          statement.bindNull(11);
        } else {
          statement.bindString(11, entity.getFingerprint());
        }
        final String _tmp_5 = __commonConverters.fromListOfStringToString(entity.getFingerprints());
        if (_tmp_5 == null) {
          statement.bindNull(12);
        } else {
          statement.bindString(12, _tmp_5);
        }
        if (entity.getActivation() == null) {
          statement.bindNull(13);
        } else {
          statement.bindString(13, entity.getActivation());
        }
        final int _tmp_6 = entity.getActive() ? 1 : 0;
        statement.bindLong(14, _tmp_6);
      }
    };
    this.__deletionAdapterOfAddressKeyEntity = new EntityDeletionOrUpdateAdapter<AddressKeyEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "DELETE FROM `AddressKeyEntity` WHERE `keyId` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final AddressKeyEntity entity) {
        final String _tmp = __userConverters.fromKeyIdToString(entity.getKeyId());
        if (_tmp == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, _tmp);
        }
      }
    };
    this.__updateAdapterOfAddressKeyEntity = new EntityDeletionOrUpdateAdapter<AddressKeyEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR ABORT `AddressKeyEntity` SET `addressId` = ?,`keyId` = ?,`version` = ?,`privateKey` = ?,`isPrimary` = ?,`isUnlockable` = ?,`flags` = ?,`passphrase` = ?,`token` = ?,`signature` = ?,`fingerprint` = ?,`fingerprints` = ?,`activation` = ?,`active` = ? WHERE `keyId` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final AddressKeyEntity entity) {
        final String _tmp = __userConverters.fromAddressIdToString(entity.getAddressId());
        if (_tmp == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, _tmp);
        }
        final String _tmp_1 = __userConverters.fromKeyIdToString(entity.getKeyId());
        if (_tmp_1 == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, _tmp_1);
        }
        statement.bindLong(3, entity.getVersion());
        if (entity.getPrivateKey() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getPrivateKey());
        }
        final int _tmp_2 = entity.isPrimary() ? 1 : 0;
        statement.bindLong(5, _tmp_2);
        final int _tmp_3 = entity.isUnlockable() ? 1 : 0;
        statement.bindLong(6, _tmp_3);
        statement.bindLong(7, entity.getFlags());
        final byte[] _tmp_4 = __cryptoConverters.fromEncryptedByteArrayToByteArray(entity.getPassphrase());
        if (_tmp_4 == null) {
          statement.bindNull(8);
        } else {
          statement.bindBlob(8, _tmp_4);
        }
        if (entity.getToken() == null) {
          statement.bindNull(9);
        } else {
          statement.bindString(9, entity.getToken());
        }
        if (entity.getSignature() == null) {
          statement.bindNull(10);
        } else {
          statement.bindString(10, entity.getSignature());
        }
        if (entity.getFingerprint() == null) {
          statement.bindNull(11);
        } else {
          statement.bindString(11, entity.getFingerprint());
        }
        final String _tmp_5 = __commonConverters.fromListOfStringToString(entity.getFingerprints());
        if (_tmp_5 == null) {
          statement.bindNull(12);
        } else {
          statement.bindString(12, _tmp_5);
        }
        if (entity.getActivation() == null) {
          statement.bindNull(13);
        } else {
          statement.bindString(13, entity.getActivation());
        }
        final int _tmp_6 = entity.getActive() ? 1 : 0;
        statement.bindLong(14, _tmp_6);
        final String _tmp_7 = __userConverters.fromKeyIdToString(entity.getKeyId());
        if (_tmp_7 == null) {
          statement.bindNull(15);
        } else {
          statement.bindString(15, _tmp_7);
        }
      }
    };
    this.__preparedStmtOfDeleteAllByAddressId = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "DELETE FROM AddressKeyEntity WHERE addressId = ?";
        return _query;
      }
    };
  }

  @Override
  public Object insertOrIgnore(final AddressKeyEntity[] entities,
      final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfAddressKeyEntity.insert(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object delete(final AddressKeyEntity[] entities, final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __deletionAdapterOfAddressKeyEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object update(final AddressKeyEntity[] entities,
      final Continuation<? super Integer> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      @NonNull
      public Integer call() throws Exception {
        int _total = 0;
        __db.beginTransaction();
        try {
          _total += __updateAdapterOfAddressKeyEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return _total;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object insertOrUpdate(final AddressKeyEntity[] entities,
      final Continuation<? super Unit> $completion) {
    return RoomDatabaseKt.withTransaction(__db, (__cont) -> AddressKeyDao_Impl.super.insertOrUpdate(entities, __cont), $completion);
  }

  @Override
  public Object deleteAllByAddressId(final AddressId addressId,
      final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteAllByAddressId.acquire();
        int _argIndex = 1;
        final String _tmp = __userConverters.fromAddressIdToString(addressId);
        if (_tmp == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, _tmp);
        }
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfDeleteAllByAddressId.release(_stmt);
        }
      }
    }, arg1);
  }

  @Override
  public Flow<List<AddressKeyEntity>> observeAllByAddressId(final AddressId addressId) {
    final String _sql = "SELECT * FROM AddressKeyEntity WHERE addressId = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    final String _tmp = __userConverters.fromAddressIdToString(addressId);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp);
    }
    return CoroutinesRoom.createFlow(__db, false, new String[] {"AddressKeyEntity"}, new Callable<List<AddressKeyEntity>>() {
      @Override
      @NonNull
      public List<AddressKeyEntity> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfAddressId = CursorUtil.getColumnIndexOrThrow(_cursor, "addressId");
          final int _cursorIndexOfKeyId = CursorUtil.getColumnIndexOrThrow(_cursor, "keyId");
          final int _cursorIndexOfVersion = CursorUtil.getColumnIndexOrThrow(_cursor, "version");
          final int _cursorIndexOfPrivateKey = CursorUtil.getColumnIndexOrThrow(_cursor, "privateKey");
          final int _cursorIndexOfIsPrimary = CursorUtil.getColumnIndexOrThrow(_cursor, "isPrimary");
          final int _cursorIndexOfIsUnlockable = CursorUtil.getColumnIndexOrThrow(_cursor, "isUnlockable");
          final int _cursorIndexOfFlags = CursorUtil.getColumnIndexOrThrow(_cursor, "flags");
          final int _cursorIndexOfPassphrase = CursorUtil.getColumnIndexOrThrow(_cursor, "passphrase");
          final int _cursorIndexOfToken = CursorUtil.getColumnIndexOrThrow(_cursor, "token");
          final int _cursorIndexOfSignature = CursorUtil.getColumnIndexOrThrow(_cursor, "signature");
          final int _cursorIndexOfFingerprint = CursorUtil.getColumnIndexOrThrow(_cursor, "fingerprint");
          final int _cursorIndexOfFingerprints = CursorUtil.getColumnIndexOrThrow(_cursor, "fingerprints");
          final int _cursorIndexOfActivation = CursorUtil.getColumnIndexOrThrow(_cursor, "activation");
          final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(_cursor, "active");
          final List<AddressKeyEntity> _result = new ArrayList<AddressKeyEntity>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final AddressKeyEntity _item;
            final AddressId _tmpAddressId;
            final String _tmp_1;
            if (_cursor.isNull(_cursorIndexOfAddressId)) {
              _tmp_1 = null;
            } else {
              _tmp_1 = _cursor.getString(_cursorIndexOfAddressId);
            }
            _tmpAddressId = __userConverters.fromStringToAddressId(_tmp_1);
            final KeyId _tmpKeyId;
            final String _tmp_2;
            if (_cursor.isNull(_cursorIndexOfKeyId)) {
              _tmp_2 = null;
            } else {
              _tmp_2 = _cursor.getString(_cursorIndexOfKeyId);
            }
            _tmpKeyId = __userConverters.fromStringToKeyId(_tmp_2);
            final int _tmpVersion;
            _tmpVersion = _cursor.getInt(_cursorIndexOfVersion);
            final String _tmpPrivateKey;
            if (_cursor.isNull(_cursorIndexOfPrivateKey)) {
              _tmpPrivateKey = null;
            } else {
              _tmpPrivateKey = _cursor.getString(_cursorIndexOfPrivateKey);
            }
            final boolean _tmpIsPrimary;
            final int _tmp_3;
            _tmp_3 = _cursor.getInt(_cursorIndexOfIsPrimary);
            _tmpIsPrimary = _tmp_3 != 0;
            final boolean _tmpIsUnlockable;
            final int _tmp_4;
            _tmp_4 = _cursor.getInt(_cursorIndexOfIsUnlockable);
            _tmpIsUnlockable = _tmp_4 != 0;
            final int _tmpFlags;
            _tmpFlags = _cursor.getInt(_cursorIndexOfFlags);
            final EncryptedByteArray _tmpPassphrase;
            final byte[] _tmp_5;
            if (_cursor.isNull(_cursorIndexOfPassphrase)) {
              _tmp_5 = null;
            } else {
              _tmp_5 = _cursor.getBlob(_cursorIndexOfPassphrase);
            }
            _tmpPassphrase = __cryptoConverters.fromByteArrayToEncryptedByteArray(_tmp_5);
            final String _tmpToken;
            if (_cursor.isNull(_cursorIndexOfToken)) {
              _tmpToken = null;
            } else {
              _tmpToken = _cursor.getString(_cursorIndexOfToken);
            }
            final String _tmpSignature;
            if (_cursor.isNull(_cursorIndexOfSignature)) {
              _tmpSignature = null;
            } else {
              _tmpSignature = _cursor.getString(_cursorIndexOfSignature);
            }
            final String _tmpFingerprint;
            if (_cursor.isNull(_cursorIndexOfFingerprint)) {
              _tmpFingerprint = null;
            } else {
              _tmpFingerprint = _cursor.getString(_cursorIndexOfFingerprint);
            }
            final List<String> _tmpFingerprints;
            final String _tmp_6;
            if (_cursor.isNull(_cursorIndexOfFingerprints)) {
              _tmp_6 = null;
            } else {
              _tmp_6 = _cursor.getString(_cursorIndexOfFingerprints);
            }
            _tmpFingerprints = __commonConverters.fromStringToListOfString(_tmp_6);
            final String _tmpActivation;
            if (_cursor.isNull(_cursorIndexOfActivation)) {
              _tmpActivation = null;
            } else {
              _tmpActivation = _cursor.getString(_cursorIndexOfActivation);
            }
            final boolean _tmpActive;
            final int _tmp_7;
            _tmp_7 = _cursor.getInt(_cursorIndexOfActive);
            _tmpActive = _tmp_7 != 0;
            _item = new AddressKeyEntity(_tmpAddressId,_tmpKeyId,_tmpVersion,_tmpPrivateKey,_tmpIsPrimary,_tmpIsUnlockable,_tmpFlags,_tmpPassphrase,_tmpToken,_tmpSignature,_tmpFingerprint,_tmpFingerprints,_tmpActivation,_tmpActive);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object getAllByAddressId(final AddressId addressId,
      final Continuation<? super List<AddressKeyEntity>> arg1) {
    final String _sql = "SELECT * FROM AddressKeyEntity WHERE addressId = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    final String _tmp = __userConverters.fromAddressIdToString(addressId);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp);
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<AddressKeyEntity>>() {
      @Override
      @NonNull
      public List<AddressKeyEntity> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfAddressId = CursorUtil.getColumnIndexOrThrow(_cursor, "addressId");
          final int _cursorIndexOfKeyId = CursorUtil.getColumnIndexOrThrow(_cursor, "keyId");
          final int _cursorIndexOfVersion = CursorUtil.getColumnIndexOrThrow(_cursor, "version");
          final int _cursorIndexOfPrivateKey = CursorUtil.getColumnIndexOrThrow(_cursor, "privateKey");
          final int _cursorIndexOfIsPrimary = CursorUtil.getColumnIndexOrThrow(_cursor, "isPrimary");
          final int _cursorIndexOfIsUnlockable = CursorUtil.getColumnIndexOrThrow(_cursor, "isUnlockable");
          final int _cursorIndexOfFlags = CursorUtil.getColumnIndexOrThrow(_cursor, "flags");
          final int _cursorIndexOfPassphrase = CursorUtil.getColumnIndexOrThrow(_cursor, "passphrase");
          final int _cursorIndexOfToken = CursorUtil.getColumnIndexOrThrow(_cursor, "token");
          final int _cursorIndexOfSignature = CursorUtil.getColumnIndexOrThrow(_cursor, "signature");
          final int _cursorIndexOfFingerprint = CursorUtil.getColumnIndexOrThrow(_cursor, "fingerprint");
          final int _cursorIndexOfFingerprints = CursorUtil.getColumnIndexOrThrow(_cursor, "fingerprints");
          final int _cursorIndexOfActivation = CursorUtil.getColumnIndexOrThrow(_cursor, "activation");
          final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(_cursor, "active");
          final List<AddressKeyEntity> _result = new ArrayList<AddressKeyEntity>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final AddressKeyEntity _item;
            final AddressId _tmpAddressId;
            final String _tmp_1;
            if (_cursor.isNull(_cursorIndexOfAddressId)) {
              _tmp_1 = null;
            } else {
              _tmp_1 = _cursor.getString(_cursorIndexOfAddressId);
            }
            _tmpAddressId = __userConverters.fromStringToAddressId(_tmp_1);
            final KeyId _tmpKeyId;
            final String _tmp_2;
            if (_cursor.isNull(_cursorIndexOfKeyId)) {
              _tmp_2 = null;
            } else {
              _tmp_2 = _cursor.getString(_cursorIndexOfKeyId);
            }
            _tmpKeyId = __userConverters.fromStringToKeyId(_tmp_2);
            final int _tmpVersion;
            _tmpVersion = _cursor.getInt(_cursorIndexOfVersion);
            final String _tmpPrivateKey;
            if (_cursor.isNull(_cursorIndexOfPrivateKey)) {
              _tmpPrivateKey = null;
            } else {
              _tmpPrivateKey = _cursor.getString(_cursorIndexOfPrivateKey);
            }
            final boolean _tmpIsPrimary;
            final int _tmp_3;
            _tmp_3 = _cursor.getInt(_cursorIndexOfIsPrimary);
            _tmpIsPrimary = _tmp_3 != 0;
            final boolean _tmpIsUnlockable;
            final int _tmp_4;
            _tmp_4 = _cursor.getInt(_cursorIndexOfIsUnlockable);
            _tmpIsUnlockable = _tmp_4 != 0;
            final int _tmpFlags;
            _tmpFlags = _cursor.getInt(_cursorIndexOfFlags);
            final EncryptedByteArray _tmpPassphrase;
            final byte[] _tmp_5;
            if (_cursor.isNull(_cursorIndexOfPassphrase)) {
              _tmp_5 = null;
            } else {
              _tmp_5 = _cursor.getBlob(_cursorIndexOfPassphrase);
            }
            _tmpPassphrase = __cryptoConverters.fromByteArrayToEncryptedByteArray(_tmp_5);
            final String _tmpToken;
            if (_cursor.isNull(_cursorIndexOfToken)) {
              _tmpToken = null;
            } else {
              _tmpToken = _cursor.getString(_cursorIndexOfToken);
            }
            final String _tmpSignature;
            if (_cursor.isNull(_cursorIndexOfSignature)) {
              _tmpSignature = null;
            } else {
              _tmpSignature = _cursor.getString(_cursorIndexOfSignature);
            }
            final String _tmpFingerprint;
            if (_cursor.isNull(_cursorIndexOfFingerprint)) {
              _tmpFingerprint = null;
            } else {
              _tmpFingerprint = _cursor.getString(_cursorIndexOfFingerprint);
            }
            final List<String> _tmpFingerprints;
            final String _tmp_6;
            if (_cursor.isNull(_cursorIndexOfFingerprints)) {
              _tmp_6 = null;
            } else {
              _tmp_6 = _cursor.getString(_cursorIndexOfFingerprints);
            }
            _tmpFingerprints = __commonConverters.fromStringToListOfString(_tmp_6);
            final String _tmpActivation;
            if (_cursor.isNull(_cursorIndexOfActivation)) {
              _tmpActivation = null;
            } else {
              _tmpActivation = _cursor.getString(_cursorIndexOfActivation);
            }
            final boolean _tmpActive;
            final int _tmp_7;
            _tmp_7 = _cursor.getInt(_cursorIndexOfActive);
            _tmpActive = _tmp_7 != 0;
            _item = new AddressKeyEntity(_tmpAddressId,_tmpKeyId,_tmpVersion,_tmpPrivateKey,_tmpIsPrimary,_tmpIsUnlockable,_tmpFlags,_tmpPassphrase,_tmpToken,_tmpSignature,_tmpFingerprint,_tmpFingerprints,_tmpActivation,_tmpActive);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, arg1);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
