package me.proton.core.mailsettings.data.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;
import me.proton.core.data.room.db.CommonConverters;
import me.proton.core.domain.entity.UserId;
import me.proton.core.mailsettings.data.entity.MailSettingsEntity;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class MailSettingsDao_Impl extends MailSettingsDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<MailSettingsEntity> __insertionAdapterOfMailSettingsEntity;

  private final CommonConverters __commonConverters = new CommonConverters();

  private final EntityDeletionOrUpdateAdapter<MailSettingsEntity> __deletionAdapterOfMailSettingsEntity;

  private final EntityDeletionOrUpdateAdapter<MailSettingsEntity> __updateAdapterOfMailSettingsEntity;

  private final SharedSQLiteStatement __preparedStmtOfDelete;

  private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

  public MailSettingsDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfMailSettingsEntity = new EntityInsertionAdapter<MailSettingsEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR IGNORE INTO `MailSettingsEntity` (`userId`,`displayName`,`signature`,`autoSaveContacts`,`composerMode`,`messageButtons`,`showImages`,`showMoved`,`viewMode`,`viewLayout`,`swipeLeft`,`swipeRight`,`shortcuts`,`pmSignature`,`numMessagePerPage`,`draftMimeType`,`receiveMimeType`,`showMimeType`,`enableFolderColor`,`inheritParentFolderColor`,`rightToLeft`,`attachPublicKey`,`sign`,`pgpScheme`,`promptPin`,`stickyLabels`,`confirmLink`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final MailSettingsEntity entity) {
        final String _tmp = __commonConverters.fromUserIdToString(entity.getUserId());
        if (_tmp == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, _tmp);
        }
        if (entity.getDisplayName() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getDisplayName());
        }
        if (entity.getSignature() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getSignature());
        }
        if (entity.getAutoSaveContacts() == null) {
          statement.bindNull(4);
        } else {
          statement.bindLong(4, entity.getAutoSaveContacts());
        }
        if (entity.getComposerMode() == null) {
          statement.bindNull(5);
        } else {
          statement.bindLong(5, entity.getComposerMode());
        }
        if (entity.getMessageButtons() == null) {
          statement.bindNull(6);
        } else {
          statement.bindLong(6, entity.getMessageButtons());
        }
        if (entity.getShowImages() == null) {
          statement.bindNull(7);
        } else {
          statement.bindLong(7, entity.getShowImages());
        }
        if (entity.getShowMoved() == null) {
          statement.bindNull(8);
        } else {
          statement.bindLong(8, entity.getShowMoved());
        }
        if (entity.getViewMode() == null) {
          statement.bindNull(9);
        } else {
          statement.bindLong(9, entity.getViewMode());
        }
        if (entity.getViewLayout() == null) {
          statement.bindNull(10);
        } else {
          statement.bindLong(10, entity.getViewLayout());
        }
        if (entity.getSwipeLeft() == null) {
          statement.bindNull(11);
        } else {
          statement.bindLong(11, entity.getSwipeLeft());
        }
        if (entity.getSwipeRight() == null) {
          statement.bindNull(12);
        } else {
          statement.bindLong(12, entity.getSwipeRight());
        }
        if (entity.getShortcuts() == null) {
          statement.bindNull(13);
        } else {
          statement.bindLong(13, entity.getShortcuts());
        }
        if (entity.getPmSignature() == null) {
          statement.bindNull(14);
        } else {
          statement.bindLong(14, entity.getPmSignature());
        }
        if (entity.getNumMessagePerPage() == null) {
          statement.bindNull(15);
        } else {
          statement.bindLong(15, entity.getNumMessagePerPage());
        }
        if (entity.getDraftMimeType() == null) {
          statement.bindNull(16);
        } else {
          statement.bindString(16, entity.getDraftMimeType());
        }
        if (entity.getReceiveMimeType() == null) {
          statement.bindNull(17);
        } else {
          statement.bindString(17, entity.getReceiveMimeType());
        }
        if (entity.getShowMimeType() == null) {
          statement.bindNull(18);
        } else {
          statement.bindString(18, entity.getShowMimeType());
        }
        if (entity.getEnableFolderColor() == null) {
          statement.bindNull(19);
        } else {
          statement.bindLong(19, entity.getEnableFolderColor());
        }
        if (entity.getInheritParentFolderColor() == null) {
          statement.bindNull(20);
        } else {
          statement.bindLong(20, entity.getInheritParentFolderColor());
        }
        if (entity.getRightToLeft() == null) {
          statement.bindNull(21);
        } else {
          statement.bindLong(21, entity.getRightToLeft());
        }
        if (entity.getAttachPublicKey() == null) {
          statement.bindNull(22);
        } else {
          statement.bindLong(22, entity.getAttachPublicKey());
        }
        if (entity.getSign() == null) {
          statement.bindNull(23);
        } else {
          statement.bindLong(23, entity.getSign());
        }
        if (entity.getPgpScheme() == null) {
          statement.bindNull(24);
        } else {
          statement.bindLong(24, entity.getPgpScheme());
        }
        if (entity.getPromptPin() == null) {
          statement.bindNull(25);
        } else {
          statement.bindLong(25, entity.getPromptPin());
        }
        if (entity.getStickyLabels() == null) {
          statement.bindNull(26);
        } else {
          statement.bindLong(26, entity.getStickyLabels());
        }
        if (entity.getConfirmLink() == null) {
          statement.bindNull(27);
        } else {
          statement.bindLong(27, entity.getConfirmLink());
        }
      }
    };
    this.__deletionAdapterOfMailSettingsEntity = new EntityDeletionOrUpdateAdapter<MailSettingsEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "DELETE FROM `MailSettingsEntity` WHERE `userId` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final MailSettingsEntity entity) {
        final String _tmp = __commonConverters.fromUserIdToString(entity.getUserId());
        if (_tmp == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, _tmp);
        }
      }
    };
    this.__updateAdapterOfMailSettingsEntity = new EntityDeletionOrUpdateAdapter<MailSettingsEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR ABORT `MailSettingsEntity` SET `userId` = ?,`displayName` = ?,`signature` = ?,`autoSaveContacts` = ?,`composerMode` = ?,`messageButtons` = ?,`showImages` = ?,`showMoved` = ?,`viewMode` = ?,`viewLayout` = ?,`swipeLeft` = ?,`swipeRight` = ?,`shortcuts` = ?,`pmSignature` = ?,`numMessagePerPage` = ?,`draftMimeType` = ?,`receiveMimeType` = ?,`showMimeType` = ?,`enableFolderColor` = ?,`inheritParentFolderColor` = ?,`rightToLeft` = ?,`attachPublicKey` = ?,`sign` = ?,`pgpScheme` = ?,`promptPin` = ?,`stickyLabels` = ?,`confirmLink` = ? WHERE `userId` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final MailSettingsEntity entity) {
        final String _tmp = __commonConverters.fromUserIdToString(entity.getUserId());
        if (_tmp == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, _tmp);
        }
        if (entity.getDisplayName() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getDisplayName());
        }
        if (entity.getSignature() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getSignature());
        }
        if (entity.getAutoSaveContacts() == null) {
          statement.bindNull(4);
        } else {
          statement.bindLong(4, entity.getAutoSaveContacts());
        }
        if (entity.getComposerMode() == null) {
          statement.bindNull(5);
        } else {
          statement.bindLong(5, entity.getComposerMode());
        }
        if (entity.getMessageButtons() == null) {
          statement.bindNull(6);
        } else {
          statement.bindLong(6, entity.getMessageButtons());
        }
        if (entity.getShowImages() == null) {
          statement.bindNull(7);
        } else {
          statement.bindLong(7, entity.getShowImages());
        }
        if (entity.getShowMoved() == null) {
          statement.bindNull(8);
        } else {
          statement.bindLong(8, entity.getShowMoved());
        }
        if (entity.getViewMode() == null) {
          statement.bindNull(9);
        } else {
          statement.bindLong(9, entity.getViewMode());
        }
        if (entity.getViewLayout() == null) {
          statement.bindNull(10);
        } else {
          statement.bindLong(10, entity.getViewLayout());
        }
        if (entity.getSwipeLeft() == null) {
          statement.bindNull(11);
        } else {
          statement.bindLong(11, entity.getSwipeLeft());
        }
        if (entity.getSwipeRight() == null) {
          statement.bindNull(12);
        } else {
          statement.bindLong(12, entity.getSwipeRight());
        }
        if (entity.getShortcuts() == null) {
          statement.bindNull(13);
        } else {
          statement.bindLong(13, entity.getShortcuts());
        }
        if (entity.getPmSignature() == null) {
          statement.bindNull(14);
        } else {
          statement.bindLong(14, entity.getPmSignature());
        }
        if (entity.getNumMessagePerPage() == null) {
          statement.bindNull(15);
        } else {
          statement.bindLong(15, entity.getNumMessagePerPage());
        }
        if (entity.getDraftMimeType() == null) {
          statement.bindNull(16);
        } else {
          statement.bindString(16, entity.getDraftMimeType());
        }
        if (entity.getReceiveMimeType() == null) {
          statement.bindNull(17);
        } else {
          statement.bindString(17, entity.getReceiveMimeType());
        }
        if (entity.getShowMimeType() == null) {
          statement.bindNull(18);
        } else {
          statement.bindString(18, entity.getShowMimeType());
        }
        if (entity.getEnableFolderColor() == null) {
          statement.bindNull(19);
        } else {
          statement.bindLong(19, entity.getEnableFolderColor());
        }
        if (entity.getInheritParentFolderColor() == null) {
          statement.bindNull(20);
        } else {
          statement.bindLong(20, entity.getInheritParentFolderColor());
        }
        if (entity.getRightToLeft() == null) {
          statement.bindNull(21);
        } else {
          statement.bindLong(21, entity.getRightToLeft());
        }
        if (entity.getAttachPublicKey() == null) {
          statement.bindNull(22);
        } else {
          statement.bindLong(22, entity.getAttachPublicKey());
        }
        if (entity.getSign() == null) {
          statement.bindNull(23);
        } else {
          statement.bindLong(23, entity.getSign());
        }
        if (entity.getPgpScheme() == null) {
          statement.bindNull(24);
        } else {
          statement.bindLong(24, entity.getPgpScheme());
        }
        if (entity.getPromptPin() == null) {
          statement.bindNull(25);
        } else {
          statement.bindLong(25, entity.getPromptPin());
        }
        if (entity.getStickyLabels() == null) {
          statement.bindNull(26);
        } else {
          statement.bindLong(26, entity.getStickyLabels());
        }
        if (entity.getConfirmLink() == null) {
          statement.bindNull(27);
        } else {
          statement.bindLong(27, entity.getConfirmLink());
        }
        final String _tmp_1 = __commonConverters.fromUserIdToString(entity.getUserId());
        if (_tmp_1 == null) {
          statement.bindNull(28);
        } else {
          statement.bindString(28, _tmp_1);
        }
      }
    };
    this.__preparedStmtOfDelete = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "DELETE FROM MailSettingsEntity WHERE userId = ?";
        return _query;
      }
    };
    this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "DELETE FROM MailSettingsEntity";
        return _query;
      }
    };
  }

  @Override
  public Object insertOrIgnore(final MailSettingsEntity[] entities,
      final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfMailSettingsEntity.insert(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object delete(final MailSettingsEntity[] entities, final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __deletionAdapterOfMailSettingsEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object update(final MailSettingsEntity[] entities,
      final Continuation<? super Integer> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      @NonNull
      public Integer call() throws Exception {
        int _total = 0;
        __db.beginTransaction();
        try {
          _total += __updateAdapterOfMailSettingsEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return _total;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object insertOrUpdate(final MailSettingsEntity[] entities,
      final Continuation<? super Unit> $completion) {
    return RoomDatabaseKt.withTransaction(__db, (__cont) -> MailSettingsDao_Impl.super.insertOrUpdate(entities, __cont), $completion);
  }

  @Override
  public Object delete(final UserId userId, final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDelete.acquire();
        int _argIndex = 1;
        final String _tmp = __commonConverters.fromUserIdToString(userId);
        if (_tmp == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, _tmp);
        }
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfDelete.release(_stmt);
        }
      }
    }, arg1);
  }

  @Override
  public Object deleteAll(final Continuation<? super Unit> arg0) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteAll.acquire();
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfDeleteAll.release(_stmt);
        }
      }
    }, arg0);
  }

  @Override
  public Flow<MailSettingsEntity> observeByUserId(final UserId userId) {
    final String _sql = "SELECT * FROM MailSettingsEntity WHERE userId = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    final String _tmp = __commonConverters.fromUserIdToString(userId);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp);
    }
    return CoroutinesRoom.createFlow(__db, false, new String[] {"MailSettingsEntity"}, new Callable<MailSettingsEntity>() {
      @Override
      @Nullable
      public MailSettingsEntity call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
          final int _cursorIndexOfDisplayName = CursorUtil.getColumnIndexOrThrow(_cursor, "displayName");
          final int _cursorIndexOfSignature = CursorUtil.getColumnIndexOrThrow(_cursor, "signature");
          final int _cursorIndexOfAutoSaveContacts = CursorUtil.getColumnIndexOrThrow(_cursor, "autoSaveContacts");
          final int _cursorIndexOfComposerMode = CursorUtil.getColumnIndexOrThrow(_cursor, "composerMode");
          final int _cursorIndexOfMessageButtons = CursorUtil.getColumnIndexOrThrow(_cursor, "messageButtons");
          final int _cursorIndexOfShowImages = CursorUtil.getColumnIndexOrThrow(_cursor, "showImages");
          final int _cursorIndexOfShowMoved = CursorUtil.getColumnIndexOrThrow(_cursor, "showMoved");
          final int _cursorIndexOfViewMode = CursorUtil.getColumnIndexOrThrow(_cursor, "viewMode");
          final int _cursorIndexOfViewLayout = CursorUtil.getColumnIndexOrThrow(_cursor, "viewLayout");
          final int _cursorIndexOfSwipeLeft = CursorUtil.getColumnIndexOrThrow(_cursor, "swipeLeft");
          final int _cursorIndexOfSwipeRight = CursorUtil.getColumnIndexOrThrow(_cursor, "swipeRight");
          final int _cursorIndexOfShortcuts = CursorUtil.getColumnIndexOrThrow(_cursor, "shortcuts");
          final int _cursorIndexOfPmSignature = CursorUtil.getColumnIndexOrThrow(_cursor, "pmSignature");
          final int _cursorIndexOfNumMessagePerPage = CursorUtil.getColumnIndexOrThrow(_cursor, "numMessagePerPage");
          final int _cursorIndexOfDraftMimeType = CursorUtil.getColumnIndexOrThrow(_cursor, "draftMimeType");
          final int _cursorIndexOfReceiveMimeType = CursorUtil.getColumnIndexOrThrow(_cursor, "receiveMimeType");
          final int _cursorIndexOfShowMimeType = CursorUtil.getColumnIndexOrThrow(_cursor, "showMimeType");
          final int _cursorIndexOfEnableFolderColor = CursorUtil.getColumnIndexOrThrow(_cursor, "enableFolderColor");
          final int _cursorIndexOfInheritParentFolderColor = CursorUtil.getColumnIndexOrThrow(_cursor, "inheritParentFolderColor");
          final int _cursorIndexOfRightToLeft = CursorUtil.getColumnIndexOrThrow(_cursor, "rightToLeft");
          final int _cursorIndexOfAttachPublicKey = CursorUtil.getColumnIndexOrThrow(_cursor, "attachPublicKey");
          final int _cursorIndexOfSign = CursorUtil.getColumnIndexOrThrow(_cursor, "sign");
          final int _cursorIndexOfPgpScheme = CursorUtil.getColumnIndexOrThrow(_cursor, "pgpScheme");
          final int _cursorIndexOfPromptPin = CursorUtil.getColumnIndexOrThrow(_cursor, "promptPin");
          final int _cursorIndexOfStickyLabels = CursorUtil.getColumnIndexOrThrow(_cursor, "stickyLabels");
          final int _cursorIndexOfConfirmLink = CursorUtil.getColumnIndexOrThrow(_cursor, "confirmLink");
          final MailSettingsEntity _result;
          if (_cursor.moveToFirst()) {
            final UserId _tmpUserId;
            final String _tmp_1;
            if (_cursor.isNull(_cursorIndexOfUserId)) {
              _tmp_1 = null;
            } else {
              _tmp_1 = _cursor.getString(_cursorIndexOfUserId);
            }
            _tmpUserId = __commonConverters.fromStringToUserId(_tmp_1);
            final String _tmpDisplayName;
            if (_cursor.isNull(_cursorIndexOfDisplayName)) {
              _tmpDisplayName = null;
            } else {
              _tmpDisplayName = _cursor.getString(_cursorIndexOfDisplayName);
            }
            final String _tmpSignature;
            if (_cursor.isNull(_cursorIndexOfSignature)) {
              _tmpSignature = null;
            } else {
              _tmpSignature = _cursor.getString(_cursorIndexOfSignature);
            }
            final Integer _tmpAutoSaveContacts;
            if (_cursor.isNull(_cursorIndexOfAutoSaveContacts)) {
              _tmpAutoSaveContacts = null;
            } else {
              _tmpAutoSaveContacts = _cursor.getInt(_cursorIndexOfAutoSaveContacts);
            }
            final Integer _tmpComposerMode;
            if (_cursor.isNull(_cursorIndexOfComposerMode)) {
              _tmpComposerMode = null;
            } else {
              _tmpComposerMode = _cursor.getInt(_cursorIndexOfComposerMode);
            }
            final Integer _tmpMessageButtons;
            if (_cursor.isNull(_cursorIndexOfMessageButtons)) {
              _tmpMessageButtons = null;
            } else {
              _tmpMessageButtons = _cursor.getInt(_cursorIndexOfMessageButtons);
            }
            final Integer _tmpShowImages;
            if (_cursor.isNull(_cursorIndexOfShowImages)) {
              _tmpShowImages = null;
            } else {
              _tmpShowImages = _cursor.getInt(_cursorIndexOfShowImages);
            }
            final Integer _tmpShowMoved;
            if (_cursor.isNull(_cursorIndexOfShowMoved)) {
              _tmpShowMoved = null;
            } else {
              _tmpShowMoved = _cursor.getInt(_cursorIndexOfShowMoved);
            }
            final Integer _tmpViewMode;
            if (_cursor.isNull(_cursorIndexOfViewMode)) {
              _tmpViewMode = null;
            } else {
              _tmpViewMode = _cursor.getInt(_cursorIndexOfViewMode);
            }
            final Integer _tmpViewLayout;
            if (_cursor.isNull(_cursorIndexOfViewLayout)) {
              _tmpViewLayout = null;
            } else {
              _tmpViewLayout = _cursor.getInt(_cursorIndexOfViewLayout);
            }
            final Integer _tmpSwipeLeft;
            if (_cursor.isNull(_cursorIndexOfSwipeLeft)) {
              _tmpSwipeLeft = null;
            } else {
              _tmpSwipeLeft = _cursor.getInt(_cursorIndexOfSwipeLeft);
            }
            final Integer _tmpSwipeRight;
            if (_cursor.isNull(_cursorIndexOfSwipeRight)) {
              _tmpSwipeRight = null;
            } else {
              _tmpSwipeRight = _cursor.getInt(_cursorIndexOfSwipeRight);
            }
            final Integer _tmpShortcuts;
            if (_cursor.isNull(_cursorIndexOfShortcuts)) {
              _tmpShortcuts = null;
            } else {
              _tmpShortcuts = _cursor.getInt(_cursorIndexOfShortcuts);
            }
            final Integer _tmpPmSignature;
            if (_cursor.isNull(_cursorIndexOfPmSignature)) {
              _tmpPmSignature = null;
            } else {
              _tmpPmSignature = _cursor.getInt(_cursorIndexOfPmSignature);
            }
            final Integer _tmpNumMessagePerPage;
            if (_cursor.isNull(_cursorIndexOfNumMessagePerPage)) {
              _tmpNumMessagePerPage = null;
            } else {
              _tmpNumMessagePerPage = _cursor.getInt(_cursorIndexOfNumMessagePerPage);
            }
            final String _tmpDraftMimeType;
            if (_cursor.isNull(_cursorIndexOfDraftMimeType)) {
              _tmpDraftMimeType = null;
            } else {
              _tmpDraftMimeType = _cursor.getString(_cursorIndexOfDraftMimeType);
            }
            final String _tmpReceiveMimeType;
            if (_cursor.isNull(_cursorIndexOfReceiveMimeType)) {
              _tmpReceiveMimeType = null;
            } else {
              _tmpReceiveMimeType = _cursor.getString(_cursorIndexOfReceiveMimeType);
            }
            final String _tmpShowMimeType;
            if (_cursor.isNull(_cursorIndexOfShowMimeType)) {
              _tmpShowMimeType = null;
            } else {
              _tmpShowMimeType = _cursor.getString(_cursorIndexOfShowMimeType);
            }
            final Integer _tmpEnableFolderColor;
            if (_cursor.isNull(_cursorIndexOfEnableFolderColor)) {
              _tmpEnableFolderColor = null;
            } else {
              _tmpEnableFolderColor = _cursor.getInt(_cursorIndexOfEnableFolderColor);
            }
            final Integer _tmpInheritParentFolderColor;
            if (_cursor.isNull(_cursorIndexOfInheritParentFolderColor)) {
              _tmpInheritParentFolderColor = null;
            } else {
              _tmpInheritParentFolderColor = _cursor.getInt(_cursorIndexOfInheritParentFolderColor);
            }
            final Integer _tmpRightToLeft;
            if (_cursor.isNull(_cursorIndexOfRightToLeft)) {
              _tmpRightToLeft = null;
            } else {
              _tmpRightToLeft = _cursor.getInt(_cursorIndexOfRightToLeft);
            }
            final Integer _tmpAttachPublicKey;
            if (_cursor.isNull(_cursorIndexOfAttachPublicKey)) {
              _tmpAttachPublicKey = null;
            } else {
              _tmpAttachPublicKey = _cursor.getInt(_cursorIndexOfAttachPublicKey);
            }
            final Integer _tmpSign;
            if (_cursor.isNull(_cursorIndexOfSign)) {
              _tmpSign = null;
            } else {
              _tmpSign = _cursor.getInt(_cursorIndexOfSign);
            }
            final Integer _tmpPgpScheme;
            if (_cursor.isNull(_cursorIndexOfPgpScheme)) {
              _tmpPgpScheme = null;
            } else {
              _tmpPgpScheme = _cursor.getInt(_cursorIndexOfPgpScheme);
            }
            final Integer _tmpPromptPin;
            if (_cursor.isNull(_cursorIndexOfPromptPin)) {
              _tmpPromptPin = null;
            } else {
              _tmpPromptPin = _cursor.getInt(_cursorIndexOfPromptPin);
            }
            final Integer _tmpStickyLabels;
            if (_cursor.isNull(_cursorIndexOfStickyLabels)) {
              _tmpStickyLabels = null;
            } else {
              _tmpStickyLabels = _cursor.getInt(_cursorIndexOfStickyLabels);
            }
            final Integer _tmpConfirmLink;
            if (_cursor.isNull(_cursorIndexOfConfirmLink)) {
              _tmpConfirmLink = null;
            } else {
              _tmpConfirmLink = _cursor.getInt(_cursorIndexOfConfirmLink);
            }
            _result = new MailSettingsEntity(_tmpUserId,_tmpDisplayName,_tmpSignature,_tmpAutoSaveContacts,_tmpComposerMode,_tmpMessageButtons,_tmpShowImages,_tmpShowMoved,_tmpViewMode,_tmpViewLayout,_tmpSwipeLeft,_tmpSwipeRight,_tmpShortcuts,_tmpPmSignature,_tmpNumMessagePerPage,_tmpDraftMimeType,_tmpReceiveMimeType,_tmpShowMimeType,_tmpEnableFolderColor,_tmpInheritParentFolderColor,_tmpRightToLeft,_tmpAttachPublicKey,_tmpSign,_tmpPgpScheme,_tmpPromptPin,_tmpStickyLabels,_tmpConfirmLink);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object getByUserId(final UserId userId,
      final Continuation<? super MailSettingsEntity> arg1) {
    final String _sql = "SELECT * FROM MailSettingsEntity WHERE userId = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    final String _tmp = __commonConverters.fromUserIdToString(userId);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp);
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<MailSettingsEntity>() {
      @Override
      @Nullable
      public MailSettingsEntity call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
          final int _cursorIndexOfDisplayName = CursorUtil.getColumnIndexOrThrow(_cursor, "displayName");
          final int _cursorIndexOfSignature = CursorUtil.getColumnIndexOrThrow(_cursor, "signature");
          final int _cursorIndexOfAutoSaveContacts = CursorUtil.getColumnIndexOrThrow(_cursor, "autoSaveContacts");
          final int _cursorIndexOfComposerMode = CursorUtil.getColumnIndexOrThrow(_cursor, "composerMode");
          final int _cursorIndexOfMessageButtons = CursorUtil.getColumnIndexOrThrow(_cursor, "messageButtons");
          final int _cursorIndexOfShowImages = CursorUtil.getColumnIndexOrThrow(_cursor, "showImages");
          final int _cursorIndexOfShowMoved = CursorUtil.getColumnIndexOrThrow(_cursor, "showMoved");
          final int _cursorIndexOfViewMode = CursorUtil.getColumnIndexOrThrow(_cursor, "viewMode");
          final int _cursorIndexOfViewLayout = CursorUtil.getColumnIndexOrThrow(_cursor, "viewLayout");
          final int _cursorIndexOfSwipeLeft = CursorUtil.getColumnIndexOrThrow(_cursor, "swipeLeft");
          final int _cursorIndexOfSwipeRight = CursorUtil.getColumnIndexOrThrow(_cursor, "swipeRight");
          final int _cursorIndexOfShortcuts = CursorUtil.getColumnIndexOrThrow(_cursor, "shortcuts");
          final int _cursorIndexOfPmSignature = CursorUtil.getColumnIndexOrThrow(_cursor, "pmSignature");
          final int _cursorIndexOfNumMessagePerPage = CursorUtil.getColumnIndexOrThrow(_cursor, "numMessagePerPage");
          final int _cursorIndexOfDraftMimeType = CursorUtil.getColumnIndexOrThrow(_cursor, "draftMimeType");
          final int _cursorIndexOfReceiveMimeType = CursorUtil.getColumnIndexOrThrow(_cursor, "receiveMimeType");
          final int _cursorIndexOfShowMimeType = CursorUtil.getColumnIndexOrThrow(_cursor, "showMimeType");
          final int _cursorIndexOfEnableFolderColor = CursorUtil.getColumnIndexOrThrow(_cursor, "enableFolderColor");
          final int _cursorIndexOfInheritParentFolderColor = CursorUtil.getColumnIndexOrThrow(_cursor, "inheritParentFolderColor");
          final int _cursorIndexOfRightToLeft = CursorUtil.getColumnIndexOrThrow(_cursor, "rightToLeft");
          final int _cursorIndexOfAttachPublicKey = CursorUtil.getColumnIndexOrThrow(_cursor, "attachPublicKey");
          final int _cursorIndexOfSign = CursorUtil.getColumnIndexOrThrow(_cursor, "sign");
          final int _cursorIndexOfPgpScheme = CursorUtil.getColumnIndexOrThrow(_cursor, "pgpScheme");
          final int _cursorIndexOfPromptPin = CursorUtil.getColumnIndexOrThrow(_cursor, "promptPin");
          final int _cursorIndexOfStickyLabels = CursorUtil.getColumnIndexOrThrow(_cursor, "stickyLabels");
          final int _cursorIndexOfConfirmLink = CursorUtil.getColumnIndexOrThrow(_cursor, "confirmLink");
          final MailSettingsEntity _result;
          if (_cursor.moveToFirst()) {
            final UserId _tmpUserId;
            final String _tmp_1;
            if (_cursor.isNull(_cursorIndexOfUserId)) {
              _tmp_1 = null;
            } else {
              _tmp_1 = _cursor.getString(_cursorIndexOfUserId);
            }
            _tmpUserId = __commonConverters.fromStringToUserId(_tmp_1);
            final String _tmpDisplayName;
            if (_cursor.isNull(_cursorIndexOfDisplayName)) {
              _tmpDisplayName = null;
            } else {
              _tmpDisplayName = _cursor.getString(_cursorIndexOfDisplayName);
            }
            final String _tmpSignature;
            if (_cursor.isNull(_cursorIndexOfSignature)) {
              _tmpSignature = null;
            } else {
              _tmpSignature = _cursor.getString(_cursorIndexOfSignature);
            }
            final Integer _tmpAutoSaveContacts;
            if (_cursor.isNull(_cursorIndexOfAutoSaveContacts)) {
              _tmpAutoSaveContacts = null;
            } else {
              _tmpAutoSaveContacts = _cursor.getInt(_cursorIndexOfAutoSaveContacts);
            }
            final Integer _tmpComposerMode;
            if (_cursor.isNull(_cursorIndexOfComposerMode)) {
              _tmpComposerMode = null;
            } else {
              _tmpComposerMode = _cursor.getInt(_cursorIndexOfComposerMode);
            }
            final Integer _tmpMessageButtons;
            if (_cursor.isNull(_cursorIndexOfMessageButtons)) {
              _tmpMessageButtons = null;
            } else {
              _tmpMessageButtons = _cursor.getInt(_cursorIndexOfMessageButtons);
            }
            final Integer _tmpShowImages;
            if (_cursor.isNull(_cursorIndexOfShowImages)) {
              _tmpShowImages = null;
            } else {
              _tmpShowImages = _cursor.getInt(_cursorIndexOfShowImages);
            }
            final Integer _tmpShowMoved;
            if (_cursor.isNull(_cursorIndexOfShowMoved)) {
              _tmpShowMoved = null;
            } else {
              _tmpShowMoved = _cursor.getInt(_cursorIndexOfShowMoved);
            }
            final Integer _tmpViewMode;
            if (_cursor.isNull(_cursorIndexOfViewMode)) {
              _tmpViewMode = null;
            } else {
              _tmpViewMode = _cursor.getInt(_cursorIndexOfViewMode);
            }
            final Integer _tmpViewLayout;
            if (_cursor.isNull(_cursorIndexOfViewLayout)) {
              _tmpViewLayout = null;
            } else {
              _tmpViewLayout = _cursor.getInt(_cursorIndexOfViewLayout);
            }
            final Integer _tmpSwipeLeft;
            if (_cursor.isNull(_cursorIndexOfSwipeLeft)) {
              _tmpSwipeLeft = null;
            } else {
              _tmpSwipeLeft = _cursor.getInt(_cursorIndexOfSwipeLeft);
            }
            final Integer _tmpSwipeRight;
            if (_cursor.isNull(_cursorIndexOfSwipeRight)) {
              _tmpSwipeRight = null;
            } else {
              _tmpSwipeRight = _cursor.getInt(_cursorIndexOfSwipeRight);
            }
            final Integer _tmpShortcuts;
            if (_cursor.isNull(_cursorIndexOfShortcuts)) {
              _tmpShortcuts = null;
            } else {
              _tmpShortcuts = _cursor.getInt(_cursorIndexOfShortcuts);
            }
            final Integer _tmpPmSignature;
            if (_cursor.isNull(_cursorIndexOfPmSignature)) {
              _tmpPmSignature = null;
            } else {
              _tmpPmSignature = _cursor.getInt(_cursorIndexOfPmSignature);
            }
            final Integer _tmpNumMessagePerPage;
            if (_cursor.isNull(_cursorIndexOfNumMessagePerPage)) {
              _tmpNumMessagePerPage = null;
            } else {
              _tmpNumMessagePerPage = _cursor.getInt(_cursorIndexOfNumMessagePerPage);
            }
            final String _tmpDraftMimeType;
            if (_cursor.isNull(_cursorIndexOfDraftMimeType)) {
              _tmpDraftMimeType = null;
            } else {
              _tmpDraftMimeType = _cursor.getString(_cursorIndexOfDraftMimeType);
            }
            final String _tmpReceiveMimeType;
            if (_cursor.isNull(_cursorIndexOfReceiveMimeType)) {
              _tmpReceiveMimeType = null;
            } else {
              _tmpReceiveMimeType = _cursor.getString(_cursorIndexOfReceiveMimeType);
            }
            final String _tmpShowMimeType;
            if (_cursor.isNull(_cursorIndexOfShowMimeType)) {
              _tmpShowMimeType = null;
            } else {
              _tmpShowMimeType = _cursor.getString(_cursorIndexOfShowMimeType);
            }
            final Integer _tmpEnableFolderColor;
            if (_cursor.isNull(_cursorIndexOfEnableFolderColor)) {
              _tmpEnableFolderColor = null;
            } else {
              _tmpEnableFolderColor = _cursor.getInt(_cursorIndexOfEnableFolderColor);
            }
            final Integer _tmpInheritParentFolderColor;
            if (_cursor.isNull(_cursorIndexOfInheritParentFolderColor)) {
              _tmpInheritParentFolderColor = null;
            } else {
              _tmpInheritParentFolderColor = _cursor.getInt(_cursorIndexOfInheritParentFolderColor);
            }
            final Integer _tmpRightToLeft;
            if (_cursor.isNull(_cursorIndexOfRightToLeft)) {
              _tmpRightToLeft = null;
            } else {
              _tmpRightToLeft = _cursor.getInt(_cursorIndexOfRightToLeft);
            }
            final Integer _tmpAttachPublicKey;
            if (_cursor.isNull(_cursorIndexOfAttachPublicKey)) {
              _tmpAttachPublicKey = null;
            } else {
              _tmpAttachPublicKey = _cursor.getInt(_cursorIndexOfAttachPublicKey);
            }
            final Integer _tmpSign;
            if (_cursor.isNull(_cursorIndexOfSign)) {
              _tmpSign = null;
            } else {
              _tmpSign = _cursor.getInt(_cursorIndexOfSign);
            }
            final Integer _tmpPgpScheme;
            if (_cursor.isNull(_cursorIndexOfPgpScheme)) {
              _tmpPgpScheme = null;
            } else {
              _tmpPgpScheme = _cursor.getInt(_cursorIndexOfPgpScheme);
            }
            final Integer _tmpPromptPin;
            if (_cursor.isNull(_cursorIndexOfPromptPin)) {
              _tmpPromptPin = null;
            } else {
              _tmpPromptPin = _cursor.getInt(_cursorIndexOfPromptPin);
            }
            final Integer _tmpStickyLabels;
            if (_cursor.isNull(_cursorIndexOfStickyLabels)) {
              _tmpStickyLabels = null;
            } else {
              _tmpStickyLabels = _cursor.getInt(_cursorIndexOfStickyLabels);
            }
            final Integer _tmpConfirmLink;
            if (_cursor.isNull(_cursorIndexOfConfirmLink)) {
              _tmpConfirmLink = null;
            } else {
              _tmpConfirmLink = _cursor.getInt(_cursorIndexOfConfirmLink);
            }
            _result = new MailSettingsEntity(_tmpUserId,_tmpDisplayName,_tmpSignature,_tmpAutoSaveContacts,_tmpComposerMode,_tmpMessageButtons,_tmpShowImages,_tmpShowMoved,_tmpViewMode,_tmpViewLayout,_tmpSwipeLeft,_tmpSwipeRight,_tmpShortcuts,_tmpPmSignature,_tmpNumMessagePerPage,_tmpDraftMimeType,_tmpReceiveMimeType,_tmpShowMimeType,_tmpEnableFolderColor,_tmpInheritParentFolderColor,_tmpRightToLeft,_tmpAttachPublicKey,_tmpSign,_tmpPgpScheme,_tmpPromptPin,_tmpStickyLabels,_tmpConfirmLink);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, arg1);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
