package me.proton.core.key.data.db;

import android.database.Cursor;
import androidx.annotation.NonNull;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;
import me.proton.core.data.room.db.CommonConverters;
import me.proton.core.domain.entity.UserId;
import me.proton.core.key.data.entity.KeySaltEntity;
import me.proton.core.key.domain.entity.key.KeyId;
import me.proton.core.user.data.db.UserConverters;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class KeySaltDao_Impl extends KeySaltDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<KeySaltEntity> __insertionAdapterOfKeySaltEntity;

  private final CommonConverters __commonConverters = new CommonConverters();

  private final UserConverters __userConverters = new UserConverters();

  private final EntityDeletionOrUpdateAdapter<KeySaltEntity> __deletionAdapterOfKeySaltEntity;

  private final EntityDeletionOrUpdateAdapter<KeySaltEntity> __updateAdapterOfKeySaltEntity;

  private final SharedSQLiteStatement __preparedStmtOfDeleteByUserId;

  private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

  public KeySaltDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfKeySaltEntity = new EntityInsertionAdapter<KeySaltEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR IGNORE INTO `KeySaltEntity` (`userId`,`keyId`,`keySalt`) VALUES (?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final KeySaltEntity entity) {
        final String _tmp = __commonConverters.fromUserIdToString(entity.getUserId());
        if (_tmp == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, _tmp);
        }
        final String _tmp_1 = __userConverters.fromKeyIdToString(entity.getKeyId());
        if (_tmp_1 == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, _tmp_1);
        }
        if (entity.getKeySalt() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getKeySalt());
        }
      }
    };
    this.__deletionAdapterOfKeySaltEntity = new EntityDeletionOrUpdateAdapter<KeySaltEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "DELETE FROM `KeySaltEntity` WHERE `userId` = ? AND `keyId` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final KeySaltEntity entity) {
        final String _tmp = __commonConverters.fromUserIdToString(entity.getUserId());
        if (_tmp == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, _tmp);
        }
        final String _tmp_1 = __userConverters.fromKeyIdToString(entity.getKeyId());
        if (_tmp_1 == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, _tmp_1);
        }
      }
    };
    this.__updateAdapterOfKeySaltEntity = new EntityDeletionOrUpdateAdapter<KeySaltEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR ABORT `KeySaltEntity` SET `userId` = ?,`keyId` = ?,`keySalt` = ? WHERE `userId` = ? AND `keyId` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final KeySaltEntity entity) {
        final String _tmp = __commonConverters.fromUserIdToString(entity.getUserId());
        if (_tmp == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, _tmp);
        }
        final String _tmp_1 = __userConverters.fromKeyIdToString(entity.getKeyId());
        if (_tmp_1 == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, _tmp_1);
        }
        if (entity.getKeySalt() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getKeySalt());
        }
        final String _tmp_2 = __commonConverters.fromUserIdToString(entity.getUserId());
        if (_tmp_2 == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, _tmp_2);
        }
        final String _tmp_3 = __userConverters.fromKeyIdToString(entity.getKeyId());
        if (_tmp_3 == null) {
          statement.bindNull(5);
        } else {
          statement.bindString(5, _tmp_3);
        }
      }
    };
    this.__preparedStmtOfDeleteByUserId = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "DELETE FROM KeySaltEntity WHERE userId = ?";
        return _query;
      }
    };
    this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "DELETE FROM KeySaltEntity";
        return _query;
      }
    };
  }

  @Override
  public Object insertOrIgnore(final KeySaltEntity[] entities,
      final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfKeySaltEntity.insert(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object delete(final KeySaltEntity[] entities, final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __deletionAdapterOfKeySaltEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object update(final KeySaltEntity[] entities, final Continuation<? super Integer> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      @NonNull
      public Integer call() throws Exception {
        int _total = 0;
        __db.beginTransaction();
        try {
          _total += __updateAdapterOfKeySaltEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return _total;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object insertOrUpdate(final KeySaltEntity[] entities,
      final Continuation<? super Unit> $completion) {
    return RoomDatabaseKt.withTransaction(__db, (__cont) -> KeySaltDao_Impl.super.insertOrUpdate(entities, __cont), $completion);
  }

  @Override
  public Object deleteByUserId(final UserId userId, final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteByUserId.acquire();
        int _argIndex = 1;
        final String _tmp = __commonConverters.fromUserIdToString(userId);
        if (_tmp == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, _tmp);
        }
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfDeleteByUserId.release(_stmt);
        }
      }
    }, arg1);
  }

  @Override
  public Object deleteAll(final Continuation<? super Unit> arg0) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteAll.acquire();
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfDeleteAll.release(_stmt);
        }
      }
    }, arg0);
  }

  @Override
  public Flow<List<KeySaltEntity>> findAllByUserId(final UserId userId) {
    final String _sql = "SELECT * FROM KeySaltEntity WHERE userId = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    final String _tmp = __commonConverters.fromUserIdToString(userId);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp);
    }
    return CoroutinesRoom.createFlow(__db, false, new String[] {"KeySaltEntity"}, new Callable<List<KeySaltEntity>>() {
      @Override
      @NonNull
      public List<KeySaltEntity> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
          final int _cursorIndexOfKeyId = CursorUtil.getColumnIndexOrThrow(_cursor, "keyId");
          final int _cursorIndexOfKeySalt = CursorUtil.getColumnIndexOrThrow(_cursor, "keySalt");
          final List<KeySaltEntity> _result = new ArrayList<KeySaltEntity>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final KeySaltEntity _item;
            final UserId _tmpUserId;
            final String _tmp_1;
            if (_cursor.isNull(_cursorIndexOfUserId)) {
              _tmp_1 = null;
            } else {
              _tmp_1 = _cursor.getString(_cursorIndexOfUserId);
            }
            _tmpUserId = __commonConverters.fromStringToUserId(_tmp_1);
            final KeyId _tmpKeyId;
            final String _tmp_2;
            if (_cursor.isNull(_cursorIndexOfKeyId)) {
              _tmp_2 = null;
            } else {
              _tmp_2 = _cursor.getString(_cursorIndexOfKeyId);
            }
            _tmpKeyId = __userConverters.fromStringToKeyId(_tmp_2);
            final String _tmpKeySalt;
            if (_cursor.isNull(_cursorIndexOfKeySalt)) {
              _tmpKeySalt = null;
            } else {
              _tmpKeySalt = _cursor.getString(_cursorIndexOfKeySalt);
            }
            _item = new KeySaltEntity(_tmpUserId,_tmpKeyId,_tmpKeySalt);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
