package me.proton.core.featureflag.data.db;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.lang.Class;
import java.lang.Exception;
import java.lang.IllegalArgumentException;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;
import me.proton.core.data.room.db.CommonConverters;
import me.proton.core.domain.entity.UserId;
import me.proton.core.featureflag.data.entity.FeatureFlagEntity;
import me.proton.core.featureflag.domain.entity.Scope;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class FeatureFlagDao_Impl extends FeatureFlagDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<FeatureFlagEntity> __insertionAdapterOfFeatureFlagEntity;

  private final CommonConverters __commonConverters = new CommonConverters();

  private final EntityDeletionOrUpdateAdapter<FeatureFlagEntity> __deletionAdapterOfFeatureFlagEntity;

  private final EntityDeletionOrUpdateAdapter<FeatureFlagEntity> __updateAdapterOfFeatureFlagEntity;

  private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

  private final SharedSQLiteStatement __preparedStmtOfUpdateValue;

  public FeatureFlagDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfFeatureFlagEntity = new EntityInsertionAdapter<FeatureFlagEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR IGNORE INTO `FeatureFlagEntity` (`userId`,`featureId`,`scope`,`defaultValue`,`value`) VALUES (?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final FeatureFlagEntity entity) {
        final String _tmp = __commonConverters.fromUserIdToString(entity.getUserId());
        if (_tmp == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, _tmp);
        }
        if (entity.getFeatureId() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getFeatureId());
        }
        statement.bindString(3, __Scope_enumToString(entity.getScope()));
        final int _tmp_1 = entity.getDefaultValue() ? 1 : 0;
        statement.bindLong(4, _tmp_1);
        final int _tmp_2 = entity.getValue() ? 1 : 0;
        statement.bindLong(5, _tmp_2);
      }
    };
    this.__deletionAdapterOfFeatureFlagEntity = new EntityDeletionOrUpdateAdapter<FeatureFlagEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "DELETE FROM `FeatureFlagEntity` WHERE `userId` = ? AND `featureId` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final FeatureFlagEntity entity) {
        final String _tmp = __commonConverters.fromUserIdToString(entity.getUserId());
        if (_tmp == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, _tmp);
        }
        if (entity.getFeatureId() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getFeatureId());
        }
      }
    };
    this.__updateAdapterOfFeatureFlagEntity = new EntityDeletionOrUpdateAdapter<FeatureFlagEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR ABORT `FeatureFlagEntity` SET `userId` = ?,`featureId` = ?,`scope` = ?,`defaultValue` = ?,`value` = ? WHERE `userId` = ? AND `featureId` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final FeatureFlagEntity entity) {
        final String _tmp = __commonConverters.fromUserIdToString(entity.getUserId());
        if (_tmp == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, _tmp);
        }
        if (entity.getFeatureId() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getFeatureId());
        }
        statement.bindString(3, __Scope_enumToString(entity.getScope()));
        final int _tmp_1 = entity.getDefaultValue() ? 1 : 0;
        statement.bindLong(4, _tmp_1);
        final int _tmp_2 = entity.getValue() ? 1 : 0;
        statement.bindLong(5, _tmp_2);
        final String _tmp_3 = __commonConverters.fromUserIdToString(entity.getUserId());
        if (_tmp_3 == null) {
          statement.bindNull(6);
        } else {
          statement.bindString(6, _tmp_3);
        }
        if (entity.getFeatureId() == null) {
          statement.bindNull(7);
        } else {
          statement.bindString(7, entity.getFeatureId());
        }
      }
    };
    this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "DELETE FROM FeatureFlagEntity WHERE userId = ? AND scope = ?";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateValue = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "UPDATE FeatureFlagEntity SET value = ? WHERE userId = ? AND featureId = ?";
        return _query;
      }
    };
  }

  @Override
  public Object insertOrIgnore(final FeatureFlagEntity[] entities,
      final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfFeatureFlagEntity.insert(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object delete(final FeatureFlagEntity[] entities, final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __deletionAdapterOfFeatureFlagEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object update(final FeatureFlagEntity[] entities,
      final Continuation<? super Integer> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      @NonNull
      public Integer call() throws Exception {
        int _total = 0;
        __db.beginTransaction();
        try {
          _total += __updateAdapterOfFeatureFlagEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return _total;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object insertOrUpdate(final FeatureFlagEntity[] entities,
      final Continuation<? super Unit> $completion) {
    return RoomDatabaseKt.withTransaction(__db, (__cont) -> FeatureFlagDao_Impl.super.insertOrUpdate(entities, __cont), $completion);
  }

  @Override
  public Object deleteAll$feature_flag_data_release(final UserId userId, final Scope scope,
      final Continuation<? super Unit> arg2) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteAll.acquire();
        int _argIndex = 1;
        final String _tmp = __commonConverters.fromUserIdToString(userId);
        if (_tmp == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, _tmp);
        }
        _argIndex = 2;
        _stmt.bindString(_argIndex, __Scope_enumToString(scope));
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfDeleteAll.release(_stmt);
        }
      }
    }, arg2);
  }

  @Override
  public void updateValue$feature_flag_data_release(final UserId userId, final String featureId,
      final boolean value) {
    __db.assertNotSuspendingTransaction();
    final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateValue.acquire();
    int _argIndex = 1;
    final int _tmp = value ? 1 : 0;
    _stmt.bindLong(_argIndex, _tmp);
    _argIndex = 2;
    final String _tmp_1 = __commonConverters.fromUserIdToString(userId);
    if (_tmp_1 == null) {
      _stmt.bindNull(_argIndex);
    } else {
      _stmt.bindString(_argIndex, _tmp_1);
    }
    _argIndex = 3;
    if (featureId == null) {
      _stmt.bindNull(_argIndex);
    } else {
      _stmt.bindString(_argIndex, featureId);
    }
    try {
      __db.beginTransaction();
      try {
        _stmt.executeUpdateDelete();
        __db.setTransactionSuccessful();
      } finally {
        __db.endTransaction();
      }
    } finally {
      __preparedStmtOfUpdateValue.release(_stmt);
    }
  }

  @Override
  public Object getAll$feature_flag_data_release(final Scope scope,
      final Continuation<? super List<FeatureFlagEntity>> arg1) {
    final String _sql = "SELECT * FROM FeatureFlagEntity WHERE scope = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindString(_argIndex, __Scope_enumToString(scope));
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<FeatureFlagEntity>>() {
      @Override
      @NonNull
      public List<FeatureFlagEntity> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
          final int _cursorIndexOfFeatureId = CursorUtil.getColumnIndexOrThrow(_cursor, "featureId");
          final int _cursorIndexOfScope = CursorUtil.getColumnIndexOrThrow(_cursor, "scope");
          final int _cursorIndexOfDefaultValue = CursorUtil.getColumnIndexOrThrow(_cursor, "defaultValue");
          final int _cursorIndexOfValue = CursorUtil.getColumnIndexOrThrow(_cursor, "value");
          final List<FeatureFlagEntity> _result = new ArrayList<FeatureFlagEntity>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final FeatureFlagEntity _item;
            final UserId _tmpUserId;
            final String _tmp;
            if (_cursor.isNull(_cursorIndexOfUserId)) {
              _tmp = null;
            } else {
              _tmp = _cursor.getString(_cursorIndexOfUserId);
            }
            _tmpUserId = __commonConverters.fromStringToUserId(_tmp);
            final String _tmpFeatureId;
            if (_cursor.isNull(_cursorIndexOfFeatureId)) {
              _tmpFeatureId = null;
            } else {
              _tmpFeatureId = _cursor.getString(_cursorIndexOfFeatureId);
            }
            final Scope _tmpScope;
            _tmpScope = __Scope_stringToEnum(_cursor.getString(_cursorIndexOfScope));
            final boolean _tmpDefaultValue;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfDefaultValue);
            _tmpDefaultValue = _tmp_1 != 0;
            final boolean _tmpValue;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfValue);
            _tmpValue = _tmp_2 != 0;
            _item = new FeatureFlagEntity(_tmpUserId,_tmpFeatureId,_tmpScope,_tmpDefaultValue,_tmpValue);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, arg1);
  }

  @Override
  public Flow<List<FeatureFlagEntity>> observe$feature_flag_data_release(final List<UserId> userIds,
      final Scope scope) {
    final StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("SELECT * FROM FeatureFlagEntity WHERE scope = ");
    _stringBuilder.append("?");
    _stringBuilder.append(" AND userId IN (");
    final int _inputSize = userIds.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(")");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 1 + _inputSize;
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    _statement.bindString(_argIndex, __Scope_enumToString(scope));
    _argIndex = 2;
    for (UserId _item : userIds) {
      final String _tmp = __commonConverters.fromUserIdToString(_item);
      if (_tmp == null) {
        _statement.bindNull(_argIndex);
      } else {
        _statement.bindString(_argIndex, _tmp);
      }
      _argIndex++;
    }
    return CoroutinesRoom.createFlow(__db, false, new String[] {"FeatureFlagEntity"}, new Callable<List<FeatureFlagEntity>>() {
      @Override
      @NonNull
      public List<FeatureFlagEntity> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
          final int _cursorIndexOfFeatureId = CursorUtil.getColumnIndexOrThrow(_cursor, "featureId");
          final int _cursorIndexOfScope = CursorUtil.getColumnIndexOrThrow(_cursor, "scope");
          final int _cursorIndexOfDefaultValue = CursorUtil.getColumnIndexOrThrow(_cursor, "defaultValue");
          final int _cursorIndexOfValue = CursorUtil.getColumnIndexOrThrow(_cursor, "value");
          final List<FeatureFlagEntity> _result = new ArrayList<FeatureFlagEntity>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final FeatureFlagEntity _item_1;
            final UserId _tmpUserId;
            final String _tmp_1;
            if (_cursor.isNull(_cursorIndexOfUserId)) {
              _tmp_1 = null;
            } else {
              _tmp_1 = _cursor.getString(_cursorIndexOfUserId);
            }
            _tmpUserId = __commonConverters.fromStringToUserId(_tmp_1);
            final String _tmpFeatureId;
            if (_cursor.isNull(_cursorIndexOfFeatureId)) {
              _tmpFeatureId = null;
            } else {
              _tmpFeatureId = _cursor.getString(_cursorIndexOfFeatureId);
            }
            final Scope _tmpScope;
            _tmpScope = __Scope_stringToEnum(_cursor.getString(_cursorIndexOfScope));
            final boolean _tmpDefaultValue;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfDefaultValue);
            _tmpDefaultValue = _tmp_2 != 0;
            final boolean _tmpValue;
            final int _tmp_3;
            _tmp_3 = _cursor.getInt(_cursorIndexOfValue);
            _tmpValue = _tmp_3 != 0;
            _item_1 = new FeatureFlagEntity(_tmpUserId,_tmpFeatureId,_tmpScope,_tmpDefaultValue,_tmpValue);
            _result.add(_item_1);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Flow<List<FeatureFlagEntity>> observe$feature_flag_data_release(final List<UserId> userIds,
      final List<String> featureIds) {
    final StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("SELECT * FROM FeatureFlagEntity WHERE featureId IN (");
    final int _inputSize = featureIds.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(") AND userId IN (");
    final int _inputSize_1 = userIds.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize_1);
    _stringBuilder.append(")");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 0 + _inputSize + _inputSize_1;
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    for (String _item : featureIds) {
      if (_item == null) {
        _statement.bindNull(_argIndex);
      } else {
        _statement.bindString(_argIndex, _item);
      }
      _argIndex++;
    }
    _argIndex = 1 + _inputSize;
    for (UserId _item_1 : userIds) {
      final String _tmp = __commonConverters.fromUserIdToString(_item_1);
      if (_tmp == null) {
        _statement.bindNull(_argIndex);
      } else {
        _statement.bindString(_argIndex, _tmp);
      }
      _argIndex++;
    }
    return CoroutinesRoom.createFlow(__db, false, new String[] {"FeatureFlagEntity"}, new Callable<List<FeatureFlagEntity>>() {
      @Override
      @NonNull
      public List<FeatureFlagEntity> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
          final int _cursorIndexOfFeatureId = CursorUtil.getColumnIndexOrThrow(_cursor, "featureId");
          final int _cursorIndexOfScope = CursorUtil.getColumnIndexOrThrow(_cursor, "scope");
          final int _cursorIndexOfDefaultValue = CursorUtil.getColumnIndexOrThrow(_cursor, "defaultValue");
          final int _cursorIndexOfValue = CursorUtil.getColumnIndexOrThrow(_cursor, "value");
          final List<FeatureFlagEntity> _result = new ArrayList<FeatureFlagEntity>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final FeatureFlagEntity _item_2;
            final UserId _tmpUserId;
            final String _tmp_1;
            if (_cursor.isNull(_cursorIndexOfUserId)) {
              _tmp_1 = null;
            } else {
              _tmp_1 = _cursor.getString(_cursorIndexOfUserId);
            }
            _tmpUserId = __commonConverters.fromStringToUserId(_tmp_1);
            final String _tmpFeatureId;
            if (_cursor.isNull(_cursorIndexOfFeatureId)) {
              _tmpFeatureId = null;
            } else {
              _tmpFeatureId = _cursor.getString(_cursorIndexOfFeatureId);
            }
            final Scope _tmpScope;
            _tmpScope = __Scope_stringToEnum(_cursor.getString(_cursorIndexOfScope));
            final boolean _tmpDefaultValue;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfDefaultValue);
            _tmpDefaultValue = _tmp_2 != 0;
            final boolean _tmpValue;
            final int _tmp_3;
            _tmp_3 = _cursor.getInt(_cursorIndexOfValue);
            _tmpValue = _tmp_3 != 0;
            _item_2 = new FeatureFlagEntity(_tmpUserId,_tmpFeatureId,_tmpScope,_tmpDefaultValue,_tmpValue);
            _result.add(_item_2);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object deleteAll$feature_flag_data_release(final List<UserId> userIds,
      final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("DELETE FROM FeatureFlagEntity WHERE userId IN (");
        final int _inputSize = userIds.size();
        StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
        _stringBuilder.append(")");
        final String _sql = _stringBuilder.toString();
        final SupportSQLiteStatement _stmt = __db.compileStatement(_sql);
        int _argIndex = 1;
        for (UserId _item : userIds) {
          final String _tmp = __commonConverters.fromUserIdToString(_item);
          if (_tmp == null) {
            _stmt.bindNull(_argIndex);
          } else {
            _stmt.bindString(_argIndex, _tmp);
          }
          _argIndex++;
        }
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }

  private String __Scope_enumToString(@NonNull final Scope _value) {
    switch (_value) {
      case Unknown: return "Unknown";
      case Local: return "Local";
      case User: return "User";
      case Global: return "Global";
      case Unleash: return "Unleash";
      default: throw new IllegalArgumentException("Can't convert enum to string, unknown enum value: " + _value);
    }
  }

  private Scope __Scope_stringToEnum(@NonNull final String _value) {
    switch (_value) {
      case "Unknown": return Scope.Unknown;
      case "Local": return Scope.Local;
      case "User": return Scope.User;
      case "Global": return Scope.Global;
      case "Unleash": return Scope.Unleash;
      default: throw new IllegalArgumentException("Can't convert value to enum, unknown value: " + _value);
    }
  }
}
