package me.proton.core.contact.data.local.db.dao;

import android.database.Cursor;
import androidx.annotation.NonNull;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;
import me.proton.core.contact.data.local.db.ContactConverters;
import me.proton.core.contact.data.local.db.entity.ContactEmailLabelEntity;
import me.proton.core.contact.domain.entity.ContactEmailId;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class ContactEmailLabelDao_Impl extends ContactEmailLabelDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<ContactEmailLabelEntity> __insertionAdapterOfContactEmailLabelEntity;

  private final ContactConverters __contactConverters = new ContactConverters();

  private final EntityDeletionOrUpdateAdapter<ContactEmailLabelEntity> __deletionAdapterOfContactEmailLabelEntity;

  private final EntityDeletionOrUpdateAdapter<ContactEmailLabelEntity> __updateAdapterOfContactEmailLabelEntity;

  public ContactEmailLabelDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfContactEmailLabelEntity = new EntityInsertionAdapter<ContactEmailLabelEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR IGNORE INTO `ContactEmailLabelEntity` (`contactEmailId`,`labelId`) VALUES (?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final ContactEmailLabelEntity entity) {
        final String _tmp = __contactConverters.fromContactEmailIdToString(entity.getContactEmailId());
        if (_tmp == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, _tmp);
        }
        if (entity.getLabelId() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getLabelId());
        }
      }
    };
    this.__deletionAdapterOfContactEmailLabelEntity = new EntityDeletionOrUpdateAdapter<ContactEmailLabelEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "DELETE FROM `ContactEmailLabelEntity` WHERE `contactEmailId` = ? AND `labelId` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final ContactEmailLabelEntity entity) {
        final String _tmp = __contactConverters.fromContactEmailIdToString(entity.getContactEmailId());
        if (_tmp == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, _tmp);
        }
        if (entity.getLabelId() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getLabelId());
        }
      }
    };
    this.__updateAdapterOfContactEmailLabelEntity = new EntityDeletionOrUpdateAdapter<ContactEmailLabelEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR ABORT `ContactEmailLabelEntity` SET `contactEmailId` = ?,`labelId` = ? WHERE `contactEmailId` = ? AND `labelId` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final ContactEmailLabelEntity entity) {
        final String _tmp = __contactConverters.fromContactEmailIdToString(entity.getContactEmailId());
        if (_tmp == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, _tmp);
        }
        if (entity.getLabelId() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getLabelId());
        }
        final String _tmp_1 = __contactConverters.fromContactEmailIdToString(entity.getContactEmailId());
        if (_tmp_1 == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, _tmp_1);
        }
        if (entity.getLabelId() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getLabelId());
        }
      }
    };
  }

  @Override
  public Object insertOrIgnore(final ContactEmailLabelEntity[] entities,
      final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfContactEmailLabelEntity.insert(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object delete(final ContactEmailLabelEntity[] entities,
      final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __deletionAdapterOfContactEmailLabelEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object update(final ContactEmailLabelEntity[] entities,
      final Continuation<? super Integer> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      @NonNull
      public Integer call() throws Exception {
        int _total = 0;
        __db.beginTransaction();
        try {
          _total += __updateAdapterOfContactEmailLabelEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return _total;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object insertOrUpdate(final ContactEmailLabelEntity[] entities,
      final Continuation<? super Unit> $completion) {
    return RoomDatabaseKt.withTransaction(__db, (__cont) -> ContactEmailLabelDao_Impl.super.insertOrUpdate(entities, __cont), $completion);
  }

  @Override
  public Object deleteAllLabels(final ContactEmailId[] contactEmailIds,
      final Continuation<? super Unit> $completion) {
    return RoomDatabaseKt.withTransaction(__db, (__cont) -> ContactEmailLabelDao_Impl.super.deleteAllLabels(contactEmailIds, __cont), $completion);
  }

  @Override
  public Flow<List<String>> observeAllLabels(final ContactEmailId contactEmailId) {
    final String _sql = "SELECT labelId FROM ContactEmailLabelEntity WHERE contactEmailId = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    final String _tmp = __contactConverters.fromContactEmailIdToString(contactEmailId);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp);
    }
    return CoroutinesRoom.createFlow(__db, true, new String[] {"ContactEmailLabelEntity"}, new Callable<List<String>>() {
      @Override
      @NonNull
      public List<String> call() throws Exception {
        __db.beginTransaction();
        try {
          final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
          try {
            final List<String> _result = new ArrayList<String>(_cursor.getCount());
            while (_cursor.moveToNext()) {
              final String _item;
              if (_cursor.isNull(0)) {
                _item = null;
              } else {
                _item = _cursor.getString(0);
              }
              _result.add(_item);
            }
            __db.setTransactionSuccessful();
            return _result;
          } finally {
            _cursor.close();
          }
        } finally {
          __db.endTransaction();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  protected Object deleteAllLabelsSingleBatch(final ContactEmailId[] contactEmailIds,
      final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("DELETE FROM ContactEmailLabelEntity WHERE contactEmailId IN (");
        final int _inputSize = contactEmailIds.length;
        StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
        _stringBuilder.append(")");
        final String _sql = _stringBuilder.toString();
        final SupportSQLiteStatement _stmt = __db.compileStatement(_sql);
        int _argIndex = 1;
        for (ContactEmailId _item : contactEmailIds) {
          final String _tmp = __contactConverters.fromContactEmailIdToString(_item);
          if (_tmp == null) {
            _stmt.bindNull(_argIndex);
          } else {
            _stmt.bindString(_argIndex, _tmp);
          }
          _argIndex++;
        }
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
