package me.proton.core.contact.data.local.db.dao;

import android.database.Cursor;
import androidx.annotation.NonNull;
import androidx.collection.ArrayMap;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.RelationUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;
import me.proton.core.contact.data.local.db.ContactConverters;
import me.proton.core.contact.data.local.db.entity.ContactEmailEntity;
import me.proton.core.contact.data.local.db.entity.relation.ContactEmailWithLabelsRelation;
import me.proton.core.contact.domain.entity.ContactEmailId;
import me.proton.core.contact.domain.entity.ContactId;
import me.proton.core.data.room.db.CommonConverters;
import me.proton.core.domain.entity.UserId;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class ContactEmailDao_Impl extends ContactEmailDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<ContactEmailEntity> __insertionAdapterOfContactEmailEntity;

  private final CommonConverters __commonConverters = new CommonConverters();

  private final ContactConverters __contactConverters = new ContactConverters();

  private final EntityDeletionOrUpdateAdapter<ContactEmailEntity> __deletionAdapterOfContactEmailEntity;

  private final EntityDeletionOrUpdateAdapter<ContactEmailEntity> __updateAdapterOfContactEmailEntity;

  private final SharedSQLiteStatement __preparedStmtOfDeleteAllContactsEmails;

  private final SharedSQLiteStatement __preparedStmtOfDeleteAllContactsEmails_1;

  public ContactEmailDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfContactEmailEntity = new EntityInsertionAdapter<ContactEmailEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR IGNORE INTO `ContactEmailEntity` (`userId`,`contactEmailId`,`name`,`email`,`defaults`,`order`,`contactId`,`canonicalEmail`,`isProton`) VALUES (?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final ContactEmailEntity entity) {
        final String _tmp = __commonConverters.fromUserIdToString(entity.getUserId());
        if (_tmp == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, _tmp);
        }
        final String _tmp_1 = __contactConverters.fromContactEmailIdToString(entity.getContactEmailId());
        if (_tmp_1 == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, _tmp_1);
        }
        if (entity.getName() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getName());
        }
        if (entity.getEmail() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getEmail());
        }
        statement.bindLong(5, entity.getDefaults());
        statement.bindLong(6, entity.getOrder());
        final String _tmp_2 = __contactConverters.fromContactIdToString(entity.getContactId());
        if (_tmp_2 == null) {
          statement.bindNull(7);
        } else {
          statement.bindString(7, _tmp_2);
        }
        if (entity.getCanonicalEmail() == null) {
          statement.bindNull(8);
        } else {
          statement.bindString(8, entity.getCanonicalEmail());
        }
        if (entity.isProton() == null) {
          statement.bindNull(9);
        } else {
          statement.bindLong(9, entity.isProton());
        }
      }
    };
    this.__deletionAdapterOfContactEmailEntity = new EntityDeletionOrUpdateAdapter<ContactEmailEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "DELETE FROM `ContactEmailEntity` WHERE `contactEmailId` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final ContactEmailEntity entity) {
        final String _tmp = __contactConverters.fromContactEmailIdToString(entity.getContactEmailId());
        if (_tmp == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, _tmp);
        }
      }
    };
    this.__updateAdapterOfContactEmailEntity = new EntityDeletionOrUpdateAdapter<ContactEmailEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR ABORT `ContactEmailEntity` SET `userId` = ?,`contactEmailId` = ?,`name` = ?,`email` = ?,`defaults` = ?,`order` = ?,`contactId` = ?,`canonicalEmail` = ?,`isProton` = ? WHERE `contactEmailId` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final ContactEmailEntity entity) {
        final String _tmp = __commonConverters.fromUserIdToString(entity.getUserId());
        if (_tmp == null) {
          statement.bindNull(1);
        } else {
          statement.bindString(1, _tmp);
        }
        final String _tmp_1 = __contactConverters.fromContactEmailIdToString(entity.getContactEmailId());
        if (_tmp_1 == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, _tmp_1);
        }
        if (entity.getName() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getName());
        }
        if (entity.getEmail() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getEmail());
        }
        statement.bindLong(5, entity.getDefaults());
        statement.bindLong(6, entity.getOrder());
        final String _tmp_2 = __contactConverters.fromContactIdToString(entity.getContactId());
        if (_tmp_2 == null) {
          statement.bindNull(7);
        } else {
          statement.bindString(7, _tmp_2);
        }
        if (entity.getCanonicalEmail() == null) {
          statement.bindNull(8);
        } else {
          statement.bindString(8, entity.getCanonicalEmail());
        }
        if (entity.isProton() == null) {
          statement.bindNull(9);
        } else {
          statement.bindLong(9, entity.isProton());
        }
        final String _tmp_3 = __contactConverters.fromContactEmailIdToString(entity.getContactEmailId());
        if (_tmp_3 == null) {
          statement.bindNull(10);
        } else {
          statement.bindString(10, _tmp_3);
        }
      }
    };
    this.__preparedStmtOfDeleteAllContactsEmails = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "DELETE FROM ContactEmailEntity WHERE userId = ?";
        return _query;
      }
    };
    this.__preparedStmtOfDeleteAllContactsEmails_1 = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "DELETE FROM ContactEmailEntity";
        return _query;
      }
    };
  }

  @Override
  public Object insertOrIgnore(final ContactEmailEntity[] entities,
      final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfContactEmailEntity.insert(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object delete(final ContactEmailEntity[] entities, final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __deletionAdapterOfContactEmailEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object update(final ContactEmailEntity[] entities,
      final Continuation<? super Integer> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      @NonNull
      public Integer call() throws Exception {
        int _total = 0;
        __db.beginTransaction();
        try {
          _total += __updateAdapterOfContactEmailEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return _total;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object insertOrUpdate(final ContactEmailEntity[] entities,
      final Continuation<? super Unit> $completion) {
    return RoomDatabaseKt.withTransaction(__db, (__cont) -> ContactEmailDao_Impl.super.insertOrUpdate(entities, __cont), $completion);
  }

  @Override
  public Object deleteContactsEmails(final ContactEmailId[] contactEmailIds,
      final Continuation<? super Unit> $completion) {
    return RoomDatabaseKt.withTransaction(__db, (__cont) -> ContactEmailDao_Impl.super.deleteContactsEmails(contactEmailIds, __cont), $completion);
  }

  @Override
  public Object deleteAllContactsEmails(final ContactId[] contactIds,
      final Continuation<? super Unit> $completion) {
    return RoomDatabaseKt.withTransaction(__db, (__cont) -> ContactEmailDao_Impl.super.deleteAllContactsEmails(contactIds, __cont), $completion);
  }

  @Override
  public Object deleteAllContactsEmails(final UserId userId,
      final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteAllContactsEmails.acquire();
        int _argIndex = 1;
        final String _tmp = __commonConverters.fromUserIdToString(userId);
        if (_tmp == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, _tmp);
        }
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfDeleteAllContactsEmails.release(_stmt);
        }
      }
    }, arg1);
  }

  @Override
  public Object deleteAllContactsEmails(final Continuation<? super Unit> arg0) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteAllContactsEmails_1.acquire();
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfDeleteAllContactsEmails_1.release(_stmt);
        }
      }
    }, arg0);
  }

  @Override
  public Flow<List<ContactEmailWithLabelsRelation>> observeAllContactsEmails(final UserId userId) {
    final String _sql = "SELECT * FROM ContactEmailEntity WHERE userId = ? ORDER BY `order`, name";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    final String _tmp = __commonConverters.fromUserIdToString(userId);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp);
    }
    return CoroutinesRoom.createFlow(__db, true, new String[] {"ContactEmailLabelEntity",
        "ContactEmailEntity"}, new Callable<List<ContactEmailWithLabelsRelation>>() {
      @Override
      @NonNull
      public List<ContactEmailWithLabelsRelation> call() throws Exception {
        __db.beginTransaction();
        try {
          final Cursor _cursor = DBUtil.query(__db, _statement, true, null);
          try {
            final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
            final int _cursorIndexOfContactEmailId = CursorUtil.getColumnIndexOrThrow(_cursor, "contactEmailId");
            final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "name");
            final int _cursorIndexOfEmail = CursorUtil.getColumnIndexOrThrow(_cursor, "email");
            final int _cursorIndexOfDefaults = CursorUtil.getColumnIndexOrThrow(_cursor, "defaults");
            final int _cursorIndexOfOrder = CursorUtil.getColumnIndexOrThrow(_cursor, "order");
            final int _cursorIndexOfContactId = CursorUtil.getColumnIndexOrThrow(_cursor, "contactId");
            final int _cursorIndexOfCanonicalEmail = CursorUtil.getColumnIndexOrThrow(_cursor, "canonicalEmail");
            final int _cursorIndexOfIsProton = CursorUtil.getColumnIndexOrThrow(_cursor, "isProton");
            final ArrayMap<String, ArrayList<String>> _collectionLabelIds = new ArrayMap<String, ArrayList<String>>();
            while (_cursor.moveToNext()) {
              final String _tmpKey;
              if (_cursor.isNull(_cursorIndexOfContactEmailId)) {
                _tmpKey = null;
              } else {
                _tmpKey = _cursor.getString(_cursorIndexOfContactEmailId);
              }
              if (_tmpKey != null) {
                if (!_collectionLabelIds.containsKey(_tmpKey)) {
                  _collectionLabelIds.put(_tmpKey, new ArrayList<String>());
                }
              }
            }
            _cursor.moveToPosition(-1);
            __fetchRelationshipContactEmailLabelEntityAsjavaLangString(_collectionLabelIds);
            final List<ContactEmailWithLabelsRelation> _result = new ArrayList<ContactEmailWithLabelsRelation>(_cursor.getCount());
            while (_cursor.moveToNext()) {
              final ContactEmailWithLabelsRelation _item;
              final ContactEmailEntity _tmpContactEmail;
              final UserId _tmpUserId;
              final String _tmp_1;
              if (_cursor.isNull(_cursorIndexOfUserId)) {
                _tmp_1 = null;
              } else {
                _tmp_1 = _cursor.getString(_cursorIndexOfUserId);
              }
              _tmpUserId = __commonConverters.fromStringToUserId(_tmp_1);
              final ContactEmailId _tmpContactEmailId;
              final String _tmp_2;
              if (_cursor.isNull(_cursorIndexOfContactEmailId)) {
                _tmp_2 = null;
              } else {
                _tmp_2 = _cursor.getString(_cursorIndexOfContactEmailId);
              }
              _tmpContactEmailId = __contactConverters.fromStringToContactEmailId(_tmp_2);
              final String _tmpName;
              if (_cursor.isNull(_cursorIndexOfName)) {
                _tmpName = null;
              } else {
                _tmpName = _cursor.getString(_cursorIndexOfName);
              }
              final String _tmpEmail;
              if (_cursor.isNull(_cursorIndexOfEmail)) {
                _tmpEmail = null;
              } else {
                _tmpEmail = _cursor.getString(_cursorIndexOfEmail);
              }
              final int _tmpDefaults;
              _tmpDefaults = _cursor.getInt(_cursorIndexOfDefaults);
              final int _tmpOrder;
              _tmpOrder = _cursor.getInt(_cursorIndexOfOrder);
              final ContactId _tmpContactId;
              final String _tmp_3;
              if (_cursor.isNull(_cursorIndexOfContactId)) {
                _tmp_3 = null;
              } else {
                _tmp_3 = _cursor.getString(_cursorIndexOfContactId);
              }
              _tmpContactId = __contactConverters.fromStringToContactId(_tmp_3);
              final String _tmpCanonicalEmail;
              if (_cursor.isNull(_cursorIndexOfCanonicalEmail)) {
                _tmpCanonicalEmail = null;
              } else {
                _tmpCanonicalEmail = _cursor.getString(_cursorIndexOfCanonicalEmail);
              }
              final Integer _tmpIsProton;
              if (_cursor.isNull(_cursorIndexOfIsProton)) {
                _tmpIsProton = null;
              } else {
                _tmpIsProton = _cursor.getInt(_cursorIndexOfIsProton);
              }
              _tmpContactEmail = new ContactEmailEntity(_tmpUserId,_tmpContactEmailId,_tmpName,_tmpEmail,_tmpDefaults,_tmpOrder,_tmpContactId,_tmpCanonicalEmail,_tmpIsProton);
              final ArrayList<String> _tmpLabelIdsCollection;
              final String _tmpKey_1;
              if (_cursor.isNull(_cursorIndexOfContactEmailId)) {
                _tmpKey_1 = null;
              } else {
                _tmpKey_1 = _cursor.getString(_cursorIndexOfContactEmailId);
              }
              if (_tmpKey_1 != null) {
                _tmpLabelIdsCollection = _collectionLabelIds.get(_tmpKey_1);
              } else {
                _tmpLabelIdsCollection = new ArrayList<String>();
              }
              _item = new ContactEmailWithLabelsRelation(_tmpContactEmail,_tmpLabelIdsCollection);
              _result.add(_item);
            }
            __db.setTransactionSuccessful();
            return _result;
          } finally {
            _cursor.close();
          }
        } finally {
          __db.endTransaction();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Flow<List<ContactEmailWithLabelsRelation>> observeAllContactsEmails(
      final ContactId contactId) {
    final String _sql = "SELECT * FROM ContactEmailEntity WHERE contactId = ? ORDER BY `order`, name";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    final String _tmp = __contactConverters.fromContactIdToString(contactId);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp);
    }
    return CoroutinesRoom.createFlow(__db, true, new String[] {"ContactEmailLabelEntity",
        "ContactEmailEntity"}, new Callable<List<ContactEmailWithLabelsRelation>>() {
      @Override
      @NonNull
      public List<ContactEmailWithLabelsRelation> call() throws Exception {
        __db.beginTransaction();
        try {
          final Cursor _cursor = DBUtil.query(__db, _statement, true, null);
          try {
            final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
            final int _cursorIndexOfContactEmailId = CursorUtil.getColumnIndexOrThrow(_cursor, "contactEmailId");
            final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "name");
            final int _cursorIndexOfEmail = CursorUtil.getColumnIndexOrThrow(_cursor, "email");
            final int _cursorIndexOfDefaults = CursorUtil.getColumnIndexOrThrow(_cursor, "defaults");
            final int _cursorIndexOfOrder = CursorUtil.getColumnIndexOrThrow(_cursor, "order");
            final int _cursorIndexOfContactId = CursorUtil.getColumnIndexOrThrow(_cursor, "contactId");
            final int _cursorIndexOfCanonicalEmail = CursorUtil.getColumnIndexOrThrow(_cursor, "canonicalEmail");
            final int _cursorIndexOfIsProton = CursorUtil.getColumnIndexOrThrow(_cursor, "isProton");
            final ArrayMap<String, ArrayList<String>> _collectionLabelIds = new ArrayMap<String, ArrayList<String>>();
            while (_cursor.moveToNext()) {
              final String _tmpKey;
              if (_cursor.isNull(_cursorIndexOfContactEmailId)) {
                _tmpKey = null;
              } else {
                _tmpKey = _cursor.getString(_cursorIndexOfContactEmailId);
              }
              if (_tmpKey != null) {
                if (!_collectionLabelIds.containsKey(_tmpKey)) {
                  _collectionLabelIds.put(_tmpKey, new ArrayList<String>());
                }
              }
            }
            _cursor.moveToPosition(-1);
            __fetchRelationshipContactEmailLabelEntityAsjavaLangString(_collectionLabelIds);
            final List<ContactEmailWithLabelsRelation> _result = new ArrayList<ContactEmailWithLabelsRelation>(_cursor.getCount());
            while (_cursor.moveToNext()) {
              final ContactEmailWithLabelsRelation _item;
              final ContactEmailEntity _tmpContactEmail;
              final UserId _tmpUserId;
              final String _tmp_1;
              if (_cursor.isNull(_cursorIndexOfUserId)) {
                _tmp_1 = null;
              } else {
                _tmp_1 = _cursor.getString(_cursorIndexOfUserId);
              }
              _tmpUserId = __commonConverters.fromStringToUserId(_tmp_1);
              final ContactEmailId _tmpContactEmailId;
              final String _tmp_2;
              if (_cursor.isNull(_cursorIndexOfContactEmailId)) {
                _tmp_2 = null;
              } else {
                _tmp_2 = _cursor.getString(_cursorIndexOfContactEmailId);
              }
              _tmpContactEmailId = __contactConverters.fromStringToContactEmailId(_tmp_2);
              final String _tmpName;
              if (_cursor.isNull(_cursorIndexOfName)) {
                _tmpName = null;
              } else {
                _tmpName = _cursor.getString(_cursorIndexOfName);
              }
              final String _tmpEmail;
              if (_cursor.isNull(_cursorIndexOfEmail)) {
                _tmpEmail = null;
              } else {
                _tmpEmail = _cursor.getString(_cursorIndexOfEmail);
              }
              final int _tmpDefaults;
              _tmpDefaults = _cursor.getInt(_cursorIndexOfDefaults);
              final int _tmpOrder;
              _tmpOrder = _cursor.getInt(_cursorIndexOfOrder);
              final ContactId _tmpContactId;
              final String _tmp_3;
              if (_cursor.isNull(_cursorIndexOfContactId)) {
                _tmp_3 = null;
              } else {
                _tmp_3 = _cursor.getString(_cursorIndexOfContactId);
              }
              _tmpContactId = __contactConverters.fromStringToContactId(_tmp_3);
              final String _tmpCanonicalEmail;
              if (_cursor.isNull(_cursorIndexOfCanonicalEmail)) {
                _tmpCanonicalEmail = null;
              } else {
                _tmpCanonicalEmail = _cursor.getString(_cursorIndexOfCanonicalEmail);
              }
              final Integer _tmpIsProton;
              if (_cursor.isNull(_cursorIndexOfIsProton)) {
                _tmpIsProton = null;
              } else {
                _tmpIsProton = _cursor.getInt(_cursorIndexOfIsProton);
              }
              _tmpContactEmail = new ContactEmailEntity(_tmpUserId,_tmpContactEmailId,_tmpName,_tmpEmail,_tmpDefaults,_tmpOrder,_tmpContactId,_tmpCanonicalEmail,_tmpIsProton);
              final ArrayList<String> _tmpLabelIdsCollection;
              final String _tmpKey_1;
              if (_cursor.isNull(_cursorIndexOfContactEmailId)) {
                _tmpKey_1 = null;
              } else {
                _tmpKey_1 = _cursor.getString(_cursorIndexOfContactEmailId);
              }
              if (_tmpKey_1 != null) {
                _tmpLabelIdsCollection = _collectionLabelIds.get(_tmpKey_1);
              } else {
                _tmpLabelIdsCollection = new ArrayList<String>();
              }
              _item = new ContactEmailWithLabelsRelation(_tmpContactEmail,_tmpLabelIdsCollection);
              _result.add(_item);
            }
            __db.setTransactionSuccessful();
            return _result;
          } finally {
            _cursor.close();
          }
        } finally {
          __db.endTransaction();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  protected Object deleteContactsEmailsSingleBatch(final ContactEmailId[] contactEmailIds,
      final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("DELETE FROM ContactEmailEntity WHERE contactId IN (");
        final int _inputSize = contactEmailIds.length;
        StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
        _stringBuilder.append(")");
        final String _sql = _stringBuilder.toString();
        final SupportSQLiteStatement _stmt = __db.compileStatement(_sql);
        int _argIndex = 1;
        for (ContactEmailId _item : contactEmailIds) {
          final String _tmp = __contactConverters.fromContactEmailIdToString(_item);
          if (_tmp == null) {
            _stmt.bindNull(_argIndex);
          } else {
            _stmt.bindString(_argIndex, _tmp);
          }
          _argIndex++;
        }
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  protected Object deleteAllContactsEmailsSingleBatch(final ContactId[] contactIds,
      final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("DELETE FROM ContactEmailEntity WHERE contactId IN (");
        final int _inputSize = contactIds.length;
        StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
        _stringBuilder.append(")");
        final String _sql = _stringBuilder.toString();
        final SupportSQLiteStatement _stmt = __db.compileStatement(_sql);
        int _argIndex = 1;
        for (ContactId _item : contactIds) {
          final String _tmp = __contactConverters.fromContactIdToString(_item);
          if (_tmp == null) {
            _stmt.bindNull(_argIndex);
          } else {
            _stmt.bindString(_argIndex, _tmp);
          }
          _argIndex++;
        }
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }

  private void __fetchRelationshipContactEmailLabelEntityAsjavaLangString(
      @NonNull final ArrayMap<String, ArrayList<String>> _map) {
    final Set<String> __mapKeySet = _map.keySet();
    if (__mapKeySet.isEmpty()) {
      return;
    }
    if (_map.size() > RoomDatabase.MAX_BIND_PARAMETER_CNT) {
      RelationUtil.recursiveFetchArrayMap(_map, true, (map) -> {
        __fetchRelationshipContactEmailLabelEntityAsjavaLangString(map);
        return Unit.INSTANCE;
      });
      return;
    }
    final StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("SELECT `labelId`,`contactEmailId` FROM `ContactEmailLabelEntity` WHERE `contactEmailId` IN (");
    final int _inputSize = __mapKeySet == null ? 1 : __mapKeySet.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(")");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 0 + _inputSize;
    final RoomSQLiteQuery _stmt = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    if (__mapKeySet == null) {
      _stmt.bindNull(_argIndex);
    } else {
      for (String _item : __mapKeySet) {
        if (_item == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, _item);
        }
        _argIndex++;
      }
    }
    final Cursor _cursor = DBUtil.query(__db, _stmt, false, null);
    try {
      final int _itemKeyIndex = CursorUtil.getColumnIndex(_cursor, "contactEmailId");
      if (_itemKeyIndex == -1) {
        return;
      }
      while (_cursor.moveToNext()) {
        final String _tmpKey;
        if (_cursor.isNull(_itemKeyIndex)) {
          _tmpKey = null;
        } else {
          _tmpKey = _cursor.getString(_itemKeyIndex);
        }
        if (_tmpKey != null) {
          final ArrayList<String> _tmpRelation = _map.get(_tmpKey);
          if (_tmpRelation != null) {
            final String _item_1;
            if (_cursor.isNull(0)) {
              _item_1 = null;
            } else {
              _item_1 = _cursor.getString(0);
            }
            _tmpRelation.add(_item_1);
          }
        }
      }
    } finally {
      _cursor.close();
    }
  }
}
