package me.proton.core.accountmanager.data.db;

import androidx.annotation.NonNull;
import androidx.room.DatabaseConfiguration;
import androidx.room.InvalidationTracker;
import androidx.room.RoomDatabase;
import androidx.room.RoomOpenHelper;
import androidx.room.migration.AutoMigrationSpec;
import androidx.room.migration.Migration;
import androidx.room.util.DBUtil;
import androidx.room.util.TableInfo;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Generated;
import me.proton.core.account.data.db.AccountDao;
import me.proton.core.account.data.db.AccountDao_Impl;
import me.proton.core.account.data.db.AccountMetadataDao;
import me.proton.core.account.data.db.AccountMetadataDao_Impl;
import me.proton.core.account.data.db.SessionDao;
import me.proton.core.account.data.db.SessionDao_Impl;
import me.proton.core.account.data.db.SessionDetailsDao;
import me.proton.core.account.data.db.SessionDetailsDao_Impl;
import me.proton.core.challenge.data.db.ChallengeFramesDao;
import me.proton.core.challenge.data.db.ChallengeFramesDao_Impl;
import me.proton.core.contact.data.local.db.dao.ContactCardDao;
import me.proton.core.contact.data.local.db.dao.ContactCardDao_Impl;
import me.proton.core.contact.data.local.db.dao.ContactDao;
import me.proton.core.contact.data.local.db.dao.ContactDao_Impl;
import me.proton.core.contact.data.local.db.dao.ContactEmailDao;
import me.proton.core.contact.data.local.db.dao.ContactEmailDao_Impl;
import me.proton.core.contact.data.local.db.dao.ContactEmailLabelDao;
import me.proton.core.contact.data.local.db.dao.ContactEmailLabelDao_Impl;
import me.proton.core.eventmanager.data.db.dao.EventMetadataDao;
import me.proton.core.eventmanager.data.db.dao.EventMetadataDao_Impl;
import me.proton.core.featureflag.data.db.FeatureFlagDao;
import me.proton.core.featureflag.data.db.FeatureFlagDao_Impl;
import me.proton.core.humanverification.data.db.HumanVerificationDetailsDao;
import me.proton.core.humanverification.data.db.HumanVerificationDetailsDao_Impl;
import me.proton.core.key.data.db.KeySaltDao;
import me.proton.core.key.data.db.KeySaltDao_Impl;
import me.proton.core.key.data.db.PublicAddressDao;
import me.proton.core.key.data.db.PublicAddressDao_Impl;
import me.proton.core.key.data.db.PublicAddressKeyDao;
import me.proton.core.key.data.db.PublicAddressKeyDao_Impl;
import me.proton.core.key.data.db.PublicAddressWithKeysDao;
import me.proton.core.key.data.db.PublicAddressWithKeysDao_Impl;
import me.proton.core.keytransparency.data.local.AddressChangeDao;
import me.proton.core.keytransparency.data.local.AddressChangeDao_Impl;
import me.proton.core.keytransparency.data.local.SelfAuditResultDao;
import me.proton.core.keytransparency.data.local.SelfAuditResultDao_Impl;
import me.proton.core.label.data.local.LabelDao;
import me.proton.core.label.data.local.LabelDao_Impl;
import me.proton.core.mailsettings.data.db.dao.MailSettingsDao;
import me.proton.core.mailsettings.data.db.dao.MailSettingsDao_Impl;
import me.proton.core.notification.data.local.db.NotificationDao;
import me.proton.core.notification.data.local.db.NotificationDao_Impl;
import me.proton.core.observability.data.db.ObservabilityDao;
import me.proton.core.observability.data.db.ObservabilityDao_Impl;
import me.proton.core.payment.data.local.db.dao.GooglePurchaseDao;
import me.proton.core.payment.data.local.db.dao.GooglePurchaseDao_Impl;
import me.proton.core.payment.data.local.db.dao.PurchaseDao;
import me.proton.core.payment.data.local.db.dao.PurchaseDao_Impl;
import me.proton.core.push.data.local.db.PushDao;
import me.proton.core.push.data.local.db.PushDao_Impl;
import me.proton.core.telemetry.data.db.TelemetryDao;
import me.proton.core.telemetry.data.db.TelemetryDao_Impl;
import me.proton.core.user.data.db.dao.AddressDao;
import me.proton.core.user.data.db.dao.AddressDao_Impl;
import me.proton.core.user.data.db.dao.AddressKeyDao;
import me.proton.core.user.data.db.dao.AddressKeyDao_Impl;
import me.proton.core.user.data.db.dao.AddressWithKeysDao;
import me.proton.core.user.data.db.dao.AddressWithKeysDao_Impl;
import me.proton.core.user.data.db.dao.UserDao;
import me.proton.core.user.data.db.dao.UserDao_Impl;
import me.proton.core.user.data.db.dao.UserKeyDao;
import me.proton.core.user.data.db.dao.UserKeyDao_Impl;
import me.proton.core.user.data.db.dao.UserWithKeysDao;
import me.proton.core.user.data.db.dao.UserWithKeysDao_Impl;
import me.proton.core.usersettings.data.db.dao.OrganizationDao;
import me.proton.core.usersettings.data.db.dao.OrganizationDao_Impl;
import me.proton.core.usersettings.data.db.dao.OrganizationKeysDao;
import me.proton.core.usersettings.data.db.dao.OrganizationKeysDao_Impl;
import me.proton.core.usersettings.data.db.dao.UserSettingsDao;
import me.proton.core.usersettings.data.db.dao.UserSettingsDao_Impl;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class AccountManagerDatabase_Impl extends AccountManagerDatabase {
  private volatile AccountDao _accountDao;

  private volatile SessionDao _sessionDao;

  private volatile AccountMetadataDao _accountMetadataDao;

  private volatile SessionDetailsDao _sessionDetailsDao;

  private volatile UserKeyDao _userKeyDao;

  private volatile UserDao _userDao;

  private volatile UserWithKeysDao _userWithKeysDao;

  private volatile AddressKeyDao _addressKeyDao;

  private volatile AddressDao _addressDao;

  private volatile AddressWithKeysDao _addressWithKeysDao;

  private volatile KeySaltDao _keySaltDao;

  private volatile HumanVerificationDetailsDao _humanVerificationDetailsDao;

  private volatile PublicAddressDao _publicAddressDao;

  private volatile PublicAddressKeyDao _publicAddressKeyDao;

  private volatile PublicAddressWithKeysDao _publicAddressWithKeysDao;

  private volatile MailSettingsDao _mailSettingsDao;

  private volatile UserSettingsDao _userSettingsDao;

  private volatile OrganizationDao _organizationDao;

  private volatile OrganizationKeysDao _organizationKeysDao;

  private volatile ContactDao _contactDao;

  private volatile ContactCardDao _contactCardDao;

  private volatile ContactEmailDao _contactEmailDao;

  private volatile ContactEmailLabelDao _contactEmailLabelDao;

  private volatile EventMetadataDao _eventMetadataDao;

  private volatile LabelDao _labelDao;

  private volatile FeatureFlagDao _featureFlagDao;

  private volatile ChallengeFramesDao _challengeFramesDao;

  private volatile PushDao _pushDao;

  private volatile PurchaseDao _purchaseDao;

  private volatile GooglePurchaseDao _googlePurchaseDao;

  private volatile ObservabilityDao _observabilityDao;

  private volatile TelemetryDao _telemetryDao;

  private volatile AddressChangeDao _addressChangeDao;

  private volatile SelfAuditResultDao _selfAuditResultDao;

  private volatile NotificationDao _notificationDao;

  @Override
  @NonNull
  protected SupportSQLiteOpenHelper createOpenHelper(@NonNull final DatabaseConfiguration config) {
    final SupportSQLiteOpenHelper.Callback _openCallback = new RoomOpenHelper(config, new RoomOpenHelper.Delegate(44) {
      @Override
      public void createAllTables(@NonNull final SupportSQLiteDatabase db) {
        db.execSQL("CREATE TABLE IF NOT EXISTS `AccountEntity` (`userId` TEXT NOT NULL, `username` TEXT, `email` TEXT, `state` TEXT NOT NULL, `sessionId` TEXT, `sessionState` TEXT, PRIMARY KEY(`userId`), FOREIGN KEY(`sessionId`) REFERENCES `SessionEntity`(`sessionId`) ON UPDATE NO ACTION ON DELETE NO ACTION )");
        db.execSQL("CREATE INDEX IF NOT EXISTS `index_AccountEntity_sessionId` ON `AccountEntity` (`sessionId`)");
        db.execSQL("CREATE INDEX IF NOT EXISTS `index_AccountEntity_userId` ON `AccountEntity` (`userId`)");
        db.execSQL("CREATE TABLE IF NOT EXISTS `AccountMetadataEntity` (`userId` TEXT NOT NULL, `product` TEXT NOT NULL, `primaryAtUtc` INTEGER NOT NULL, `migrations` TEXT, PRIMARY KEY(`userId`, `product`), FOREIGN KEY(`userId`) REFERENCES `AccountEntity`(`userId`) ON UPDATE NO ACTION ON DELETE CASCADE )");
        db.execSQL("CREATE INDEX IF NOT EXISTS `index_AccountMetadataEntity_userId` ON `AccountMetadataEntity` (`userId`)");
        db.execSQL("CREATE INDEX IF NOT EXISTS `index_AccountMetadataEntity_product` ON `AccountMetadataEntity` (`product`)");
        db.execSQL("CREATE INDEX IF NOT EXISTS `index_AccountMetadataEntity_primaryAtUtc` ON `AccountMetadataEntity` (`primaryAtUtc`)");
        db.execSQL("CREATE TABLE IF NOT EXISTS `SessionEntity` (`userId` TEXT, `sessionId` TEXT NOT NULL, `accessToken` TEXT NOT NULL, `refreshToken` TEXT NOT NULL, `scopes` TEXT NOT NULL, `product` TEXT NOT NULL, PRIMARY KEY(`sessionId`), FOREIGN KEY(`userId`) REFERENCES `AccountEntity`(`userId`) ON UPDATE NO ACTION ON DELETE CASCADE )");
        db.execSQL("CREATE INDEX IF NOT EXISTS `index_SessionEntity_sessionId` ON `SessionEntity` (`sessionId`)");
        db.execSQL("CREATE INDEX IF NOT EXISTS `index_SessionEntity_userId` ON `SessionEntity` (`userId`)");
        db.execSQL("CREATE TABLE IF NOT EXISTS `SessionDetailsEntity` (`sessionId` TEXT NOT NULL, `initialEventId` TEXT NOT NULL, `requiredAccountType` TEXT NOT NULL, `secondFactorEnabled` INTEGER NOT NULL, `twoPassModeEnabled` INTEGER NOT NULL, `password` TEXT, PRIMARY KEY(`sessionId`), FOREIGN KEY(`sessionId`) REFERENCES `SessionEntity`(`sessionId`) ON UPDATE NO ACTION ON DELETE CASCADE )");
        db.execSQL("CREATE INDEX IF NOT EXISTS `index_SessionDetailsEntity_sessionId` ON `SessionDetailsEntity` (`sessionId`)");
        db.execSQL("CREATE TABLE IF NOT EXISTS `UserEntity` (`userId` TEXT NOT NULL, `email` TEXT, `name` TEXT, `displayName` TEXT, `currency` TEXT NOT NULL, `credit` INTEGER NOT NULL, `createdAtUtc` INTEGER NOT NULL, `usedSpace` INTEGER NOT NULL, `maxSpace` INTEGER NOT NULL, `maxUpload` INTEGER NOT NULL, `type` INTEGER, `role` INTEGER, `private` INTEGER NOT NULL, `subscribed` INTEGER NOT NULL, `services` INTEGER NOT NULL, `delinquent` INTEGER, `passphrase` BLOB, `maxBaseSpace` INTEGER, `maxDriveSpace` INTEGER, `usedBaseSpace` INTEGER, `usedDriveSpace` INTEGER, `recovery_state` INTEGER, `recovery_startTime` INTEGER, `recovery_endTime` INTEGER, `recovery_sessionId` TEXT, `recovery_reason` INTEGER, PRIMARY KEY(`userId`), FOREIGN KEY(`userId`) REFERENCES `AccountEntity`(`userId`) ON UPDATE NO ACTION ON DELETE CASCADE )");
        db.execSQL("CREATE INDEX IF NOT EXISTS `index_UserEntity_userId` ON `UserEntity` (`userId`)");
        db.execSQL("CREATE TABLE IF NOT EXISTS `UserKeyEntity` (`userId` TEXT NOT NULL, `keyId` TEXT NOT NULL, `version` INTEGER NOT NULL, `privateKey` TEXT NOT NULL, `isPrimary` INTEGER NOT NULL, `isUnlockable` INTEGER NOT NULL, `fingerprint` TEXT, `activation` TEXT, `active` INTEGER, `recoverySecret` TEXT, `recoverySecretSignature` TEXT, PRIMARY KEY(`keyId`), FOREIGN KEY(`userId`) REFERENCES `UserEntity`(`userId`) ON UPDATE NO ACTION ON DELETE CASCADE )");
        db.execSQL("CREATE INDEX IF NOT EXISTS `index_UserKeyEntity_userId` ON `UserKeyEntity` (`userId`)");
        db.execSQL("CREATE INDEX IF NOT EXISTS `index_UserKeyEntity_keyId` ON `UserKeyEntity` (`keyId`)");
        db.execSQL("CREATE TABLE IF NOT EXISTS `AddressEntity` (`userId` TEXT NOT NULL, `addressId` TEXT NOT NULL, `email` TEXT NOT NULL, `displayName` TEXT, `signature` TEXT, `domainId` TEXT, `canSend` INTEGER NOT NULL, `canReceive` INTEGER NOT NULL, `enabled` INTEGER NOT NULL, `type` INTEGER, `order` INTEGER NOT NULL, `signedKeyList_data` TEXT, `signedKeyList_signature` TEXT, `signedKeyList_minEpochId` INTEGER, `signedKeyList_maxEpochId` INTEGER, `signedKeyList_expectedMinEpochId` INTEGER, PRIMARY KEY(`addressId`), FOREIGN KEY(`userId`) REFERENCES `UserEntity`(`userId`) ON UPDATE NO ACTION ON DELETE CASCADE )");
        db.execSQL("CREATE INDEX IF NOT EXISTS `index_AddressEntity_addressId` ON `AddressEntity` (`addressId`)");
        db.execSQL("CREATE INDEX IF NOT EXISTS `index_AddressEntity_userId` ON `AddressEntity` (`userId`)");
        db.execSQL("CREATE TABLE IF NOT EXISTS `AddressKeyEntity` (`addressId` TEXT NOT NULL, `keyId` TEXT NOT NULL, `version` INTEGER NOT NULL, `privateKey` TEXT NOT NULL, `isPrimary` INTEGER NOT NULL, `isUnlockable` INTEGER NOT NULL, `flags` INTEGER NOT NULL, `passphrase` BLOB, `token` TEXT, `signature` TEXT, `fingerprint` TEXT, `fingerprints` TEXT, `activation` TEXT, `active` INTEGER NOT NULL, PRIMARY KEY(`keyId`), FOREIGN KEY(`addressId`) REFERENCES `AddressEntity`(`addressId`) ON UPDATE NO ACTION ON DELETE CASCADE )");
        db.execSQL("CREATE INDEX IF NOT EXISTS `index_AddressKeyEntity_addressId` ON `AddressKeyEntity` (`addressId`)");
        db.execSQL("CREATE INDEX IF NOT EXISTS `index_AddressKeyEntity_keyId` ON `AddressKeyEntity` (`keyId`)");
        db.execSQL("CREATE TABLE IF NOT EXISTS `KeySaltEntity` (`userId` TEXT NOT NULL, `keyId` TEXT NOT NULL, `keySalt` TEXT, PRIMARY KEY(`userId`, `keyId`))");
        db.execSQL("CREATE INDEX IF NOT EXISTS `index_KeySaltEntity_userId` ON `KeySaltEntity` (`userId`)");
        db.execSQL("CREATE INDEX IF NOT EXISTS `index_KeySaltEntity_keyId` ON `KeySaltEntity` (`keyId`)");
        db.execSQL("CREATE TABLE IF NOT EXISTS `PublicAddressEntity` (`email` TEXT NOT NULL, `recipientType` INTEGER NOT NULL, `mimeType` TEXT, `ignoreKT` INTEGER, `signedKeyList_data` TEXT, `signedKeyList_signature` TEXT, `signedKeyList_minEpochId` INTEGER, `signedKeyList_maxEpochId` INTEGER, `signedKeyList_expectedMinEpochId` INTEGER, PRIMARY KEY(`email`))");
        db.execSQL("CREATE INDEX IF NOT EXISTS `index_PublicAddressEntity_email` ON `PublicAddressEntity` (`email`)");
        db.execSQL("CREATE TABLE IF NOT EXISTS `PublicAddressKeyEntity` (`email` TEXT NOT NULL, `flags` INTEGER NOT NULL, `publicKey` TEXT NOT NULL, `isPrimary` INTEGER NOT NULL, PRIMARY KEY(`email`, `publicKey`), FOREIGN KEY(`email`) REFERENCES `PublicAddressEntity`(`email`) ON UPDATE NO ACTION ON DELETE CASCADE )");
        db.execSQL("CREATE INDEX IF NOT EXISTS `index_PublicAddressKeyEntity_email` ON `PublicAddressKeyEntity` (`email`)");
        db.execSQL("CREATE TABLE IF NOT EXISTS `HumanVerificationEntity` (`clientId` TEXT NOT NULL, `clientIdType` TEXT NOT NULL, `verificationMethods` TEXT NOT NULL, `verificationToken` TEXT, `state` TEXT NOT NULL, `humanHeaderTokenType` TEXT, `humanHeaderTokenCode` TEXT, PRIMARY KEY(`clientId`))");
        db.execSQL("CREATE TABLE IF NOT EXISTS `MailSettingsEntity` (`userId` TEXT NOT NULL, `displayName` TEXT, `signature` TEXT, `autoSaveContacts` INTEGER, `composerMode` INTEGER, `messageButtons` INTEGER, `showImages` INTEGER, `showMoved` INTEGER, `viewMode` INTEGER, `viewLayout` INTEGER, `swipeLeft` INTEGER, `swipeRight` INTEGER, `shortcuts` INTEGER, `pmSignature` INTEGER, `numMessagePerPage` INTEGER, `draftMimeType` TEXT, `receiveMimeType` TEXT, `showMimeType` TEXT, `enableFolderColor` INTEGER, `inheritParentFolderColor` INTEGER, `rightToLeft` INTEGER, `attachPublicKey` INTEGER, `sign` INTEGER, `pgpScheme` INTEGER, `promptPin` INTEGER, `stickyLabels` INTEGER, `confirmLink` INTEGER, PRIMARY KEY(`userId`), FOREIGN KEY(`userId`) REFERENCES `UserEntity`(`userId`) ON UPDATE NO ACTION ON DELETE CASCADE )");
        db.execSQL("CREATE TABLE IF NOT EXISTS `UserSettingsEntity` (`userId` TEXT NOT NULL, `news` INTEGER, `locale` TEXT, `logAuth` INTEGER, `density` INTEGER, `weekStart` INTEGER, `dateFormat` INTEGER, `timeFormat` INTEGER, `earlyAccess` INTEGER, `deviceRecovery` INTEGER, `telemetry` INTEGER, `crashReports` INTEGER, `email_value` TEXT, `email_status` INTEGER, `email_notify` INTEGER, `email_reset` INTEGER, `phone_value` TEXT, `phone_status` INTEGER, `phone_notify` INTEGER, `phone_reset` INTEGER, `password_mode` INTEGER, `password_expirationTime` INTEGER, `twoFA_enabled` INTEGER, `twoFA_allowed` INTEGER, `twoFA_expirationTime` INTEGER, PRIMARY KEY(`userId`), FOREIGN KEY(`userId`) REFERENCES `UserEntity`(`userId`) ON UPDATE NO ACTION ON DELETE CASCADE )");
        db.execSQL("CREATE TABLE IF NOT EXISTS `OrganizationEntity` (`userId` TEXT NOT NULL, `name` TEXT NOT NULL, `displayName` TEXT, `planName` TEXT, `twoFactorGracePeriod` INTEGER, `theme` TEXT, `email` TEXT, `maxDomains` INTEGER, `maxAddresses` INTEGER, `maxSpace` INTEGER, `maxMembers` INTEGER, `maxVPN` INTEGER, `maxCalendars` INTEGER, `features` INTEGER, `flags` INTEGER, `usedDomains` INTEGER, `usedAddresses` INTEGER, `usedSpace` INTEGER, `assignedSpace` INTEGER, `usedMembers` INTEGER, `usedVPN` INTEGER, `usedCalendars` INTEGER, `hasKeys` INTEGER, `toMigrate` INTEGER, PRIMARY KEY(`userId`), FOREIGN KEY(`userId`) REFERENCES `UserEntity`(`userId`) ON UPDATE NO ACTION ON DELETE CASCADE )");
        db.execSQL("CREATE TABLE IF NOT EXISTS `OrganizationKeysEntity` (`userId` TEXT NOT NULL, `publicKey` TEXT NOT NULL, `privateKey` TEXT NOT NULL, PRIMARY KEY(`userId`), FOREIGN KEY(`userId`) REFERENCES `UserEntity`(`userId`) ON UPDATE NO ACTION ON DELETE CASCADE )");
        db.execSQL("CREATE TABLE IF NOT EXISTS `ContactEntity` (`userId` TEXT NOT NULL, `contactId` TEXT NOT NULL, `name` TEXT NOT NULL, PRIMARY KEY(`contactId`), FOREIGN KEY(`userId`) REFERENCES `UserEntity`(`userId`) ON UPDATE NO ACTION ON DELETE CASCADE )");
        db.execSQL("CREATE INDEX IF NOT EXISTS `index_ContactEntity_userId` ON `ContactEntity` (`userId`)");
        db.execSQL("CREATE TABLE IF NOT EXISTS `ContactCardEntity` (`contactId` TEXT NOT NULL, `type` INTEGER NOT NULL, `data` TEXT NOT NULL, `signature` TEXT, `cardId` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, FOREIGN KEY(`contactId`) REFERENCES `ContactEntity`(`contactId`) ON UPDATE NO ACTION ON DELETE CASCADE )");
        db.execSQL("CREATE INDEX IF NOT EXISTS `index_ContactCardEntity_contactId` ON `ContactCardEntity` (`contactId`)");
        db.execSQL("CREATE TABLE IF NOT EXISTS `ContactEmailEntity` (`userId` TEXT NOT NULL, `contactEmailId` TEXT NOT NULL, `name` TEXT NOT NULL, `email` TEXT NOT NULL, `defaults` INTEGER NOT NULL, `order` INTEGER NOT NULL, `contactId` TEXT NOT NULL, `canonicalEmail` TEXT, `isProton` INTEGER, PRIMARY KEY(`contactEmailId`), FOREIGN KEY(`userId`) REFERENCES `UserEntity`(`userId`) ON UPDATE NO ACTION ON DELETE CASCADE , FOREIGN KEY(`contactId`) REFERENCES `ContactEntity`(`contactId`) ON UPDATE NO ACTION ON DELETE CASCADE )");
        db.execSQL("CREATE INDEX IF NOT EXISTS `index_ContactEmailEntity_userId` ON `ContactEmailEntity` (`userId`)");
        db.execSQL("CREATE INDEX IF NOT EXISTS `index_ContactEmailEntity_contactId` ON `ContactEmailEntity` (`contactId`)");
        db.execSQL("CREATE TABLE IF NOT EXISTS `ContactEmailLabelEntity` (`contactEmailId` TEXT NOT NULL, `labelId` TEXT NOT NULL, PRIMARY KEY(`contactEmailId`, `labelId`), FOREIGN KEY(`contactEmailId`) REFERENCES `ContactEmailEntity`(`contactEmailId`) ON UPDATE NO ACTION ON DELETE CASCADE )");
        db.execSQL("CREATE TABLE IF NOT EXISTS `EventMetadataEntity` (`userId` TEXT NOT NULL, `config` TEXT NOT NULL, `eventId` TEXT, `nextEventId` TEXT, `refresh` TEXT, `more` INTEGER, `retry` INTEGER NOT NULL, `state` TEXT NOT NULL, `createdAt` INTEGER NOT NULL, `updatedAt` INTEGER, PRIMARY KEY(`userId`, `config`), FOREIGN KEY(`userId`) REFERENCES `UserEntity`(`userId`) ON UPDATE NO ACTION ON DELETE CASCADE )");
        db.execSQL("CREATE INDEX IF NOT EXISTS `index_EventMetadataEntity_userId` ON `EventMetadataEntity` (`userId`)");
        db.execSQL("CREATE INDEX IF NOT EXISTS `index_EventMetadataEntity_config` ON `EventMetadataEntity` (`config`)");
        db.execSQL("CREATE INDEX IF NOT EXISTS `index_EventMetadataEntity_createdAt` ON `EventMetadataEntity` (`createdAt`)");
        db.execSQL("CREATE TABLE IF NOT EXISTS `LabelEntity` (`userId` TEXT NOT NULL, `labelId` TEXT NOT NULL, `parentId` TEXT, `name` TEXT NOT NULL, `type` INTEGER NOT NULL, `path` TEXT NOT NULL, `color` TEXT NOT NULL, `order` INTEGER NOT NULL, `isNotified` INTEGER, `isExpanded` INTEGER, `isSticky` INTEGER, PRIMARY KEY(`userId`, `labelId`), FOREIGN KEY(`userId`) REFERENCES `UserEntity`(`userId`) ON UPDATE NO ACTION ON DELETE CASCADE )");
        db.execSQL("CREATE INDEX IF NOT EXISTS `index_LabelEntity_userId` ON `LabelEntity` (`userId`)");
        db.execSQL("CREATE INDEX IF NOT EXISTS `index_LabelEntity_labelId` ON `LabelEntity` (`labelId`)");
        db.execSQL("CREATE INDEX IF NOT EXISTS `index_LabelEntity_parentId` ON `LabelEntity` (`parentId`)");
        db.execSQL("CREATE INDEX IF NOT EXISTS `index_LabelEntity_name` ON `LabelEntity` (`name`)");
        db.execSQL("CREATE INDEX IF NOT EXISTS `index_LabelEntity_type` ON `LabelEntity` (`type`)");
        db.execSQL("CREATE TABLE IF NOT EXISTS `FeatureFlagEntity` (`userId` TEXT NOT NULL, `featureId` TEXT NOT NULL, `scope` TEXT NOT NULL, `defaultValue` INTEGER NOT NULL, `value` INTEGER NOT NULL, PRIMARY KEY(`userId`, `featureId`))");
        db.execSQL("CREATE INDEX IF NOT EXISTS `index_FeatureFlagEntity_userId` ON `FeatureFlagEntity` (`userId`)");
        db.execSQL("CREATE INDEX IF NOT EXISTS `index_FeatureFlagEntity_featureId` ON `FeatureFlagEntity` (`featureId`)");
        db.execSQL("CREATE TABLE IF NOT EXISTS `ChallengeFrameEntity` (`challengeFrame` TEXT NOT NULL, `flow` TEXT NOT NULL, `focusTime` TEXT NOT NULL, `clicks` INTEGER NOT NULL, `copy` TEXT NOT NULL, `paste` TEXT NOT NULL, `keys` TEXT NOT NULL, PRIMARY KEY(`challengeFrame`))");
        db.execSQL("CREATE TABLE IF NOT EXISTS `PushEntity` (`userId` TEXT NOT NULL, `pushId` TEXT NOT NULL, `objectId` TEXT NOT NULL, `type` TEXT NOT NULL, PRIMARY KEY(`userId`, `pushId`), FOREIGN KEY(`userId`) REFERENCES `UserEntity`(`userId`) ON UPDATE NO ACTION ON DELETE CASCADE )");
        db.execSQL("CREATE INDEX IF NOT EXISTS `index_PushEntity_userId` ON `PushEntity` (`userId`)");
        db.execSQL("CREATE INDEX IF NOT EXISTS `index_PushEntity_type` ON `PushEntity` (`type`)");
        db.execSQL("CREATE TABLE IF NOT EXISTS `PurchaseEntity` (`sessionId` TEXT NOT NULL, `planName` TEXT NOT NULL, `planCycle` INTEGER NOT NULL, `purchaseState` TEXT NOT NULL, `purchaseFailure` TEXT, `paymentProvider` TEXT NOT NULL, `paymentOrderId` TEXT, `paymentToken` TEXT, `paymentCurrency` TEXT NOT NULL, `paymentAmount` INTEGER NOT NULL, PRIMARY KEY(`planName`), FOREIGN KEY(`sessionId`) REFERENCES `SessionEntity`(`sessionId`) ON UPDATE NO ACTION ON DELETE CASCADE )");
        db.execSQL("CREATE INDEX IF NOT EXISTS `index_PurchaseEntity_planName` ON `PurchaseEntity` (`planName`)");
        db.execSQL("CREATE INDEX IF NOT EXISTS `index_PurchaseEntity_sessionId` ON `PurchaseEntity` (`sessionId`)");
        db.execSQL("CREATE INDEX IF NOT EXISTS `index_PurchaseEntity_purchaseState` ON `PurchaseEntity` (`purchaseState`)");
        db.execSQL("CREATE INDEX IF NOT EXISTS `index_PurchaseEntity_paymentProvider` ON `PurchaseEntity` (`paymentProvider`)");
        db.execSQL("CREATE TABLE IF NOT EXISTS `GooglePurchaseEntity` (`googlePurchaseToken` TEXT NOT NULL, `paymentToken` TEXT NOT NULL, PRIMARY KEY(`googlePurchaseToken`))");
        db.execSQL("CREATE UNIQUE INDEX IF NOT EXISTS `index_GooglePurchaseEntity_paymentToken` ON `GooglePurchaseEntity` (`paymentToken`)");
        db.execSQL("CREATE TABLE IF NOT EXISTS `ObservabilityEventEntity` (`id` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `name` TEXT NOT NULL, `version` INTEGER NOT NULL, `timestamp` INTEGER NOT NULL, `data` TEXT NOT NULL)");
        db.execSQL("CREATE TABLE IF NOT EXISTS `TelemetryEventEntity` (`id` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `userId` TEXT, `group` TEXT NOT NULL, `name` TEXT NOT NULL, `values` TEXT NOT NULL, `dimensions` TEXT NOT NULL, `timestamp` INTEGER NOT NULL, FOREIGN KEY(`userId`) REFERENCES `UserEntity`(`userId`) ON UPDATE NO ACTION ON DELETE CASCADE )");
        db.execSQL("CREATE INDEX IF NOT EXISTS `index_TelemetryEventEntity_userId` ON `TelemetryEventEntity` (`userId`)");
        db.execSQL("CREATE TABLE IF NOT EXISTS `AddressChangeEntity` (`userId` TEXT NOT NULL, `changeId` TEXT NOT NULL, `counterEncrypted` TEXT NOT NULL, `emailEncrypted` TEXT NOT NULL, `epochIdEncrypted` TEXT NOT NULL, `creationTimestampEncrypted` TEXT NOT NULL, `publicKeysEncrypted` TEXT NOT NULL, `isObsolete` TEXT NOT NULL, PRIMARY KEY(`userId`, `changeId`), FOREIGN KEY(`userId`) REFERENCES `UserEntity`(`userId`) ON UPDATE NO ACTION ON DELETE CASCADE )");
        db.execSQL("CREATE TABLE IF NOT EXISTS `SelfAuditResultEntity` (`userId` TEXT NOT NULL, `timestamp` INTEGER NOT NULL, PRIMARY KEY(`userId`), FOREIGN KEY(`userId`) REFERENCES `UserEntity`(`userId`) ON UPDATE NO ACTION ON DELETE CASCADE )");
        db.execSQL("CREATE TABLE IF NOT EXISTS `NotificationEntity` (`notificationId` TEXT NOT NULL, `userId` TEXT NOT NULL, `time` INTEGER NOT NULL, `type` TEXT NOT NULL, `payload` TEXT NOT NULL, PRIMARY KEY(`userId`, `notificationId`), FOREIGN KEY(`userId`) REFERENCES `UserEntity`(`userId`) ON UPDATE NO ACTION ON DELETE CASCADE )");
        db.execSQL("CREATE INDEX IF NOT EXISTS `index_NotificationEntity_userId` ON `NotificationEntity` (`userId`)");
        db.execSQL("CREATE INDEX IF NOT EXISTS `index_NotificationEntity_notificationId` ON `NotificationEntity` (`notificationId`)");
        db.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)");
        db.execSQL("INSERT OR REPLACE INTO room_master_table (id,identity_hash) VALUES(42, '18b8d6bbd6630979635188feeba02ff6')");
      }

      @Override
      public void dropAllTables(@NonNull final SupportSQLiteDatabase db) {
        db.execSQL("DROP TABLE IF EXISTS `AccountEntity`");
        db.execSQL("DROP TABLE IF EXISTS `AccountMetadataEntity`");
        db.execSQL("DROP TABLE IF EXISTS `SessionEntity`");
        db.execSQL("DROP TABLE IF EXISTS `SessionDetailsEntity`");
        db.execSQL("DROP TABLE IF EXISTS `UserEntity`");
        db.execSQL("DROP TABLE IF EXISTS `UserKeyEntity`");
        db.execSQL("DROP TABLE IF EXISTS `AddressEntity`");
        db.execSQL("DROP TABLE IF EXISTS `AddressKeyEntity`");
        db.execSQL("DROP TABLE IF EXISTS `KeySaltEntity`");
        db.execSQL("DROP TABLE IF EXISTS `PublicAddressEntity`");
        db.execSQL("DROP TABLE IF EXISTS `PublicAddressKeyEntity`");
        db.execSQL("DROP TABLE IF EXISTS `HumanVerificationEntity`");
        db.execSQL("DROP TABLE IF EXISTS `MailSettingsEntity`");
        db.execSQL("DROP TABLE IF EXISTS `UserSettingsEntity`");
        db.execSQL("DROP TABLE IF EXISTS `OrganizationEntity`");
        db.execSQL("DROP TABLE IF EXISTS `OrganizationKeysEntity`");
        db.execSQL("DROP TABLE IF EXISTS `ContactEntity`");
        db.execSQL("DROP TABLE IF EXISTS `ContactCardEntity`");
        db.execSQL("DROP TABLE IF EXISTS `ContactEmailEntity`");
        db.execSQL("DROP TABLE IF EXISTS `ContactEmailLabelEntity`");
        db.execSQL("DROP TABLE IF EXISTS `EventMetadataEntity`");
        db.execSQL("DROP TABLE IF EXISTS `LabelEntity`");
        db.execSQL("DROP TABLE IF EXISTS `FeatureFlagEntity`");
        db.execSQL("DROP TABLE IF EXISTS `ChallengeFrameEntity`");
        db.execSQL("DROP TABLE IF EXISTS `PushEntity`");
        db.execSQL("DROP TABLE IF EXISTS `PurchaseEntity`");
        db.execSQL("DROP TABLE IF EXISTS `GooglePurchaseEntity`");
        db.execSQL("DROP TABLE IF EXISTS `ObservabilityEventEntity`");
        db.execSQL("DROP TABLE IF EXISTS `TelemetryEventEntity`");
        db.execSQL("DROP TABLE IF EXISTS `AddressChangeEntity`");
        db.execSQL("DROP TABLE IF EXISTS `SelfAuditResultEntity`");
        db.execSQL("DROP TABLE IF EXISTS `NotificationEntity`");
        final List<? extends RoomDatabase.Callback> _callbacks = mCallbacks;
        if (_callbacks != null) {
          for (RoomDatabase.Callback _callback : _callbacks) {
            _callback.onDestructiveMigration(db);
          }
        }
      }

      @Override
      public void onCreate(@NonNull final SupportSQLiteDatabase db) {
        final List<? extends RoomDatabase.Callback> _callbacks = mCallbacks;
        if (_callbacks != null) {
          for (RoomDatabase.Callback _callback : _callbacks) {
            _callback.onCreate(db);
          }
        }
      }

      @Override
      public void onOpen(@NonNull final SupportSQLiteDatabase db) {
        mDatabase = db;
        db.execSQL("PRAGMA foreign_keys = ON");
        internalInitInvalidationTracker(db);
        final List<? extends RoomDatabase.Callback> _callbacks = mCallbacks;
        if (_callbacks != null) {
          for (RoomDatabase.Callback _callback : _callbacks) {
            _callback.onOpen(db);
          }
        }
      }

      @Override
      public void onPreMigrate(@NonNull final SupportSQLiteDatabase db) {
        DBUtil.dropFtsSyncTriggers(db);
      }

      @Override
      public void onPostMigrate(@NonNull final SupportSQLiteDatabase db) {
      }

      @Override
      @NonNull
      public RoomOpenHelper.ValidationResult onValidateSchema(
          @NonNull final SupportSQLiteDatabase db) {
        final HashMap<String, TableInfo.Column> _columnsAccountEntity = new HashMap<String, TableInfo.Column>(6);
        _columnsAccountEntity.put("userId", new TableInfo.Column("userId", "TEXT", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAccountEntity.put("username", new TableInfo.Column("username", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAccountEntity.put("email", new TableInfo.Column("email", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAccountEntity.put("state", new TableInfo.Column("state", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAccountEntity.put("sessionId", new TableInfo.Column("sessionId", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAccountEntity.put("sessionState", new TableInfo.Column("sessionState", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysAccountEntity = new HashSet<TableInfo.ForeignKey>(1);
        _foreignKeysAccountEntity.add(new TableInfo.ForeignKey("SessionEntity", "NO ACTION", "NO ACTION", Arrays.asList("sessionId"), Arrays.asList("sessionId")));
        final HashSet<TableInfo.Index> _indicesAccountEntity = new HashSet<TableInfo.Index>(2);
        _indicesAccountEntity.add(new TableInfo.Index("index_AccountEntity_sessionId", false, Arrays.asList("sessionId"), Arrays.asList("ASC")));
        _indicesAccountEntity.add(new TableInfo.Index("index_AccountEntity_userId", false, Arrays.asList("userId"), Arrays.asList("ASC")));
        final TableInfo _infoAccountEntity = new TableInfo("AccountEntity", _columnsAccountEntity, _foreignKeysAccountEntity, _indicesAccountEntity);
        final TableInfo _existingAccountEntity = TableInfo.read(db, "AccountEntity");
        if (!_infoAccountEntity.equals(_existingAccountEntity)) {
          return new RoomOpenHelper.ValidationResult(false, "AccountEntity(me.proton.core.account.data.entity.AccountEntity).\n"
                  + " Expected:\n" + _infoAccountEntity + "\n"
                  + " Found:\n" + _existingAccountEntity);
        }
        final HashMap<String, TableInfo.Column> _columnsAccountMetadataEntity = new HashMap<String, TableInfo.Column>(4);
        _columnsAccountMetadataEntity.put("userId", new TableInfo.Column("userId", "TEXT", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAccountMetadataEntity.put("product", new TableInfo.Column("product", "TEXT", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAccountMetadataEntity.put("primaryAtUtc", new TableInfo.Column("primaryAtUtc", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAccountMetadataEntity.put("migrations", new TableInfo.Column("migrations", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysAccountMetadataEntity = new HashSet<TableInfo.ForeignKey>(1);
        _foreignKeysAccountMetadataEntity.add(new TableInfo.ForeignKey("AccountEntity", "CASCADE", "NO ACTION", Arrays.asList("userId"), Arrays.asList("userId")));
        final HashSet<TableInfo.Index> _indicesAccountMetadataEntity = new HashSet<TableInfo.Index>(3);
        _indicesAccountMetadataEntity.add(new TableInfo.Index("index_AccountMetadataEntity_userId", false, Arrays.asList("userId"), Arrays.asList("ASC")));
        _indicesAccountMetadataEntity.add(new TableInfo.Index("index_AccountMetadataEntity_product", false, Arrays.asList("product"), Arrays.asList("ASC")));
        _indicesAccountMetadataEntity.add(new TableInfo.Index("index_AccountMetadataEntity_primaryAtUtc", false, Arrays.asList("primaryAtUtc"), Arrays.asList("ASC")));
        final TableInfo _infoAccountMetadataEntity = new TableInfo("AccountMetadataEntity", _columnsAccountMetadataEntity, _foreignKeysAccountMetadataEntity, _indicesAccountMetadataEntity);
        final TableInfo _existingAccountMetadataEntity = TableInfo.read(db, "AccountMetadataEntity");
        if (!_infoAccountMetadataEntity.equals(_existingAccountMetadataEntity)) {
          return new RoomOpenHelper.ValidationResult(false, "AccountMetadataEntity(me.proton.core.account.data.entity.AccountMetadataEntity).\n"
                  + " Expected:\n" + _infoAccountMetadataEntity + "\n"
                  + " Found:\n" + _existingAccountMetadataEntity);
        }
        final HashMap<String, TableInfo.Column> _columnsSessionEntity = new HashMap<String, TableInfo.Column>(6);
        _columnsSessionEntity.put("userId", new TableInfo.Column("userId", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSessionEntity.put("sessionId", new TableInfo.Column("sessionId", "TEXT", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSessionEntity.put("accessToken", new TableInfo.Column("accessToken", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSessionEntity.put("refreshToken", new TableInfo.Column("refreshToken", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSessionEntity.put("scopes", new TableInfo.Column("scopes", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSessionEntity.put("product", new TableInfo.Column("product", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysSessionEntity = new HashSet<TableInfo.ForeignKey>(1);
        _foreignKeysSessionEntity.add(new TableInfo.ForeignKey("AccountEntity", "CASCADE", "NO ACTION", Arrays.asList("userId"), Arrays.asList("userId")));
        final HashSet<TableInfo.Index> _indicesSessionEntity = new HashSet<TableInfo.Index>(2);
        _indicesSessionEntity.add(new TableInfo.Index("index_SessionEntity_sessionId", false, Arrays.asList("sessionId"), Arrays.asList("ASC")));
        _indicesSessionEntity.add(new TableInfo.Index("index_SessionEntity_userId", false, Arrays.asList("userId"), Arrays.asList("ASC")));
        final TableInfo _infoSessionEntity = new TableInfo("SessionEntity", _columnsSessionEntity, _foreignKeysSessionEntity, _indicesSessionEntity);
        final TableInfo _existingSessionEntity = TableInfo.read(db, "SessionEntity");
        if (!_infoSessionEntity.equals(_existingSessionEntity)) {
          return new RoomOpenHelper.ValidationResult(false, "SessionEntity(me.proton.core.account.data.entity.SessionEntity).\n"
                  + " Expected:\n" + _infoSessionEntity + "\n"
                  + " Found:\n" + _existingSessionEntity);
        }
        final HashMap<String, TableInfo.Column> _columnsSessionDetailsEntity = new HashMap<String, TableInfo.Column>(6);
        _columnsSessionDetailsEntity.put("sessionId", new TableInfo.Column("sessionId", "TEXT", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSessionDetailsEntity.put("initialEventId", new TableInfo.Column("initialEventId", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSessionDetailsEntity.put("requiredAccountType", new TableInfo.Column("requiredAccountType", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSessionDetailsEntity.put("secondFactorEnabled", new TableInfo.Column("secondFactorEnabled", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSessionDetailsEntity.put("twoPassModeEnabled", new TableInfo.Column("twoPassModeEnabled", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSessionDetailsEntity.put("password", new TableInfo.Column("password", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysSessionDetailsEntity = new HashSet<TableInfo.ForeignKey>(1);
        _foreignKeysSessionDetailsEntity.add(new TableInfo.ForeignKey("SessionEntity", "CASCADE", "NO ACTION", Arrays.asList("sessionId"), Arrays.asList("sessionId")));
        final HashSet<TableInfo.Index> _indicesSessionDetailsEntity = new HashSet<TableInfo.Index>(1);
        _indicesSessionDetailsEntity.add(new TableInfo.Index("index_SessionDetailsEntity_sessionId", false, Arrays.asList("sessionId"), Arrays.asList("ASC")));
        final TableInfo _infoSessionDetailsEntity = new TableInfo("SessionDetailsEntity", _columnsSessionDetailsEntity, _foreignKeysSessionDetailsEntity, _indicesSessionDetailsEntity);
        final TableInfo _existingSessionDetailsEntity = TableInfo.read(db, "SessionDetailsEntity");
        if (!_infoSessionDetailsEntity.equals(_existingSessionDetailsEntity)) {
          return new RoomOpenHelper.ValidationResult(false, "SessionDetailsEntity(me.proton.core.account.data.entity.SessionDetailsEntity).\n"
                  + " Expected:\n" + _infoSessionDetailsEntity + "\n"
                  + " Found:\n" + _existingSessionDetailsEntity);
        }
        final HashMap<String, TableInfo.Column> _columnsUserEntity = new HashMap<String, TableInfo.Column>(26);
        _columnsUserEntity.put("userId", new TableInfo.Column("userId", "TEXT", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserEntity.put("email", new TableInfo.Column("email", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserEntity.put("name", new TableInfo.Column("name", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserEntity.put("displayName", new TableInfo.Column("displayName", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserEntity.put("currency", new TableInfo.Column("currency", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserEntity.put("credit", new TableInfo.Column("credit", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserEntity.put("createdAtUtc", new TableInfo.Column("createdAtUtc", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserEntity.put("usedSpace", new TableInfo.Column("usedSpace", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserEntity.put("maxSpace", new TableInfo.Column("maxSpace", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserEntity.put("maxUpload", new TableInfo.Column("maxUpload", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserEntity.put("type", new TableInfo.Column("type", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserEntity.put("role", new TableInfo.Column("role", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserEntity.put("private", new TableInfo.Column("private", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserEntity.put("subscribed", new TableInfo.Column("subscribed", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserEntity.put("services", new TableInfo.Column("services", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserEntity.put("delinquent", new TableInfo.Column("delinquent", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserEntity.put("passphrase", new TableInfo.Column("passphrase", "BLOB", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserEntity.put("maxBaseSpace", new TableInfo.Column("maxBaseSpace", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserEntity.put("maxDriveSpace", new TableInfo.Column("maxDriveSpace", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserEntity.put("usedBaseSpace", new TableInfo.Column("usedBaseSpace", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserEntity.put("usedDriveSpace", new TableInfo.Column("usedDriveSpace", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserEntity.put("recovery_state", new TableInfo.Column("recovery_state", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserEntity.put("recovery_startTime", new TableInfo.Column("recovery_startTime", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserEntity.put("recovery_endTime", new TableInfo.Column("recovery_endTime", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserEntity.put("recovery_sessionId", new TableInfo.Column("recovery_sessionId", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserEntity.put("recovery_reason", new TableInfo.Column("recovery_reason", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysUserEntity = new HashSet<TableInfo.ForeignKey>(1);
        _foreignKeysUserEntity.add(new TableInfo.ForeignKey("AccountEntity", "CASCADE", "NO ACTION", Arrays.asList("userId"), Arrays.asList("userId")));
        final HashSet<TableInfo.Index> _indicesUserEntity = new HashSet<TableInfo.Index>(1);
        _indicesUserEntity.add(new TableInfo.Index("index_UserEntity_userId", false, Arrays.asList("userId"), Arrays.asList("ASC")));
        final TableInfo _infoUserEntity = new TableInfo("UserEntity", _columnsUserEntity, _foreignKeysUserEntity, _indicesUserEntity);
        final TableInfo _existingUserEntity = TableInfo.read(db, "UserEntity");
        if (!_infoUserEntity.equals(_existingUserEntity)) {
          return new RoomOpenHelper.ValidationResult(false, "UserEntity(me.proton.core.user.data.entity.UserEntity).\n"
                  + " Expected:\n" + _infoUserEntity + "\n"
                  + " Found:\n" + _existingUserEntity);
        }
        final HashMap<String, TableInfo.Column> _columnsUserKeyEntity = new HashMap<String, TableInfo.Column>(11);
        _columnsUserKeyEntity.put("userId", new TableInfo.Column("userId", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserKeyEntity.put("keyId", new TableInfo.Column("keyId", "TEXT", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserKeyEntity.put("version", new TableInfo.Column("version", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserKeyEntity.put("privateKey", new TableInfo.Column("privateKey", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserKeyEntity.put("isPrimary", new TableInfo.Column("isPrimary", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserKeyEntity.put("isUnlockable", new TableInfo.Column("isUnlockable", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserKeyEntity.put("fingerprint", new TableInfo.Column("fingerprint", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserKeyEntity.put("activation", new TableInfo.Column("activation", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserKeyEntity.put("active", new TableInfo.Column("active", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserKeyEntity.put("recoverySecret", new TableInfo.Column("recoverySecret", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserKeyEntity.put("recoverySecretSignature", new TableInfo.Column("recoverySecretSignature", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysUserKeyEntity = new HashSet<TableInfo.ForeignKey>(1);
        _foreignKeysUserKeyEntity.add(new TableInfo.ForeignKey("UserEntity", "CASCADE", "NO ACTION", Arrays.asList("userId"), Arrays.asList("userId")));
        final HashSet<TableInfo.Index> _indicesUserKeyEntity = new HashSet<TableInfo.Index>(2);
        _indicesUserKeyEntity.add(new TableInfo.Index("index_UserKeyEntity_userId", false, Arrays.asList("userId"), Arrays.asList("ASC")));
        _indicesUserKeyEntity.add(new TableInfo.Index("index_UserKeyEntity_keyId", false, Arrays.asList("keyId"), Arrays.asList("ASC")));
        final TableInfo _infoUserKeyEntity = new TableInfo("UserKeyEntity", _columnsUserKeyEntity, _foreignKeysUserKeyEntity, _indicesUserKeyEntity);
        final TableInfo _existingUserKeyEntity = TableInfo.read(db, "UserKeyEntity");
        if (!_infoUserKeyEntity.equals(_existingUserKeyEntity)) {
          return new RoomOpenHelper.ValidationResult(false, "UserKeyEntity(me.proton.core.user.data.entity.UserKeyEntity).\n"
                  + " Expected:\n" + _infoUserKeyEntity + "\n"
                  + " Found:\n" + _existingUserKeyEntity);
        }
        final HashMap<String, TableInfo.Column> _columnsAddressEntity = new HashMap<String, TableInfo.Column>(16);
        _columnsAddressEntity.put("userId", new TableInfo.Column("userId", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAddressEntity.put("addressId", new TableInfo.Column("addressId", "TEXT", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAddressEntity.put("email", new TableInfo.Column("email", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAddressEntity.put("displayName", new TableInfo.Column("displayName", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAddressEntity.put("signature", new TableInfo.Column("signature", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAddressEntity.put("domainId", new TableInfo.Column("domainId", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAddressEntity.put("canSend", new TableInfo.Column("canSend", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAddressEntity.put("canReceive", new TableInfo.Column("canReceive", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAddressEntity.put("enabled", new TableInfo.Column("enabled", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAddressEntity.put("type", new TableInfo.Column("type", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAddressEntity.put("order", new TableInfo.Column("order", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAddressEntity.put("signedKeyList_data", new TableInfo.Column("signedKeyList_data", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAddressEntity.put("signedKeyList_signature", new TableInfo.Column("signedKeyList_signature", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAddressEntity.put("signedKeyList_minEpochId", new TableInfo.Column("signedKeyList_minEpochId", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAddressEntity.put("signedKeyList_maxEpochId", new TableInfo.Column("signedKeyList_maxEpochId", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAddressEntity.put("signedKeyList_expectedMinEpochId", new TableInfo.Column("signedKeyList_expectedMinEpochId", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysAddressEntity = new HashSet<TableInfo.ForeignKey>(1);
        _foreignKeysAddressEntity.add(new TableInfo.ForeignKey("UserEntity", "CASCADE", "NO ACTION", Arrays.asList("userId"), Arrays.asList("userId")));
        final HashSet<TableInfo.Index> _indicesAddressEntity = new HashSet<TableInfo.Index>(2);
        _indicesAddressEntity.add(new TableInfo.Index("index_AddressEntity_addressId", false, Arrays.asList("addressId"), Arrays.asList("ASC")));
        _indicesAddressEntity.add(new TableInfo.Index("index_AddressEntity_userId", false, Arrays.asList("userId"), Arrays.asList("ASC")));
        final TableInfo _infoAddressEntity = new TableInfo("AddressEntity", _columnsAddressEntity, _foreignKeysAddressEntity, _indicesAddressEntity);
        final TableInfo _existingAddressEntity = TableInfo.read(db, "AddressEntity");
        if (!_infoAddressEntity.equals(_existingAddressEntity)) {
          return new RoomOpenHelper.ValidationResult(false, "AddressEntity(me.proton.core.user.data.entity.AddressEntity).\n"
                  + " Expected:\n" + _infoAddressEntity + "\n"
                  + " Found:\n" + _existingAddressEntity);
        }
        final HashMap<String, TableInfo.Column> _columnsAddressKeyEntity = new HashMap<String, TableInfo.Column>(14);
        _columnsAddressKeyEntity.put("addressId", new TableInfo.Column("addressId", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAddressKeyEntity.put("keyId", new TableInfo.Column("keyId", "TEXT", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAddressKeyEntity.put("version", new TableInfo.Column("version", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAddressKeyEntity.put("privateKey", new TableInfo.Column("privateKey", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAddressKeyEntity.put("isPrimary", new TableInfo.Column("isPrimary", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAddressKeyEntity.put("isUnlockable", new TableInfo.Column("isUnlockable", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAddressKeyEntity.put("flags", new TableInfo.Column("flags", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAddressKeyEntity.put("passphrase", new TableInfo.Column("passphrase", "BLOB", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAddressKeyEntity.put("token", new TableInfo.Column("token", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAddressKeyEntity.put("signature", new TableInfo.Column("signature", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAddressKeyEntity.put("fingerprint", new TableInfo.Column("fingerprint", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAddressKeyEntity.put("fingerprints", new TableInfo.Column("fingerprints", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAddressKeyEntity.put("activation", new TableInfo.Column("activation", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAddressKeyEntity.put("active", new TableInfo.Column("active", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysAddressKeyEntity = new HashSet<TableInfo.ForeignKey>(1);
        _foreignKeysAddressKeyEntity.add(new TableInfo.ForeignKey("AddressEntity", "CASCADE", "NO ACTION", Arrays.asList("addressId"), Arrays.asList("addressId")));
        final HashSet<TableInfo.Index> _indicesAddressKeyEntity = new HashSet<TableInfo.Index>(2);
        _indicesAddressKeyEntity.add(new TableInfo.Index("index_AddressKeyEntity_addressId", false, Arrays.asList("addressId"), Arrays.asList("ASC")));
        _indicesAddressKeyEntity.add(new TableInfo.Index("index_AddressKeyEntity_keyId", false, Arrays.asList("keyId"), Arrays.asList("ASC")));
        final TableInfo _infoAddressKeyEntity = new TableInfo("AddressKeyEntity", _columnsAddressKeyEntity, _foreignKeysAddressKeyEntity, _indicesAddressKeyEntity);
        final TableInfo _existingAddressKeyEntity = TableInfo.read(db, "AddressKeyEntity");
        if (!_infoAddressKeyEntity.equals(_existingAddressKeyEntity)) {
          return new RoomOpenHelper.ValidationResult(false, "AddressKeyEntity(me.proton.core.user.data.entity.AddressKeyEntity).\n"
                  + " Expected:\n" + _infoAddressKeyEntity + "\n"
                  + " Found:\n" + _existingAddressKeyEntity);
        }
        final HashMap<String, TableInfo.Column> _columnsKeySaltEntity = new HashMap<String, TableInfo.Column>(3);
        _columnsKeySaltEntity.put("userId", new TableInfo.Column("userId", "TEXT", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsKeySaltEntity.put("keyId", new TableInfo.Column("keyId", "TEXT", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsKeySaltEntity.put("keySalt", new TableInfo.Column("keySalt", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysKeySaltEntity = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesKeySaltEntity = new HashSet<TableInfo.Index>(2);
        _indicesKeySaltEntity.add(new TableInfo.Index("index_KeySaltEntity_userId", false, Arrays.asList("userId"), Arrays.asList("ASC")));
        _indicesKeySaltEntity.add(new TableInfo.Index("index_KeySaltEntity_keyId", false, Arrays.asList("keyId"), Arrays.asList("ASC")));
        final TableInfo _infoKeySaltEntity = new TableInfo("KeySaltEntity", _columnsKeySaltEntity, _foreignKeysKeySaltEntity, _indicesKeySaltEntity);
        final TableInfo _existingKeySaltEntity = TableInfo.read(db, "KeySaltEntity");
        if (!_infoKeySaltEntity.equals(_existingKeySaltEntity)) {
          return new RoomOpenHelper.ValidationResult(false, "KeySaltEntity(me.proton.core.key.data.entity.KeySaltEntity).\n"
                  + " Expected:\n" + _infoKeySaltEntity + "\n"
                  + " Found:\n" + _existingKeySaltEntity);
        }
        final HashMap<String, TableInfo.Column> _columnsPublicAddressEntity = new HashMap<String, TableInfo.Column>(9);
        _columnsPublicAddressEntity.put("email", new TableInfo.Column("email", "TEXT", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPublicAddressEntity.put("recipientType", new TableInfo.Column("recipientType", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPublicAddressEntity.put("mimeType", new TableInfo.Column("mimeType", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPublicAddressEntity.put("ignoreKT", new TableInfo.Column("ignoreKT", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPublicAddressEntity.put("signedKeyList_data", new TableInfo.Column("signedKeyList_data", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPublicAddressEntity.put("signedKeyList_signature", new TableInfo.Column("signedKeyList_signature", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPublicAddressEntity.put("signedKeyList_minEpochId", new TableInfo.Column("signedKeyList_minEpochId", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPublicAddressEntity.put("signedKeyList_maxEpochId", new TableInfo.Column("signedKeyList_maxEpochId", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPublicAddressEntity.put("signedKeyList_expectedMinEpochId", new TableInfo.Column("signedKeyList_expectedMinEpochId", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysPublicAddressEntity = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesPublicAddressEntity = new HashSet<TableInfo.Index>(1);
        _indicesPublicAddressEntity.add(new TableInfo.Index("index_PublicAddressEntity_email", false, Arrays.asList("email"), Arrays.asList("ASC")));
        final TableInfo _infoPublicAddressEntity = new TableInfo("PublicAddressEntity", _columnsPublicAddressEntity, _foreignKeysPublicAddressEntity, _indicesPublicAddressEntity);
        final TableInfo _existingPublicAddressEntity = TableInfo.read(db, "PublicAddressEntity");
        if (!_infoPublicAddressEntity.equals(_existingPublicAddressEntity)) {
          return new RoomOpenHelper.ValidationResult(false, "PublicAddressEntity(me.proton.core.key.data.entity.PublicAddressEntity).\n"
                  + " Expected:\n" + _infoPublicAddressEntity + "\n"
                  + " Found:\n" + _existingPublicAddressEntity);
        }
        final HashMap<String, TableInfo.Column> _columnsPublicAddressKeyEntity = new HashMap<String, TableInfo.Column>(4);
        _columnsPublicAddressKeyEntity.put("email", new TableInfo.Column("email", "TEXT", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPublicAddressKeyEntity.put("flags", new TableInfo.Column("flags", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPublicAddressKeyEntity.put("publicKey", new TableInfo.Column("publicKey", "TEXT", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPublicAddressKeyEntity.put("isPrimary", new TableInfo.Column("isPrimary", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysPublicAddressKeyEntity = new HashSet<TableInfo.ForeignKey>(1);
        _foreignKeysPublicAddressKeyEntity.add(new TableInfo.ForeignKey("PublicAddressEntity", "CASCADE", "NO ACTION", Arrays.asList("email"), Arrays.asList("email")));
        final HashSet<TableInfo.Index> _indicesPublicAddressKeyEntity = new HashSet<TableInfo.Index>(1);
        _indicesPublicAddressKeyEntity.add(new TableInfo.Index("index_PublicAddressKeyEntity_email", false, Arrays.asList("email"), Arrays.asList("ASC")));
        final TableInfo _infoPublicAddressKeyEntity = new TableInfo("PublicAddressKeyEntity", _columnsPublicAddressKeyEntity, _foreignKeysPublicAddressKeyEntity, _indicesPublicAddressKeyEntity);
        final TableInfo _existingPublicAddressKeyEntity = TableInfo.read(db, "PublicAddressKeyEntity");
        if (!_infoPublicAddressKeyEntity.equals(_existingPublicAddressKeyEntity)) {
          return new RoomOpenHelper.ValidationResult(false, "PublicAddressKeyEntity(me.proton.core.key.data.entity.PublicAddressKeyEntity).\n"
                  + " Expected:\n" + _infoPublicAddressKeyEntity + "\n"
                  + " Found:\n" + _existingPublicAddressKeyEntity);
        }
        final HashMap<String, TableInfo.Column> _columnsHumanVerificationEntity = new HashMap<String, TableInfo.Column>(7);
        _columnsHumanVerificationEntity.put("clientId", new TableInfo.Column("clientId", "TEXT", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsHumanVerificationEntity.put("clientIdType", new TableInfo.Column("clientIdType", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsHumanVerificationEntity.put("verificationMethods", new TableInfo.Column("verificationMethods", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsHumanVerificationEntity.put("verificationToken", new TableInfo.Column("verificationToken", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsHumanVerificationEntity.put("state", new TableInfo.Column("state", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsHumanVerificationEntity.put("humanHeaderTokenType", new TableInfo.Column("humanHeaderTokenType", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsHumanVerificationEntity.put("humanHeaderTokenCode", new TableInfo.Column("humanHeaderTokenCode", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysHumanVerificationEntity = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesHumanVerificationEntity = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoHumanVerificationEntity = new TableInfo("HumanVerificationEntity", _columnsHumanVerificationEntity, _foreignKeysHumanVerificationEntity, _indicesHumanVerificationEntity);
        final TableInfo _existingHumanVerificationEntity = TableInfo.read(db, "HumanVerificationEntity");
        if (!_infoHumanVerificationEntity.equals(_existingHumanVerificationEntity)) {
          return new RoomOpenHelper.ValidationResult(false, "HumanVerificationEntity(me.proton.core.humanverification.data.entity.HumanVerificationEntity).\n"
                  + " Expected:\n" + _infoHumanVerificationEntity + "\n"
                  + " Found:\n" + _existingHumanVerificationEntity);
        }
        final HashMap<String, TableInfo.Column> _columnsMailSettingsEntity = new HashMap<String, TableInfo.Column>(27);
        _columnsMailSettingsEntity.put("userId", new TableInfo.Column("userId", "TEXT", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMailSettingsEntity.put("displayName", new TableInfo.Column("displayName", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMailSettingsEntity.put("signature", new TableInfo.Column("signature", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMailSettingsEntity.put("autoSaveContacts", new TableInfo.Column("autoSaveContacts", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMailSettingsEntity.put("composerMode", new TableInfo.Column("composerMode", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMailSettingsEntity.put("messageButtons", new TableInfo.Column("messageButtons", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMailSettingsEntity.put("showImages", new TableInfo.Column("showImages", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMailSettingsEntity.put("showMoved", new TableInfo.Column("showMoved", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMailSettingsEntity.put("viewMode", new TableInfo.Column("viewMode", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMailSettingsEntity.put("viewLayout", new TableInfo.Column("viewLayout", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMailSettingsEntity.put("swipeLeft", new TableInfo.Column("swipeLeft", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMailSettingsEntity.put("swipeRight", new TableInfo.Column("swipeRight", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMailSettingsEntity.put("shortcuts", new TableInfo.Column("shortcuts", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMailSettingsEntity.put("pmSignature", new TableInfo.Column("pmSignature", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMailSettingsEntity.put("numMessagePerPage", new TableInfo.Column("numMessagePerPage", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMailSettingsEntity.put("draftMimeType", new TableInfo.Column("draftMimeType", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMailSettingsEntity.put("receiveMimeType", new TableInfo.Column("receiveMimeType", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMailSettingsEntity.put("showMimeType", new TableInfo.Column("showMimeType", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMailSettingsEntity.put("enableFolderColor", new TableInfo.Column("enableFolderColor", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMailSettingsEntity.put("inheritParentFolderColor", new TableInfo.Column("inheritParentFolderColor", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMailSettingsEntity.put("rightToLeft", new TableInfo.Column("rightToLeft", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMailSettingsEntity.put("attachPublicKey", new TableInfo.Column("attachPublicKey", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMailSettingsEntity.put("sign", new TableInfo.Column("sign", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMailSettingsEntity.put("pgpScheme", new TableInfo.Column("pgpScheme", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMailSettingsEntity.put("promptPin", new TableInfo.Column("promptPin", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMailSettingsEntity.put("stickyLabels", new TableInfo.Column("stickyLabels", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMailSettingsEntity.put("confirmLink", new TableInfo.Column("confirmLink", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysMailSettingsEntity = new HashSet<TableInfo.ForeignKey>(1);
        _foreignKeysMailSettingsEntity.add(new TableInfo.ForeignKey("UserEntity", "CASCADE", "NO ACTION", Arrays.asList("userId"), Arrays.asList("userId")));
        final HashSet<TableInfo.Index> _indicesMailSettingsEntity = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoMailSettingsEntity = new TableInfo("MailSettingsEntity", _columnsMailSettingsEntity, _foreignKeysMailSettingsEntity, _indicesMailSettingsEntity);
        final TableInfo _existingMailSettingsEntity = TableInfo.read(db, "MailSettingsEntity");
        if (!_infoMailSettingsEntity.equals(_existingMailSettingsEntity)) {
          return new RoomOpenHelper.ValidationResult(false, "MailSettingsEntity(me.proton.core.mailsettings.data.entity.MailSettingsEntity).\n"
                  + " Expected:\n" + _infoMailSettingsEntity + "\n"
                  + " Found:\n" + _existingMailSettingsEntity);
        }
        final HashMap<String, TableInfo.Column> _columnsUserSettingsEntity = new HashMap<String, TableInfo.Column>(25);
        _columnsUserSettingsEntity.put("userId", new TableInfo.Column("userId", "TEXT", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserSettingsEntity.put("news", new TableInfo.Column("news", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserSettingsEntity.put("locale", new TableInfo.Column("locale", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserSettingsEntity.put("logAuth", new TableInfo.Column("logAuth", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserSettingsEntity.put("density", new TableInfo.Column("density", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserSettingsEntity.put("weekStart", new TableInfo.Column("weekStart", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserSettingsEntity.put("dateFormat", new TableInfo.Column("dateFormat", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserSettingsEntity.put("timeFormat", new TableInfo.Column("timeFormat", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserSettingsEntity.put("earlyAccess", new TableInfo.Column("earlyAccess", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserSettingsEntity.put("deviceRecovery", new TableInfo.Column("deviceRecovery", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserSettingsEntity.put("telemetry", new TableInfo.Column("telemetry", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserSettingsEntity.put("crashReports", new TableInfo.Column("crashReports", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserSettingsEntity.put("email_value", new TableInfo.Column("email_value", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserSettingsEntity.put("email_status", new TableInfo.Column("email_status", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserSettingsEntity.put("email_notify", new TableInfo.Column("email_notify", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserSettingsEntity.put("email_reset", new TableInfo.Column("email_reset", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserSettingsEntity.put("phone_value", new TableInfo.Column("phone_value", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserSettingsEntity.put("phone_status", new TableInfo.Column("phone_status", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserSettingsEntity.put("phone_notify", new TableInfo.Column("phone_notify", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserSettingsEntity.put("phone_reset", new TableInfo.Column("phone_reset", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserSettingsEntity.put("password_mode", new TableInfo.Column("password_mode", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserSettingsEntity.put("password_expirationTime", new TableInfo.Column("password_expirationTime", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserSettingsEntity.put("twoFA_enabled", new TableInfo.Column("twoFA_enabled", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserSettingsEntity.put("twoFA_allowed", new TableInfo.Column("twoFA_allowed", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserSettingsEntity.put("twoFA_expirationTime", new TableInfo.Column("twoFA_expirationTime", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysUserSettingsEntity = new HashSet<TableInfo.ForeignKey>(1);
        _foreignKeysUserSettingsEntity.add(new TableInfo.ForeignKey("UserEntity", "CASCADE", "NO ACTION", Arrays.asList("userId"), Arrays.asList("userId")));
        final HashSet<TableInfo.Index> _indicesUserSettingsEntity = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoUserSettingsEntity = new TableInfo("UserSettingsEntity", _columnsUserSettingsEntity, _foreignKeysUserSettingsEntity, _indicesUserSettingsEntity);
        final TableInfo _existingUserSettingsEntity = TableInfo.read(db, "UserSettingsEntity");
        if (!_infoUserSettingsEntity.equals(_existingUserSettingsEntity)) {
          return new RoomOpenHelper.ValidationResult(false, "UserSettingsEntity(me.proton.core.usersettings.data.entity.UserSettingsEntity).\n"
                  + " Expected:\n" + _infoUserSettingsEntity + "\n"
                  + " Found:\n" + _existingUserSettingsEntity);
        }
        final HashMap<String, TableInfo.Column> _columnsOrganizationEntity = new HashMap<String, TableInfo.Column>(24);
        _columnsOrganizationEntity.put("userId", new TableInfo.Column("userId", "TEXT", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsOrganizationEntity.put("name", new TableInfo.Column("name", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsOrganizationEntity.put("displayName", new TableInfo.Column("displayName", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsOrganizationEntity.put("planName", new TableInfo.Column("planName", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsOrganizationEntity.put("twoFactorGracePeriod", new TableInfo.Column("twoFactorGracePeriod", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsOrganizationEntity.put("theme", new TableInfo.Column("theme", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsOrganizationEntity.put("email", new TableInfo.Column("email", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsOrganizationEntity.put("maxDomains", new TableInfo.Column("maxDomains", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsOrganizationEntity.put("maxAddresses", new TableInfo.Column("maxAddresses", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsOrganizationEntity.put("maxSpace", new TableInfo.Column("maxSpace", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsOrganizationEntity.put("maxMembers", new TableInfo.Column("maxMembers", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsOrganizationEntity.put("maxVPN", new TableInfo.Column("maxVPN", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsOrganizationEntity.put("maxCalendars", new TableInfo.Column("maxCalendars", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsOrganizationEntity.put("features", new TableInfo.Column("features", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsOrganizationEntity.put("flags", new TableInfo.Column("flags", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsOrganizationEntity.put("usedDomains", new TableInfo.Column("usedDomains", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsOrganizationEntity.put("usedAddresses", new TableInfo.Column("usedAddresses", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsOrganizationEntity.put("usedSpace", new TableInfo.Column("usedSpace", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsOrganizationEntity.put("assignedSpace", new TableInfo.Column("assignedSpace", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsOrganizationEntity.put("usedMembers", new TableInfo.Column("usedMembers", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsOrganizationEntity.put("usedVPN", new TableInfo.Column("usedVPN", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsOrganizationEntity.put("usedCalendars", new TableInfo.Column("usedCalendars", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsOrganizationEntity.put("hasKeys", new TableInfo.Column("hasKeys", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsOrganizationEntity.put("toMigrate", new TableInfo.Column("toMigrate", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysOrganizationEntity = new HashSet<TableInfo.ForeignKey>(1);
        _foreignKeysOrganizationEntity.add(new TableInfo.ForeignKey("UserEntity", "CASCADE", "NO ACTION", Arrays.asList("userId"), Arrays.asList("userId")));
        final HashSet<TableInfo.Index> _indicesOrganizationEntity = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoOrganizationEntity = new TableInfo("OrganizationEntity", _columnsOrganizationEntity, _foreignKeysOrganizationEntity, _indicesOrganizationEntity);
        final TableInfo _existingOrganizationEntity = TableInfo.read(db, "OrganizationEntity");
        if (!_infoOrganizationEntity.equals(_existingOrganizationEntity)) {
          return new RoomOpenHelper.ValidationResult(false, "OrganizationEntity(me.proton.core.usersettings.data.entity.OrganizationEntity).\n"
                  + " Expected:\n" + _infoOrganizationEntity + "\n"
                  + " Found:\n" + _existingOrganizationEntity);
        }
        final HashMap<String, TableInfo.Column> _columnsOrganizationKeysEntity = new HashMap<String, TableInfo.Column>(3);
        _columnsOrganizationKeysEntity.put("userId", new TableInfo.Column("userId", "TEXT", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsOrganizationKeysEntity.put("publicKey", new TableInfo.Column("publicKey", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsOrganizationKeysEntity.put("privateKey", new TableInfo.Column("privateKey", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysOrganizationKeysEntity = new HashSet<TableInfo.ForeignKey>(1);
        _foreignKeysOrganizationKeysEntity.add(new TableInfo.ForeignKey("UserEntity", "CASCADE", "NO ACTION", Arrays.asList("userId"), Arrays.asList("userId")));
        final HashSet<TableInfo.Index> _indicesOrganizationKeysEntity = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoOrganizationKeysEntity = new TableInfo("OrganizationKeysEntity", _columnsOrganizationKeysEntity, _foreignKeysOrganizationKeysEntity, _indicesOrganizationKeysEntity);
        final TableInfo _existingOrganizationKeysEntity = TableInfo.read(db, "OrganizationKeysEntity");
        if (!_infoOrganizationKeysEntity.equals(_existingOrganizationKeysEntity)) {
          return new RoomOpenHelper.ValidationResult(false, "OrganizationKeysEntity(me.proton.core.usersettings.data.entity.OrganizationKeysEntity).\n"
                  + " Expected:\n" + _infoOrganizationKeysEntity + "\n"
                  + " Found:\n" + _existingOrganizationKeysEntity);
        }
        final HashMap<String, TableInfo.Column> _columnsContactEntity = new HashMap<String, TableInfo.Column>(3);
        _columnsContactEntity.put("userId", new TableInfo.Column("userId", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContactEntity.put("contactId", new TableInfo.Column("contactId", "TEXT", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContactEntity.put("name", new TableInfo.Column("name", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysContactEntity = new HashSet<TableInfo.ForeignKey>(1);
        _foreignKeysContactEntity.add(new TableInfo.ForeignKey("UserEntity", "CASCADE", "NO ACTION", Arrays.asList("userId"), Arrays.asList("userId")));
        final HashSet<TableInfo.Index> _indicesContactEntity = new HashSet<TableInfo.Index>(1);
        _indicesContactEntity.add(new TableInfo.Index("index_ContactEntity_userId", false, Arrays.asList("userId"), Arrays.asList("ASC")));
        final TableInfo _infoContactEntity = new TableInfo("ContactEntity", _columnsContactEntity, _foreignKeysContactEntity, _indicesContactEntity);
        final TableInfo _existingContactEntity = TableInfo.read(db, "ContactEntity");
        if (!_infoContactEntity.equals(_existingContactEntity)) {
          return new RoomOpenHelper.ValidationResult(false, "ContactEntity(me.proton.core.contact.data.local.db.entity.ContactEntity).\n"
                  + " Expected:\n" + _infoContactEntity + "\n"
                  + " Found:\n" + _existingContactEntity);
        }
        final HashMap<String, TableInfo.Column> _columnsContactCardEntity = new HashMap<String, TableInfo.Column>(5);
        _columnsContactCardEntity.put("contactId", new TableInfo.Column("contactId", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContactCardEntity.put("type", new TableInfo.Column("type", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContactCardEntity.put("data", new TableInfo.Column("data", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContactCardEntity.put("signature", new TableInfo.Column("signature", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContactCardEntity.put("cardId", new TableInfo.Column("cardId", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysContactCardEntity = new HashSet<TableInfo.ForeignKey>(1);
        _foreignKeysContactCardEntity.add(new TableInfo.ForeignKey("ContactEntity", "CASCADE", "NO ACTION", Arrays.asList("contactId"), Arrays.asList("contactId")));
        final HashSet<TableInfo.Index> _indicesContactCardEntity = new HashSet<TableInfo.Index>(1);
        _indicesContactCardEntity.add(new TableInfo.Index("index_ContactCardEntity_contactId", false, Arrays.asList("contactId"), Arrays.asList("ASC")));
        final TableInfo _infoContactCardEntity = new TableInfo("ContactCardEntity", _columnsContactCardEntity, _foreignKeysContactCardEntity, _indicesContactCardEntity);
        final TableInfo _existingContactCardEntity = TableInfo.read(db, "ContactCardEntity");
        if (!_infoContactCardEntity.equals(_existingContactCardEntity)) {
          return new RoomOpenHelper.ValidationResult(false, "ContactCardEntity(me.proton.core.contact.data.local.db.entity.ContactCardEntity).\n"
                  + " Expected:\n" + _infoContactCardEntity + "\n"
                  + " Found:\n" + _existingContactCardEntity);
        }
        final HashMap<String, TableInfo.Column> _columnsContactEmailEntity = new HashMap<String, TableInfo.Column>(9);
        _columnsContactEmailEntity.put("userId", new TableInfo.Column("userId", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContactEmailEntity.put("contactEmailId", new TableInfo.Column("contactEmailId", "TEXT", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContactEmailEntity.put("name", new TableInfo.Column("name", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContactEmailEntity.put("email", new TableInfo.Column("email", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContactEmailEntity.put("defaults", new TableInfo.Column("defaults", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContactEmailEntity.put("order", new TableInfo.Column("order", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContactEmailEntity.put("contactId", new TableInfo.Column("contactId", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContactEmailEntity.put("canonicalEmail", new TableInfo.Column("canonicalEmail", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContactEmailEntity.put("isProton", new TableInfo.Column("isProton", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysContactEmailEntity = new HashSet<TableInfo.ForeignKey>(2);
        _foreignKeysContactEmailEntity.add(new TableInfo.ForeignKey("UserEntity", "CASCADE", "NO ACTION", Arrays.asList("userId"), Arrays.asList("userId")));
        _foreignKeysContactEmailEntity.add(new TableInfo.ForeignKey("ContactEntity", "CASCADE", "NO ACTION", Arrays.asList("contactId"), Arrays.asList("contactId")));
        final HashSet<TableInfo.Index> _indicesContactEmailEntity = new HashSet<TableInfo.Index>(2);
        _indicesContactEmailEntity.add(new TableInfo.Index("index_ContactEmailEntity_userId", false, Arrays.asList("userId"), Arrays.asList("ASC")));
        _indicesContactEmailEntity.add(new TableInfo.Index("index_ContactEmailEntity_contactId", false, Arrays.asList("contactId"), Arrays.asList("ASC")));
        final TableInfo _infoContactEmailEntity = new TableInfo("ContactEmailEntity", _columnsContactEmailEntity, _foreignKeysContactEmailEntity, _indicesContactEmailEntity);
        final TableInfo _existingContactEmailEntity = TableInfo.read(db, "ContactEmailEntity");
        if (!_infoContactEmailEntity.equals(_existingContactEmailEntity)) {
          return new RoomOpenHelper.ValidationResult(false, "ContactEmailEntity(me.proton.core.contact.data.local.db.entity.ContactEmailEntity).\n"
                  + " Expected:\n" + _infoContactEmailEntity + "\n"
                  + " Found:\n" + _existingContactEmailEntity);
        }
        final HashMap<String, TableInfo.Column> _columnsContactEmailLabelEntity = new HashMap<String, TableInfo.Column>(2);
        _columnsContactEmailLabelEntity.put("contactEmailId", new TableInfo.Column("contactEmailId", "TEXT", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContactEmailLabelEntity.put("labelId", new TableInfo.Column("labelId", "TEXT", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysContactEmailLabelEntity = new HashSet<TableInfo.ForeignKey>(1);
        _foreignKeysContactEmailLabelEntity.add(new TableInfo.ForeignKey("ContactEmailEntity", "CASCADE", "NO ACTION", Arrays.asList("contactEmailId"), Arrays.asList("contactEmailId")));
        final HashSet<TableInfo.Index> _indicesContactEmailLabelEntity = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoContactEmailLabelEntity = new TableInfo("ContactEmailLabelEntity", _columnsContactEmailLabelEntity, _foreignKeysContactEmailLabelEntity, _indicesContactEmailLabelEntity);
        final TableInfo _existingContactEmailLabelEntity = TableInfo.read(db, "ContactEmailLabelEntity");
        if (!_infoContactEmailLabelEntity.equals(_existingContactEmailLabelEntity)) {
          return new RoomOpenHelper.ValidationResult(false, "ContactEmailLabelEntity(me.proton.core.contact.data.local.db.entity.ContactEmailLabelEntity).\n"
                  + " Expected:\n" + _infoContactEmailLabelEntity + "\n"
                  + " Found:\n" + _existingContactEmailLabelEntity);
        }
        final HashMap<String, TableInfo.Column> _columnsEventMetadataEntity = new HashMap<String, TableInfo.Column>(10);
        _columnsEventMetadataEntity.put("userId", new TableInfo.Column("userId", "TEXT", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsEventMetadataEntity.put("config", new TableInfo.Column("config", "TEXT", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsEventMetadataEntity.put("eventId", new TableInfo.Column("eventId", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsEventMetadataEntity.put("nextEventId", new TableInfo.Column("nextEventId", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsEventMetadataEntity.put("refresh", new TableInfo.Column("refresh", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsEventMetadataEntity.put("more", new TableInfo.Column("more", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsEventMetadataEntity.put("retry", new TableInfo.Column("retry", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsEventMetadataEntity.put("state", new TableInfo.Column("state", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsEventMetadataEntity.put("createdAt", new TableInfo.Column("createdAt", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsEventMetadataEntity.put("updatedAt", new TableInfo.Column("updatedAt", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysEventMetadataEntity = new HashSet<TableInfo.ForeignKey>(1);
        _foreignKeysEventMetadataEntity.add(new TableInfo.ForeignKey("UserEntity", "CASCADE", "NO ACTION", Arrays.asList("userId"), Arrays.asList("userId")));
        final HashSet<TableInfo.Index> _indicesEventMetadataEntity = new HashSet<TableInfo.Index>(3);
        _indicesEventMetadataEntity.add(new TableInfo.Index("index_EventMetadataEntity_userId", false, Arrays.asList("userId"), Arrays.asList("ASC")));
        _indicesEventMetadataEntity.add(new TableInfo.Index("index_EventMetadataEntity_config", false, Arrays.asList("config"), Arrays.asList("ASC")));
        _indicesEventMetadataEntity.add(new TableInfo.Index("index_EventMetadataEntity_createdAt", false, Arrays.asList("createdAt"), Arrays.asList("ASC")));
        final TableInfo _infoEventMetadataEntity = new TableInfo("EventMetadataEntity", _columnsEventMetadataEntity, _foreignKeysEventMetadataEntity, _indicesEventMetadataEntity);
        final TableInfo _existingEventMetadataEntity = TableInfo.read(db, "EventMetadataEntity");
        if (!_infoEventMetadataEntity.equals(_existingEventMetadataEntity)) {
          return new RoomOpenHelper.ValidationResult(false, "EventMetadataEntity(me.proton.core.eventmanager.data.entity.EventMetadataEntity).\n"
                  + " Expected:\n" + _infoEventMetadataEntity + "\n"
                  + " Found:\n" + _existingEventMetadataEntity);
        }
        final HashMap<String, TableInfo.Column> _columnsLabelEntity = new HashMap<String, TableInfo.Column>(11);
        _columnsLabelEntity.put("userId", new TableInfo.Column("userId", "TEXT", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsLabelEntity.put("labelId", new TableInfo.Column("labelId", "TEXT", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsLabelEntity.put("parentId", new TableInfo.Column("parentId", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsLabelEntity.put("name", new TableInfo.Column("name", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsLabelEntity.put("type", new TableInfo.Column("type", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsLabelEntity.put("path", new TableInfo.Column("path", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsLabelEntity.put("color", new TableInfo.Column("color", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsLabelEntity.put("order", new TableInfo.Column("order", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsLabelEntity.put("isNotified", new TableInfo.Column("isNotified", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsLabelEntity.put("isExpanded", new TableInfo.Column("isExpanded", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsLabelEntity.put("isSticky", new TableInfo.Column("isSticky", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysLabelEntity = new HashSet<TableInfo.ForeignKey>(1);
        _foreignKeysLabelEntity.add(new TableInfo.ForeignKey("UserEntity", "CASCADE", "NO ACTION", Arrays.asList("userId"), Arrays.asList("userId")));
        final HashSet<TableInfo.Index> _indicesLabelEntity = new HashSet<TableInfo.Index>(5);
        _indicesLabelEntity.add(new TableInfo.Index("index_LabelEntity_userId", false, Arrays.asList("userId"), Arrays.asList("ASC")));
        _indicesLabelEntity.add(new TableInfo.Index("index_LabelEntity_labelId", false, Arrays.asList("labelId"), Arrays.asList("ASC")));
        _indicesLabelEntity.add(new TableInfo.Index("index_LabelEntity_parentId", false, Arrays.asList("parentId"), Arrays.asList("ASC")));
        _indicesLabelEntity.add(new TableInfo.Index("index_LabelEntity_name", false, Arrays.asList("name"), Arrays.asList("ASC")));
        _indicesLabelEntity.add(new TableInfo.Index("index_LabelEntity_type", false, Arrays.asList("type"), Arrays.asList("ASC")));
        final TableInfo _infoLabelEntity = new TableInfo("LabelEntity", _columnsLabelEntity, _foreignKeysLabelEntity, _indicesLabelEntity);
        final TableInfo _existingLabelEntity = TableInfo.read(db, "LabelEntity");
        if (!_infoLabelEntity.equals(_existingLabelEntity)) {
          return new RoomOpenHelper.ValidationResult(false, "LabelEntity(me.proton.core.label.data.local.LabelEntity).\n"
                  + " Expected:\n" + _infoLabelEntity + "\n"
                  + " Found:\n" + _existingLabelEntity);
        }
        final HashMap<String, TableInfo.Column> _columnsFeatureFlagEntity = new HashMap<String, TableInfo.Column>(5);
        _columnsFeatureFlagEntity.put("userId", new TableInfo.Column("userId", "TEXT", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsFeatureFlagEntity.put("featureId", new TableInfo.Column("featureId", "TEXT", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsFeatureFlagEntity.put("scope", new TableInfo.Column("scope", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsFeatureFlagEntity.put("defaultValue", new TableInfo.Column("defaultValue", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsFeatureFlagEntity.put("value", new TableInfo.Column("value", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysFeatureFlagEntity = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesFeatureFlagEntity = new HashSet<TableInfo.Index>(2);
        _indicesFeatureFlagEntity.add(new TableInfo.Index("index_FeatureFlagEntity_userId", false, Arrays.asList("userId"), Arrays.asList("ASC")));
        _indicesFeatureFlagEntity.add(new TableInfo.Index("index_FeatureFlagEntity_featureId", false, Arrays.asList("featureId"), Arrays.asList("ASC")));
        final TableInfo _infoFeatureFlagEntity = new TableInfo("FeatureFlagEntity", _columnsFeatureFlagEntity, _foreignKeysFeatureFlagEntity, _indicesFeatureFlagEntity);
        final TableInfo _existingFeatureFlagEntity = TableInfo.read(db, "FeatureFlagEntity");
        if (!_infoFeatureFlagEntity.equals(_existingFeatureFlagEntity)) {
          return new RoomOpenHelper.ValidationResult(false, "FeatureFlagEntity(me.proton.core.featureflag.data.entity.FeatureFlagEntity).\n"
                  + " Expected:\n" + _infoFeatureFlagEntity + "\n"
                  + " Found:\n" + _existingFeatureFlagEntity);
        }
        final HashMap<String, TableInfo.Column> _columnsChallengeFrameEntity = new HashMap<String, TableInfo.Column>(7);
        _columnsChallengeFrameEntity.put("challengeFrame", new TableInfo.Column("challengeFrame", "TEXT", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsChallengeFrameEntity.put("flow", new TableInfo.Column("flow", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsChallengeFrameEntity.put("focusTime", new TableInfo.Column("focusTime", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsChallengeFrameEntity.put("clicks", new TableInfo.Column("clicks", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsChallengeFrameEntity.put("copy", new TableInfo.Column("copy", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsChallengeFrameEntity.put("paste", new TableInfo.Column("paste", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsChallengeFrameEntity.put("keys", new TableInfo.Column("keys", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysChallengeFrameEntity = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesChallengeFrameEntity = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoChallengeFrameEntity = new TableInfo("ChallengeFrameEntity", _columnsChallengeFrameEntity, _foreignKeysChallengeFrameEntity, _indicesChallengeFrameEntity);
        final TableInfo _existingChallengeFrameEntity = TableInfo.read(db, "ChallengeFrameEntity");
        if (!_infoChallengeFrameEntity.equals(_existingChallengeFrameEntity)) {
          return new RoomOpenHelper.ValidationResult(false, "ChallengeFrameEntity(me.proton.core.challenge.data.entity.ChallengeFrameEntity).\n"
                  + " Expected:\n" + _infoChallengeFrameEntity + "\n"
                  + " Found:\n" + _existingChallengeFrameEntity);
        }
        final HashMap<String, TableInfo.Column> _columnsPushEntity = new HashMap<String, TableInfo.Column>(4);
        _columnsPushEntity.put("userId", new TableInfo.Column("userId", "TEXT", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPushEntity.put("pushId", new TableInfo.Column("pushId", "TEXT", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPushEntity.put("objectId", new TableInfo.Column("objectId", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPushEntity.put("type", new TableInfo.Column("type", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysPushEntity = new HashSet<TableInfo.ForeignKey>(1);
        _foreignKeysPushEntity.add(new TableInfo.ForeignKey("UserEntity", "CASCADE", "NO ACTION", Arrays.asList("userId"), Arrays.asList("userId")));
        final HashSet<TableInfo.Index> _indicesPushEntity = new HashSet<TableInfo.Index>(2);
        _indicesPushEntity.add(new TableInfo.Index("index_PushEntity_userId", false, Arrays.asList("userId"), Arrays.asList("ASC")));
        _indicesPushEntity.add(new TableInfo.Index("index_PushEntity_type", false, Arrays.asList("type"), Arrays.asList("ASC")));
        final TableInfo _infoPushEntity = new TableInfo("PushEntity", _columnsPushEntity, _foreignKeysPushEntity, _indicesPushEntity);
        final TableInfo _existingPushEntity = TableInfo.read(db, "PushEntity");
        if (!_infoPushEntity.equals(_existingPushEntity)) {
          return new RoomOpenHelper.ValidationResult(false, "PushEntity(me.proton.core.push.data.local.db.PushEntity).\n"
                  + " Expected:\n" + _infoPushEntity + "\n"
                  + " Found:\n" + _existingPushEntity);
        }
        final HashMap<String, TableInfo.Column> _columnsPurchaseEntity = new HashMap<String, TableInfo.Column>(10);
        _columnsPurchaseEntity.put("sessionId", new TableInfo.Column("sessionId", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPurchaseEntity.put("planName", new TableInfo.Column("planName", "TEXT", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPurchaseEntity.put("planCycle", new TableInfo.Column("planCycle", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPurchaseEntity.put("purchaseState", new TableInfo.Column("purchaseState", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPurchaseEntity.put("purchaseFailure", new TableInfo.Column("purchaseFailure", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPurchaseEntity.put("paymentProvider", new TableInfo.Column("paymentProvider", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPurchaseEntity.put("paymentOrderId", new TableInfo.Column("paymentOrderId", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPurchaseEntity.put("paymentToken", new TableInfo.Column("paymentToken", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPurchaseEntity.put("paymentCurrency", new TableInfo.Column("paymentCurrency", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPurchaseEntity.put("paymentAmount", new TableInfo.Column("paymentAmount", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysPurchaseEntity = new HashSet<TableInfo.ForeignKey>(1);
        _foreignKeysPurchaseEntity.add(new TableInfo.ForeignKey("SessionEntity", "CASCADE", "NO ACTION", Arrays.asList("sessionId"), Arrays.asList("sessionId")));
        final HashSet<TableInfo.Index> _indicesPurchaseEntity = new HashSet<TableInfo.Index>(4);
        _indicesPurchaseEntity.add(new TableInfo.Index("index_PurchaseEntity_planName", false, Arrays.asList("planName"), Arrays.asList("ASC")));
        _indicesPurchaseEntity.add(new TableInfo.Index("index_PurchaseEntity_sessionId", false, Arrays.asList("sessionId"), Arrays.asList("ASC")));
        _indicesPurchaseEntity.add(new TableInfo.Index("index_PurchaseEntity_purchaseState", false, Arrays.asList("purchaseState"), Arrays.asList("ASC")));
        _indicesPurchaseEntity.add(new TableInfo.Index("index_PurchaseEntity_paymentProvider", false, Arrays.asList("paymentProvider"), Arrays.asList("ASC")));
        final TableInfo _infoPurchaseEntity = new TableInfo("PurchaseEntity", _columnsPurchaseEntity, _foreignKeysPurchaseEntity, _indicesPurchaseEntity);
        final TableInfo _existingPurchaseEntity = TableInfo.read(db, "PurchaseEntity");
        if (!_infoPurchaseEntity.equals(_existingPurchaseEntity)) {
          return new RoomOpenHelper.ValidationResult(false, "PurchaseEntity(me.proton.core.payment.data.local.entity.PurchaseEntity).\n"
                  + " Expected:\n" + _infoPurchaseEntity + "\n"
                  + " Found:\n" + _existingPurchaseEntity);
        }
        final HashMap<String, TableInfo.Column> _columnsGooglePurchaseEntity = new HashMap<String, TableInfo.Column>(2);
        _columnsGooglePurchaseEntity.put("googlePurchaseToken", new TableInfo.Column("googlePurchaseToken", "TEXT", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsGooglePurchaseEntity.put("paymentToken", new TableInfo.Column("paymentToken", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysGooglePurchaseEntity = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesGooglePurchaseEntity = new HashSet<TableInfo.Index>(1);
        _indicesGooglePurchaseEntity.add(new TableInfo.Index("index_GooglePurchaseEntity_paymentToken", true, Arrays.asList("paymentToken"), Arrays.asList("ASC")));
        final TableInfo _infoGooglePurchaseEntity = new TableInfo("GooglePurchaseEntity", _columnsGooglePurchaseEntity, _foreignKeysGooglePurchaseEntity, _indicesGooglePurchaseEntity);
        final TableInfo _existingGooglePurchaseEntity = TableInfo.read(db, "GooglePurchaseEntity");
        if (!_infoGooglePurchaseEntity.equals(_existingGooglePurchaseEntity)) {
          return new RoomOpenHelper.ValidationResult(false, "GooglePurchaseEntity(me.proton.core.payment.data.local.entity.GooglePurchaseEntity).\n"
                  + " Expected:\n" + _infoGooglePurchaseEntity + "\n"
                  + " Found:\n" + _existingGooglePurchaseEntity);
        }
        final HashMap<String, TableInfo.Column> _columnsObservabilityEventEntity = new HashMap<String, TableInfo.Column>(5);
        _columnsObservabilityEventEntity.put("id", new TableInfo.Column("id", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsObservabilityEventEntity.put("name", new TableInfo.Column("name", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsObservabilityEventEntity.put("version", new TableInfo.Column("version", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsObservabilityEventEntity.put("timestamp", new TableInfo.Column("timestamp", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsObservabilityEventEntity.put("data", new TableInfo.Column("data", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysObservabilityEventEntity = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesObservabilityEventEntity = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoObservabilityEventEntity = new TableInfo("ObservabilityEventEntity", _columnsObservabilityEventEntity, _foreignKeysObservabilityEventEntity, _indicesObservabilityEventEntity);
        final TableInfo _existingObservabilityEventEntity = TableInfo.read(db, "ObservabilityEventEntity");
        if (!_infoObservabilityEventEntity.equals(_existingObservabilityEventEntity)) {
          return new RoomOpenHelper.ValidationResult(false, "ObservabilityEventEntity(me.proton.core.observability.data.entity.ObservabilityEventEntity).\n"
                  + " Expected:\n" + _infoObservabilityEventEntity + "\n"
                  + " Found:\n" + _existingObservabilityEventEntity);
        }
        final HashMap<String, TableInfo.Column> _columnsTelemetryEventEntity = new HashMap<String, TableInfo.Column>(7);
        _columnsTelemetryEventEntity.put("id", new TableInfo.Column("id", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsTelemetryEventEntity.put("userId", new TableInfo.Column("userId", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsTelemetryEventEntity.put("group", new TableInfo.Column("group", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsTelemetryEventEntity.put("name", new TableInfo.Column("name", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsTelemetryEventEntity.put("values", new TableInfo.Column("values", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsTelemetryEventEntity.put("dimensions", new TableInfo.Column("dimensions", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsTelemetryEventEntity.put("timestamp", new TableInfo.Column("timestamp", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysTelemetryEventEntity = new HashSet<TableInfo.ForeignKey>(1);
        _foreignKeysTelemetryEventEntity.add(new TableInfo.ForeignKey("UserEntity", "CASCADE", "NO ACTION", Arrays.asList("userId"), Arrays.asList("userId")));
        final HashSet<TableInfo.Index> _indicesTelemetryEventEntity = new HashSet<TableInfo.Index>(1);
        _indicesTelemetryEventEntity.add(new TableInfo.Index("index_TelemetryEventEntity_userId", false, Arrays.asList("userId"), Arrays.asList("ASC")));
        final TableInfo _infoTelemetryEventEntity = new TableInfo("TelemetryEventEntity", _columnsTelemetryEventEntity, _foreignKeysTelemetryEventEntity, _indicesTelemetryEventEntity);
        final TableInfo _existingTelemetryEventEntity = TableInfo.read(db, "TelemetryEventEntity");
        if (!_infoTelemetryEventEntity.equals(_existingTelemetryEventEntity)) {
          return new RoomOpenHelper.ValidationResult(false, "TelemetryEventEntity(me.proton.core.telemetry.data.entity.TelemetryEventEntity).\n"
                  + " Expected:\n" + _infoTelemetryEventEntity + "\n"
                  + " Found:\n" + _existingTelemetryEventEntity);
        }
        final HashMap<String, TableInfo.Column> _columnsAddressChangeEntity = new HashMap<String, TableInfo.Column>(8);
        _columnsAddressChangeEntity.put("userId", new TableInfo.Column("userId", "TEXT", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAddressChangeEntity.put("changeId", new TableInfo.Column("changeId", "TEXT", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAddressChangeEntity.put("counterEncrypted", new TableInfo.Column("counterEncrypted", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAddressChangeEntity.put("emailEncrypted", new TableInfo.Column("emailEncrypted", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAddressChangeEntity.put("epochIdEncrypted", new TableInfo.Column("epochIdEncrypted", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAddressChangeEntity.put("creationTimestampEncrypted", new TableInfo.Column("creationTimestampEncrypted", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAddressChangeEntity.put("publicKeysEncrypted", new TableInfo.Column("publicKeysEncrypted", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAddressChangeEntity.put("isObsolete", new TableInfo.Column("isObsolete", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysAddressChangeEntity = new HashSet<TableInfo.ForeignKey>(1);
        _foreignKeysAddressChangeEntity.add(new TableInfo.ForeignKey("UserEntity", "CASCADE", "NO ACTION", Arrays.asList("userId"), Arrays.asList("userId")));
        final HashSet<TableInfo.Index> _indicesAddressChangeEntity = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoAddressChangeEntity = new TableInfo("AddressChangeEntity", _columnsAddressChangeEntity, _foreignKeysAddressChangeEntity, _indicesAddressChangeEntity);
        final TableInfo _existingAddressChangeEntity = TableInfo.read(db, "AddressChangeEntity");
        if (!_infoAddressChangeEntity.equals(_existingAddressChangeEntity)) {
          return new RoomOpenHelper.ValidationResult(false, "AddressChangeEntity(me.proton.core.keytransparency.data.local.entity.AddressChangeEntity).\n"
                  + " Expected:\n" + _infoAddressChangeEntity + "\n"
                  + " Found:\n" + _existingAddressChangeEntity);
        }
        final HashMap<String, TableInfo.Column> _columnsSelfAuditResultEntity = new HashMap<String, TableInfo.Column>(2);
        _columnsSelfAuditResultEntity.put("userId", new TableInfo.Column("userId", "TEXT", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSelfAuditResultEntity.put("timestamp", new TableInfo.Column("timestamp", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysSelfAuditResultEntity = new HashSet<TableInfo.ForeignKey>(1);
        _foreignKeysSelfAuditResultEntity.add(new TableInfo.ForeignKey("UserEntity", "CASCADE", "NO ACTION", Arrays.asList("userId"), Arrays.asList("userId")));
        final HashSet<TableInfo.Index> _indicesSelfAuditResultEntity = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoSelfAuditResultEntity = new TableInfo("SelfAuditResultEntity", _columnsSelfAuditResultEntity, _foreignKeysSelfAuditResultEntity, _indicesSelfAuditResultEntity);
        final TableInfo _existingSelfAuditResultEntity = TableInfo.read(db, "SelfAuditResultEntity");
        if (!_infoSelfAuditResultEntity.equals(_existingSelfAuditResultEntity)) {
          return new RoomOpenHelper.ValidationResult(false, "SelfAuditResultEntity(me.proton.core.keytransparency.data.local.entity.SelfAuditResultEntity).\n"
                  + " Expected:\n" + _infoSelfAuditResultEntity + "\n"
                  + " Found:\n" + _existingSelfAuditResultEntity);
        }
        final HashMap<String, TableInfo.Column> _columnsNotificationEntity = new HashMap<String, TableInfo.Column>(5);
        _columnsNotificationEntity.put("notificationId", new TableInfo.Column("notificationId", "TEXT", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsNotificationEntity.put("userId", new TableInfo.Column("userId", "TEXT", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsNotificationEntity.put("time", new TableInfo.Column("time", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsNotificationEntity.put("type", new TableInfo.Column("type", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsNotificationEntity.put("payload", new TableInfo.Column("payload", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysNotificationEntity = new HashSet<TableInfo.ForeignKey>(1);
        _foreignKeysNotificationEntity.add(new TableInfo.ForeignKey("UserEntity", "CASCADE", "NO ACTION", Arrays.asList("userId"), Arrays.asList("userId")));
        final HashSet<TableInfo.Index> _indicesNotificationEntity = new HashSet<TableInfo.Index>(2);
        _indicesNotificationEntity.add(new TableInfo.Index("index_NotificationEntity_userId", false, Arrays.asList("userId"), Arrays.asList("ASC")));
        _indicesNotificationEntity.add(new TableInfo.Index("index_NotificationEntity_notificationId", false, Arrays.asList("notificationId"), Arrays.asList("ASC")));
        final TableInfo _infoNotificationEntity = new TableInfo("NotificationEntity", _columnsNotificationEntity, _foreignKeysNotificationEntity, _indicesNotificationEntity);
        final TableInfo _existingNotificationEntity = TableInfo.read(db, "NotificationEntity");
        if (!_infoNotificationEntity.equals(_existingNotificationEntity)) {
          return new RoomOpenHelper.ValidationResult(false, "NotificationEntity(me.proton.core.notification.data.local.db.NotificationEntity).\n"
                  + " Expected:\n" + _infoNotificationEntity + "\n"
                  + " Found:\n" + _existingNotificationEntity);
        }
        return new RoomOpenHelper.ValidationResult(true, null);
      }
    }, "18b8d6bbd6630979635188feeba02ff6", "bf4b9e2cf6308a48840024f608bdc6bc");
    final SupportSQLiteOpenHelper.Configuration _sqliteConfig = SupportSQLiteOpenHelper.Configuration.builder(config.context).name(config.name).callback(_openCallback).build();
    final SupportSQLiteOpenHelper _helper = config.sqliteOpenHelperFactory.create(_sqliteConfig);
    return _helper;
  }

  @Override
  @NonNull
  protected InvalidationTracker createInvalidationTracker() {
    final HashMap<String, String> _shadowTablesMap = new HashMap<String, String>(0);
    final HashMap<String, Set<String>> _viewTables = new HashMap<String, Set<String>>(0);
    return new InvalidationTracker(this, _shadowTablesMap, _viewTables, "AccountEntity","AccountMetadataEntity","SessionEntity","SessionDetailsEntity","UserEntity","UserKeyEntity","AddressEntity","AddressKeyEntity","KeySaltEntity","PublicAddressEntity","PublicAddressKeyEntity","HumanVerificationEntity","MailSettingsEntity","UserSettingsEntity","OrganizationEntity","OrganizationKeysEntity","ContactEntity","ContactCardEntity","ContactEmailEntity","ContactEmailLabelEntity","EventMetadataEntity","LabelEntity","FeatureFlagEntity","ChallengeFrameEntity","PushEntity","PurchaseEntity","GooglePurchaseEntity","ObservabilityEventEntity","TelemetryEventEntity","AddressChangeEntity","SelfAuditResultEntity","NotificationEntity");
  }

  @Override
  public void clearAllTables() {
    super.assertNotMainThread();
    final SupportSQLiteDatabase _db = super.getOpenHelper().getWritableDatabase();
    final boolean _supportsDeferForeignKeys = android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.LOLLIPOP;
    try {
      if (!_supportsDeferForeignKeys) {
        _db.execSQL("PRAGMA foreign_keys = FALSE");
      }
      super.beginTransaction();
      if (_supportsDeferForeignKeys) {
        _db.execSQL("PRAGMA defer_foreign_keys = TRUE");
      }
      _db.execSQL("DELETE FROM `AccountEntity`");
      _db.execSQL("DELETE FROM `AccountMetadataEntity`");
      _db.execSQL("DELETE FROM `SessionEntity`");
      _db.execSQL("DELETE FROM `SessionDetailsEntity`");
      _db.execSQL("DELETE FROM `UserEntity`");
      _db.execSQL("DELETE FROM `UserKeyEntity`");
      _db.execSQL("DELETE FROM `AddressEntity`");
      _db.execSQL("DELETE FROM `AddressKeyEntity`");
      _db.execSQL("DELETE FROM `KeySaltEntity`");
      _db.execSQL("DELETE FROM `PublicAddressEntity`");
      _db.execSQL("DELETE FROM `PublicAddressKeyEntity`");
      _db.execSQL("DELETE FROM `HumanVerificationEntity`");
      _db.execSQL("DELETE FROM `MailSettingsEntity`");
      _db.execSQL("DELETE FROM `UserSettingsEntity`");
      _db.execSQL("DELETE FROM `OrganizationEntity`");
      _db.execSQL("DELETE FROM `OrganizationKeysEntity`");
      _db.execSQL("DELETE FROM `ContactEntity`");
      _db.execSQL("DELETE FROM `ContactCardEntity`");
      _db.execSQL("DELETE FROM `ContactEmailEntity`");
      _db.execSQL("DELETE FROM `ContactEmailLabelEntity`");
      _db.execSQL("DELETE FROM `EventMetadataEntity`");
      _db.execSQL("DELETE FROM `LabelEntity`");
      _db.execSQL("DELETE FROM `FeatureFlagEntity`");
      _db.execSQL("DELETE FROM `ChallengeFrameEntity`");
      _db.execSQL("DELETE FROM `PushEntity`");
      _db.execSQL("DELETE FROM `PurchaseEntity`");
      _db.execSQL("DELETE FROM `GooglePurchaseEntity`");
      _db.execSQL("DELETE FROM `ObservabilityEventEntity`");
      _db.execSQL("DELETE FROM `TelemetryEventEntity`");
      _db.execSQL("DELETE FROM `AddressChangeEntity`");
      _db.execSQL("DELETE FROM `SelfAuditResultEntity`");
      _db.execSQL("DELETE FROM `NotificationEntity`");
      super.setTransactionSuccessful();
    } finally {
      super.endTransaction();
      if (!_supportsDeferForeignKeys) {
        _db.execSQL("PRAGMA foreign_keys = TRUE");
      }
      _db.query("PRAGMA wal_checkpoint(FULL)").close();
      if (!_db.inTransaction()) {
        _db.execSQL("VACUUM");
      }
    }
  }

  @Override
  @NonNull
  protected Map<Class<?>, List<Class<?>>> getRequiredTypeConverters() {
    final HashMap<Class<?>, List<Class<?>>> _typeConvertersMap = new HashMap<Class<?>, List<Class<?>>>();
    _typeConvertersMap.put(AccountDao.class, AccountDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(SessionDao.class, SessionDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(AccountMetadataDao.class, AccountMetadataDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(SessionDetailsDao.class, SessionDetailsDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(UserKeyDao.class, UserKeyDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(UserDao.class, UserDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(UserWithKeysDao.class, UserWithKeysDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(AddressKeyDao.class, AddressKeyDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(AddressDao.class, AddressDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(AddressWithKeysDao.class, AddressWithKeysDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(KeySaltDao.class, KeySaltDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(HumanVerificationDetailsDao.class, HumanVerificationDetailsDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(PublicAddressDao.class, PublicAddressDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(PublicAddressKeyDao.class, PublicAddressKeyDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(PublicAddressWithKeysDao.class, PublicAddressWithKeysDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(MailSettingsDao.class, MailSettingsDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(UserSettingsDao.class, UserSettingsDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(OrganizationDao.class, OrganizationDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(OrganizationKeysDao.class, OrganizationKeysDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(ContactDao.class, ContactDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(ContactCardDao.class, ContactCardDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(ContactEmailDao.class, ContactEmailDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(ContactEmailLabelDao.class, ContactEmailLabelDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(EventMetadataDao.class, EventMetadataDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(LabelDao.class, LabelDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(FeatureFlagDao.class, FeatureFlagDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(ChallengeFramesDao.class, ChallengeFramesDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(PushDao.class, PushDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(PurchaseDao.class, PurchaseDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(GooglePurchaseDao.class, GooglePurchaseDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(ObservabilityDao.class, ObservabilityDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(TelemetryDao.class, TelemetryDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(AddressChangeDao.class, AddressChangeDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(SelfAuditResultDao.class, SelfAuditResultDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(NotificationDao.class, NotificationDao_Impl.getRequiredConverters());
    return _typeConvertersMap;
  }

  @Override
  @NonNull
  public Set<Class<? extends AutoMigrationSpec>> getRequiredAutoMigrationSpecs() {
    final HashSet<Class<? extends AutoMigrationSpec>> _autoMigrationSpecsSet = new HashSet<Class<? extends AutoMigrationSpec>>();
    return _autoMigrationSpecsSet;
  }

  @Override
  @NonNull
  public List<Migration> getAutoMigrations(
      @NonNull final Map<Class<? extends AutoMigrationSpec>, AutoMigrationSpec> autoMigrationSpecs) {
    final List<Migration> _autoMigrations = new ArrayList<Migration>();
    return _autoMigrations;
  }

  @Override
  public AccountDao accountDao() {
    if (_accountDao != null) {
      return _accountDao;
    } else {
      synchronized(this) {
        if(_accountDao == null) {
          _accountDao = new AccountDao_Impl(this);
        }
        return _accountDao;
      }
    }
  }

  @Override
  public SessionDao sessionDao() {
    if (_sessionDao != null) {
      return _sessionDao;
    } else {
      synchronized(this) {
        if(_sessionDao == null) {
          _sessionDao = new SessionDao_Impl(this);
        }
        return _sessionDao;
      }
    }
  }

  @Override
  public AccountMetadataDao accountMetadataDao() {
    if (_accountMetadataDao != null) {
      return _accountMetadataDao;
    } else {
      synchronized(this) {
        if(_accountMetadataDao == null) {
          _accountMetadataDao = new AccountMetadataDao_Impl(this);
        }
        return _accountMetadataDao;
      }
    }
  }

  @Override
  public SessionDetailsDao sessionDetailsDao() {
    if (_sessionDetailsDao != null) {
      return _sessionDetailsDao;
    } else {
      synchronized(this) {
        if(_sessionDetailsDao == null) {
          _sessionDetailsDao = new SessionDetailsDao_Impl(this);
        }
        return _sessionDetailsDao;
      }
    }
  }

  @Override
  public UserKeyDao userKeyDao() {
    if (_userKeyDao != null) {
      return _userKeyDao;
    } else {
      synchronized(this) {
        if(_userKeyDao == null) {
          _userKeyDao = new UserKeyDao_Impl(this);
        }
        return _userKeyDao;
      }
    }
  }

  @Override
  public UserDao userDao() {
    if (_userDao != null) {
      return _userDao;
    } else {
      synchronized(this) {
        if(_userDao == null) {
          _userDao = new UserDao_Impl(this);
        }
        return _userDao;
      }
    }
  }

  @Override
  public UserWithKeysDao userWithKeysDao() {
    if (_userWithKeysDao != null) {
      return _userWithKeysDao;
    } else {
      synchronized(this) {
        if(_userWithKeysDao == null) {
          _userWithKeysDao = new UserWithKeysDao_Impl(this);
        }
        return _userWithKeysDao;
      }
    }
  }

  @Override
  public AddressKeyDao addressKeyDao() {
    if (_addressKeyDao != null) {
      return _addressKeyDao;
    } else {
      synchronized(this) {
        if(_addressKeyDao == null) {
          _addressKeyDao = new AddressKeyDao_Impl(this);
        }
        return _addressKeyDao;
      }
    }
  }

  @Override
  public AddressDao addressDao() {
    if (_addressDao != null) {
      return _addressDao;
    } else {
      synchronized(this) {
        if(_addressDao == null) {
          _addressDao = new AddressDao_Impl(this);
        }
        return _addressDao;
      }
    }
  }

  @Override
  public AddressWithKeysDao addressWithKeysDao() {
    if (_addressWithKeysDao != null) {
      return _addressWithKeysDao;
    } else {
      synchronized(this) {
        if(_addressWithKeysDao == null) {
          _addressWithKeysDao = new AddressWithKeysDao_Impl(this);
        }
        return _addressWithKeysDao;
      }
    }
  }

  @Override
  public KeySaltDao keySaltDao() {
    if (_keySaltDao != null) {
      return _keySaltDao;
    } else {
      synchronized(this) {
        if(_keySaltDao == null) {
          _keySaltDao = new KeySaltDao_Impl(this);
        }
        return _keySaltDao;
      }
    }
  }

  @Override
  public HumanVerificationDetailsDao humanVerificationDetailsDao() {
    if (_humanVerificationDetailsDao != null) {
      return _humanVerificationDetailsDao;
    } else {
      synchronized(this) {
        if(_humanVerificationDetailsDao == null) {
          _humanVerificationDetailsDao = new HumanVerificationDetailsDao_Impl(this);
        }
        return _humanVerificationDetailsDao;
      }
    }
  }

  @Override
  public PublicAddressDao publicAddressDao() {
    if (_publicAddressDao != null) {
      return _publicAddressDao;
    } else {
      synchronized(this) {
        if(_publicAddressDao == null) {
          _publicAddressDao = new PublicAddressDao_Impl(this);
        }
        return _publicAddressDao;
      }
    }
  }

  @Override
  public PublicAddressKeyDao publicAddressKeyDao() {
    if (_publicAddressKeyDao != null) {
      return _publicAddressKeyDao;
    } else {
      synchronized(this) {
        if(_publicAddressKeyDao == null) {
          _publicAddressKeyDao = new PublicAddressKeyDao_Impl(this);
        }
        return _publicAddressKeyDao;
      }
    }
  }

  @Override
  public PublicAddressWithKeysDao publicAddressWithKeysDao() {
    if (_publicAddressWithKeysDao != null) {
      return _publicAddressWithKeysDao;
    } else {
      synchronized(this) {
        if(_publicAddressWithKeysDao == null) {
          _publicAddressWithKeysDao = new PublicAddressWithKeysDao_Impl(this);
        }
        return _publicAddressWithKeysDao;
      }
    }
  }

  @Override
  public MailSettingsDao mailSettingsDao() {
    if (_mailSettingsDao != null) {
      return _mailSettingsDao;
    } else {
      synchronized(this) {
        if(_mailSettingsDao == null) {
          _mailSettingsDao = new MailSettingsDao_Impl(this);
        }
        return _mailSettingsDao;
      }
    }
  }

  @Override
  public UserSettingsDao userSettingsDao() {
    if (_userSettingsDao != null) {
      return _userSettingsDao;
    } else {
      synchronized(this) {
        if(_userSettingsDao == null) {
          _userSettingsDao = new UserSettingsDao_Impl(this);
        }
        return _userSettingsDao;
      }
    }
  }

  @Override
  public OrganizationDao organizationDao() {
    if (_organizationDao != null) {
      return _organizationDao;
    } else {
      synchronized(this) {
        if(_organizationDao == null) {
          _organizationDao = new OrganizationDao_Impl(this);
        }
        return _organizationDao;
      }
    }
  }

  @Override
  public OrganizationKeysDao organizationKeysDao() {
    if (_organizationKeysDao != null) {
      return _organizationKeysDao;
    } else {
      synchronized(this) {
        if(_organizationKeysDao == null) {
          _organizationKeysDao = new OrganizationKeysDao_Impl(this);
        }
        return _organizationKeysDao;
      }
    }
  }

  @Override
  public ContactDao contactDao() {
    if (_contactDao != null) {
      return _contactDao;
    } else {
      synchronized(this) {
        if(_contactDao == null) {
          _contactDao = new ContactDao_Impl(this);
        }
        return _contactDao;
      }
    }
  }

  @Override
  public ContactCardDao contactCardDao() {
    if (_contactCardDao != null) {
      return _contactCardDao;
    } else {
      synchronized(this) {
        if(_contactCardDao == null) {
          _contactCardDao = new ContactCardDao_Impl(this);
        }
        return _contactCardDao;
      }
    }
  }

  @Override
  public ContactEmailDao contactEmailDao() {
    if (_contactEmailDao != null) {
      return _contactEmailDao;
    } else {
      synchronized(this) {
        if(_contactEmailDao == null) {
          _contactEmailDao = new ContactEmailDao_Impl(this);
        }
        return _contactEmailDao;
      }
    }
  }

  @Override
  public ContactEmailLabelDao contactEmailLabelDao() {
    if (_contactEmailLabelDao != null) {
      return _contactEmailLabelDao;
    } else {
      synchronized(this) {
        if(_contactEmailLabelDao == null) {
          _contactEmailLabelDao = new ContactEmailLabelDao_Impl(this);
        }
        return _contactEmailLabelDao;
      }
    }
  }

  @Override
  public EventMetadataDao eventMetadataDao() {
    if (_eventMetadataDao != null) {
      return _eventMetadataDao;
    } else {
      synchronized(this) {
        if(_eventMetadataDao == null) {
          _eventMetadataDao = new EventMetadataDao_Impl(this);
        }
        return _eventMetadataDao;
      }
    }
  }

  @Override
  public LabelDao labelDao() {
    if (_labelDao != null) {
      return _labelDao;
    } else {
      synchronized(this) {
        if(_labelDao == null) {
          _labelDao = new LabelDao_Impl(this);
        }
        return _labelDao;
      }
    }
  }

  @Override
  public FeatureFlagDao featureFlagDao() {
    if (_featureFlagDao != null) {
      return _featureFlagDao;
    } else {
      synchronized(this) {
        if(_featureFlagDao == null) {
          _featureFlagDao = new FeatureFlagDao_Impl(this);
        }
        return _featureFlagDao;
      }
    }
  }

  @Override
  public ChallengeFramesDao challengeFramesDao() {
    if (_challengeFramesDao != null) {
      return _challengeFramesDao;
    } else {
      synchronized(this) {
        if(_challengeFramesDao == null) {
          _challengeFramesDao = new ChallengeFramesDao_Impl(this);
        }
        return _challengeFramesDao;
      }
    }
  }

  @Override
  public PushDao pushDao() {
    if (_pushDao != null) {
      return _pushDao;
    } else {
      synchronized(this) {
        if(_pushDao == null) {
          _pushDao = new PushDao_Impl(this);
        }
        return _pushDao;
      }
    }
  }

  @Override
  public PurchaseDao purchaseDao() {
    if (_purchaseDao != null) {
      return _purchaseDao;
    } else {
      synchronized(this) {
        if(_purchaseDao == null) {
          _purchaseDao = new PurchaseDao_Impl(this);
        }
        return _purchaseDao;
      }
    }
  }

  @Override
  public GooglePurchaseDao googlePurchaseDao() {
    if (_googlePurchaseDao != null) {
      return _googlePurchaseDao;
    } else {
      synchronized(this) {
        if(_googlePurchaseDao == null) {
          _googlePurchaseDao = new GooglePurchaseDao_Impl(this);
        }
        return _googlePurchaseDao;
      }
    }
  }

  @Override
  public ObservabilityDao observabilityDao() {
    if (_observabilityDao != null) {
      return _observabilityDao;
    } else {
      synchronized(this) {
        if(_observabilityDao == null) {
          _observabilityDao = new ObservabilityDao_Impl(this);
        }
        return _observabilityDao;
      }
    }
  }

  @Override
  public TelemetryDao telemetryDao() {
    if (_telemetryDao != null) {
      return _telemetryDao;
    } else {
      synchronized(this) {
        if(_telemetryDao == null) {
          _telemetryDao = new TelemetryDao_Impl(this);
        }
        return _telemetryDao;
      }
    }
  }

  @Override
  public AddressChangeDao addressChangeDao() {
    if (_addressChangeDao != null) {
      return _addressChangeDao;
    } else {
      synchronized(this) {
        if(_addressChangeDao == null) {
          _addressChangeDao = new AddressChangeDao_Impl(this);
        }
        return _addressChangeDao;
      }
    }
  }

  @Override
  public SelfAuditResultDao selfAuditResultDao() {
    if (_selfAuditResultDao != null) {
      return _selfAuditResultDao;
    } else {
      synchronized(this) {
        if(_selfAuditResultDao == null) {
          _selfAuditResultDao = new SelfAuditResultDao_Impl(this);
        }
        return _selfAuditResultDao;
      }
    }
  }

  @Override
  public NotificationDao notificationDao() {
    if (_notificationDao != null) {
      return _notificationDao;
    } else {
      synchronized(this) {
        if(_notificationDao == null) {
          _notificationDao = new NotificationDao_Impl(this);
        }
        return _notificationDao;
      }
    }
  }
}
