package me.proton.core.usersettings.data.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;
import me.proton.core.data.room.db.CommonConverters;
import me.proton.core.domain.entity.UserId;
import me.proton.core.usersettings.data.entity.OrganizationKeysEntity;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class OrganizationKeysDao_Impl extends OrganizationKeysDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<OrganizationKeysEntity> __insertionAdapterOfOrganizationKeysEntity;

  private final CommonConverters __commonConverters = new CommonConverters();

  private final EntityDeletionOrUpdateAdapter<OrganizationKeysEntity> __deletionAdapterOfOrganizationKeysEntity;

  private final EntityDeletionOrUpdateAdapter<OrganizationKeysEntity> __updateAdapterOfOrganizationKeysEntity;

  private final SharedSQLiteStatement __preparedStmtOfDelete;

  private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

  public OrganizationKeysDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfOrganizationKeysEntity = new EntityInsertionAdapter<OrganizationKeysEntity>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR IGNORE INTO `OrganizationKeysEntity` (`userId`,`publicKey`,`privateKey`) VALUES (?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, OrganizationKeysEntity value) {
        final String _tmp = __commonConverters.fromUserIdToString(value.getUserId());
        if (_tmp == null) {
          stmt.bindNull(1);
        } else {
          stmt.bindString(1, _tmp);
        }
        if (value.getPublicKey() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getPublicKey());
        }
        if (value.getPrivateKey() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getPrivateKey());
        }
      }
    };
    this.__deletionAdapterOfOrganizationKeysEntity = new EntityDeletionOrUpdateAdapter<OrganizationKeysEntity>(__db) {
      @Override
      public String createQuery() {
        return "DELETE FROM `OrganizationKeysEntity` WHERE `userId` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, OrganizationKeysEntity value) {
        final String _tmp = __commonConverters.fromUserIdToString(value.getUserId());
        if (_tmp == null) {
          stmt.bindNull(1);
        } else {
          stmt.bindString(1, _tmp);
        }
      }
    };
    this.__updateAdapterOfOrganizationKeysEntity = new EntityDeletionOrUpdateAdapter<OrganizationKeysEntity>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `OrganizationKeysEntity` SET `userId` = ?,`publicKey` = ?,`privateKey` = ? WHERE `userId` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, OrganizationKeysEntity value) {
        final String _tmp = __commonConverters.fromUserIdToString(value.getUserId());
        if (_tmp == null) {
          stmt.bindNull(1);
        } else {
          stmt.bindString(1, _tmp);
        }
        if (value.getPublicKey() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getPublicKey());
        }
        if (value.getPrivateKey() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getPrivateKey());
        }
        final String _tmp_1 = __commonConverters.fromUserIdToString(value.getUserId());
        if (_tmp_1 == null) {
          stmt.bindNull(4);
        } else {
          stmt.bindString(4, _tmp_1);
        }
      }
    };
    this.__preparedStmtOfDelete = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "DELETE FROM OrganizationKeysEntity WHERE userId = ?";
        return _query;
      }
    };
    this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "DELETE FROM OrganizationKeysEntity";
        return _query;
      }
    };
  }

  @Override
  public Object insertOrIgnore(final OrganizationKeysEntity[] entities,
      final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfOrganizationKeysEntity.insert(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object delete(final OrganizationKeysEntity[] entities,
      final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __deletionAdapterOfOrganizationKeysEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object update(final OrganizationKeysEntity[] entities,
      final Continuation<? super Integer> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      public Integer call() throws Exception {
        int _total = 0;
        __db.beginTransaction();
        try {
          _total +=__updateAdapterOfOrganizationKeysEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return _total;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object insertOrUpdate(final OrganizationKeysEntity[] entities,
      final Continuation<? super Unit> $completion) {
    return RoomDatabaseKt.withTransaction(__db, (__cont) -> OrganizationKeysDao_Impl.super.insertOrUpdate(entities, __cont), $completion);
  }

  @Override
  public Object delete(final UserId userId, final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDelete.acquire();
        int _argIndex = 1;
        final String _tmp = __commonConverters.fromUserIdToString(userId);
        if (_tmp == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, _tmp);
        }
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfDelete.release(_stmt);
        }
      }
    }, arg1);
  }

  @Override
  public Object deleteAll(final Continuation<? super Unit> arg0) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteAll.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfDeleteAll.release(_stmt);
        }
      }
    }, arg0);
  }

  @Override
  public Flow<OrganizationKeysEntity> observeByUserId(final UserId userId) {
    final String _sql = "SELECT * FROM OrganizationKeysEntity WHERE userId = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    final String _tmp = __commonConverters.fromUserIdToString(userId);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp);
    }
    return CoroutinesRoom.createFlow(__db, false, new String[]{"OrganizationKeysEntity"}, new Callable<OrganizationKeysEntity>() {
      @Override
      public OrganizationKeysEntity call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
          final int _cursorIndexOfPublicKey = CursorUtil.getColumnIndexOrThrow(_cursor, "publicKey");
          final int _cursorIndexOfPrivateKey = CursorUtil.getColumnIndexOrThrow(_cursor, "privateKey");
          final OrganizationKeysEntity _result;
          if(_cursor.moveToFirst()) {
            final UserId _tmpUserId;
            final String _tmp_1;
            if (_cursor.isNull(_cursorIndexOfUserId)) {
              _tmp_1 = null;
            } else {
              _tmp_1 = _cursor.getString(_cursorIndexOfUserId);
            }
            _tmpUserId = __commonConverters.fromStringToUserId(_tmp_1);
            final String _tmpPublicKey;
            if (_cursor.isNull(_cursorIndexOfPublicKey)) {
              _tmpPublicKey = null;
            } else {
              _tmpPublicKey = _cursor.getString(_cursorIndexOfPublicKey);
            }
            final String _tmpPrivateKey;
            if (_cursor.isNull(_cursorIndexOfPrivateKey)) {
              _tmpPrivateKey = null;
            } else {
              _tmpPrivateKey = _cursor.getString(_cursorIndexOfPrivateKey);
            }
            _result = new OrganizationKeysEntity(_tmpUserId,_tmpPublicKey,_tmpPrivateKey);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object getByUserId(final UserId userId,
      final Continuation<? super OrganizationKeysEntity> arg1) {
    final String _sql = "SELECT * FROM OrganizationKeysEntity WHERE userId = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    final String _tmp = __commonConverters.fromUserIdToString(userId);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp);
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<OrganizationKeysEntity>() {
      @Override
      public OrganizationKeysEntity call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
          final int _cursorIndexOfPublicKey = CursorUtil.getColumnIndexOrThrow(_cursor, "publicKey");
          final int _cursorIndexOfPrivateKey = CursorUtil.getColumnIndexOrThrow(_cursor, "privateKey");
          final OrganizationKeysEntity _result;
          if(_cursor.moveToFirst()) {
            final UserId _tmpUserId;
            final String _tmp_1;
            if (_cursor.isNull(_cursorIndexOfUserId)) {
              _tmp_1 = null;
            } else {
              _tmp_1 = _cursor.getString(_cursorIndexOfUserId);
            }
            _tmpUserId = __commonConverters.fromStringToUserId(_tmp_1);
            final String _tmpPublicKey;
            if (_cursor.isNull(_cursorIndexOfPublicKey)) {
              _tmpPublicKey = null;
            } else {
              _tmpPublicKey = _cursor.getString(_cursorIndexOfPublicKey);
            }
            final String _tmpPrivateKey;
            if (_cursor.isNull(_cursorIndexOfPrivateKey)) {
              _tmpPrivateKey = null;
            } else {
              _tmpPrivateKey = _cursor.getString(_cursorIndexOfPrivateKey);
            }
            _result = new OrganizationKeysEntity(_tmpUserId,_tmpPublicKey,_tmpPrivateKey);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, arg1);
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
