package me.proton.core.usersettings.data.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;
import me.proton.core.data.room.db.CommonConverters;
import me.proton.core.domain.entity.UserId;
import me.proton.core.usersettings.data.entity.OrganizationEntity;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class OrganizationDao_Impl extends OrganizationDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<OrganizationEntity> __insertionAdapterOfOrganizationEntity;

  private final CommonConverters __commonConverters = new CommonConverters();

  private final EntityDeletionOrUpdateAdapter<OrganizationEntity> __deletionAdapterOfOrganizationEntity;

  private final EntityDeletionOrUpdateAdapter<OrganizationEntity> __updateAdapterOfOrganizationEntity;

  private final SharedSQLiteStatement __preparedStmtOfDelete;

  private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

  public OrganizationDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfOrganizationEntity = new EntityInsertionAdapter<OrganizationEntity>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR IGNORE INTO `OrganizationEntity` (`userId`,`name`,`displayName`,`planName`,`twoFactorGracePeriod`,`theme`,`email`,`maxDomains`,`maxAddresses`,`maxSpace`,`maxMembers`,`maxVPN`,`maxCalendars`,`features`,`flags`,`usedDomains`,`usedAddresses`,`usedSpace`,`assignedSpace`,`usedMembers`,`usedVPN`,`usedCalendars`,`hasKeys`,`toMigrate`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, OrganizationEntity value) {
        final String _tmp = __commonConverters.fromUserIdToString(value.getUserId());
        if (_tmp == null) {
          stmt.bindNull(1);
        } else {
          stmt.bindString(1, _tmp);
        }
        if (value.getName() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getName());
        }
        if (value.getDisplayName() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getDisplayName());
        }
        if (value.getPlanName() == null) {
          stmt.bindNull(4);
        } else {
          stmt.bindString(4, value.getPlanName());
        }
        if (value.getTwoFactorGracePeriod() == null) {
          stmt.bindNull(5);
        } else {
          stmt.bindLong(5, value.getTwoFactorGracePeriod());
        }
        if (value.getTheme() == null) {
          stmt.bindNull(6);
        } else {
          stmt.bindString(6, value.getTheme());
        }
        if (value.getEmail() == null) {
          stmt.bindNull(7);
        } else {
          stmt.bindString(7, value.getEmail());
        }
        if (value.getMaxDomains() == null) {
          stmt.bindNull(8);
        } else {
          stmt.bindLong(8, value.getMaxDomains());
        }
        if (value.getMaxAddresses() == null) {
          stmt.bindNull(9);
        } else {
          stmt.bindLong(9, value.getMaxAddresses());
        }
        if (value.getMaxSpace() == null) {
          stmt.bindNull(10);
        } else {
          stmt.bindLong(10, value.getMaxSpace());
        }
        if (value.getMaxMembers() == null) {
          stmt.bindNull(11);
        } else {
          stmt.bindLong(11, value.getMaxMembers());
        }
        if (value.getMaxVPN() == null) {
          stmt.bindNull(12);
        } else {
          stmt.bindLong(12, value.getMaxVPN());
        }
        if (value.getMaxCalendars() == null) {
          stmt.bindNull(13);
        } else {
          stmt.bindLong(13, value.getMaxCalendars());
        }
        if (value.getFeatures() == null) {
          stmt.bindNull(14);
        } else {
          stmt.bindLong(14, value.getFeatures());
        }
        if (value.getFlags() == null) {
          stmt.bindNull(15);
        } else {
          stmt.bindLong(15, value.getFlags());
        }
        if (value.getUsedDomains() == null) {
          stmt.bindNull(16);
        } else {
          stmt.bindLong(16, value.getUsedDomains());
        }
        if (value.getUsedAddresses() == null) {
          stmt.bindNull(17);
        } else {
          stmt.bindLong(17, value.getUsedAddresses());
        }
        if (value.getUsedSpace() == null) {
          stmt.bindNull(18);
        } else {
          stmt.bindLong(18, value.getUsedSpace());
        }
        if (value.getAssignedSpace() == null) {
          stmt.bindNull(19);
        } else {
          stmt.bindLong(19, value.getAssignedSpace());
        }
        if (value.getUsedMembers() == null) {
          stmt.bindNull(20);
        } else {
          stmt.bindLong(20, value.getUsedMembers());
        }
        if (value.getUsedVPN() == null) {
          stmt.bindNull(21);
        } else {
          stmt.bindLong(21, value.getUsedVPN());
        }
        if (value.getUsedCalendars() == null) {
          stmt.bindNull(22);
        } else {
          stmt.bindLong(22, value.getUsedCalendars());
        }
        if (value.getHasKeys() == null) {
          stmt.bindNull(23);
        } else {
          stmt.bindLong(23, value.getHasKeys());
        }
        if (value.getToMigrate() == null) {
          stmt.bindNull(24);
        } else {
          stmt.bindLong(24, value.getToMigrate());
        }
      }
    };
    this.__deletionAdapterOfOrganizationEntity = new EntityDeletionOrUpdateAdapter<OrganizationEntity>(__db) {
      @Override
      public String createQuery() {
        return "DELETE FROM `OrganizationEntity` WHERE `userId` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, OrganizationEntity value) {
        final String _tmp = __commonConverters.fromUserIdToString(value.getUserId());
        if (_tmp == null) {
          stmt.bindNull(1);
        } else {
          stmt.bindString(1, _tmp);
        }
      }
    };
    this.__updateAdapterOfOrganizationEntity = new EntityDeletionOrUpdateAdapter<OrganizationEntity>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `OrganizationEntity` SET `userId` = ?,`name` = ?,`displayName` = ?,`planName` = ?,`twoFactorGracePeriod` = ?,`theme` = ?,`email` = ?,`maxDomains` = ?,`maxAddresses` = ?,`maxSpace` = ?,`maxMembers` = ?,`maxVPN` = ?,`maxCalendars` = ?,`features` = ?,`flags` = ?,`usedDomains` = ?,`usedAddresses` = ?,`usedSpace` = ?,`assignedSpace` = ?,`usedMembers` = ?,`usedVPN` = ?,`usedCalendars` = ?,`hasKeys` = ?,`toMigrate` = ? WHERE `userId` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, OrganizationEntity value) {
        final String _tmp = __commonConverters.fromUserIdToString(value.getUserId());
        if (_tmp == null) {
          stmt.bindNull(1);
        } else {
          stmt.bindString(1, _tmp);
        }
        if (value.getName() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getName());
        }
        if (value.getDisplayName() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getDisplayName());
        }
        if (value.getPlanName() == null) {
          stmt.bindNull(4);
        } else {
          stmt.bindString(4, value.getPlanName());
        }
        if (value.getTwoFactorGracePeriod() == null) {
          stmt.bindNull(5);
        } else {
          stmt.bindLong(5, value.getTwoFactorGracePeriod());
        }
        if (value.getTheme() == null) {
          stmt.bindNull(6);
        } else {
          stmt.bindString(6, value.getTheme());
        }
        if (value.getEmail() == null) {
          stmt.bindNull(7);
        } else {
          stmt.bindString(7, value.getEmail());
        }
        if (value.getMaxDomains() == null) {
          stmt.bindNull(8);
        } else {
          stmt.bindLong(8, value.getMaxDomains());
        }
        if (value.getMaxAddresses() == null) {
          stmt.bindNull(9);
        } else {
          stmt.bindLong(9, value.getMaxAddresses());
        }
        if (value.getMaxSpace() == null) {
          stmt.bindNull(10);
        } else {
          stmt.bindLong(10, value.getMaxSpace());
        }
        if (value.getMaxMembers() == null) {
          stmt.bindNull(11);
        } else {
          stmt.bindLong(11, value.getMaxMembers());
        }
        if (value.getMaxVPN() == null) {
          stmt.bindNull(12);
        } else {
          stmt.bindLong(12, value.getMaxVPN());
        }
        if (value.getMaxCalendars() == null) {
          stmt.bindNull(13);
        } else {
          stmt.bindLong(13, value.getMaxCalendars());
        }
        if (value.getFeatures() == null) {
          stmt.bindNull(14);
        } else {
          stmt.bindLong(14, value.getFeatures());
        }
        if (value.getFlags() == null) {
          stmt.bindNull(15);
        } else {
          stmt.bindLong(15, value.getFlags());
        }
        if (value.getUsedDomains() == null) {
          stmt.bindNull(16);
        } else {
          stmt.bindLong(16, value.getUsedDomains());
        }
        if (value.getUsedAddresses() == null) {
          stmt.bindNull(17);
        } else {
          stmt.bindLong(17, value.getUsedAddresses());
        }
        if (value.getUsedSpace() == null) {
          stmt.bindNull(18);
        } else {
          stmt.bindLong(18, value.getUsedSpace());
        }
        if (value.getAssignedSpace() == null) {
          stmt.bindNull(19);
        } else {
          stmt.bindLong(19, value.getAssignedSpace());
        }
        if (value.getUsedMembers() == null) {
          stmt.bindNull(20);
        } else {
          stmt.bindLong(20, value.getUsedMembers());
        }
        if (value.getUsedVPN() == null) {
          stmt.bindNull(21);
        } else {
          stmt.bindLong(21, value.getUsedVPN());
        }
        if (value.getUsedCalendars() == null) {
          stmt.bindNull(22);
        } else {
          stmt.bindLong(22, value.getUsedCalendars());
        }
        if (value.getHasKeys() == null) {
          stmt.bindNull(23);
        } else {
          stmt.bindLong(23, value.getHasKeys());
        }
        if (value.getToMigrate() == null) {
          stmt.bindNull(24);
        } else {
          stmt.bindLong(24, value.getToMigrate());
        }
        final String _tmp_1 = __commonConverters.fromUserIdToString(value.getUserId());
        if (_tmp_1 == null) {
          stmt.bindNull(25);
        } else {
          stmt.bindString(25, _tmp_1);
        }
      }
    };
    this.__preparedStmtOfDelete = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "DELETE FROM OrganizationEntity WHERE userId = ?";
        return _query;
      }
    };
    this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "DELETE FROM OrganizationEntity";
        return _query;
      }
    };
  }

  @Override
  public Object insertOrIgnore(final OrganizationEntity[] entities,
      final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfOrganizationEntity.insert(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object delete(final OrganizationEntity[] entities, final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __deletionAdapterOfOrganizationEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object update(final OrganizationEntity[] entities,
      final Continuation<? super Integer> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      public Integer call() throws Exception {
        int _total = 0;
        __db.beginTransaction();
        try {
          _total +=__updateAdapterOfOrganizationEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return _total;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object insertOrUpdate(final OrganizationEntity[] entities,
      final Continuation<? super Unit> $completion) {
    return RoomDatabaseKt.withTransaction(__db, (__cont) -> OrganizationDao_Impl.super.insertOrUpdate(entities, __cont), $completion);
  }

  @Override
  public Object delete(final UserId userId, final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDelete.acquire();
        int _argIndex = 1;
        final String _tmp = __commonConverters.fromUserIdToString(userId);
        if (_tmp == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, _tmp);
        }
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfDelete.release(_stmt);
        }
      }
    }, arg1);
  }

  @Override
  public Object deleteAll(final Continuation<? super Unit> arg0) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteAll.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfDeleteAll.release(_stmt);
        }
      }
    }, arg0);
  }

  @Override
  public Flow<OrganizationEntity> observeByUserId(final UserId userId) {
    final String _sql = "SELECT * FROM OrganizationEntity WHERE userId = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    final String _tmp = __commonConverters.fromUserIdToString(userId);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp);
    }
    return CoroutinesRoom.createFlow(__db, false, new String[]{"OrganizationEntity"}, new Callable<OrganizationEntity>() {
      @Override
      public OrganizationEntity call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
          final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "name");
          final int _cursorIndexOfDisplayName = CursorUtil.getColumnIndexOrThrow(_cursor, "displayName");
          final int _cursorIndexOfPlanName = CursorUtil.getColumnIndexOrThrow(_cursor, "planName");
          final int _cursorIndexOfTwoFactorGracePeriod = CursorUtil.getColumnIndexOrThrow(_cursor, "twoFactorGracePeriod");
          final int _cursorIndexOfTheme = CursorUtil.getColumnIndexOrThrow(_cursor, "theme");
          final int _cursorIndexOfEmail = CursorUtil.getColumnIndexOrThrow(_cursor, "email");
          final int _cursorIndexOfMaxDomains = CursorUtil.getColumnIndexOrThrow(_cursor, "maxDomains");
          final int _cursorIndexOfMaxAddresses = CursorUtil.getColumnIndexOrThrow(_cursor, "maxAddresses");
          final int _cursorIndexOfMaxSpace = CursorUtil.getColumnIndexOrThrow(_cursor, "maxSpace");
          final int _cursorIndexOfMaxMembers = CursorUtil.getColumnIndexOrThrow(_cursor, "maxMembers");
          final int _cursorIndexOfMaxVPN = CursorUtil.getColumnIndexOrThrow(_cursor, "maxVPN");
          final int _cursorIndexOfMaxCalendars = CursorUtil.getColumnIndexOrThrow(_cursor, "maxCalendars");
          final int _cursorIndexOfFeatures = CursorUtil.getColumnIndexOrThrow(_cursor, "features");
          final int _cursorIndexOfFlags = CursorUtil.getColumnIndexOrThrow(_cursor, "flags");
          final int _cursorIndexOfUsedDomains = CursorUtil.getColumnIndexOrThrow(_cursor, "usedDomains");
          final int _cursorIndexOfUsedAddresses = CursorUtil.getColumnIndexOrThrow(_cursor, "usedAddresses");
          final int _cursorIndexOfUsedSpace = CursorUtil.getColumnIndexOrThrow(_cursor, "usedSpace");
          final int _cursorIndexOfAssignedSpace = CursorUtil.getColumnIndexOrThrow(_cursor, "assignedSpace");
          final int _cursorIndexOfUsedMembers = CursorUtil.getColumnIndexOrThrow(_cursor, "usedMembers");
          final int _cursorIndexOfUsedVPN = CursorUtil.getColumnIndexOrThrow(_cursor, "usedVPN");
          final int _cursorIndexOfUsedCalendars = CursorUtil.getColumnIndexOrThrow(_cursor, "usedCalendars");
          final int _cursorIndexOfHasKeys = CursorUtil.getColumnIndexOrThrow(_cursor, "hasKeys");
          final int _cursorIndexOfToMigrate = CursorUtil.getColumnIndexOrThrow(_cursor, "toMigrate");
          final OrganizationEntity _result;
          if(_cursor.moveToFirst()) {
            final UserId _tmpUserId;
            final String _tmp_1;
            if (_cursor.isNull(_cursorIndexOfUserId)) {
              _tmp_1 = null;
            } else {
              _tmp_1 = _cursor.getString(_cursorIndexOfUserId);
            }
            _tmpUserId = __commonConverters.fromStringToUserId(_tmp_1);
            final String _tmpName;
            if (_cursor.isNull(_cursorIndexOfName)) {
              _tmpName = null;
            } else {
              _tmpName = _cursor.getString(_cursorIndexOfName);
            }
            final String _tmpDisplayName;
            if (_cursor.isNull(_cursorIndexOfDisplayName)) {
              _tmpDisplayName = null;
            } else {
              _tmpDisplayName = _cursor.getString(_cursorIndexOfDisplayName);
            }
            final String _tmpPlanName;
            if (_cursor.isNull(_cursorIndexOfPlanName)) {
              _tmpPlanName = null;
            } else {
              _tmpPlanName = _cursor.getString(_cursorIndexOfPlanName);
            }
            final Integer _tmpTwoFactorGracePeriod;
            if (_cursor.isNull(_cursorIndexOfTwoFactorGracePeriod)) {
              _tmpTwoFactorGracePeriod = null;
            } else {
              _tmpTwoFactorGracePeriod = _cursor.getInt(_cursorIndexOfTwoFactorGracePeriod);
            }
            final String _tmpTheme;
            if (_cursor.isNull(_cursorIndexOfTheme)) {
              _tmpTheme = null;
            } else {
              _tmpTheme = _cursor.getString(_cursorIndexOfTheme);
            }
            final String _tmpEmail;
            if (_cursor.isNull(_cursorIndexOfEmail)) {
              _tmpEmail = null;
            } else {
              _tmpEmail = _cursor.getString(_cursorIndexOfEmail);
            }
            final Integer _tmpMaxDomains;
            if (_cursor.isNull(_cursorIndexOfMaxDomains)) {
              _tmpMaxDomains = null;
            } else {
              _tmpMaxDomains = _cursor.getInt(_cursorIndexOfMaxDomains);
            }
            final Integer _tmpMaxAddresses;
            if (_cursor.isNull(_cursorIndexOfMaxAddresses)) {
              _tmpMaxAddresses = null;
            } else {
              _tmpMaxAddresses = _cursor.getInt(_cursorIndexOfMaxAddresses);
            }
            final Long _tmpMaxSpace;
            if (_cursor.isNull(_cursorIndexOfMaxSpace)) {
              _tmpMaxSpace = null;
            } else {
              _tmpMaxSpace = _cursor.getLong(_cursorIndexOfMaxSpace);
            }
            final Integer _tmpMaxMembers;
            if (_cursor.isNull(_cursorIndexOfMaxMembers)) {
              _tmpMaxMembers = null;
            } else {
              _tmpMaxMembers = _cursor.getInt(_cursorIndexOfMaxMembers);
            }
            final Integer _tmpMaxVPN;
            if (_cursor.isNull(_cursorIndexOfMaxVPN)) {
              _tmpMaxVPN = null;
            } else {
              _tmpMaxVPN = _cursor.getInt(_cursorIndexOfMaxVPN);
            }
            final Integer _tmpMaxCalendars;
            if (_cursor.isNull(_cursorIndexOfMaxCalendars)) {
              _tmpMaxCalendars = null;
            } else {
              _tmpMaxCalendars = _cursor.getInt(_cursorIndexOfMaxCalendars);
            }
            final Integer _tmpFeatures;
            if (_cursor.isNull(_cursorIndexOfFeatures)) {
              _tmpFeatures = null;
            } else {
              _tmpFeatures = _cursor.getInt(_cursorIndexOfFeatures);
            }
            final Integer _tmpFlags;
            if (_cursor.isNull(_cursorIndexOfFlags)) {
              _tmpFlags = null;
            } else {
              _tmpFlags = _cursor.getInt(_cursorIndexOfFlags);
            }
            final Integer _tmpUsedDomains;
            if (_cursor.isNull(_cursorIndexOfUsedDomains)) {
              _tmpUsedDomains = null;
            } else {
              _tmpUsedDomains = _cursor.getInt(_cursorIndexOfUsedDomains);
            }
            final Integer _tmpUsedAddresses;
            if (_cursor.isNull(_cursorIndexOfUsedAddresses)) {
              _tmpUsedAddresses = null;
            } else {
              _tmpUsedAddresses = _cursor.getInt(_cursorIndexOfUsedAddresses);
            }
            final Long _tmpUsedSpace;
            if (_cursor.isNull(_cursorIndexOfUsedSpace)) {
              _tmpUsedSpace = null;
            } else {
              _tmpUsedSpace = _cursor.getLong(_cursorIndexOfUsedSpace);
            }
            final Long _tmpAssignedSpace;
            if (_cursor.isNull(_cursorIndexOfAssignedSpace)) {
              _tmpAssignedSpace = null;
            } else {
              _tmpAssignedSpace = _cursor.getLong(_cursorIndexOfAssignedSpace);
            }
            final Integer _tmpUsedMembers;
            if (_cursor.isNull(_cursorIndexOfUsedMembers)) {
              _tmpUsedMembers = null;
            } else {
              _tmpUsedMembers = _cursor.getInt(_cursorIndexOfUsedMembers);
            }
            final Integer _tmpUsedVPN;
            if (_cursor.isNull(_cursorIndexOfUsedVPN)) {
              _tmpUsedVPN = null;
            } else {
              _tmpUsedVPN = _cursor.getInt(_cursorIndexOfUsedVPN);
            }
            final Integer _tmpUsedCalendars;
            if (_cursor.isNull(_cursorIndexOfUsedCalendars)) {
              _tmpUsedCalendars = null;
            } else {
              _tmpUsedCalendars = _cursor.getInt(_cursorIndexOfUsedCalendars);
            }
            final Integer _tmpHasKeys;
            if (_cursor.isNull(_cursorIndexOfHasKeys)) {
              _tmpHasKeys = null;
            } else {
              _tmpHasKeys = _cursor.getInt(_cursorIndexOfHasKeys);
            }
            final Integer _tmpToMigrate;
            if (_cursor.isNull(_cursorIndexOfToMigrate)) {
              _tmpToMigrate = null;
            } else {
              _tmpToMigrate = _cursor.getInt(_cursorIndexOfToMigrate);
            }
            _result = new OrganizationEntity(_tmpUserId,_tmpName,_tmpDisplayName,_tmpPlanName,_tmpTwoFactorGracePeriod,_tmpTheme,_tmpEmail,_tmpMaxDomains,_tmpMaxAddresses,_tmpMaxSpace,_tmpMaxMembers,_tmpMaxVPN,_tmpMaxCalendars,_tmpFeatures,_tmpFlags,_tmpUsedDomains,_tmpUsedAddresses,_tmpUsedSpace,_tmpAssignedSpace,_tmpUsedMembers,_tmpUsedVPN,_tmpUsedCalendars,_tmpHasKeys,_tmpToMigrate);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object getByUserId(final UserId userId,
      final Continuation<? super OrganizationEntity> arg1) {
    final String _sql = "SELECT * FROM OrganizationEntity WHERE userId = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    final String _tmp = __commonConverters.fromUserIdToString(userId);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp);
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<OrganizationEntity>() {
      @Override
      public OrganizationEntity call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
          final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "name");
          final int _cursorIndexOfDisplayName = CursorUtil.getColumnIndexOrThrow(_cursor, "displayName");
          final int _cursorIndexOfPlanName = CursorUtil.getColumnIndexOrThrow(_cursor, "planName");
          final int _cursorIndexOfTwoFactorGracePeriod = CursorUtil.getColumnIndexOrThrow(_cursor, "twoFactorGracePeriod");
          final int _cursorIndexOfTheme = CursorUtil.getColumnIndexOrThrow(_cursor, "theme");
          final int _cursorIndexOfEmail = CursorUtil.getColumnIndexOrThrow(_cursor, "email");
          final int _cursorIndexOfMaxDomains = CursorUtil.getColumnIndexOrThrow(_cursor, "maxDomains");
          final int _cursorIndexOfMaxAddresses = CursorUtil.getColumnIndexOrThrow(_cursor, "maxAddresses");
          final int _cursorIndexOfMaxSpace = CursorUtil.getColumnIndexOrThrow(_cursor, "maxSpace");
          final int _cursorIndexOfMaxMembers = CursorUtil.getColumnIndexOrThrow(_cursor, "maxMembers");
          final int _cursorIndexOfMaxVPN = CursorUtil.getColumnIndexOrThrow(_cursor, "maxVPN");
          final int _cursorIndexOfMaxCalendars = CursorUtil.getColumnIndexOrThrow(_cursor, "maxCalendars");
          final int _cursorIndexOfFeatures = CursorUtil.getColumnIndexOrThrow(_cursor, "features");
          final int _cursorIndexOfFlags = CursorUtil.getColumnIndexOrThrow(_cursor, "flags");
          final int _cursorIndexOfUsedDomains = CursorUtil.getColumnIndexOrThrow(_cursor, "usedDomains");
          final int _cursorIndexOfUsedAddresses = CursorUtil.getColumnIndexOrThrow(_cursor, "usedAddresses");
          final int _cursorIndexOfUsedSpace = CursorUtil.getColumnIndexOrThrow(_cursor, "usedSpace");
          final int _cursorIndexOfAssignedSpace = CursorUtil.getColumnIndexOrThrow(_cursor, "assignedSpace");
          final int _cursorIndexOfUsedMembers = CursorUtil.getColumnIndexOrThrow(_cursor, "usedMembers");
          final int _cursorIndexOfUsedVPN = CursorUtil.getColumnIndexOrThrow(_cursor, "usedVPN");
          final int _cursorIndexOfUsedCalendars = CursorUtil.getColumnIndexOrThrow(_cursor, "usedCalendars");
          final int _cursorIndexOfHasKeys = CursorUtil.getColumnIndexOrThrow(_cursor, "hasKeys");
          final int _cursorIndexOfToMigrate = CursorUtil.getColumnIndexOrThrow(_cursor, "toMigrate");
          final OrganizationEntity _result;
          if(_cursor.moveToFirst()) {
            final UserId _tmpUserId;
            final String _tmp_1;
            if (_cursor.isNull(_cursorIndexOfUserId)) {
              _tmp_1 = null;
            } else {
              _tmp_1 = _cursor.getString(_cursorIndexOfUserId);
            }
            _tmpUserId = __commonConverters.fromStringToUserId(_tmp_1);
            final String _tmpName;
            if (_cursor.isNull(_cursorIndexOfName)) {
              _tmpName = null;
            } else {
              _tmpName = _cursor.getString(_cursorIndexOfName);
            }
            final String _tmpDisplayName;
            if (_cursor.isNull(_cursorIndexOfDisplayName)) {
              _tmpDisplayName = null;
            } else {
              _tmpDisplayName = _cursor.getString(_cursorIndexOfDisplayName);
            }
            final String _tmpPlanName;
            if (_cursor.isNull(_cursorIndexOfPlanName)) {
              _tmpPlanName = null;
            } else {
              _tmpPlanName = _cursor.getString(_cursorIndexOfPlanName);
            }
            final Integer _tmpTwoFactorGracePeriod;
            if (_cursor.isNull(_cursorIndexOfTwoFactorGracePeriod)) {
              _tmpTwoFactorGracePeriod = null;
            } else {
              _tmpTwoFactorGracePeriod = _cursor.getInt(_cursorIndexOfTwoFactorGracePeriod);
            }
            final String _tmpTheme;
            if (_cursor.isNull(_cursorIndexOfTheme)) {
              _tmpTheme = null;
            } else {
              _tmpTheme = _cursor.getString(_cursorIndexOfTheme);
            }
            final String _tmpEmail;
            if (_cursor.isNull(_cursorIndexOfEmail)) {
              _tmpEmail = null;
            } else {
              _tmpEmail = _cursor.getString(_cursorIndexOfEmail);
            }
            final Integer _tmpMaxDomains;
            if (_cursor.isNull(_cursorIndexOfMaxDomains)) {
              _tmpMaxDomains = null;
            } else {
              _tmpMaxDomains = _cursor.getInt(_cursorIndexOfMaxDomains);
            }
            final Integer _tmpMaxAddresses;
            if (_cursor.isNull(_cursorIndexOfMaxAddresses)) {
              _tmpMaxAddresses = null;
            } else {
              _tmpMaxAddresses = _cursor.getInt(_cursorIndexOfMaxAddresses);
            }
            final Long _tmpMaxSpace;
            if (_cursor.isNull(_cursorIndexOfMaxSpace)) {
              _tmpMaxSpace = null;
            } else {
              _tmpMaxSpace = _cursor.getLong(_cursorIndexOfMaxSpace);
            }
            final Integer _tmpMaxMembers;
            if (_cursor.isNull(_cursorIndexOfMaxMembers)) {
              _tmpMaxMembers = null;
            } else {
              _tmpMaxMembers = _cursor.getInt(_cursorIndexOfMaxMembers);
            }
            final Integer _tmpMaxVPN;
            if (_cursor.isNull(_cursorIndexOfMaxVPN)) {
              _tmpMaxVPN = null;
            } else {
              _tmpMaxVPN = _cursor.getInt(_cursorIndexOfMaxVPN);
            }
            final Integer _tmpMaxCalendars;
            if (_cursor.isNull(_cursorIndexOfMaxCalendars)) {
              _tmpMaxCalendars = null;
            } else {
              _tmpMaxCalendars = _cursor.getInt(_cursorIndexOfMaxCalendars);
            }
            final Integer _tmpFeatures;
            if (_cursor.isNull(_cursorIndexOfFeatures)) {
              _tmpFeatures = null;
            } else {
              _tmpFeatures = _cursor.getInt(_cursorIndexOfFeatures);
            }
            final Integer _tmpFlags;
            if (_cursor.isNull(_cursorIndexOfFlags)) {
              _tmpFlags = null;
            } else {
              _tmpFlags = _cursor.getInt(_cursorIndexOfFlags);
            }
            final Integer _tmpUsedDomains;
            if (_cursor.isNull(_cursorIndexOfUsedDomains)) {
              _tmpUsedDomains = null;
            } else {
              _tmpUsedDomains = _cursor.getInt(_cursorIndexOfUsedDomains);
            }
            final Integer _tmpUsedAddresses;
            if (_cursor.isNull(_cursorIndexOfUsedAddresses)) {
              _tmpUsedAddresses = null;
            } else {
              _tmpUsedAddresses = _cursor.getInt(_cursorIndexOfUsedAddresses);
            }
            final Long _tmpUsedSpace;
            if (_cursor.isNull(_cursorIndexOfUsedSpace)) {
              _tmpUsedSpace = null;
            } else {
              _tmpUsedSpace = _cursor.getLong(_cursorIndexOfUsedSpace);
            }
            final Long _tmpAssignedSpace;
            if (_cursor.isNull(_cursorIndexOfAssignedSpace)) {
              _tmpAssignedSpace = null;
            } else {
              _tmpAssignedSpace = _cursor.getLong(_cursorIndexOfAssignedSpace);
            }
            final Integer _tmpUsedMembers;
            if (_cursor.isNull(_cursorIndexOfUsedMembers)) {
              _tmpUsedMembers = null;
            } else {
              _tmpUsedMembers = _cursor.getInt(_cursorIndexOfUsedMembers);
            }
            final Integer _tmpUsedVPN;
            if (_cursor.isNull(_cursorIndexOfUsedVPN)) {
              _tmpUsedVPN = null;
            } else {
              _tmpUsedVPN = _cursor.getInt(_cursorIndexOfUsedVPN);
            }
            final Integer _tmpUsedCalendars;
            if (_cursor.isNull(_cursorIndexOfUsedCalendars)) {
              _tmpUsedCalendars = null;
            } else {
              _tmpUsedCalendars = _cursor.getInt(_cursorIndexOfUsedCalendars);
            }
            final Integer _tmpHasKeys;
            if (_cursor.isNull(_cursorIndexOfHasKeys)) {
              _tmpHasKeys = null;
            } else {
              _tmpHasKeys = _cursor.getInt(_cursorIndexOfHasKeys);
            }
            final Integer _tmpToMigrate;
            if (_cursor.isNull(_cursorIndexOfToMigrate)) {
              _tmpToMigrate = null;
            } else {
              _tmpToMigrate = _cursor.getInt(_cursorIndexOfToMigrate);
            }
            _result = new OrganizationEntity(_tmpUserId,_tmpName,_tmpDisplayName,_tmpPlanName,_tmpTwoFactorGracePeriod,_tmpTheme,_tmpEmail,_tmpMaxDomains,_tmpMaxAddresses,_tmpMaxSpace,_tmpMaxMembers,_tmpMaxVPN,_tmpMaxCalendars,_tmpFeatures,_tmpFlags,_tmpUsedDomains,_tmpUsedAddresses,_tmpUsedSpace,_tmpAssignedSpace,_tmpUsedMembers,_tmpUsedVPN,_tmpUsedCalendars,_tmpHasKeys,_tmpToMigrate);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, arg1);
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
