package me.proton.core.user.data.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.collection.ArrayMap;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;
import me.proton.core.crypto.android.keystore.CryptoConverters;
import me.proton.core.crypto.common.keystore.EncryptedByteArray;
import me.proton.core.data.room.db.CommonConverters;
import me.proton.core.domain.entity.UserId;
import me.proton.core.key.domain.entity.key.KeyId;
import me.proton.core.network.domain.session.SessionId;
import me.proton.core.user.data.db.UserConverters;
import me.proton.core.user.data.entity.UserEntity;
import me.proton.core.user.data.entity.UserKeyEntity;
import me.proton.core.user.data.entity.UserRecoveryEntity;
import me.proton.core.user.data.entity.UserWithKeys;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class UserWithKeysDao_Impl extends UserWithKeysDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<UserEntity> __insertionAdapterOfUserEntity;

  private final CommonConverters __commonConverters = new CommonConverters();

  private final CryptoConverters __cryptoConverters = new CryptoConverters();

  private final EntityDeletionOrUpdateAdapter<UserEntity> __deletionAdapterOfUserEntity;

  private final EntityDeletionOrUpdateAdapter<UserEntity> __updateAdapterOfUserEntity;

  private final UserConverters __userConverters = new UserConverters();

  public UserWithKeysDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfUserEntity = new EntityInsertionAdapter<UserEntity>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR IGNORE INTO `UserEntity` (`userId`,`email`,`name`,`displayName`,`currency`,`credit`,`createdAtUtc`,`usedSpace`,`maxSpace`,`maxUpload`,`type`,`role`,`private`,`subscribed`,`services`,`delinquent`,`passphrase`,`maxBaseSpace`,`maxDriveSpace`,`usedBaseSpace`,`usedDriveSpace`,`recovery_state`,`recovery_startTime`,`recovery_endTime`,`recovery_sessionId`,`recovery_reason`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, UserEntity value) {
        final String _tmp = __commonConverters.fromUserIdToString(value.getUserId());
        if (_tmp == null) {
          stmt.bindNull(1);
        } else {
          stmt.bindString(1, _tmp);
        }
        if (value.getEmail() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getEmail());
        }
        if (value.getName() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getName());
        }
        if (value.getDisplayName() == null) {
          stmt.bindNull(4);
        } else {
          stmt.bindString(4, value.getDisplayName());
        }
        if (value.getCurrency() == null) {
          stmt.bindNull(5);
        } else {
          stmt.bindString(5, value.getCurrency());
        }
        stmt.bindLong(6, value.getCredit());
        stmt.bindLong(7, value.getCreatedAtUtc());
        stmt.bindLong(8, value.getUsedSpace());
        stmt.bindLong(9, value.getMaxSpace());
        stmt.bindLong(10, value.getMaxUpload());
        if (value.getType() == null) {
          stmt.bindNull(11);
        } else {
          stmt.bindLong(11, value.getType());
        }
        if (value.getRole() == null) {
          stmt.bindNull(12);
        } else {
          stmt.bindLong(12, value.getRole());
        }
        final int _tmp_1 = value.isPrivate() ? 1 : 0;
        stmt.bindLong(13, _tmp_1);
        stmt.bindLong(14, value.getSubscribed());
        stmt.bindLong(15, value.getServices());
        if (value.getDelinquent() == null) {
          stmt.bindNull(16);
        } else {
          stmt.bindLong(16, value.getDelinquent());
        }
        final byte[] _tmp_2 = __cryptoConverters.fromEncryptedByteArrayToByteArray(value.getPassphrase());
        if (_tmp_2 == null) {
          stmt.bindNull(17);
        } else {
          stmt.bindBlob(17, _tmp_2);
        }
        if (value.getMaxBaseSpace() == null) {
          stmt.bindNull(18);
        } else {
          stmt.bindLong(18, value.getMaxBaseSpace());
        }
        if (value.getMaxDriveSpace() == null) {
          stmt.bindNull(19);
        } else {
          stmt.bindLong(19, value.getMaxDriveSpace());
        }
        if (value.getUsedBaseSpace() == null) {
          stmt.bindNull(20);
        } else {
          stmt.bindLong(20, value.getUsedBaseSpace());
        }
        if (value.getUsedDriveSpace() == null) {
          stmt.bindNull(21);
        } else {
          stmt.bindLong(21, value.getUsedDriveSpace());
        }
        final UserRecoveryEntity _tmpRecovery = value.getRecovery();
        if(_tmpRecovery != null) {
          stmt.bindLong(22, _tmpRecovery.getState());
          stmt.bindLong(23, _tmpRecovery.getStartTime());
          stmt.bindLong(24, _tmpRecovery.getEndTime());
          final String _tmp_3 = __commonConverters.fromSessionIdToString(_tmpRecovery.getSessionId());
          if (_tmp_3 == null) {
            stmt.bindNull(25);
          } else {
            stmt.bindString(25, _tmp_3);
          }
          if (_tmpRecovery.getReason() == null) {
            stmt.bindNull(26);
          } else {
            stmt.bindLong(26, _tmpRecovery.getReason());
          }
        } else {
          stmt.bindNull(22);
          stmt.bindNull(23);
          stmt.bindNull(24);
          stmt.bindNull(25);
          stmt.bindNull(26);
        }
      }
    };
    this.__deletionAdapterOfUserEntity = new EntityDeletionOrUpdateAdapter<UserEntity>(__db) {
      @Override
      public String createQuery() {
        return "DELETE FROM `UserEntity` WHERE `userId` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, UserEntity value) {
        final String _tmp = __commonConverters.fromUserIdToString(value.getUserId());
        if (_tmp == null) {
          stmt.bindNull(1);
        } else {
          stmt.bindString(1, _tmp);
        }
      }
    };
    this.__updateAdapterOfUserEntity = new EntityDeletionOrUpdateAdapter<UserEntity>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `UserEntity` SET `userId` = ?,`email` = ?,`name` = ?,`displayName` = ?,`currency` = ?,`credit` = ?,`createdAtUtc` = ?,`usedSpace` = ?,`maxSpace` = ?,`maxUpload` = ?,`type` = ?,`role` = ?,`private` = ?,`subscribed` = ?,`services` = ?,`delinquent` = ?,`passphrase` = ?,`maxBaseSpace` = ?,`maxDriveSpace` = ?,`usedBaseSpace` = ?,`usedDriveSpace` = ?,`recovery_state` = ?,`recovery_startTime` = ?,`recovery_endTime` = ?,`recovery_sessionId` = ?,`recovery_reason` = ? WHERE `userId` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, UserEntity value) {
        final String _tmp = __commonConverters.fromUserIdToString(value.getUserId());
        if (_tmp == null) {
          stmt.bindNull(1);
        } else {
          stmt.bindString(1, _tmp);
        }
        if (value.getEmail() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getEmail());
        }
        if (value.getName() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getName());
        }
        if (value.getDisplayName() == null) {
          stmt.bindNull(4);
        } else {
          stmt.bindString(4, value.getDisplayName());
        }
        if (value.getCurrency() == null) {
          stmt.bindNull(5);
        } else {
          stmt.bindString(5, value.getCurrency());
        }
        stmt.bindLong(6, value.getCredit());
        stmt.bindLong(7, value.getCreatedAtUtc());
        stmt.bindLong(8, value.getUsedSpace());
        stmt.bindLong(9, value.getMaxSpace());
        stmt.bindLong(10, value.getMaxUpload());
        if (value.getType() == null) {
          stmt.bindNull(11);
        } else {
          stmt.bindLong(11, value.getType());
        }
        if (value.getRole() == null) {
          stmt.bindNull(12);
        } else {
          stmt.bindLong(12, value.getRole());
        }
        final int _tmp_1 = value.isPrivate() ? 1 : 0;
        stmt.bindLong(13, _tmp_1);
        stmt.bindLong(14, value.getSubscribed());
        stmt.bindLong(15, value.getServices());
        if (value.getDelinquent() == null) {
          stmt.bindNull(16);
        } else {
          stmt.bindLong(16, value.getDelinquent());
        }
        final byte[] _tmp_2 = __cryptoConverters.fromEncryptedByteArrayToByteArray(value.getPassphrase());
        if (_tmp_2 == null) {
          stmt.bindNull(17);
        } else {
          stmt.bindBlob(17, _tmp_2);
        }
        if (value.getMaxBaseSpace() == null) {
          stmt.bindNull(18);
        } else {
          stmt.bindLong(18, value.getMaxBaseSpace());
        }
        if (value.getMaxDriveSpace() == null) {
          stmt.bindNull(19);
        } else {
          stmt.bindLong(19, value.getMaxDriveSpace());
        }
        if (value.getUsedBaseSpace() == null) {
          stmt.bindNull(20);
        } else {
          stmt.bindLong(20, value.getUsedBaseSpace());
        }
        if (value.getUsedDriveSpace() == null) {
          stmt.bindNull(21);
        } else {
          stmt.bindLong(21, value.getUsedDriveSpace());
        }
        final UserRecoveryEntity _tmpRecovery = value.getRecovery();
        if(_tmpRecovery != null) {
          stmt.bindLong(22, _tmpRecovery.getState());
          stmt.bindLong(23, _tmpRecovery.getStartTime());
          stmt.bindLong(24, _tmpRecovery.getEndTime());
          final String _tmp_3 = __commonConverters.fromSessionIdToString(_tmpRecovery.getSessionId());
          if (_tmp_3 == null) {
            stmt.bindNull(25);
          } else {
            stmt.bindString(25, _tmp_3);
          }
          if (_tmpRecovery.getReason() == null) {
            stmt.bindNull(26);
          } else {
            stmt.bindLong(26, _tmpRecovery.getReason());
          }
        } else {
          stmt.bindNull(22);
          stmt.bindNull(23);
          stmt.bindNull(24);
          stmt.bindNull(25);
          stmt.bindNull(26);
        }
        final String _tmp_4 = __commonConverters.fromUserIdToString(value.getUserId());
        if (_tmp_4 == null) {
          stmt.bindNull(27);
        } else {
          stmt.bindString(27, _tmp_4);
        }
      }
    };
  }

  @Override
  public Object insertOrIgnore(final UserEntity[] entities, final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfUserEntity.insert(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object delete(final UserEntity[] entities, final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __deletionAdapterOfUserEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object update(final UserEntity[] entities, final Continuation<? super Integer> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      public Integer call() throws Exception {
        int _total = 0;
        __db.beginTransaction();
        try {
          _total +=__updateAdapterOfUserEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return _total;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object insertOrUpdate(final UserEntity[] entities,
      final Continuation<? super Unit> $completion) {
    return RoomDatabaseKt.withTransaction(__db, (__cont) -> UserWithKeysDao_Impl.super.insertOrUpdate(entities, __cont), $completion);
  }

  @Override
  public Flow<UserWithKeys> observeByUserId(final UserId userId) {
    final String _sql = "SELECT * FROM UserEntity WHERE userId = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    final String _tmp = __commonConverters.fromUserIdToString(userId);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp);
    }
    return CoroutinesRoom.createFlow(__db, true, new String[]{"UserKeyEntity","UserEntity"}, new Callable<UserWithKeys>() {
      @Override
      public UserWithKeys call() throws Exception {
        __db.beginTransaction();
        try {
          final Cursor _cursor = DBUtil.query(__db, _statement, true, null);
          try {
            final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
            final int _cursorIndexOfEmail = CursorUtil.getColumnIndexOrThrow(_cursor, "email");
            final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "name");
            final int _cursorIndexOfDisplayName = CursorUtil.getColumnIndexOrThrow(_cursor, "displayName");
            final int _cursorIndexOfCurrency = CursorUtil.getColumnIndexOrThrow(_cursor, "currency");
            final int _cursorIndexOfCredit = CursorUtil.getColumnIndexOrThrow(_cursor, "credit");
            final int _cursorIndexOfCreatedAtUtc = CursorUtil.getColumnIndexOrThrow(_cursor, "createdAtUtc");
            final int _cursorIndexOfUsedSpace = CursorUtil.getColumnIndexOrThrow(_cursor, "usedSpace");
            final int _cursorIndexOfMaxSpace = CursorUtil.getColumnIndexOrThrow(_cursor, "maxSpace");
            final int _cursorIndexOfMaxUpload = CursorUtil.getColumnIndexOrThrow(_cursor, "maxUpload");
            final int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow(_cursor, "type");
            final int _cursorIndexOfRole = CursorUtil.getColumnIndexOrThrow(_cursor, "role");
            final int _cursorIndexOfIsPrivate = CursorUtil.getColumnIndexOrThrow(_cursor, "private");
            final int _cursorIndexOfSubscribed = CursorUtil.getColumnIndexOrThrow(_cursor, "subscribed");
            final int _cursorIndexOfServices = CursorUtil.getColumnIndexOrThrow(_cursor, "services");
            final int _cursorIndexOfDelinquent = CursorUtil.getColumnIndexOrThrow(_cursor, "delinquent");
            final int _cursorIndexOfPassphrase = CursorUtil.getColumnIndexOrThrow(_cursor, "passphrase");
            final int _cursorIndexOfMaxBaseSpace = CursorUtil.getColumnIndexOrThrow(_cursor, "maxBaseSpace");
            final int _cursorIndexOfMaxDriveSpace = CursorUtil.getColumnIndexOrThrow(_cursor, "maxDriveSpace");
            final int _cursorIndexOfUsedBaseSpace = CursorUtil.getColumnIndexOrThrow(_cursor, "usedBaseSpace");
            final int _cursorIndexOfUsedDriveSpace = CursorUtil.getColumnIndexOrThrow(_cursor, "usedDriveSpace");
            final int _cursorIndexOfState = CursorUtil.getColumnIndexOrThrow(_cursor, "recovery_state");
            final int _cursorIndexOfStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "recovery_startTime");
            final int _cursorIndexOfEndTime = CursorUtil.getColumnIndexOrThrow(_cursor, "recovery_endTime");
            final int _cursorIndexOfSessionId = CursorUtil.getColumnIndexOrThrow(_cursor, "recovery_sessionId");
            final int _cursorIndexOfReason = CursorUtil.getColumnIndexOrThrow(_cursor, "recovery_reason");
            final ArrayMap<String, ArrayList<UserKeyEntity>> _collectionKeys = new ArrayMap<String, ArrayList<UserKeyEntity>>();
            while (_cursor.moveToNext()) {
              final String _tmpKey = _cursor.getString(_cursorIndexOfUserId);
              ArrayList<UserKeyEntity> _tmpKeysCollection = _collectionKeys.get(_tmpKey);
              if (_tmpKeysCollection == null) {
                _tmpKeysCollection = new ArrayList<UserKeyEntity>();
                _collectionKeys.put(_tmpKey, _tmpKeysCollection);
              }
            }
            _cursor.moveToPosition(-1);
            __fetchRelationshipUserKeyEntityAsmeProtonCoreUserDataEntityUserKeyEntity(_collectionKeys);
            final UserWithKeys _result;
            if(_cursor.moveToFirst()) {
              final UserEntity _tmpEntity;
              if (! (_cursor.isNull(_cursorIndexOfUserId) && _cursor.isNull(_cursorIndexOfEmail) && _cursor.isNull(_cursorIndexOfName) && _cursor.isNull(_cursorIndexOfDisplayName) && _cursor.isNull(_cursorIndexOfCurrency) && _cursor.isNull(_cursorIndexOfCredit) && _cursor.isNull(_cursorIndexOfCreatedAtUtc) && _cursor.isNull(_cursorIndexOfUsedSpace) && _cursor.isNull(_cursorIndexOfMaxSpace) && _cursor.isNull(_cursorIndexOfMaxUpload) && _cursor.isNull(_cursorIndexOfType) && _cursor.isNull(_cursorIndexOfRole) && _cursor.isNull(_cursorIndexOfIsPrivate) && _cursor.isNull(_cursorIndexOfSubscribed) && _cursor.isNull(_cursorIndexOfServices) && _cursor.isNull(_cursorIndexOfDelinquent) && _cursor.isNull(_cursorIndexOfPassphrase) && _cursor.isNull(_cursorIndexOfMaxBaseSpace) && _cursor.isNull(_cursorIndexOfMaxDriveSpace) && _cursor.isNull(_cursorIndexOfUsedBaseSpace) && _cursor.isNull(_cursorIndexOfUsedDriveSpace) && _cursor.isNull(_cursorIndexOfState) && _cursor.isNull(_cursorIndexOfStartTime) && _cursor.isNull(_cursorIndexOfEndTime) && _cursor.isNull(_cursorIndexOfSessionId) && _cursor.isNull(_cursorIndexOfReason))) {
                final UserId _tmpUserId;
                final String _tmp_1;
                if (_cursor.isNull(_cursorIndexOfUserId)) {
                  _tmp_1 = null;
                } else {
                  _tmp_1 = _cursor.getString(_cursorIndexOfUserId);
                }
                _tmpUserId = __commonConverters.fromStringToUserId(_tmp_1);
                final String _tmpEmail;
                if (_cursor.isNull(_cursorIndexOfEmail)) {
                  _tmpEmail = null;
                } else {
                  _tmpEmail = _cursor.getString(_cursorIndexOfEmail);
                }
                final String _tmpName;
                if (_cursor.isNull(_cursorIndexOfName)) {
                  _tmpName = null;
                } else {
                  _tmpName = _cursor.getString(_cursorIndexOfName);
                }
                final String _tmpDisplayName;
                if (_cursor.isNull(_cursorIndexOfDisplayName)) {
                  _tmpDisplayName = null;
                } else {
                  _tmpDisplayName = _cursor.getString(_cursorIndexOfDisplayName);
                }
                final String _tmpCurrency;
                if (_cursor.isNull(_cursorIndexOfCurrency)) {
                  _tmpCurrency = null;
                } else {
                  _tmpCurrency = _cursor.getString(_cursorIndexOfCurrency);
                }
                final int _tmpCredit;
                _tmpCredit = _cursor.getInt(_cursorIndexOfCredit);
                final long _tmpCreatedAtUtc;
                _tmpCreatedAtUtc = _cursor.getLong(_cursorIndexOfCreatedAtUtc);
                final long _tmpUsedSpace;
                _tmpUsedSpace = _cursor.getLong(_cursorIndexOfUsedSpace);
                final long _tmpMaxSpace;
                _tmpMaxSpace = _cursor.getLong(_cursorIndexOfMaxSpace);
                final long _tmpMaxUpload;
                _tmpMaxUpload = _cursor.getLong(_cursorIndexOfMaxUpload);
                final Integer _tmpType;
                if (_cursor.isNull(_cursorIndexOfType)) {
                  _tmpType = null;
                } else {
                  _tmpType = _cursor.getInt(_cursorIndexOfType);
                }
                final Integer _tmpRole;
                if (_cursor.isNull(_cursorIndexOfRole)) {
                  _tmpRole = null;
                } else {
                  _tmpRole = _cursor.getInt(_cursorIndexOfRole);
                }
                final boolean _tmpIsPrivate;
                final int _tmp_2;
                _tmp_2 = _cursor.getInt(_cursorIndexOfIsPrivate);
                _tmpIsPrivate = _tmp_2 != 0;
                final int _tmpSubscribed;
                _tmpSubscribed = _cursor.getInt(_cursorIndexOfSubscribed);
                final int _tmpServices;
                _tmpServices = _cursor.getInt(_cursorIndexOfServices);
                final Integer _tmpDelinquent;
                if (_cursor.isNull(_cursorIndexOfDelinquent)) {
                  _tmpDelinquent = null;
                } else {
                  _tmpDelinquent = _cursor.getInt(_cursorIndexOfDelinquent);
                }
                final EncryptedByteArray _tmpPassphrase;
                final byte[] _tmp_3;
                if (_cursor.isNull(_cursorIndexOfPassphrase)) {
                  _tmp_3 = null;
                } else {
                  _tmp_3 = _cursor.getBlob(_cursorIndexOfPassphrase);
                }
                _tmpPassphrase = __cryptoConverters.fromByteArrayToEncryptedByteArray(_tmp_3);
                final Long _tmpMaxBaseSpace;
                if (_cursor.isNull(_cursorIndexOfMaxBaseSpace)) {
                  _tmpMaxBaseSpace = null;
                } else {
                  _tmpMaxBaseSpace = _cursor.getLong(_cursorIndexOfMaxBaseSpace);
                }
                final Long _tmpMaxDriveSpace;
                if (_cursor.isNull(_cursorIndexOfMaxDriveSpace)) {
                  _tmpMaxDriveSpace = null;
                } else {
                  _tmpMaxDriveSpace = _cursor.getLong(_cursorIndexOfMaxDriveSpace);
                }
                final Long _tmpUsedBaseSpace;
                if (_cursor.isNull(_cursorIndexOfUsedBaseSpace)) {
                  _tmpUsedBaseSpace = null;
                } else {
                  _tmpUsedBaseSpace = _cursor.getLong(_cursorIndexOfUsedBaseSpace);
                }
                final Long _tmpUsedDriveSpace;
                if (_cursor.isNull(_cursorIndexOfUsedDriveSpace)) {
                  _tmpUsedDriveSpace = null;
                } else {
                  _tmpUsedDriveSpace = _cursor.getLong(_cursorIndexOfUsedDriveSpace);
                }
                final UserRecoveryEntity _tmpRecovery;
                if (! (_cursor.isNull(_cursorIndexOfState) && _cursor.isNull(_cursorIndexOfStartTime) && _cursor.isNull(_cursorIndexOfEndTime) && _cursor.isNull(_cursorIndexOfSessionId) && _cursor.isNull(_cursorIndexOfReason))) {
                  final int _tmpState;
                  _tmpState = _cursor.getInt(_cursorIndexOfState);
                  final long _tmpStartTime;
                  _tmpStartTime = _cursor.getLong(_cursorIndexOfStartTime);
                  final long _tmpEndTime;
                  _tmpEndTime = _cursor.getLong(_cursorIndexOfEndTime);
                  final SessionId _tmpSessionId;
                  final String _tmp_4;
                  if (_cursor.isNull(_cursorIndexOfSessionId)) {
                    _tmp_4 = null;
                  } else {
                    _tmp_4 = _cursor.getString(_cursorIndexOfSessionId);
                  }
                  _tmpSessionId = __commonConverters.fromStringToSessionId(_tmp_4);
                  final Integer _tmpReason;
                  if (_cursor.isNull(_cursorIndexOfReason)) {
                    _tmpReason = null;
                  } else {
                    _tmpReason = _cursor.getInt(_cursorIndexOfReason);
                  }
                  _tmpRecovery = new UserRecoveryEntity(_tmpState,_tmpStartTime,_tmpEndTime,_tmpSessionId,_tmpReason);
                }  else  {
                  _tmpRecovery = null;
                }
                _tmpEntity = new UserEntity(_tmpUserId,_tmpEmail,_tmpName,_tmpDisplayName,_tmpCurrency,_tmpCredit,_tmpCreatedAtUtc,_tmpUsedSpace,_tmpMaxSpace,_tmpMaxUpload,_tmpType,_tmpRole,_tmpIsPrivate,_tmpSubscribed,_tmpServices,_tmpDelinquent,_tmpRecovery,_tmpPassphrase,_tmpMaxBaseSpace,_tmpMaxDriveSpace,_tmpUsedBaseSpace,_tmpUsedDriveSpace);
              }  else  {
                _tmpEntity = null;
              }
              ArrayList<UserKeyEntity> _tmpKeysCollection_1 = null;
              final String _tmpKey_1 = _cursor.getString(_cursorIndexOfUserId);
              _tmpKeysCollection_1 = _collectionKeys.get(_tmpKey_1);
              if (_tmpKeysCollection_1 == null) {
                _tmpKeysCollection_1 = new ArrayList<UserKeyEntity>();
              }
              _result = new UserWithKeys(_tmpEntity,_tmpKeysCollection_1);
            } else {
              _result = null;
            }
            __db.setTransactionSuccessful();
            return _result;
          } finally {
            _cursor.close();
          }
        } finally {
          __db.endTransaction();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object getByUserId(final UserId userId, final Continuation<? super UserWithKeys> arg1) {
    final String _sql = "SELECT * FROM UserEntity WHERE userId = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    final String _tmp = __commonConverters.fromUserIdToString(userId);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp);
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, true, _cancellationSignal, new Callable<UserWithKeys>() {
      @Override
      public UserWithKeys call() throws Exception {
        __db.beginTransaction();
        try {
          final Cursor _cursor = DBUtil.query(__db, _statement, true, null);
          try {
            final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
            final int _cursorIndexOfEmail = CursorUtil.getColumnIndexOrThrow(_cursor, "email");
            final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "name");
            final int _cursorIndexOfDisplayName = CursorUtil.getColumnIndexOrThrow(_cursor, "displayName");
            final int _cursorIndexOfCurrency = CursorUtil.getColumnIndexOrThrow(_cursor, "currency");
            final int _cursorIndexOfCredit = CursorUtil.getColumnIndexOrThrow(_cursor, "credit");
            final int _cursorIndexOfCreatedAtUtc = CursorUtil.getColumnIndexOrThrow(_cursor, "createdAtUtc");
            final int _cursorIndexOfUsedSpace = CursorUtil.getColumnIndexOrThrow(_cursor, "usedSpace");
            final int _cursorIndexOfMaxSpace = CursorUtil.getColumnIndexOrThrow(_cursor, "maxSpace");
            final int _cursorIndexOfMaxUpload = CursorUtil.getColumnIndexOrThrow(_cursor, "maxUpload");
            final int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow(_cursor, "type");
            final int _cursorIndexOfRole = CursorUtil.getColumnIndexOrThrow(_cursor, "role");
            final int _cursorIndexOfIsPrivate = CursorUtil.getColumnIndexOrThrow(_cursor, "private");
            final int _cursorIndexOfSubscribed = CursorUtil.getColumnIndexOrThrow(_cursor, "subscribed");
            final int _cursorIndexOfServices = CursorUtil.getColumnIndexOrThrow(_cursor, "services");
            final int _cursorIndexOfDelinquent = CursorUtil.getColumnIndexOrThrow(_cursor, "delinquent");
            final int _cursorIndexOfPassphrase = CursorUtil.getColumnIndexOrThrow(_cursor, "passphrase");
            final int _cursorIndexOfMaxBaseSpace = CursorUtil.getColumnIndexOrThrow(_cursor, "maxBaseSpace");
            final int _cursorIndexOfMaxDriveSpace = CursorUtil.getColumnIndexOrThrow(_cursor, "maxDriveSpace");
            final int _cursorIndexOfUsedBaseSpace = CursorUtil.getColumnIndexOrThrow(_cursor, "usedBaseSpace");
            final int _cursorIndexOfUsedDriveSpace = CursorUtil.getColumnIndexOrThrow(_cursor, "usedDriveSpace");
            final int _cursorIndexOfState = CursorUtil.getColumnIndexOrThrow(_cursor, "recovery_state");
            final int _cursorIndexOfStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "recovery_startTime");
            final int _cursorIndexOfEndTime = CursorUtil.getColumnIndexOrThrow(_cursor, "recovery_endTime");
            final int _cursorIndexOfSessionId = CursorUtil.getColumnIndexOrThrow(_cursor, "recovery_sessionId");
            final int _cursorIndexOfReason = CursorUtil.getColumnIndexOrThrow(_cursor, "recovery_reason");
            final ArrayMap<String, ArrayList<UserKeyEntity>> _collectionKeys = new ArrayMap<String, ArrayList<UserKeyEntity>>();
            while (_cursor.moveToNext()) {
              final String _tmpKey = _cursor.getString(_cursorIndexOfUserId);
              ArrayList<UserKeyEntity> _tmpKeysCollection = _collectionKeys.get(_tmpKey);
              if (_tmpKeysCollection == null) {
                _tmpKeysCollection = new ArrayList<UserKeyEntity>();
                _collectionKeys.put(_tmpKey, _tmpKeysCollection);
              }
            }
            _cursor.moveToPosition(-1);
            __fetchRelationshipUserKeyEntityAsmeProtonCoreUserDataEntityUserKeyEntity(_collectionKeys);
            final UserWithKeys _result;
            if(_cursor.moveToFirst()) {
              final UserEntity _tmpEntity;
              if (! (_cursor.isNull(_cursorIndexOfUserId) && _cursor.isNull(_cursorIndexOfEmail) && _cursor.isNull(_cursorIndexOfName) && _cursor.isNull(_cursorIndexOfDisplayName) && _cursor.isNull(_cursorIndexOfCurrency) && _cursor.isNull(_cursorIndexOfCredit) && _cursor.isNull(_cursorIndexOfCreatedAtUtc) && _cursor.isNull(_cursorIndexOfUsedSpace) && _cursor.isNull(_cursorIndexOfMaxSpace) && _cursor.isNull(_cursorIndexOfMaxUpload) && _cursor.isNull(_cursorIndexOfType) && _cursor.isNull(_cursorIndexOfRole) && _cursor.isNull(_cursorIndexOfIsPrivate) && _cursor.isNull(_cursorIndexOfSubscribed) && _cursor.isNull(_cursorIndexOfServices) && _cursor.isNull(_cursorIndexOfDelinquent) && _cursor.isNull(_cursorIndexOfPassphrase) && _cursor.isNull(_cursorIndexOfMaxBaseSpace) && _cursor.isNull(_cursorIndexOfMaxDriveSpace) && _cursor.isNull(_cursorIndexOfUsedBaseSpace) && _cursor.isNull(_cursorIndexOfUsedDriveSpace) && _cursor.isNull(_cursorIndexOfState) && _cursor.isNull(_cursorIndexOfStartTime) && _cursor.isNull(_cursorIndexOfEndTime) && _cursor.isNull(_cursorIndexOfSessionId) && _cursor.isNull(_cursorIndexOfReason))) {
                final UserId _tmpUserId;
                final String _tmp_1;
                if (_cursor.isNull(_cursorIndexOfUserId)) {
                  _tmp_1 = null;
                } else {
                  _tmp_1 = _cursor.getString(_cursorIndexOfUserId);
                }
                _tmpUserId = __commonConverters.fromStringToUserId(_tmp_1);
                final String _tmpEmail;
                if (_cursor.isNull(_cursorIndexOfEmail)) {
                  _tmpEmail = null;
                } else {
                  _tmpEmail = _cursor.getString(_cursorIndexOfEmail);
                }
                final String _tmpName;
                if (_cursor.isNull(_cursorIndexOfName)) {
                  _tmpName = null;
                } else {
                  _tmpName = _cursor.getString(_cursorIndexOfName);
                }
                final String _tmpDisplayName;
                if (_cursor.isNull(_cursorIndexOfDisplayName)) {
                  _tmpDisplayName = null;
                } else {
                  _tmpDisplayName = _cursor.getString(_cursorIndexOfDisplayName);
                }
                final String _tmpCurrency;
                if (_cursor.isNull(_cursorIndexOfCurrency)) {
                  _tmpCurrency = null;
                } else {
                  _tmpCurrency = _cursor.getString(_cursorIndexOfCurrency);
                }
                final int _tmpCredit;
                _tmpCredit = _cursor.getInt(_cursorIndexOfCredit);
                final long _tmpCreatedAtUtc;
                _tmpCreatedAtUtc = _cursor.getLong(_cursorIndexOfCreatedAtUtc);
                final long _tmpUsedSpace;
                _tmpUsedSpace = _cursor.getLong(_cursorIndexOfUsedSpace);
                final long _tmpMaxSpace;
                _tmpMaxSpace = _cursor.getLong(_cursorIndexOfMaxSpace);
                final long _tmpMaxUpload;
                _tmpMaxUpload = _cursor.getLong(_cursorIndexOfMaxUpload);
                final Integer _tmpType;
                if (_cursor.isNull(_cursorIndexOfType)) {
                  _tmpType = null;
                } else {
                  _tmpType = _cursor.getInt(_cursorIndexOfType);
                }
                final Integer _tmpRole;
                if (_cursor.isNull(_cursorIndexOfRole)) {
                  _tmpRole = null;
                } else {
                  _tmpRole = _cursor.getInt(_cursorIndexOfRole);
                }
                final boolean _tmpIsPrivate;
                final int _tmp_2;
                _tmp_2 = _cursor.getInt(_cursorIndexOfIsPrivate);
                _tmpIsPrivate = _tmp_2 != 0;
                final int _tmpSubscribed;
                _tmpSubscribed = _cursor.getInt(_cursorIndexOfSubscribed);
                final int _tmpServices;
                _tmpServices = _cursor.getInt(_cursorIndexOfServices);
                final Integer _tmpDelinquent;
                if (_cursor.isNull(_cursorIndexOfDelinquent)) {
                  _tmpDelinquent = null;
                } else {
                  _tmpDelinquent = _cursor.getInt(_cursorIndexOfDelinquent);
                }
                final EncryptedByteArray _tmpPassphrase;
                final byte[] _tmp_3;
                if (_cursor.isNull(_cursorIndexOfPassphrase)) {
                  _tmp_3 = null;
                } else {
                  _tmp_3 = _cursor.getBlob(_cursorIndexOfPassphrase);
                }
                _tmpPassphrase = __cryptoConverters.fromByteArrayToEncryptedByteArray(_tmp_3);
                final Long _tmpMaxBaseSpace;
                if (_cursor.isNull(_cursorIndexOfMaxBaseSpace)) {
                  _tmpMaxBaseSpace = null;
                } else {
                  _tmpMaxBaseSpace = _cursor.getLong(_cursorIndexOfMaxBaseSpace);
                }
                final Long _tmpMaxDriveSpace;
                if (_cursor.isNull(_cursorIndexOfMaxDriveSpace)) {
                  _tmpMaxDriveSpace = null;
                } else {
                  _tmpMaxDriveSpace = _cursor.getLong(_cursorIndexOfMaxDriveSpace);
                }
                final Long _tmpUsedBaseSpace;
                if (_cursor.isNull(_cursorIndexOfUsedBaseSpace)) {
                  _tmpUsedBaseSpace = null;
                } else {
                  _tmpUsedBaseSpace = _cursor.getLong(_cursorIndexOfUsedBaseSpace);
                }
                final Long _tmpUsedDriveSpace;
                if (_cursor.isNull(_cursorIndexOfUsedDriveSpace)) {
                  _tmpUsedDriveSpace = null;
                } else {
                  _tmpUsedDriveSpace = _cursor.getLong(_cursorIndexOfUsedDriveSpace);
                }
                final UserRecoveryEntity _tmpRecovery;
                if (! (_cursor.isNull(_cursorIndexOfState) && _cursor.isNull(_cursorIndexOfStartTime) && _cursor.isNull(_cursorIndexOfEndTime) && _cursor.isNull(_cursorIndexOfSessionId) && _cursor.isNull(_cursorIndexOfReason))) {
                  final int _tmpState;
                  _tmpState = _cursor.getInt(_cursorIndexOfState);
                  final long _tmpStartTime;
                  _tmpStartTime = _cursor.getLong(_cursorIndexOfStartTime);
                  final long _tmpEndTime;
                  _tmpEndTime = _cursor.getLong(_cursorIndexOfEndTime);
                  final SessionId _tmpSessionId;
                  final String _tmp_4;
                  if (_cursor.isNull(_cursorIndexOfSessionId)) {
                    _tmp_4 = null;
                  } else {
                    _tmp_4 = _cursor.getString(_cursorIndexOfSessionId);
                  }
                  _tmpSessionId = __commonConverters.fromStringToSessionId(_tmp_4);
                  final Integer _tmpReason;
                  if (_cursor.isNull(_cursorIndexOfReason)) {
                    _tmpReason = null;
                  } else {
                    _tmpReason = _cursor.getInt(_cursorIndexOfReason);
                  }
                  _tmpRecovery = new UserRecoveryEntity(_tmpState,_tmpStartTime,_tmpEndTime,_tmpSessionId,_tmpReason);
                }  else  {
                  _tmpRecovery = null;
                }
                _tmpEntity = new UserEntity(_tmpUserId,_tmpEmail,_tmpName,_tmpDisplayName,_tmpCurrency,_tmpCredit,_tmpCreatedAtUtc,_tmpUsedSpace,_tmpMaxSpace,_tmpMaxUpload,_tmpType,_tmpRole,_tmpIsPrivate,_tmpSubscribed,_tmpServices,_tmpDelinquent,_tmpRecovery,_tmpPassphrase,_tmpMaxBaseSpace,_tmpMaxDriveSpace,_tmpUsedBaseSpace,_tmpUsedDriveSpace);
              }  else  {
                _tmpEntity = null;
              }
              ArrayList<UserKeyEntity> _tmpKeysCollection_1 = null;
              final String _tmpKey_1 = _cursor.getString(_cursorIndexOfUserId);
              _tmpKeysCollection_1 = _collectionKeys.get(_tmpKey_1);
              if (_tmpKeysCollection_1 == null) {
                _tmpKeysCollection_1 = new ArrayList<UserKeyEntity>();
              }
              _result = new UserWithKeys(_tmpEntity,_tmpKeysCollection_1);
            } else {
              _result = null;
            }
            __db.setTransactionSuccessful();
            return _result;
          } finally {
            _cursor.close();
            _statement.release();
          }
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }

  private void __fetchRelationshipUserKeyEntityAsmeProtonCoreUserDataEntityUserKeyEntity(
      final ArrayMap<String, ArrayList<UserKeyEntity>> _map) {
    final Set<String> __mapKeySet = _map.keySet();
    if (__mapKeySet.isEmpty()) {
      return;
    }
    // check if the size is too big, if so divide;
    if(_map.size() > RoomDatabase.MAX_BIND_PARAMETER_CNT) {
      ArrayMap<String, ArrayList<UserKeyEntity>> _tmpInnerMap = new ArrayMap<String, ArrayList<UserKeyEntity>>(androidx.room.RoomDatabase.MAX_BIND_PARAMETER_CNT);
      int _tmpIndex = 0;
      int _mapIndex = 0;
      final int _limit = _map.size();
      while(_mapIndex < _limit) {
        _tmpInnerMap.put(_map.keyAt(_mapIndex), _map.valueAt(_mapIndex));
        _mapIndex++;
        _tmpIndex++;
        if(_tmpIndex == RoomDatabase.MAX_BIND_PARAMETER_CNT) {
          __fetchRelationshipUserKeyEntityAsmeProtonCoreUserDataEntityUserKeyEntity(_tmpInnerMap);
          _tmpInnerMap = new ArrayMap<String, ArrayList<UserKeyEntity>>(RoomDatabase.MAX_BIND_PARAMETER_CNT);
          _tmpIndex = 0;
        }
      }
      if(_tmpIndex > 0) {
        __fetchRelationshipUserKeyEntityAsmeProtonCoreUserDataEntityUserKeyEntity(_tmpInnerMap);
      }
      return;
    }
    StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("SELECT `userId`,`keyId`,`version`,`privateKey`,`isPrimary`,`isUnlockable`,`fingerprint`,`activation`,`active`,`recoverySecret`,`recoverySecretSignature` FROM `UserKeyEntity` WHERE `userId` IN (");
    final int _inputSize = __mapKeySet.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(")");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 0 + _inputSize;
    final RoomSQLiteQuery _stmt = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    for (String _item : __mapKeySet) {
      if (_item == null) {
        _stmt.bindNull(_argIndex);
      } else {
        _stmt.bindString(_argIndex, _item);
      }
      _argIndex ++;
    }
    final Cursor _cursor = DBUtil.query(__db, _stmt, false, null);
    try {
      final int _itemKeyIndex = CursorUtil.getColumnIndex(_cursor, "userId");
      if (_itemKeyIndex == -1) {
        return;
      }
      final int _cursorIndexOfUserId = 0;
      final int _cursorIndexOfKeyId = 1;
      final int _cursorIndexOfVersion = 2;
      final int _cursorIndexOfPrivateKey = 3;
      final int _cursorIndexOfIsPrimary = 4;
      final int _cursorIndexOfIsUnlockable = 5;
      final int _cursorIndexOfFingerprint = 6;
      final int _cursorIndexOfActivation = 7;
      final int _cursorIndexOfActive = 8;
      final int _cursorIndexOfRecoverySecret = 9;
      final int _cursorIndexOfRecoverySecretSignature = 10;
      while(_cursor.moveToNext()) {
        final String _tmpKey = _cursor.getString(_itemKeyIndex);
        ArrayList<UserKeyEntity> _tmpRelation = _map.get(_tmpKey);
        if (_tmpRelation != null) {
          final UserKeyEntity _item_1;
          final UserId _tmpUserId;
          final String _tmp;
          if (_cursor.isNull(_cursorIndexOfUserId)) {
            _tmp = null;
          } else {
            _tmp = _cursor.getString(_cursorIndexOfUserId);
          }
          _tmpUserId = __commonConverters.fromStringToUserId(_tmp);
          final KeyId _tmpKeyId;
          final String _tmp_1;
          if (_cursor.isNull(_cursorIndexOfKeyId)) {
            _tmp_1 = null;
          } else {
            _tmp_1 = _cursor.getString(_cursorIndexOfKeyId);
          }
          _tmpKeyId = __userConverters.fromStringToKeyId(_tmp_1);
          final int _tmpVersion;
          _tmpVersion = _cursor.getInt(_cursorIndexOfVersion);
          final String _tmpPrivateKey;
          if (_cursor.isNull(_cursorIndexOfPrivateKey)) {
            _tmpPrivateKey = null;
          } else {
            _tmpPrivateKey = _cursor.getString(_cursorIndexOfPrivateKey);
          }
          final boolean _tmpIsPrimary;
          final int _tmp_2;
          _tmp_2 = _cursor.getInt(_cursorIndexOfIsPrimary);
          _tmpIsPrimary = _tmp_2 != 0;
          final boolean _tmpIsUnlockable;
          final int _tmp_3;
          _tmp_3 = _cursor.getInt(_cursorIndexOfIsUnlockable);
          _tmpIsUnlockable = _tmp_3 != 0;
          final String _tmpFingerprint;
          if (_cursor.isNull(_cursorIndexOfFingerprint)) {
            _tmpFingerprint = null;
          } else {
            _tmpFingerprint = _cursor.getString(_cursorIndexOfFingerprint);
          }
          final String _tmpActivation;
          if (_cursor.isNull(_cursorIndexOfActivation)) {
            _tmpActivation = null;
          } else {
            _tmpActivation = _cursor.getString(_cursorIndexOfActivation);
          }
          final Boolean _tmpActive;
          final Integer _tmp_4;
          if (_cursor.isNull(_cursorIndexOfActive)) {
            _tmp_4 = null;
          } else {
            _tmp_4 = _cursor.getInt(_cursorIndexOfActive);
          }
          _tmpActive = _tmp_4 == null ? null : _tmp_4 != 0;
          final String _tmpRecoverySecret;
          if (_cursor.isNull(_cursorIndexOfRecoverySecret)) {
            _tmpRecoverySecret = null;
          } else {
            _tmpRecoverySecret = _cursor.getString(_cursorIndexOfRecoverySecret);
          }
          final String _tmpRecoverySecretSignature;
          if (_cursor.isNull(_cursorIndexOfRecoverySecretSignature)) {
            _tmpRecoverySecretSignature = null;
          } else {
            _tmpRecoverySecretSignature = _cursor.getString(_cursorIndexOfRecoverySecretSignature);
          }
          _item_1 = new UserKeyEntity(_tmpUserId,_tmpKeyId,_tmpVersion,_tmpPrivateKey,_tmpIsPrimary,_tmpIsUnlockable,_tmpFingerprint,_tmpActivation,_tmpActive,_tmpRecoverySecret,_tmpRecoverySecretSignature);
          _tmpRelation.add(_item_1);
        }
      }
    } finally {
      _cursor.close();
    }
  }
}
