package me.proton.core.user.data.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;
import me.proton.core.crypto.android.keystore.CryptoConverters;
import me.proton.core.crypto.common.keystore.EncryptedByteArray;
import me.proton.core.data.room.db.CommonConverters;
import me.proton.core.domain.entity.UserId;
import me.proton.core.network.domain.session.SessionId;
import me.proton.core.user.data.entity.UserEntity;
import me.proton.core.user.data.entity.UserRecoveryEntity;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class UserDao_Impl extends UserDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<UserEntity> __insertionAdapterOfUserEntity;

  private final CommonConverters __commonConverters = new CommonConverters();

  private final CryptoConverters __cryptoConverters = new CryptoConverters();

  private final EntityDeletionOrUpdateAdapter<UserEntity> __deletionAdapterOfUserEntity;

  private final EntityDeletionOrUpdateAdapter<UserEntity> __updateAdapterOfUserEntity;

  private final SharedSQLiteStatement __preparedStmtOfSetPassphrase;

  private final SharedSQLiteStatement __preparedStmtOfSetUsedSpace;

  private final SharedSQLiteStatement __preparedStmtOfSetUsedBaseSpace;

  private final SharedSQLiteStatement __preparedStmtOfSetUsedDriveSpace;

  public UserDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfUserEntity = new EntityInsertionAdapter<UserEntity>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR IGNORE INTO `UserEntity` (`userId`,`email`,`name`,`displayName`,`currency`,`credit`,`createdAtUtc`,`usedSpace`,`maxSpace`,`maxUpload`,`type`,`role`,`private`,`subscribed`,`services`,`delinquent`,`passphrase`,`maxBaseSpace`,`maxDriveSpace`,`usedBaseSpace`,`usedDriveSpace`,`recovery_state`,`recovery_startTime`,`recovery_endTime`,`recovery_sessionId`,`recovery_reason`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, UserEntity value) {
        final String _tmp = __commonConverters.fromUserIdToString(value.getUserId());
        if (_tmp == null) {
          stmt.bindNull(1);
        } else {
          stmt.bindString(1, _tmp);
        }
        if (value.getEmail() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getEmail());
        }
        if (value.getName() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getName());
        }
        if (value.getDisplayName() == null) {
          stmt.bindNull(4);
        } else {
          stmt.bindString(4, value.getDisplayName());
        }
        if (value.getCurrency() == null) {
          stmt.bindNull(5);
        } else {
          stmt.bindString(5, value.getCurrency());
        }
        stmt.bindLong(6, value.getCredit());
        stmt.bindLong(7, value.getCreatedAtUtc());
        stmt.bindLong(8, value.getUsedSpace());
        stmt.bindLong(9, value.getMaxSpace());
        stmt.bindLong(10, value.getMaxUpload());
        if (value.getType() == null) {
          stmt.bindNull(11);
        } else {
          stmt.bindLong(11, value.getType());
        }
        if (value.getRole() == null) {
          stmt.bindNull(12);
        } else {
          stmt.bindLong(12, value.getRole());
        }
        final int _tmp_1 = value.isPrivate() ? 1 : 0;
        stmt.bindLong(13, _tmp_1);
        stmt.bindLong(14, value.getSubscribed());
        stmt.bindLong(15, value.getServices());
        if (value.getDelinquent() == null) {
          stmt.bindNull(16);
        } else {
          stmt.bindLong(16, value.getDelinquent());
        }
        final byte[] _tmp_2 = __cryptoConverters.fromEncryptedByteArrayToByteArray(value.getPassphrase());
        if (_tmp_2 == null) {
          stmt.bindNull(17);
        } else {
          stmt.bindBlob(17, _tmp_2);
        }
        if (value.getMaxBaseSpace() == null) {
          stmt.bindNull(18);
        } else {
          stmt.bindLong(18, value.getMaxBaseSpace());
        }
        if (value.getMaxDriveSpace() == null) {
          stmt.bindNull(19);
        } else {
          stmt.bindLong(19, value.getMaxDriveSpace());
        }
        if (value.getUsedBaseSpace() == null) {
          stmt.bindNull(20);
        } else {
          stmt.bindLong(20, value.getUsedBaseSpace());
        }
        if (value.getUsedDriveSpace() == null) {
          stmt.bindNull(21);
        } else {
          stmt.bindLong(21, value.getUsedDriveSpace());
        }
        final UserRecoveryEntity _tmpRecovery = value.getRecovery();
        if(_tmpRecovery != null) {
          stmt.bindLong(22, _tmpRecovery.getState());
          stmt.bindLong(23, _tmpRecovery.getStartTime());
          stmt.bindLong(24, _tmpRecovery.getEndTime());
          final String _tmp_3 = __commonConverters.fromSessionIdToString(_tmpRecovery.getSessionId());
          if (_tmp_3 == null) {
            stmt.bindNull(25);
          } else {
            stmt.bindString(25, _tmp_3);
          }
          if (_tmpRecovery.getReason() == null) {
            stmt.bindNull(26);
          } else {
            stmt.bindLong(26, _tmpRecovery.getReason());
          }
        } else {
          stmt.bindNull(22);
          stmt.bindNull(23);
          stmt.bindNull(24);
          stmt.bindNull(25);
          stmt.bindNull(26);
        }
      }
    };
    this.__deletionAdapterOfUserEntity = new EntityDeletionOrUpdateAdapter<UserEntity>(__db) {
      @Override
      public String createQuery() {
        return "DELETE FROM `UserEntity` WHERE `userId` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, UserEntity value) {
        final String _tmp = __commonConverters.fromUserIdToString(value.getUserId());
        if (_tmp == null) {
          stmt.bindNull(1);
        } else {
          stmt.bindString(1, _tmp);
        }
      }
    };
    this.__updateAdapterOfUserEntity = new EntityDeletionOrUpdateAdapter<UserEntity>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `UserEntity` SET `userId` = ?,`email` = ?,`name` = ?,`displayName` = ?,`currency` = ?,`credit` = ?,`createdAtUtc` = ?,`usedSpace` = ?,`maxSpace` = ?,`maxUpload` = ?,`type` = ?,`role` = ?,`private` = ?,`subscribed` = ?,`services` = ?,`delinquent` = ?,`passphrase` = ?,`maxBaseSpace` = ?,`maxDriveSpace` = ?,`usedBaseSpace` = ?,`usedDriveSpace` = ?,`recovery_state` = ?,`recovery_startTime` = ?,`recovery_endTime` = ?,`recovery_sessionId` = ?,`recovery_reason` = ? WHERE `userId` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, UserEntity value) {
        final String _tmp = __commonConverters.fromUserIdToString(value.getUserId());
        if (_tmp == null) {
          stmt.bindNull(1);
        } else {
          stmt.bindString(1, _tmp);
        }
        if (value.getEmail() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getEmail());
        }
        if (value.getName() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getName());
        }
        if (value.getDisplayName() == null) {
          stmt.bindNull(4);
        } else {
          stmt.bindString(4, value.getDisplayName());
        }
        if (value.getCurrency() == null) {
          stmt.bindNull(5);
        } else {
          stmt.bindString(5, value.getCurrency());
        }
        stmt.bindLong(6, value.getCredit());
        stmt.bindLong(7, value.getCreatedAtUtc());
        stmt.bindLong(8, value.getUsedSpace());
        stmt.bindLong(9, value.getMaxSpace());
        stmt.bindLong(10, value.getMaxUpload());
        if (value.getType() == null) {
          stmt.bindNull(11);
        } else {
          stmt.bindLong(11, value.getType());
        }
        if (value.getRole() == null) {
          stmt.bindNull(12);
        } else {
          stmt.bindLong(12, value.getRole());
        }
        final int _tmp_1 = value.isPrivate() ? 1 : 0;
        stmt.bindLong(13, _tmp_1);
        stmt.bindLong(14, value.getSubscribed());
        stmt.bindLong(15, value.getServices());
        if (value.getDelinquent() == null) {
          stmt.bindNull(16);
        } else {
          stmt.bindLong(16, value.getDelinquent());
        }
        final byte[] _tmp_2 = __cryptoConverters.fromEncryptedByteArrayToByteArray(value.getPassphrase());
        if (_tmp_2 == null) {
          stmt.bindNull(17);
        } else {
          stmt.bindBlob(17, _tmp_2);
        }
        if (value.getMaxBaseSpace() == null) {
          stmt.bindNull(18);
        } else {
          stmt.bindLong(18, value.getMaxBaseSpace());
        }
        if (value.getMaxDriveSpace() == null) {
          stmt.bindNull(19);
        } else {
          stmt.bindLong(19, value.getMaxDriveSpace());
        }
        if (value.getUsedBaseSpace() == null) {
          stmt.bindNull(20);
        } else {
          stmt.bindLong(20, value.getUsedBaseSpace());
        }
        if (value.getUsedDriveSpace() == null) {
          stmt.bindNull(21);
        } else {
          stmt.bindLong(21, value.getUsedDriveSpace());
        }
        final UserRecoveryEntity _tmpRecovery = value.getRecovery();
        if(_tmpRecovery != null) {
          stmt.bindLong(22, _tmpRecovery.getState());
          stmt.bindLong(23, _tmpRecovery.getStartTime());
          stmt.bindLong(24, _tmpRecovery.getEndTime());
          final String _tmp_3 = __commonConverters.fromSessionIdToString(_tmpRecovery.getSessionId());
          if (_tmp_3 == null) {
            stmt.bindNull(25);
          } else {
            stmt.bindString(25, _tmp_3);
          }
          if (_tmpRecovery.getReason() == null) {
            stmt.bindNull(26);
          } else {
            stmt.bindLong(26, _tmpRecovery.getReason());
          }
        } else {
          stmt.bindNull(22);
          stmt.bindNull(23);
          stmt.bindNull(24);
          stmt.bindNull(25);
          stmt.bindNull(26);
        }
        final String _tmp_4 = __commonConverters.fromUserIdToString(value.getUserId());
        if (_tmp_4 == null) {
          stmt.bindNull(27);
        } else {
          stmt.bindString(27, _tmp_4);
        }
      }
    };
    this.__preparedStmtOfSetPassphrase = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "UPDATE UserEntity SET passphrase = ? WHERE userId = ?";
        return _query;
      }
    };
    this.__preparedStmtOfSetUsedSpace = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "UPDATE UserEntity SET usedSpace = ? WHERE userId = ?";
        return _query;
      }
    };
    this.__preparedStmtOfSetUsedBaseSpace = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "UPDATE UserEntity SET usedBaseSpace = ? WHERE userId = ?";
        return _query;
      }
    };
    this.__preparedStmtOfSetUsedDriveSpace = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "UPDATE UserEntity SET usedDriveSpace = ? WHERE userId = ?";
        return _query;
      }
    };
  }

  @Override
  public Object insertOrIgnore(final UserEntity[] entities, final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfUserEntity.insert(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object delete(final UserEntity[] entities, final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __deletionAdapterOfUserEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object update(final UserEntity[] entities, final Continuation<? super Integer> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      public Integer call() throws Exception {
        int _total = 0;
        __db.beginTransaction();
        try {
          _total +=__updateAdapterOfUserEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return _total;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object insertOrUpdate(final UserEntity[] entities,
      final Continuation<? super Unit> $completion) {
    return RoomDatabaseKt.withTransaction(__db, (__cont) -> UserDao_Impl.super.insertOrUpdate(entities, __cont), $completion);
  }

  @Override
  public Object setPassphrase(final UserId userId, final EncryptedByteArray passphrase,
      final Continuation<? super Unit> arg2) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfSetPassphrase.acquire();
        int _argIndex = 1;
        final byte[] _tmp = __cryptoConverters.fromEncryptedByteArrayToByteArray(passphrase);
        if (_tmp == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindBlob(_argIndex, _tmp);
        }
        _argIndex = 2;
        final String _tmp_1 = __commonConverters.fromUserIdToString(userId);
        if (_tmp_1 == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, _tmp_1);
        }
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfSetPassphrase.release(_stmt);
        }
      }
    }, arg2);
  }

  @Override
  public Object setUsedSpace(final UserId userId, final long usedSpace,
      final Continuation<? super Unit> arg2) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfSetUsedSpace.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, usedSpace);
        _argIndex = 2;
        final String _tmp = __commonConverters.fromUserIdToString(userId);
        if (_tmp == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, _tmp);
        }
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfSetUsedSpace.release(_stmt);
        }
      }
    }, arg2);
  }

  @Override
  public Object setUsedBaseSpace(final UserId userId, final long usedBaseSpace,
      final Continuation<? super Unit> arg2) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfSetUsedBaseSpace.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, usedBaseSpace);
        _argIndex = 2;
        final String _tmp = __commonConverters.fromUserIdToString(userId);
        if (_tmp == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, _tmp);
        }
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfSetUsedBaseSpace.release(_stmt);
        }
      }
    }, arg2);
  }

  @Override
  public Object setUsedDriveSpace(final UserId userId, final long usedDriveSpace,
      final Continuation<? super Unit> arg2) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfSetUsedDriveSpace.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, usedDriveSpace);
        _argIndex = 2;
        final String _tmp = __commonConverters.fromUserIdToString(userId);
        if (_tmp == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, _tmp);
        }
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfSetUsedDriveSpace.release(_stmt);
        }
      }
    }, arg2);
  }

  @Override
  public Flow<UserEntity> observeByUserId(final UserId userId) {
    final String _sql = "SELECT * FROM UserEntity WHERE userId = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    final String _tmp = __commonConverters.fromUserIdToString(userId);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp);
    }
    return CoroutinesRoom.createFlow(__db, false, new String[]{"UserEntity"}, new Callable<UserEntity>() {
      @Override
      public UserEntity call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
          final int _cursorIndexOfEmail = CursorUtil.getColumnIndexOrThrow(_cursor, "email");
          final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "name");
          final int _cursorIndexOfDisplayName = CursorUtil.getColumnIndexOrThrow(_cursor, "displayName");
          final int _cursorIndexOfCurrency = CursorUtil.getColumnIndexOrThrow(_cursor, "currency");
          final int _cursorIndexOfCredit = CursorUtil.getColumnIndexOrThrow(_cursor, "credit");
          final int _cursorIndexOfCreatedAtUtc = CursorUtil.getColumnIndexOrThrow(_cursor, "createdAtUtc");
          final int _cursorIndexOfUsedSpace = CursorUtil.getColumnIndexOrThrow(_cursor, "usedSpace");
          final int _cursorIndexOfMaxSpace = CursorUtil.getColumnIndexOrThrow(_cursor, "maxSpace");
          final int _cursorIndexOfMaxUpload = CursorUtil.getColumnIndexOrThrow(_cursor, "maxUpload");
          final int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow(_cursor, "type");
          final int _cursorIndexOfRole = CursorUtil.getColumnIndexOrThrow(_cursor, "role");
          final int _cursorIndexOfIsPrivate = CursorUtil.getColumnIndexOrThrow(_cursor, "private");
          final int _cursorIndexOfSubscribed = CursorUtil.getColumnIndexOrThrow(_cursor, "subscribed");
          final int _cursorIndexOfServices = CursorUtil.getColumnIndexOrThrow(_cursor, "services");
          final int _cursorIndexOfDelinquent = CursorUtil.getColumnIndexOrThrow(_cursor, "delinquent");
          final int _cursorIndexOfPassphrase = CursorUtil.getColumnIndexOrThrow(_cursor, "passphrase");
          final int _cursorIndexOfMaxBaseSpace = CursorUtil.getColumnIndexOrThrow(_cursor, "maxBaseSpace");
          final int _cursorIndexOfMaxDriveSpace = CursorUtil.getColumnIndexOrThrow(_cursor, "maxDriveSpace");
          final int _cursorIndexOfUsedBaseSpace = CursorUtil.getColumnIndexOrThrow(_cursor, "usedBaseSpace");
          final int _cursorIndexOfUsedDriveSpace = CursorUtil.getColumnIndexOrThrow(_cursor, "usedDriveSpace");
          final int _cursorIndexOfState = CursorUtil.getColumnIndexOrThrow(_cursor, "recovery_state");
          final int _cursorIndexOfStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "recovery_startTime");
          final int _cursorIndexOfEndTime = CursorUtil.getColumnIndexOrThrow(_cursor, "recovery_endTime");
          final int _cursorIndexOfSessionId = CursorUtil.getColumnIndexOrThrow(_cursor, "recovery_sessionId");
          final int _cursorIndexOfReason = CursorUtil.getColumnIndexOrThrow(_cursor, "recovery_reason");
          final UserEntity _result;
          if(_cursor.moveToFirst()) {
            final UserId _tmpUserId;
            final String _tmp_1;
            if (_cursor.isNull(_cursorIndexOfUserId)) {
              _tmp_1 = null;
            } else {
              _tmp_1 = _cursor.getString(_cursorIndexOfUserId);
            }
            _tmpUserId = __commonConverters.fromStringToUserId(_tmp_1);
            final String _tmpEmail;
            if (_cursor.isNull(_cursorIndexOfEmail)) {
              _tmpEmail = null;
            } else {
              _tmpEmail = _cursor.getString(_cursorIndexOfEmail);
            }
            final String _tmpName;
            if (_cursor.isNull(_cursorIndexOfName)) {
              _tmpName = null;
            } else {
              _tmpName = _cursor.getString(_cursorIndexOfName);
            }
            final String _tmpDisplayName;
            if (_cursor.isNull(_cursorIndexOfDisplayName)) {
              _tmpDisplayName = null;
            } else {
              _tmpDisplayName = _cursor.getString(_cursorIndexOfDisplayName);
            }
            final String _tmpCurrency;
            if (_cursor.isNull(_cursorIndexOfCurrency)) {
              _tmpCurrency = null;
            } else {
              _tmpCurrency = _cursor.getString(_cursorIndexOfCurrency);
            }
            final int _tmpCredit;
            _tmpCredit = _cursor.getInt(_cursorIndexOfCredit);
            final long _tmpCreatedAtUtc;
            _tmpCreatedAtUtc = _cursor.getLong(_cursorIndexOfCreatedAtUtc);
            final long _tmpUsedSpace;
            _tmpUsedSpace = _cursor.getLong(_cursorIndexOfUsedSpace);
            final long _tmpMaxSpace;
            _tmpMaxSpace = _cursor.getLong(_cursorIndexOfMaxSpace);
            final long _tmpMaxUpload;
            _tmpMaxUpload = _cursor.getLong(_cursorIndexOfMaxUpload);
            final Integer _tmpType;
            if (_cursor.isNull(_cursorIndexOfType)) {
              _tmpType = null;
            } else {
              _tmpType = _cursor.getInt(_cursorIndexOfType);
            }
            final Integer _tmpRole;
            if (_cursor.isNull(_cursorIndexOfRole)) {
              _tmpRole = null;
            } else {
              _tmpRole = _cursor.getInt(_cursorIndexOfRole);
            }
            final boolean _tmpIsPrivate;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfIsPrivate);
            _tmpIsPrivate = _tmp_2 != 0;
            final int _tmpSubscribed;
            _tmpSubscribed = _cursor.getInt(_cursorIndexOfSubscribed);
            final int _tmpServices;
            _tmpServices = _cursor.getInt(_cursorIndexOfServices);
            final Integer _tmpDelinquent;
            if (_cursor.isNull(_cursorIndexOfDelinquent)) {
              _tmpDelinquent = null;
            } else {
              _tmpDelinquent = _cursor.getInt(_cursorIndexOfDelinquent);
            }
            final EncryptedByteArray _tmpPassphrase;
            final byte[] _tmp_3;
            if (_cursor.isNull(_cursorIndexOfPassphrase)) {
              _tmp_3 = null;
            } else {
              _tmp_3 = _cursor.getBlob(_cursorIndexOfPassphrase);
            }
            _tmpPassphrase = __cryptoConverters.fromByteArrayToEncryptedByteArray(_tmp_3);
            final Long _tmpMaxBaseSpace;
            if (_cursor.isNull(_cursorIndexOfMaxBaseSpace)) {
              _tmpMaxBaseSpace = null;
            } else {
              _tmpMaxBaseSpace = _cursor.getLong(_cursorIndexOfMaxBaseSpace);
            }
            final Long _tmpMaxDriveSpace;
            if (_cursor.isNull(_cursorIndexOfMaxDriveSpace)) {
              _tmpMaxDriveSpace = null;
            } else {
              _tmpMaxDriveSpace = _cursor.getLong(_cursorIndexOfMaxDriveSpace);
            }
            final Long _tmpUsedBaseSpace;
            if (_cursor.isNull(_cursorIndexOfUsedBaseSpace)) {
              _tmpUsedBaseSpace = null;
            } else {
              _tmpUsedBaseSpace = _cursor.getLong(_cursorIndexOfUsedBaseSpace);
            }
            final Long _tmpUsedDriveSpace;
            if (_cursor.isNull(_cursorIndexOfUsedDriveSpace)) {
              _tmpUsedDriveSpace = null;
            } else {
              _tmpUsedDriveSpace = _cursor.getLong(_cursorIndexOfUsedDriveSpace);
            }
            final UserRecoveryEntity _tmpRecovery;
            if (! (_cursor.isNull(_cursorIndexOfState) && _cursor.isNull(_cursorIndexOfStartTime) && _cursor.isNull(_cursorIndexOfEndTime) && _cursor.isNull(_cursorIndexOfSessionId) && _cursor.isNull(_cursorIndexOfReason))) {
              final int _tmpState;
              _tmpState = _cursor.getInt(_cursorIndexOfState);
              final long _tmpStartTime;
              _tmpStartTime = _cursor.getLong(_cursorIndexOfStartTime);
              final long _tmpEndTime;
              _tmpEndTime = _cursor.getLong(_cursorIndexOfEndTime);
              final SessionId _tmpSessionId;
              final String _tmp_4;
              if (_cursor.isNull(_cursorIndexOfSessionId)) {
                _tmp_4 = null;
              } else {
                _tmp_4 = _cursor.getString(_cursorIndexOfSessionId);
              }
              _tmpSessionId = __commonConverters.fromStringToSessionId(_tmp_4);
              final Integer _tmpReason;
              if (_cursor.isNull(_cursorIndexOfReason)) {
                _tmpReason = null;
              } else {
                _tmpReason = _cursor.getInt(_cursorIndexOfReason);
              }
              _tmpRecovery = new UserRecoveryEntity(_tmpState,_tmpStartTime,_tmpEndTime,_tmpSessionId,_tmpReason);
            }  else  {
              _tmpRecovery = null;
            }
            _result = new UserEntity(_tmpUserId,_tmpEmail,_tmpName,_tmpDisplayName,_tmpCurrency,_tmpCredit,_tmpCreatedAtUtc,_tmpUsedSpace,_tmpMaxSpace,_tmpMaxUpload,_tmpType,_tmpRole,_tmpIsPrivate,_tmpSubscribed,_tmpServices,_tmpDelinquent,_tmpRecovery,_tmpPassphrase,_tmpMaxBaseSpace,_tmpMaxDriveSpace,_tmpUsedBaseSpace,_tmpUsedDriveSpace);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object getByUserId(final UserId userId, final Continuation<? super UserEntity> arg1) {
    final String _sql = "SELECT * FROM UserEntity WHERE userId = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    final String _tmp = __commonConverters.fromUserIdToString(userId);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp);
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<UserEntity>() {
      @Override
      public UserEntity call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
          final int _cursorIndexOfEmail = CursorUtil.getColumnIndexOrThrow(_cursor, "email");
          final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "name");
          final int _cursorIndexOfDisplayName = CursorUtil.getColumnIndexOrThrow(_cursor, "displayName");
          final int _cursorIndexOfCurrency = CursorUtil.getColumnIndexOrThrow(_cursor, "currency");
          final int _cursorIndexOfCredit = CursorUtil.getColumnIndexOrThrow(_cursor, "credit");
          final int _cursorIndexOfCreatedAtUtc = CursorUtil.getColumnIndexOrThrow(_cursor, "createdAtUtc");
          final int _cursorIndexOfUsedSpace = CursorUtil.getColumnIndexOrThrow(_cursor, "usedSpace");
          final int _cursorIndexOfMaxSpace = CursorUtil.getColumnIndexOrThrow(_cursor, "maxSpace");
          final int _cursorIndexOfMaxUpload = CursorUtil.getColumnIndexOrThrow(_cursor, "maxUpload");
          final int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow(_cursor, "type");
          final int _cursorIndexOfRole = CursorUtil.getColumnIndexOrThrow(_cursor, "role");
          final int _cursorIndexOfIsPrivate = CursorUtil.getColumnIndexOrThrow(_cursor, "private");
          final int _cursorIndexOfSubscribed = CursorUtil.getColumnIndexOrThrow(_cursor, "subscribed");
          final int _cursorIndexOfServices = CursorUtil.getColumnIndexOrThrow(_cursor, "services");
          final int _cursorIndexOfDelinquent = CursorUtil.getColumnIndexOrThrow(_cursor, "delinquent");
          final int _cursorIndexOfPassphrase = CursorUtil.getColumnIndexOrThrow(_cursor, "passphrase");
          final int _cursorIndexOfMaxBaseSpace = CursorUtil.getColumnIndexOrThrow(_cursor, "maxBaseSpace");
          final int _cursorIndexOfMaxDriveSpace = CursorUtil.getColumnIndexOrThrow(_cursor, "maxDriveSpace");
          final int _cursorIndexOfUsedBaseSpace = CursorUtil.getColumnIndexOrThrow(_cursor, "usedBaseSpace");
          final int _cursorIndexOfUsedDriveSpace = CursorUtil.getColumnIndexOrThrow(_cursor, "usedDriveSpace");
          final int _cursorIndexOfState = CursorUtil.getColumnIndexOrThrow(_cursor, "recovery_state");
          final int _cursorIndexOfStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "recovery_startTime");
          final int _cursorIndexOfEndTime = CursorUtil.getColumnIndexOrThrow(_cursor, "recovery_endTime");
          final int _cursorIndexOfSessionId = CursorUtil.getColumnIndexOrThrow(_cursor, "recovery_sessionId");
          final int _cursorIndexOfReason = CursorUtil.getColumnIndexOrThrow(_cursor, "recovery_reason");
          final UserEntity _result;
          if(_cursor.moveToFirst()) {
            final UserId _tmpUserId;
            final String _tmp_1;
            if (_cursor.isNull(_cursorIndexOfUserId)) {
              _tmp_1 = null;
            } else {
              _tmp_1 = _cursor.getString(_cursorIndexOfUserId);
            }
            _tmpUserId = __commonConverters.fromStringToUserId(_tmp_1);
            final String _tmpEmail;
            if (_cursor.isNull(_cursorIndexOfEmail)) {
              _tmpEmail = null;
            } else {
              _tmpEmail = _cursor.getString(_cursorIndexOfEmail);
            }
            final String _tmpName;
            if (_cursor.isNull(_cursorIndexOfName)) {
              _tmpName = null;
            } else {
              _tmpName = _cursor.getString(_cursorIndexOfName);
            }
            final String _tmpDisplayName;
            if (_cursor.isNull(_cursorIndexOfDisplayName)) {
              _tmpDisplayName = null;
            } else {
              _tmpDisplayName = _cursor.getString(_cursorIndexOfDisplayName);
            }
            final String _tmpCurrency;
            if (_cursor.isNull(_cursorIndexOfCurrency)) {
              _tmpCurrency = null;
            } else {
              _tmpCurrency = _cursor.getString(_cursorIndexOfCurrency);
            }
            final int _tmpCredit;
            _tmpCredit = _cursor.getInt(_cursorIndexOfCredit);
            final long _tmpCreatedAtUtc;
            _tmpCreatedAtUtc = _cursor.getLong(_cursorIndexOfCreatedAtUtc);
            final long _tmpUsedSpace;
            _tmpUsedSpace = _cursor.getLong(_cursorIndexOfUsedSpace);
            final long _tmpMaxSpace;
            _tmpMaxSpace = _cursor.getLong(_cursorIndexOfMaxSpace);
            final long _tmpMaxUpload;
            _tmpMaxUpload = _cursor.getLong(_cursorIndexOfMaxUpload);
            final Integer _tmpType;
            if (_cursor.isNull(_cursorIndexOfType)) {
              _tmpType = null;
            } else {
              _tmpType = _cursor.getInt(_cursorIndexOfType);
            }
            final Integer _tmpRole;
            if (_cursor.isNull(_cursorIndexOfRole)) {
              _tmpRole = null;
            } else {
              _tmpRole = _cursor.getInt(_cursorIndexOfRole);
            }
            final boolean _tmpIsPrivate;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfIsPrivate);
            _tmpIsPrivate = _tmp_2 != 0;
            final int _tmpSubscribed;
            _tmpSubscribed = _cursor.getInt(_cursorIndexOfSubscribed);
            final int _tmpServices;
            _tmpServices = _cursor.getInt(_cursorIndexOfServices);
            final Integer _tmpDelinquent;
            if (_cursor.isNull(_cursorIndexOfDelinquent)) {
              _tmpDelinquent = null;
            } else {
              _tmpDelinquent = _cursor.getInt(_cursorIndexOfDelinquent);
            }
            final EncryptedByteArray _tmpPassphrase;
            final byte[] _tmp_3;
            if (_cursor.isNull(_cursorIndexOfPassphrase)) {
              _tmp_3 = null;
            } else {
              _tmp_3 = _cursor.getBlob(_cursorIndexOfPassphrase);
            }
            _tmpPassphrase = __cryptoConverters.fromByteArrayToEncryptedByteArray(_tmp_3);
            final Long _tmpMaxBaseSpace;
            if (_cursor.isNull(_cursorIndexOfMaxBaseSpace)) {
              _tmpMaxBaseSpace = null;
            } else {
              _tmpMaxBaseSpace = _cursor.getLong(_cursorIndexOfMaxBaseSpace);
            }
            final Long _tmpMaxDriveSpace;
            if (_cursor.isNull(_cursorIndexOfMaxDriveSpace)) {
              _tmpMaxDriveSpace = null;
            } else {
              _tmpMaxDriveSpace = _cursor.getLong(_cursorIndexOfMaxDriveSpace);
            }
            final Long _tmpUsedBaseSpace;
            if (_cursor.isNull(_cursorIndexOfUsedBaseSpace)) {
              _tmpUsedBaseSpace = null;
            } else {
              _tmpUsedBaseSpace = _cursor.getLong(_cursorIndexOfUsedBaseSpace);
            }
            final Long _tmpUsedDriveSpace;
            if (_cursor.isNull(_cursorIndexOfUsedDriveSpace)) {
              _tmpUsedDriveSpace = null;
            } else {
              _tmpUsedDriveSpace = _cursor.getLong(_cursorIndexOfUsedDriveSpace);
            }
            final UserRecoveryEntity _tmpRecovery;
            if (! (_cursor.isNull(_cursorIndexOfState) && _cursor.isNull(_cursorIndexOfStartTime) && _cursor.isNull(_cursorIndexOfEndTime) && _cursor.isNull(_cursorIndexOfSessionId) && _cursor.isNull(_cursorIndexOfReason))) {
              final int _tmpState;
              _tmpState = _cursor.getInt(_cursorIndexOfState);
              final long _tmpStartTime;
              _tmpStartTime = _cursor.getLong(_cursorIndexOfStartTime);
              final long _tmpEndTime;
              _tmpEndTime = _cursor.getLong(_cursorIndexOfEndTime);
              final SessionId _tmpSessionId;
              final String _tmp_4;
              if (_cursor.isNull(_cursorIndexOfSessionId)) {
                _tmp_4 = null;
              } else {
                _tmp_4 = _cursor.getString(_cursorIndexOfSessionId);
              }
              _tmpSessionId = __commonConverters.fromStringToSessionId(_tmp_4);
              final Integer _tmpReason;
              if (_cursor.isNull(_cursorIndexOfReason)) {
                _tmpReason = null;
              } else {
                _tmpReason = _cursor.getInt(_cursorIndexOfReason);
              }
              _tmpRecovery = new UserRecoveryEntity(_tmpState,_tmpStartTime,_tmpEndTime,_tmpSessionId,_tmpReason);
            }  else  {
              _tmpRecovery = null;
            }
            _result = new UserEntity(_tmpUserId,_tmpEmail,_tmpName,_tmpDisplayName,_tmpCurrency,_tmpCredit,_tmpCreatedAtUtc,_tmpUsedSpace,_tmpMaxSpace,_tmpMaxUpload,_tmpType,_tmpRole,_tmpIsPrivate,_tmpSubscribed,_tmpServices,_tmpDelinquent,_tmpRecovery,_tmpPassphrase,_tmpMaxBaseSpace,_tmpMaxDriveSpace,_tmpUsedBaseSpace,_tmpUsedDriveSpace);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, arg1);
  }

  @Override
  public Object getPassphrase(final UserId userId,
      final Continuation<? super EncryptedByteArray> arg1) {
    final String _sql = "SELECT passphrase FROM UserEntity WHERE userId = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    final String _tmp = __commonConverters.fromUserIdToString(userId);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp);
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, true, _cancellationSignal, new Callable<EncryptedByteArray>() {
      @Override
      public EncryptedByteArray call() throws Exception {
        __db.beginTransaction();
        try {
          final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
          try {
            final EncryptedByteArray _result;
            if(_cursor.moveToFirst()) {
              final byte[] _tmp_1;
              if (_cursor.isNull(0)) {
                _tmp_1 = null;
              } else {
                _tmp_1 = _cursor.getBlob(0);
              }
              _result = __cryptoConverters.fromByteArrayToEncryptedByteArray(_tmp_1);
            } else {
              _result = null;
            }
            __db.setTransactionSuccessful();
            return _result;
          } finally {
            _cursor.close();
            _statement.release();
          }
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
