package me.proton.core.user.data.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.collection.ArrayMap;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;
import me.proton.core.crypto.android.keystore.CryptoConverters;
import me.proton.core.crypto.common.keystore.EncryptedByteArray;
import me.proton.core.data.room.db.CommonConverters;
import me.proton.core.domain.entity.UserId;
import me.proton.core.key.data.entity.SignedKeyListEntity;
import me.proton.core.key.domain.entity.key.KeyId;
import me.proton.core.user.data.db.UserConverters;
import me.proton.core.user.data.entity.AddressEntity;
import me.proton.core.user.data.entity.AddressKeyEntity;
import me.proton.core.user.data.entity.AddressWithKeys;
import me.proton.core.user.domain.entity.AddressId;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class AddressWithKeysDao_Impl extends AddressWithKeysDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<AddressEntity> __insertionAdapterOfAddressEntity;

  private final CommonConverters __commonConverters = new CommonConverters();

  private final UserConverters __userConverters = new UserConverters();

  private final EntityDeletionOrUpdateAdapter<AddressEntity> __deletionAdapterOfAddressEntity;

  private final EntityDeletionOrUpdateAdapter<AddressEntity> __updateAdapterOfAddressEntity;

  private final CryptoConverters __cryptoConverters = new CryptoConverters();

  public AddressWithKeysDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfAddressEntity = new EntityInsertionAdapter<AddressEntity>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR IGNORE INTO `AddressEntity` (`userId`,`addressId`,`email`,`displayName`,`signature`,`domainId`,`canSend`,`canReceive`,`enabled`,`type`,`order`,`signedKeyList_data`,`signedKeyList_signature`,`signedKeyList_minEpochId`,`signedKeyList_maxEpochId`,`signedKeyList_expectedMinEpochId`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, AddressEntity value) {
        final String _tmp = __commonConverters.fromUserIdToString(value.getUserId());
        if (_tmp == null) {
          stmt.bindNull(1);
        } else {
          stmt.bindString(1, _tmp);
        }
        final String _tmp_1 = __userConverters.fromAddressIdToString(value.getAddressId());
        if (_tmp_1 == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, _tmp_1);
        }
        if (value.getEmail() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getEmail());
        }
        if (value.getDisplayName() == null) {
          stmt.bindNull(4);
        } else {
          stmt.bindString(4, value.getDisplayName());
        }
        if (value.getSignature() == null) {
          stmt.bindNull(5);
        } else {
          stmt.bindString(5, value.getSignature());
        }
        if (value.getDomainId() == null) {
          stmt.bindNull(6);
        } else {
          stmt.bindString(6, value.getDomainId());
        }
        final int _tmp_2 = value.getCanSend() ? 1 : 0;
        stmt.bindLong(7, _tmp_2);
        final int _tmp_3 = value.getCanReceive() ? 1 : 0;
        stmt.bindLong(8, _tmp_3);
        final int _tmp_4 = value.getEnabled() ? 1 : 0;
        stmt.bindLong(9, _tmp_4);
        if (value.getType() == null) {
          stmt.bindNull(10);
        } else {
          stmt.bindLong(10, value.getType());
        }
        stmt.bindLong(11, value.getOrder());
        final SignedKeyListEntity _tmpSignedKeyList = value.getSignedKeyList();
        if(_tmpSignedKeyList != null) {
          if (_tmpSignedKeyList.getData() == null) {
            stmt.bindNull(12);
          } else {
            stmt.bindString(12, _tmpSignedKeyList.getData());
          }
          if (_tmpSignedKeyList.getSignature() == null) {
            stmt.bindNull(13);
          } else {
            stmt.bindString(13, _tmpSignedKeyList.getSignature());
          }
          if (_tmpSignedKeyList.getMinEpochId() == null) {
            stmt.bindNull(14);
          } else {
            stmt.bindLong(14, _tmpSignedKeyList.getMinEpochId());
          }
          if (_tmpSignedKeyList.getMaxEpochId() == null) {
            stmt.bindNull(15);
          } else {
            stmt.bindLong(15, _tmpSignedKeyList.getMaxEpochId());
          }
          if (_tmpSignedKeyList.getExpectedMinEpochId() == null) {
            stmt.bindNull(16);
          } else {
            stmt.bindLong(16, _tmpSignedKeyList.getExpectedMinEpochId());
          }
        } else {
          stmt.bindNull(12);
          stmt.bindNull(13);
          stmt.bindNull(14);
          stmt.bindNull(15);
          stmt.bindNull(16);
        }
      }
    };
    this.__deletionAdapterOfAddressEntity = new EntityDeletionOrUpdateAdapter<AddressEntity>(__db) {
      @Override
      public String createQuery() {
        return "DELETE FROM `AddressEntity` WHERE `addressId` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, AddressEntity value) {
        final String _tmp = __userConverters.fromAddressIdToString(value.getAddressId());
        if (_tmp == null) {
          stmt.bindNull(1);
        } else {
          stmt.bindString(1, _tmp);
        }
      }
    };
    this.__updateAdapterOfAddressEntity = new EntityDeletionOrUpdateAdapter<AddressEntity>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `AddressEntity` SET `userId` = ?,`addressId` = ?,`email` = ?,`displayName` = ?,`signature` = ?,`domainId` = ?,`canSend` = ?,`canReceive` = ?,`enabled` = ?,`type` = ?,`order` = ?,`signedKeyList_data` = ?,`signedKeyList_signature` = ?,`signedKeyList_minEpochId` = ?,`signedKeyList_maxEpochId` = ?,`signedKeyList_expectedMinEpochId` = ? WHERE `addressId` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, AddressEntity value) {
        final String _tmp = __commonConverters.fromUserIdToString(value.getUserId());
        if (_tmp == null) {
          stmt.bindNull(1);
        } else {
          stmt.bindString(1, _tmp);
        }
        final String _tmp_1 = __userConverters.fromAddressIdToString(value.getAddressId());
        if (_tmp_1 == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, _tmp_1);
        }
        if (value.getEmail() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getEmail());
        }
        if (value.getDisplayName() == null) {
          stmt.bindNull(4);
        } else {
          stmt.bindString(4, value.getDisplayName());
        }
        if (value.getSignature() == null) {
          stmt.bindNull(5);
        } else {
          stmt.bindString(5, value.getSignature());
        }
        if (value.getDomainId() == null) {
          stmt.bindNull(6);
        } else {
          stmt.bindString(6, value.getDomainId());
        }
        final int _tmp_2 = value.getCanSend() ? 1 : 0;
        stmt.bindLong(7, _tmp_2);
        final int _tmp_3 = value.getCanReceive() ? 1 : 0;
        stmt.bindLong(8, _tmp_3);
        final int _tmp_4 = value.getEnabled() ? 1 : 0;
        stmt.bindLong(9, _tmp_4);
        if (value.getType() == null) {
          stmt.bindNull(10);
        } else {
          stmt.bindLong(10, value.getType());
        }
        stmt.bindLong(11, value.getOrder());
        final SignedKeyListEntity _tmpSignedKeyList = value.getSignedKeyList();
        if(_tmpSignedKeyList != null) {
          if (_tmpSignedKeyList.getData() == null) {
            stmt.bindNull(12);
          } else {
            stmt.bindString(12, _tmpSignedKeyList.getData());
          }
          if (_tmpSignedKeyList.getSignature() == null) {
            stmt.bindNull(13);
          } else {
            stmt.bindString(13, _tmpSignedKeyList.getSignature());
          }
          if (_tmpSignedKeyList.getMinEpochId() == null) {
            stmt.bindNull(14);
          } else {
            stmt.bindLong(14, _tmpSignedKeyList.getMinEpochId());
          }
          if (_tmpSignedKeyList.getMaxEpochId() == null) {
            stmt.bindNull(15);
          } else {
            stmt.bindLong(15, _tmpSignedKeyList.getMaxEpochId());
          }
          if (_tmpSignedKeyList.getExpectedMinEpochId() == null) {
            stmt.bindNull(16);
          } else {
            stmt.bindLong(16, _tmpSignedKeyList.getExpectedMinEpochId());
          }
        } else {
          stmt.bindNull(12);
          stmt.bindNull(13);
          stmt.bindNull(14);
          stmt.bindNull(15);
          stmt.bindNull(16);
        }
        final String _tmp_5 = __userConverters.fromAddressIdToString(value.getAddressId());
        if (_tmp_5 == null) {
          stmt.bindNull(17);
        } else {
          stmt.bindString(17, _tmp_5);
        }
      }
    };
  }

  @Override
  public Object insertOrIgnore(final AddressEntity[] entities,
      final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfAddressEntity.insert(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object delete(final AddressEntity[] entities, final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __deletionAdapterOfAddressEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object update(final AddressEntity[] entities, final Continuation<? super Integer> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      public Integer call() throws Exception {
        int _total = 0;
        __db.beginTransaction();
        try {
          _total +=__updateAdapterOfAddressEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return _total;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object insertOrUpdate(final AddressEntity[] entities,
      final Continuation<? super Unit> $completion) {
    return RoomDatabaseKt.withTransaction(__db, (__cont) -> AddressWithKeysDao_Impl.super.insertOrUpdate(entities, __cont), $completion);
  }

  @Override
  public Flow<List<AddressWithKeys>> observeByUserId(final UserId userId) {
    final String _sql = "SELECT * FROM AddressEntity WHERE userId = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    final String _tmp = __commonConverters.fromUserIdToString(userId);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp);
    }
    return CoroutinesRoom.createFlow(__db, true, new String[]{"AddressKeyEntity","AddressEntity"}, new Callable<List<AddressWithKeys>>() {
      @Override
      public List<AddressWithKeys> call() throws Exception {
        __db.beginTransaction();
        try {
          final Cursor _cursor = DBUtil.query(__db, _statement, true, null);
          try {
            final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
            final int _cursorIndexOfAddressId = CursorUtil.getColumnIndexOrThrow(_cursor, "addressId");
            final int _cursorIndexOfEmail = CursorUtil.getColumnIndexOrThrow(_cursor, "email");
            final int _cursorIndexOfDisplayName = CursorUtil.getColumnIndexOrThrow(_cursor, "displayName");
            final int _cursorIndexOfSignature = CursorUtil.getColumnIndexOrThrow(_cursor, "signature");
            final int _cursorIndexOfDomainId = CursorUtil.getColumnIndexOrThrow(_cursor, "domainId");
            final int _cursorIndexOfCanSend = CursorUtil.getColumnIndexOrThrow(_cursor, "canSend");
            final int _cursorIndexOfCanReceive = CursorUtil.getColumnIndexOrThrow(_cursor, "canReceive");
            final int _cursorIndexOfEnabled = CursorUtil.getColumnIndexOrThrow(_cursor, "enabled");
            final int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow(_cursor, "type");
            final int _cursorIndexOfOrder = CursorUtil.getColumnIndexOrThrow(_cursor, "order");
            final int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow(_cursor, "signedKeyList_data");
            final int _cursorIndexOfSignature_1 = CursorUtil.getColumnIndexOrThrow(_cursor, "signedKeyList_signature");
            final int _cursorIndexOfMinEpochId = CursorUtil.getColumnIndexOrThrow(_cursor, "signedKeyList_minEpochId");
            final int _cursorIndexOfMaxEpochId = CursorUtil.getColumnIndexOrThrow(_cursor, "signedKeyList_maxEpochId");
            final int _cursorIndexOfExpectedMinEpochId = CursorUtil.getColumnIndexOrThrow(_cursor, "signedKeyList_expectedMinEpochId");
            final ArrayMap<String, ArrayList<AddressKeyEntity>> _collectionKeys = new ArrayMap<String, ArrayList<AddressKeyEntity>>();
            while (_cursor.moveToNext()) {
              final String _tmpKey = _cursor.getString(_cursorIndexOfAddressId);
              ArrayList<AddressKeyEntity> _tmpKeysCollection = _collectionKeys.get(_tmpKey);
              if (_tmpKeysCollection == null) {
                _tmpKeysCollection = new ArrayList<AddressKeyEntity>();
                _collectionKeys.put(_tmpKey, _tmpKeysCollection);
              }
            }
            _cursor.moveToPosition(-1);
            __fetchRelationshipAddressKeyEntityAsmeProtonCoreUserDataEntityAddressKeyEntity(_collectionKeys);
            final List<AddressWithKeys> _result = new ArrayList<AddressWithKeys>(_cursor.getCount());
            while(_cursor.moveToNext()) {
              final AddressWithKeys _item;
              final AddressEntity _tmpEntity;
              if (! (_cursor.isNull(_cursorIndexOfUserId) && _cursor.isNull(_cursorIndexOfAddressId) && _cursor.isNull(_cursorIndexOfEmail) && _cursor.isNull(_cursorIndexOfDisplayName) && _cursor.isNull(_cursorIndexOfSignature) && _cursor.isNull(_cursorIndexOfDomainId) && _cursor.isNull(_cursorIndexOfCanSend) && _cursor.isNull(_cursorIndexOfCanReceive) && _cursor.isNull(_cursorIndexOfEnabled) && _cursor.isNull(_cursorIndexOfType) && _cursor.isNull(_cursorIndexOfOrder) && _cursor.isNull(_cursorIndexOfData) && _cursor.isNull(_cursorIndexOfSignature_1) && _cursor.isNull(_cursorIndexOfMinEpochId) && _cursor.isNull(_cursorIndexOfMaxEpochId) && _cursor.isNull(_cursorIndexOfExpectedMinEpochId))) {
                final UserId _tmpUserId;
                final String _tmp_1;
                if (_cursor.isNull(_cursorIndexOfUserId)) {
                  _tmp_1 = null;
                } else {
                  _tmp_1 = _cursor.getString(_cursorIndexOfUserId);
                }
                _tmpUserId = __commonConverters.fromStringToUserId(_tmp_1);
                final AddressId _tmpAddressId;
                final String _tmp_2;
                if (_cursor.isNull(_cursorIndexOfAddressId)) {
                  _tmp_2 = null;
                } else {
                  _tmp_2 = _cursor.getString(_cursorIndexOfAddressId);
                }
                _tmpAddressId = __userConverters.fromStringToAddressId(_tmp_2);
                final String _tmpEmail;
                if (_cursor.isNull(_cursorIndexOfEmail)) {
                  _tmpEmail = null;
                } else {
                  _tmpEmail = _cursor.getString(_cursorIndexOfEmail);
                }
                final String _tmpDisplayName;
                if (_cursor.isNull(_cursorIndexOfDisplayName)) {
                  _tmpDisplayName = null;
                } else {
                  _tmpDisplayName = _cursor.getString(_cursorIndexOfDisplayName);
                }
                final String _tmpSignature;
                if (_cursor.isNull(_cursorIndexOfSignature)) {
                  _tmpSignature = null;
                } else {
                  _tmpSignature = _cursor.getString(_cursorIndexOfSignature);
                }
                final String _tmpDomainId;
                if (_cursor.isNull(_cursorIndexOfDomainId)) {
                  _tmpDomainId = null;
                } else {
                  _tmpDomainId = _cursor.getString(_cursorIndexOfDomainId);
                }
                final boolean _tmpCanSend;
                final int _tmp_3;
                _tmp_3 = _cursor.getInt(_cursorIndexOfCanSend);
                _tmpCanSend = _tmp_3 != 0;
                final boolean _tmpCanReceive;
                final int _tmp_4;
                _tmp_4 = _cursor.getInt(_cursorIndexOfCanReceive);
                _tmpCanReceive = _tmp_4 != 0;
                final boolean _tmpEnabled;
                final int _tmp_5;
                _tmp_5 = _cursor.getInt(_cursorIndexOfEnabled);
                _tmpEnabled = _tmp_5 != 0;
                final Integer _tmpType;
                if (_cursor.isNull(_cursorIndexOfType)) {
                  _tmpType = null;
                } else {
                  _tmpType = _cursor.getInt(_cursorIndexOfType);
                }
                final int _tmpOrder;
                _tmpOrder = _cursor.getInt(_cursorIndexOfOrder);
                final SignedKeyListEntity _tmpSignedKeyList;
                if (! (_cursor.isNull(_cursorIndexOfData) && _cursor.isNull(_cursorIndexOfSignature_1) && _cursor.isNull(_cursorIndexOfMinEpochId) && _cursor.isNull(_cursorIndexOfMaxEpochId) && _cursor.isNull(_cursorIndexOfExpectedMinEpochId))) {
                  final String _tmpData;
                  if (_cursor.isNull(_cursorIndexOfData)) {
                    _tmpData = null;
                  } else {
                    _tmpData = _cursor.getString(_cursorIndexOfData);
                  }
                  final String _tmpSignature_1;
                  if (_cursor.isNull(_cursorIndexOfSignature_1)) {
                    _tmpSignature_1 = null;
                  } else {
                    _tmpSignature_1 = _cursor.getString(_cursorIndexOfSignature_1);
                  }
                  final Integer _tmpMinEpochId;
                  if (_cursor.isNull(_cursorIndexOfMinEpochId)) {
                    _tmpMinEpochId = null;
                  } else {
                    _tmpMinEpochId = _cursor.getInt(_cursorIndexOfMinEpochId);
                  }
                  final Integer _tmpMaxEpochId;
                  if (_cursor.isNull(_cursorIndexOfMaxEpochId)) {
                    _tmpMaxEpochId = null;
                  } else {
                    _tmpMaxEpochId = _cursor.getInt(_cursorIndexOfMaxEpochId);
                  }
                  final Integer _tmpExpectedMinEpochId;
                  if (_cursor.isNull(_cursorIndexOfExpectedMinEpochId)) {
                    _tmpExpectedMinEpochId = null;
                  } else {
                    _tmpExpectedMinEpochId = _cursor.getInt(_cursorIndexOfExpectedMinEpochId);
                  }
                  _tmpSignedKeyList = new SignedKeyListEntity(_tmpData,_tmpSignature_1,_tmpMinEpochId,_tmpMaxEpochId,_tmpExpectedMinEpochId);
                }  else  {
                  _tmpSignedKeyList = null;
                }
                _tmpEntity = new AddressEntity(_tmpUserId,_tmpAddressId,_tmpEmail,_tmpDisplayName,_tmpSignature,_tmpDomainId,_tmpCanSend,_tmpCanReceive,_tmpEnabled,_tmpType,_tmpOrder,_tmpSignedKeyList);
              }  else  {
                _tmpEntity = null;
              }
              ArrayList<AddressKeyEntity> _tmpKeysCollection_1 = null;
              final String _tmpKey_1 = _cursor.getString(_cursorIndexOfAddressId);
              _tmpKeysCollection_1 = _collectionKeys.get(_tmpKey_1);
              if (_tmpKeysCollection_1 == null) {
                _tmpKeysCollection_1 = new ArrayList<AddressKeyEntity>();
              }
              _item = new AddressWithKeys(_tmpEntity,_tmpKeysCollection_1);
              _result.add(_item);
            }
            __db.setTransactionSuccessful();
            return _result;
          } finally {
            _cursor.close();
          }
        } finally {
          __db.endTransaction();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object getByUserId(final UserId userId,
      final Continuation<? super List<AddressWithKeys>> arg1) {
    final String _sql = "SELECT * FROM AddressEntity WHERE userId = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    final String _tmp = __commonConverters.fromUserIdToString(userId);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp);
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, true, _cancellationSignal, new Callable<List<AddressWithKeys>>() {
      @Override
      public List<AddressWithKeys> call() throws Exception {
        __db.beginTransaction();
        try {
          final Cursor _cursor = DBUtil.query(__db, _statement, true, null);
          try {
            final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
            final int _cursorIndexOfAddressId = CursorUtil.getColumnIndexOrThrow(_cursor, "addressId");
            final int _cursorIndexOfEmail = CursorUtil.getColumnIndexOrThrow(_cursor, "email");
            final int _cursorIndexOfDisplayName = CursorUtil.getColumnIndexOrThrow(_cursor, "displayName");
            final int _cursorIndexOfSignature = CursorUtil.getColumnIndexOrThrow(_cursor, "signature");
            final int _cursorIndexOfDomainId = CursorUtil.getColumnIndexOrThrow(_cursor, "domainId");
            final int _cursorIndexOfCanSend = CursorUtil.getColumnIndexOrThrow(_cursor, "canSend");
            final int _cursorIndexOfCanReceive = CursorUtil.getColumnIndexOrThrow(_cursor, "canReceive");
            final int _cursorIndexOfEnabled = CursorUtil.getColumnIndexOrThrow(_cursor, "enabled");
            final int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow(_cursor, "type");
            final int _cursorIndexOfOrder = CursorUtil.getColumnIndexOrThrow(_cursor, "order");
            final int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow(_cursor, "signedKeyList_data");
            final int _cursorIndexOfSignature_1 = CursorUtil.getColumnIndexOrThrow(_cursor, "signedKeyList_signature");
            final int _cursorIndexOfMinEpochId = CursorUtil.getColumnIndexOrThrow(_cursor, "signedKeyList_minEpochId");
            final int _cursorIndexOfMaxEpochId = CursorUtil.getColumnIndexOrThrow(_cursor, "signedKeyList_maxEpochId");
            final int _cursorIndexOfExpectedMinEpochId = CursorUtil.getColumnIndexOrThrow(_cursor, "signedKeyList_expectedMinEpochId");
            final ArrayMap<String, ArrayList<AddressKeyEntity>> _collectionKeys = new ArrayMap<String, ArrayList<AddressKeyEntity>>();
            while (_cursor.moveToNext()) {
              final String _tmpKey = _cursor.getString(_cursorIndexOfAddressId);
              ArrayList<AddressKeyEntity> _tmpKeysCollection = _collectionKeys.get(_tmpKey);
              if (_tmpKeysCollection == null) {
                _tmpKeysCollection = new ArrayList<AddressKeyEntity>();
                _collectionKeys.put(_tmpKey, _tmpKeysCollection);
              }
            }
            _cursor.moveToPosition(-1);
            __fetchRelationshipAddressKeyEntityAsmeProtonCoreUserDataEntityAddressKeyEntity(_collectionKeys);
            final List<AddressWithKeys> _result = new ArrayList<AddressWithKeys>(_cursor.getCount());
            while(_cursor.moveToNext()) {
              final AddressWithKeys _item;
              final AddressEntity _tmpEntity;
              if (! (_cursor.isNull(_cursorIndexOfUserId) && _cursor.isNull(_cursorIndexOfAddressId) && _cursor.isNull(_cursorIndexOfEmail) && _cursor.isNull(_cursorIndexOfDisplayName) && _cursor.isNull(_cursorIndexOfSignature) && _cursor.isNull(_cursorIndexOfDomainId) && _cursor.isNull(_cursorIndexOfCanSend) && _cursor.isNull(_cursorIndexOfCanReceive) && _cursor.isNull(_cursorIndexOfEnabled) && _cursor.isNull(_cursorIndexOfType) && _cursor.isNull(_cursorIndexOfOrder) && _cursor.isNull(_cursorIndexOfData) && _cursor.isNull(_cursorIndexOfSignature_1) && _cursor.isNull(_cursorIndexOfMinEpochId) && _cursor.isNull(_cursorIndexOfMaxEpochId) && _cursor.isNull(_cursorIndexOfExpectedMinEpochId))) {
                final UserId _tmpUserId;
                final String _tmp_1;
                if (_cursor.isNull(_cursorIndexOfUserId)) {
                  _tmp_1 = null;
                } else {
                  _tmp_1 = _cursor.getString(_cursorIndexOfUserId);
                }
                _tmpUserId = __commonConverters.fromStringToUserId(_tmp_1);
                final AddressId _tmpAddressId;
                final String _tmp_2;
                if (_cursor.isNull(_cursorIndexOfAddressId)) {
                  _tmp_2 = null;
                } else {
                  _tmp_2 = _cursor.getString(_cursorIndexOfAddressId);
                }
                _tmpAddressId = __userConverters.fromStringToAddressId(_tmp_2);
                final String _tmpEmail;
                if (_cursor.isNull(_cursorIndexOfEmail)) {
                  _tmpEmail = null;
                } else {
                  _tmpEmail = _cursor.getString(_cursorIndexOfEmail);
                }
                final String _tmpDisplayName;
                if (_cursor.isNull(_cursorIndexOfDisplayName)) {
                  _tmpDisplayName = null;
                } else {
                  _tmpDisplayName = _cursor.getString(_cursorIndexOfDisplayName);
                }
                final String _tmpSignature;
                if (_cursor.isNull(_cursorIndexOfSignature)) {
                  _tmpSignature = null;
                } else {
                  _tmpSignature = _cursor.getString(_cursorIndexOfSignature);
                }
                final String _tmpDomainId;
                if (_cursor.isNull(_cursorIndexOfDomainId)) {
                  _tmpDomainId = null;
                } else {
                  _tmpDomainId = _cursor.getString(_cursorIndexOfDomainId);
                }
                final boolean _tmpCanSend;
                final int _tmp_3;
                _tmp_3 = _cursor.getInt(_cursorIndexOfCanSend);
                _tmpCanSend = _tmp_3 != 0;
                final boolean _tmpCanReceive;
                final int _tmp_4;
                _tmp_4 = _cursor.getInt(_cursorIndexOfCanReceive);
                _tmpCanReceive = _tmp_4 != 0;
                final boolean _tmpEnabled;
                final int _tmp_5;
                _tmp_5 = _cursor.getInt(_cursorIndexOfEnabled);
                _tmpEnabled = _tmp_5 != 0;
                final Integer _tmpType;
                if (_cursor.isNull(_cursorIndexOfType)) {
                  _tmpType = null;
                } else {
                  _tmpType = _cursor.getInt(_cursorIndexOfType);
                }
                final int _tmpOrder;
                _tmpOrder = _cursor.getInt(_cursorIndexOfOrder);
                final SignedKeyListEntity _tmpSignedKeyList;
                if (! (_cursor.isNull(_cursorIndexOfData) && _cursor.isNull(_cursorIndexOfSignature_1) && _cursor.isNull(_cursorIndexOfMinEpochId) && _cursor.isNull(_cursorIndexOfMaxEpochId) && _cursor.isNull(_cursorIndexOfExpectedMinEpochId))) {
                  final String _tmpData;
                  if (_cursor.isNull(_cursorIndexOfData)) {
                    _tmpData = null;
                  } else {
                    _tmpData = _cursor.getString(_cursorIndexOfData);
                  }
                  final String _tmpSignature_1;
                  if (_cursor.isNull(_cursorIndexOfSignature_1)) {
                    _tmpSignature_1 = null;
                  } else {
                    _tmpSignature_1 = _cursor.getString(_cursorIndexOfSignature_1);
                  }
                  final Integer _tmpMinEpochId;
                  if (_cursor.isNull(_cursorIndexOfMinEpochId)) {
                    _tmpMinEpochId = null;
                  } else {
                    _tmpMinEpochId = _cursor.getInt(_cursorIndexOfMinEpochId);
                  }
                  final Integer _tmpMaxEpochId;
                  if (_cursor.isNull(_cursorIndexOfMaxEpochId)) {
                    _tmpMaxEpochId = null;
                  } else {
                    _tmpMaxEpochId = _cursor.getInt(_cursorIndexOfMaxEpochId);
                  }
                  final Integer _tmpExpectedMinEpochId;
                  if (_cursor.isNull(_cursorIndexOfExpectedMinEpochId)) {
                    _tmpExpectedMinEpochId = null;
                  } else {
                    _tmpExpectedMinEpochId = _cursor.getInt(_cursorIndexOfExpectedMinEpochId);
                  }
                  _tmpSignedKeyList = new SignedKeyListEntity(_tmpData,_tmpSignature_1,_tmpMinEpochId,_tmpMaxEpochId,_tmpExpectedMinEpochId);
                }  else  {
                  _tmpSignedKeyList = null;
                }
                _tmpEntity = new AddressEntity(_tmpUserId,_tmpAddressId,_tmpEmail,_tmpDisplayName,_tmpSignature,_tmpDomainId,_tmpCanSend,_tmpCanReceive,_tmpEnabled,_tmpType,_tmpOrder,_tmpSignedKeyList);
              }  else  {
                _tmpEntity = null;
              }
              ArrayList<AddressKeyEntity> _tmpKeysCollection_1 = null;
              final String _tmpKey_1 = _cursor.getString(_cursorIndexOfAddressId);
              _tmpKeysCollection_1 = _collectionKeys.get(_tmpKey_1);
              if (_tmpKeysCollection_1 == null) {
                _tmpKeysCollection_1 = new ArrayList<AddressKeyEntity>();
              }
              _item = new AddressWithKeys(_tmpEntity,_tmpKeysCollection_1);
              _result.add(_item);
            }
            __db.setTransactionSuccessful();
            return _result;
          } finally {
            _cursor.close();
            _statement.release();
          }
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }

  private void __fetchRelationshipAddressKeyEntityAsmeProtonCoreUserDataEntityAddressKeyEntity(
      final ArrayMap<String, ArrayList<AddressKeyEntity>> _map) {
    final Set<String> __mapKeySet = _map.keySet();
    if (__mapKeySet.isEmpty()) {
      return;
    }
    // check if the size is too big, if so divide;
    if(_map.size() > RoomDatabase.MAX_BIND_PARAMETER_CNT) {
      ArrayMap<String, ArrayList<AddressKeyEntity>> _tmpInnerMap = new ArrayMap<String, ArrayList<AddressKeyEntity>>(androidx.room.RoomDatabase.MAX_BIND_PARAMETER_CNT);
      int _tmpIndex = 0;
      int _mapIndex = 0;
      final int _limit = _map.size();
      while(_mapIndex < _limit) {
        _tmpInnerMap.put(_map.keyAt(_mapIndex), _map.valueAt(_mapIndex));
        _mapIndex++;
        _tmpIndex++;
        if(_tmpIndex == RoomDatabase.MAX_BIND_PARAMETER_CNT) {
          __fetchRelationshipAddressKeyEntityAsmeProtonCoreUserDataEntityAddressKeyEntity(_tmpInnerMap);
          _tmpInnerMap = new ArrayMap<String, ArrayList<AddressKeyEntity>>(RoomDatabase.MAX_BIND_PARAMETER_CNT);
          _tmpIndex = 0;
        }
      }
      if(_tmpIndex > 0) {
        __fetchRelationshipAddressKeyEntityAsmeProtonCoreUserDataEntityAddressKeyEntity(_tmpInnerMap);
      }
      return;
    }
    StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("SELECT `addressId`,`keyId`,`version`,`privateKey`,`isPrimary`,`isUnlockable`,`flags`,`passphrase`,`token`,`signature`,`fingerprint`,`fingerprints`,`activation`,`active` FROM `AddressKeyEntity` WHERE `addressId` IN (");
    final int _inputSize = __mapKeySet.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(")");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 0 + _inputSize;
    final RoomSQLiteQuery _stmt = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    for (String _item : __mapKeySet) {
      if (_item == null) {
        _stmt.bindNull(_argIndex);
      } else {
        _stmt.bindString(_argIndex, _item);
      }
      _argIndex ++;
    }
    final Cursor _cursor = DBUtil.query(__db, _stmt, false, null);
    try {
      final int _itemKeyIndex = CursorUtil.getColumnIndex(_cursor, "addressId");
      if (_itemKeyIndex == -1) {
        return;
      }
      final int _cursorIndexOfAddressId = 0;
      final int _cursorIndexOfKeyId = 1;
      final int _cursorIndexOfVersion = 2;
      final int _cursorIndexOfPrivateKey = 3;
      final int _cursorIndexOfIsPrimary = 4;
      final int _cursorIndexOfIsUnlockable = 5;
      final int _cursorIndexOfFlags = 6;
      final int _cursorIndexOfPassphrase = 7;
      final int _cursorIndexOfToken = 8;
      final int _cursorIndexOfSignature = 9;
      final int _cursorIndexOfFingerprint = 10;
      final int _cursorIndexOfFingerprints = 11;
      final int _cursorIndexOfActivation = 12;
      final int _cursorIndexOfActive = 13;
      while(_cursor.moveToNext()) {
        final String _tmpKey = _cursor.getString(_itemKeyIndex);
        ArrayList<AddressKeyEntity> _tmpRelation = _map.get(_tmpKey);
        if (_tmpRelation != null) {
          final AddressKeyEntity _item_1;
          final AddressId _tmpAddressId;
          final String _tmp;
          if (_cursor.isNull(_cursorIndexOfAddressId)) {
            _tmp = null;
          } else {
            _tmp = _cursor.getString(_cursorIndexOfAddressId);
          }
          _tmpAddressId = __userConverters.fromStringToAddressId(_tmp);
          final KeyId _tmpKeyId;
          final String _tmp_1;
          if (_cursor.isNull(_cursorIndexOfKeyId)) {
            _tmp_1 = null;
          } else {
            _tmp_1 = _cursor.getString(_cursorIndexOfKeyId);
          }
          _tmpKeyId = __userConverters.fromStringToKeyId(_tmp_1);
          final int _tmpVersion;
          _tmpVersion = _cursor.getInt(_cursorIndexOfVersion);
          final String _tmpPrivateKey;
          if (_cursor.isNull(_cursorIndexOfPrivateKey)) {
            _tmpPrivateKey = null;
          } else {
            _tmpPrivateKey = _cursor.getString(_cursorIndexOfPrivateKey);
          }
          final boolean _tmpIsPrimary;
          final int _tmp_2;
          _tmp_2 = _cursor.getInt(_cursorIndexOfIsPrimary);
          _tmpIsPrimary = _tmp_2 != 0;
          final boolean _tmpIsUnlockable;
          final int _tmp_3;
          _tmp_3 = _cursor.getInt(_cursorIndexOfIsUnlockable);
          _tmpIsUnlockable = _tmp_3 != 0;
          final int _tmpFlags;
          _tmpFlags = _cursor.getInt(_cursorIndexOfFlags);
          final EncryptedByteArray _tmpPassphrase;
          final byte[] _tmp_4;
          if (_cursor.isNull(_cursorIndexOfPassphrase)) {
            _tmp_4 = null;
          } else {
            _tmp_4 = _cursor.getBlob(_cursorIndexOfPassphrase);
          }
          _tmpPassphrase = __cryptoConverters.fromByteArrayToEncryptedByteArray(_tmp_4);
          final String _tmpToken;
          if (_cursor.isNull(_cursorIndexOfToken)) {
            _tmpToken = null;
          } else {
            _tmpToken = _cursor.getString(_cursorIndexOfToken);
          }
          final String _tmpSignature;
          if (_cursor.isNull(_cursorIndexOfSignature)) {
            _tmpSignature = null;
          } else {
            _tmpSignature = _cursor.getString(_cursorIndexOfSignature);
          }
          final String _tmpFingerprint;
          if (_cursor.isNull(_cursorIndexOfFingerprint)) {
            _tmpFingerprint = null;
          } else {
            _tmpFingerprint = _cursor.getString(_cursorIndexOfFingerprint);
          }
          final List<String> _tmpFingerprints;
          final String _tmp_5;
          if (_cursor.isNull(_cursorIndexOfFingerprints)) {
            _tmp_5 = null;
          } else {
            _tmp_5 = _cursor.getString(_cursorIndexOfFingerprints);
          }
          _tmpFingerprints = __commonConverters.fromStringToListOfString(_tmp_5);
          final String _tmpActivation;
          if (_cursor.isNull(_cursorIndexOfActivation)) {
            _tmpActivation = null;
          } else {
            _tmpActivation = _cursor.getString(_cursorIndexOfActivation);
          }
          final boolean _tmpActive;
          final int _tmp_6;
          _tmp_6 = _cursor.getInt(_cursorIndexOfActive);
          _tmpActive = _tmp_6 != 0;
          _item_1 = new AddressKeyEntity(_tmpAddressId,_tmpKeyId,_tmpVersion,_tmpPrivateKey,_tmpIsPrimary,_tmpIsUnlockable,_tmpFlags,_tmpPassphrase,_tmpToken,_tmpSignature,_tmpFingerprint,_tmpFingerprints,_tmpActivation,_tmpActive);
          _tmpRelation.add(_item_1);
        }
      }
    } finally {
      _cursor.close();
    }
  }
}
