package me.proton.core.user.data.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;
import me.proton.core.data.room.db.CommonConverters;
import me.proton.core.domain.entity.UserId;
import me.proton.core.key.data.entity.SignedKeyListEntity;
import me.proton.core.user.data.db.UserConverters;
import me.proton.core.user.data.entity.AddressEntity;
import me.proton.core.user.domain.entity.AddressId;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class AddressDao_Impl extends AddressDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<AddressEntity> __insertionAdapterOfAddressEntity;

  private final CommonConverters __commonConverters = new CommonConverters();

  private final UserConverters __userConverters = new UserConverters();

  private final EntityDeletionOrUpdateAdapter<AddressEntity> __deletionAdapterOfAddressEntity;

  private final EntityDeletionOrUpdateAdapter<AddressEntity> __updateAdapterOfAddressEntity;

  private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

  private final SharedSQLiteStatement __preparedStmtOfDeleteAll_1;

  public AddressDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfAddressEntity = new EntityInsertionAdapter<AddressEntity>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR IGNORE INTO `AddressEntity` (`userId`,`addressId`,`email`,`displayName`,`signature`,`domainId`,`canSend`,`canReceive`,`enabled`,`type`,`order`,`signedKeyList_data`,`signedKeyList_signature`,`signedKeyList_minEpochId`,`signedKeyList_maxEpochId`,`signedKeyList_expectedMinEpochId`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, AddressEntity value) {
        final String _tmp = __commonConverters.fromUserIdToString(value.getUserId());
        if (_tmp == null) {
          stmt.bindNull(1);
        } else {
          stmt.bindString(1, _tmp);
        }
        final String _tmp_1 = __userConverters.fromAddressIdToString(value.getAddressId());
        if (_tmp_1 == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, _tmp_1);
        }
        if (value.getEmail() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getEmail());
        }
        if (value.getDisplayName() == null) {
          stmt.bindNull(4);
        } else {
          stmt.bindString(4, value.getDisplayName());
        }
        if (value.getSignature() == null) {
          stmt.bindNull(5);
        } else {
          stmt.bindString(5, value.getSignature());
        }
        if (value.getDomainId() == null) {
          stmt.bindNull(6);
        } else {
          stmt.bindString(6, value.getDomainId());
        }
        final int _tmp_2 = value.getCanSend() ? 1 : 0;
        stmt.bindLong(7, _tmp_2);
        final int _tmp_3 = value.getCanReceive() ? 1 : 0;
        stmt.bindLong(8, _tmp_3);
        final int _tmp_4 = value.getEnabled() ? 1 : 0;
        stmt.bindLong(9, _tmp_4);
        if (value.getType() == null) {
          stmt.bindNull(10);
        } else {
          stmt.bindLong(10, value.getType());
        }
        stmt.bindLong(11, value.getOrder());
        final SignedKeyListEntity _tmpSignedKeyList = value.getSignedKeyList();
        if(_tmpSignedKeyList != null) {
          if (_tmpSignedKeyList.getData() == null) {
            stmt.bindNull(12);
          } else {
            stmt.bindString(12, _tmpSignedKeyList.getData());
          }
          if (_tmpSignedKeyList.getSignature() == null) {
            stmt.bindNull(13);
          } else {
            stmt.bindString(13, _tmpSignedKeyList.getSignature());
          }
          if (_tmpSignedKeyList.getMinEpochId() == null) {
            stmt.bindNull(14);
          } else {
            stmt.bindLong(14, _tmpSignedKeyList.getMinEpochId());
          }
          if (_tmpSignedKeyList.getMaxEpochId() == null) {
            stmt.bindNull(15);
          } else {
            stmt.bindLong(15, _tmpSignedKeyList.getMaxEpochId());
          }
          if (_tmpSignedKeyList.getExpectedMinEpochId() == null) {
            stmt.bindNull(16);
          } else {
            stmt.bindLong(16, _tmpSignedKeyList.getExpectedMinEpochId());
          }
        } else {
          stmt.bindNull(12);
          stmt.bindNull(13);
          stmt.bindNull(14);
          stmt.bindNull(15);
          stmt.bindNull(16);
        }
      }
    };
    this.__deletionAdapterOfAddressEntity = new EntityDeletionOrUpdateAdapter<AddressEntity>(__db) {
      @Override
      public String createQuery() {
        return "DELETE FROM `AddressEntity` WHERE `addressId` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, AddressEntity value) {
        final String _tmp = __userConverters.fromAddressIdToString(value.getAddressId());
        if (_tmp == null) {
          stmt.bindNull(1);
        } else {
          stmt.bindString(1, _tmp);
        }
      }
    };
    this.__updateAdapterOfAddressEntity = new EntityDeletionOrUpdateAdapter<AddressEntity>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `AddressEntity` SET `userId` = ?,`addressId` = ?,`email` = ?,`displayName` = ?,`signature` = ?,`domainId` = ?,`canSend` = ?,`canReceive` = ?,`enabled` = ?,`type` = ?,`order` = ?,`signedKeyList_data` = ?,`signedKeyList_signature` = ?,`signedKeyList_minEpochId` = ?,`signedKeyList_maxEpochId` = ?,`signedKeyList_expectedMinEpochId` = ? WHERE `addressId` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, AddressEntity value) {
        final String _tmp = __commonConverters.fromUserIdToString(value.getUserId());
        if (_tmp == null) {
          stmt.bindNull(1);
        } else {
          stmt.bindString(1, _tmp);
        }
        final String _tmp_1 = __userConverters.fromAddressIdToString(value.getAddressId());
        if (_tmp_1 == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, _tmp_1);
        }
        if (value.getEmail() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getEmail());
        }
        if (value.getDisplayName() == null) {
          stmt.bindNull(4);
        } else {
          stmt.bindString(4, value.getDisplayName());
        }
        if (value.getSignature() == null) {
          stmt.bindNull(5);
        } else {
          stmt.bindString(5, value.getSignature());
        }
        if (value.getDomainId() == null) {
          stmt.bindNull(6);
        } else {
          stmt.bindString(6, value.getDomainId());
        }
        final int _tmp_2 = value.getCanSend() ? 1 : 0;
        stmt.bindLong(7, _tmp_2);
        final int _tmp_3 = value.getCanReceive() ? 1 : 0;
        stmt.bindLong(8, _tmp_3);
        final int _tmp_4 = value.getEnabled() ? 1 : 0;
        stmt.bindLong(9, _tmp_4);
        if (value.getType() == null) {
          stmt.bindNull(10);
        } else {
          stmt.bindLong(10, value.getType());
        }
        stmt.bindLong(11, value.getOrder());
        final SignedKeyListEntity _tmpSignedKeyList = value.getSignedKeyList();
        if(_tmpSignedKeyList != null) {
          if (_tmpSignedKeyList.getData() == null) {
            stmt.bindNull(12);
          } else {
            stmt.bindString(12, _tmpSignedKeyList.getData());
          }
          if (_tmpSignedKeyList.getSignature() == null) {
            stmt.bindNull(13);
          } else {
            stmt.bindString(13, _tmpSignedKeyList.getSignature());
          }
          if (_tmpSignedKeyList.getMinEpochId() == null) {
            stmt.bindNull(14);
          } else {
            stmt.bindLong(14, _tmpSignedKeyList.getMinEpochId());
          }
          if (_tmpSignedKeyList.getMaxEpochId() == null) {
            stmt.bindNull(15);
          } else {
            stmt.bindLong(15, _tmpSignedKeyList.getMaxEpochId());
          }
          if (_tmpSignedKeyList.getExpectedMinEpochId() == null) {
            stmt.bindNull(16);
          } else {
            stmt.bindLong(16, _tmpSignedKeyList.getExpectedMinEpochId());
          }
        } else {
          stmt.bindNull(12);
          stmt.bindNull(13);
          stmt.bindNull(14);
          stmt.bindNull(15);
          stmt.bindNull(16);
        }
        final String _tmp_5 = __userConverters.fromAddressIdToString(value.getAddressId());
        if (_tmp_5 == null) {
          stmt.bindNull(17);
        } else {
          stmt.bindString(17, _tmp_5);
        }
      }
    };
    this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "DELETE FROM AddressEntity WHERE userId = ?";
        return _query;
      }
    };
    this.__preparedStmtOfDeleteAll_1 = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "DELETE FROM AddressEntity";
        return _query;
      }
    };
  }

  @Override
  public Object insertOrIgnore(final AddressEntity[] entities,
      final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfAddressEntity.insert(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object delete(final AddressEntity[] entities, final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __deletionAdapterOfAddressEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object update(final AddressEntity[] entities, final Continuation<? super Integer> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      public Integer call() throws Exception {
        int _total = 0;
        __db.beginTransaction();
        try {
          _total +=__updateAdapterOfAddressEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return _total;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object insertOrUpdate(final AddressEntity[] entities,
      final Continuation<? super Unit> $completion) {
    return RoomDatabaseKt.withTransaction(__db, (__cont) -> AddressDao_Impl.super.insertOrUpdate(entities, __cont), $completion);
  }

  @Override
  public Object deleteAll(final UserId userId, final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteAll.acquire();
        int _argIndex = 1;
        final String _tmp = __commonConverters.fromUserIdToString(userId);
        if (_tmp == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, _tmp);
        }
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfDeleteAll.release(_stmt);
        }
      }
    }, arg1);
  }

  @Override
  public Object deleteAll(final Continuation<? super Unit> arg0) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteAll_1.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfDeleteAll_1.release(_stmt);
        }
      }
    }, arg0);
  }

  @Override
  public Flow<AddressEntity> observeByAddressId(final AddressId addressId) {
    final String _sql = "SELECT * FROM AddressEntity WHERE addressId = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    final String _tmp = __userConverters.fromAddressIdToString(addressId);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp);
    }
    return CoroutinesRoom.createFlow(__db, false, new String[]{"AddressEntity"}, new Callable<AddressEntity>() {
      @Override
      public AddressEntity call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
          final int _cursorIndexOfAddressId = CursorUtil.getColumnIndexOrThrow(_cursor, "addressId");
          final int _cursorIndexOfEmail = CursorUtil.getColumnIndexOrThrow(_cursor, "email");
          final int _cursorIndexOfDisplayName = CursorUtil.getColumnIndexOrThrow(_cursor, "displayName");
          final int _cursorIndexOfSignature = CursorUtil.getColumnIndexOrThrow(_cursor, "signature");
          final int _cursorIndexOfDomainId = CursorUtil.getColumnIndexOrThrow(_cursor, "domainId");
          final int _cursorIndexOfCanSend = CursorUtil.getColumnIndexOrThrow(_cursor, "canSend");
          final int _cursorIndexOfCanReceive = CursorUtil.getColumnIndexOrThrow(_cursor, "canReceive");
          final int _cursorIndexOfEnabled = CursorUtil.getColumnIndexOrThrow(_cursor, "enabled");
          final int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow(_cursor, "type");
          final int _cursorIndexOfOrder = CursorUtil.getColumnIndexOrThrow(_cursor, "order");
          final int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow(_cursor, "signedKeyList_data");
          final int _cursorIndexOfSignature_1 = CursorUtil.getColumnIndexOrThrow(_cursor, "signedKeyList_signature");
          final int _cursorIndexOfMinEpochId = CursorUtil.getColumnIndexOrThrow(_cursor, "signedKeyList_minEpochId");
          final int _cursorIndexOfMaxEpochId = CursorUtil.getColumnIndexOrThrow(_cursor, "signedKeyList_maxEpochId");
          final int _cursorIndexOfExpectedMinEpochId = CursorUtil.getColumnIndexOrThrow(_cursor, "signedKeyList_expectedMinEpochId");
          final AddressEntity _result;
          if(_cursor.moveToFirst()) {
            final UserId _tmpUserId;
            final String _tmp_1;
            if (_cursor.isNull(_cursorIndexOfUserId)) {
              _tmp_1 = null;
            } else {
              _tmp_1 = _cursor.getString(_cursorIndexOfUserId);
            }
            _tmpUserId = __commonConverters.fromStringToUserId(_tmp_1);
            final AddressId _tmpAddressId;
            final String _tmp_2;
            if (_cursor.isNull(_cursorIndexOfAddressId)) {
              _tmp_2 = null;
            } else {
              _tmp_2 = _cursor.getString(_cursorIndexOfAddressId);
            }
            _tmpAddressId = __userConverters.fromStringToAddressId(_tmp_2);
            final String _tmpEmail;
            if (_cursor.isNull(_cursorIndexOfEmail)) {
              _tmpEmail = null;
            } else {
              _tmpEmail = _cursor.getString(_cursorIndexOfEmail);
            }
            final String _tmpDisplayName;
            if (_cursor.isNull(_cursorIndexOfDisplayName)) {
              _tmpDisplayName = null;
            } else {
              _tmpDisplayName = _cursor.getString(_cursorIndexOfDisplayName);
            }
            final String _tmpSignature;
            if (_cursor.isNull(_cursorIndexOfSignature)) {
              _tmpSignature = null;
            } else {
              _tmpSignature = _cursor.getString(_cursorIndexOfSignature);
            }
            final String _tmpDomainId;
            if (_cursor.isNull(_cursorIndexOfDomainId)) {
              _tmpDomainId = null;
            } else {
              _tmpDomainId = _cursor.getString(_cursorIndexOfDomainId);
            }
            final boolean _tmpCanSend;
            final int _tmp_3;
            _tmp_3 = _cursor.getInt(_cursorIndexOfCanSend);
            _tmpCanSend = _tmp_3 != 0;
            final boolean _tmpCanReceive;
            final int _tmp_4;
            _tmp_4 = _cursor.getInt(_cursorIndexOfCanReceive);
            _tmpCanReceive = _tmp_4 != 0;
            final boolean _tmpEnabled;
            final int _tmp_5;
            _tmp_5 = _cursor.getInt(_cursorIndexOfEnabled);
            _tmpEnabled = _tmp_5 != 0;
            final Integer _tmpType;
            if (_cursor.isNull(_cursorIndexOfType)) {
              _tmpType = null;
            } else {
              _tmpType = _cursor.getInt(_cursorIndexOfType);
            }
            final int _tmpOrder;
            _tmpOrder = _cursor.getInt(_cursorIndexOfOrder);
            final SignedKeyListEntity _tmpSignedKeyList;
            if (! (_cursor.isNull(_cursorIndexOfData) && _cursor.isNull(_cursorIndexOfSignature_1) && _cursor.isNull(_cursorIndexOfMinEpochId) && _cursor.isNull(_cursorIndexOfMaxEpochId) && _cursor.isNull(_cursorIndexOfExpectedMinEpochId))) {
              final String _tmpData;
              if (_cursor.isNull(_cursorIndexOfData)) {
                _tmpData = null;
              } else {
                _tmpData = _cursor.getString(_cursorIndexOfData);
              }
              final String _tmpSignature_1;
              if (_cursor.isNull(_cursorIndexOfSignature_1)) {
                _tmpSignature_1 = null;
              } else {
                _tmpSignature_1 = _cursor.getString(_cursorIndexOfSignature_1);
              }
              final Integer _tmpMinEpochId;
              if (_cursor.isNull(_cursorIndexOfMinEpochId)) {
                _tmpMinEpochId = null;
              } else {
                _tmpMinEpochId = _cursor.getInt(_cursorIndexOfMinEpochId);
              }
              final Integer _tmpMaxEpochId;
              if (_cursor.isNull(_cursorIndexOfMaxEpochId)) {
                _tmpMaxEpochId = null;
              } else {
                _tmpMaxEpochId = _cursor.getInt(_cursorIndexOfMaxEpochId);
              }
              final Integer _tmpExpectedMinEpochId;
              if (_cursor.isNull(_cursorIndexOfExpectedMinEpochId)) {
                _tmpExpectedMinEpochId = null;
              } else {
                _tmpExpectedMinEpochId = _cursor.getInt(_cursorIndexOfExpectedMinEpochId);
              }
              _tmpSignedKeyList = new SignedKeyListEntity(_tmpData,_tmpSignature_1,_tmpMinEpochId,_tmpMaxEpochId,_tmpExpectedMinEpochId);
            }  else  {
              _tmpSignedKeyList = null;
            }
            _result = new AddressEntity(_tmpUserId,_tmpAddressId,_tmpEmail,_tmpDisplayName,_tmpSignature,_tmpDomainId,_tmpCanSend,_tmpCanReceive,_tmpEnabled,_tmpType,_tmpOrder,_tmpSignedKeyList);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Flow<List<AddressEntity>> observeAllByUserId(final UserId userId) {
    final String _sql = "SELECT * FROM AddressEntity WHERE userId = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    final String _tmp = __commonConverters.fromUserIdToString(userId);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp);
    }
    return CoroutinesRoom.createFlow(__db, false, new String[]{"AddressEntity"}, new Callable<List<AddressEntity>>() {
      @Override
      public List<AddressEntity> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
          final int _cursorIndexOfAddressId = CursorUtil.getColumnIndexOrThrow(_cursor, "addressId");
          final int _cursorIndexOfEmail = CursorUtil.getColumnIndexOrThrow(_cursor, "email");
          final int _cursorIndexOfDisplayName = CursorUtil.getColumnIndexOrThrow(_cursor, "displayName");
          final int _cursorIndexOfSignature = CursorUtil.getColumnIndexOrThrow(_cursor, "signature");
          final int _cursorIndexOfDomainId = CursorUtil.getColumnIndexOrThrow(_cursor, "domainId");
          final int _cursorIndexOfCanSend = CursorUtil.getColumnIndexOrThrow(_cursor, "canSend");
          final int _cursorIndexOfCanReceive = CursorUtil.getColumnIndexOrThrow(_cursor, "canReceive");
          final int _cursorIndexOfEnabled = CursorUtil.getColumnIndexOrThrow(_cursor, "enabled");
          final int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow(_cursor, "type");
          final int _cursorIndexOfOrder = CursorUtil.getColumnIndexOrThrow(_cursor, "order");
          final int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow(_cursor, "signedKeyList_data");
          final int _cursorIndexOfSignature_1 = CursorUtil.getColumnIndexOrThrow(_cursor, "signedKeyList_signature");
          final int _cursorIndexOfMinEpochId = CursorUtil.getColumnIndexOrThrow(_cursor, "signedKeyList_minEpochId");
          final int _cursorIndexOfMaxEpochId = CursorUtil.getColumnIndexOrThrow(_cursor, "signedKeyList_maxEpochId");
          final int _cursorIndexOfExpectedMinEpochId = CursorUtil.getColumnIndexOrThrow(_cursor, "signedKeyList_expectedMinEpochId");
          final List<AddressEntity> _result = new ArrayList<AddressEntity>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final AddressEntity _item;
            final UserId _tmpUserId;
            final String _tmp_1;
            if (_cursor.isNull(_cursorIndexOfUserId)) {
              _tmp_1 = null;
            } else {
              _tmp_1 = _cursor.getString(_cursorIndexOfUserId);
            }
            _tmpUserId = __commonConverters.fromStringToUserId(_tmp_1);
            final AddressId _tmpAddressId;
            final String _tmp_2;
            if (_cursor.isNull(_cursorIndexOfAddressId)) {
              _tmp_2 = null;
            } else {
              _tmp_2 = _cursor.getString(_cursorIndexOfAddressId);
            }
            _tmpAddressId = __userConverters.fromStringToAddressId(_tmp_2);
            final String _tmpEmail;
            if (_cursor.isNull(_cursorIndexOfEmail)) {
              _tmpEmail = null;
            } else {
              _tmpEmail = _cursor.getString(_cursorIndexOfEmail);
            }
            final String _tmpDisplayName;
            if (_cursor.isNull(_cursorIndexOfDisplayName)) {
              _tmpDisplayName = null;
            } else {
              _tmpDisplayName = _cursor.getString(_cursorIndexOfDisplayName);
            }
            final String _tmpSignature;
            if (_cursor.isNull(_cursorIndexOfSignature)) {
              _tmpSignature = null;
            } else {
              _tmpSignature = _cursor.getString(_cursorIndexOfSignature);
            }
            final String _tmpDomainId;
            if (_cursor.isNull(_cursorIndexOfDomainId)) {
              _tmpDomainId = null;
            } else {
              _tmpDomainId = _cursor.getString(_cursorIndexOfDomainId);
            }
            final boolean _tmpCanSend;
            final int _tmp_3;
            _tmp_3 = _cursor.getInt(_cursorIndexOfCanSend);
            _tmpCanSend = _tmp_3 != 0;
            final boolean _tmpCanReceive;
            final int _tmp_4;
            _tmp_4 = _cursor.getInt(_cursorIndexOfCanReceive);
            _tmpCanReceive = _tmp_4 != 0;
            final boolean _tmpEnabled;
            final int _tmp_5;
            _tmp_5 = _cursor.getInt(_cursorIndexOfEnabled);
            _tmpEnabled = _tmp_5 != 0;
            final Integer _tmpType;
            if (_cursor.isNull(_cursorIndexOfType)) {
              _tmpType = null;
            } else {
              _tmpType = _cursor.getInt(_cursorIndexOfType);
            }
            final int _tmpOrder;
            _tmpOrder = _cursor.getInt(_cursorIndexOfOrder);
            final SignedKeyListEntity _tmpSignedKeyList;
            if (! (_cursor.isNull(_cursorIndexOfData) && _cursor.isNull(_cursorIndexOfSignature_1) && _cursor.isNull(_cursorIndexOfMinEpochId) && _cursor.isNull(_cursorIndexOfMaxEpochId) && _cursor.isNull(_cursorIndexOfExpectedMinEpochId))) {
              final String _tmpData;
              if (_cursor.isNull(_cursorIndexOfData)) {
                _tmpData = null;
              } else {
                _tmpData = _cursor.getString(_cursorIndexOfData);
              }
              final String _tmpSignature_1;
              if (_cursor.isNull(_cursorIndexOfSignature_1)) {
                _tmpSignature_1 = null;
              } else {
                _tmpSignature_1 = _cursor.getString(_cursorIndexOfSignature_1);
              }
              final Integer _tmpMinEpochId;
              if (_cursor.isNull(_cursorIndexOfMinEpochId)) {
                _tmpMinEpochId = null;
              } else {
                _tmpMinEpochId = _cursor.getInt(_cursorIndexOfMinEpochId);
              }
              final Integer _tmpMaxEpochId;
              if (_cursor.isNull(_cursorIndexOfMaxEpochId)) {
                _tmpMaxEpochId = null;
              } else {
                _tmpMaxEpochId = _cursor.getInt(_cursorIndexOfMaxEpochId);
              }
              final Integer _tmpExpectedMinEpochId;
              if (_cursor.isNull(_cursorIndexOfExpectedMinEpochId)) {
                _tmpExpectedMinEpochId = null;
              } else {
                _tmpExpectedMinEpochId = _cursor.getInt(_cursorIndexOfExpectedMinEpochId);
              }
              _tmpSignedKeyList = new SignedKeyListEntity(_tmpData,_tmpSignature_1,_tmpMinEpochId,_tmpMaxEpochId,_tmpExpectedMinEpochId);
            }  else  {
              _tmpSignedKeyList = null;
            }
            _item = new AddressEntity(_tmpUserId,_tmpAddressId,_tmpEmail,_tmpDisplayName,_tmpSignature,_tmpDomainId,_tmpCanSend,_tmpCanReceive,_tmpEnabled,_tmpType,_tmpOrder,_tmpSignedKeyList);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object getByAddressId(final AddressId addressId,
      final Continuation<? super AddressEntity> arg1) {
    final String _sql = "SELECT * FROM AddressEntity WHERE addressId = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    final String _tmp = __userConverters.fromAddressIdToString(addressId);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp);
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<AddressEntity>() {
      @Override
      public AddressEntity call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
          final int _cursorIndexOfAddressId = CursorUtil.getColumnIndexOrThrow(_cursor, "addressId");
          final int _cursorIndexOfEmail = CursorUtil.getColumnIndexOrThrow(_cursor, "email");
          final int _cursorIndexOfDisplayName = CursorUtil.getColumnIndexOrThrow(_cursor, "displayName");
          final int _cursorIndexOfSignature = CursorUtil.getColumnIndexOrThrow(_cursor, "signature");
          final int _cursorIndexOfDomainId = CursorUtil.getColumnIndexOrThrow(_cursor, "domainId");
          final int _cursorIndexOfCanSend = CursorUtil.getColumnIndexOrThrow(_cursor, "canSend");
          final int _cursorIndexOfCanReceive = CursorUtil.getColumnIndexOrThrow(_cursor, "canReceive");
          final int _cursorIndexOfEnabled = CursorUtil.getColumnIndexOrThrow(_cursor, "enabled");
          final int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow(_cursor, "type");
          final int _cursorIndexOfOrder = CursorUtil.getColumnIndexOrThrow(_cursor, "order");
          final int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow(_cursor, "signedKeyList_data");
          final int _cursorIndexOfSignature_1 = CursorUtil.getColumnIndexOrThrow(_cursor, "signedKeyList_signature");
          final int _cursorIndexOfMinEpochId = CursorUtil.getColumnIndexOrThrow(_cursor, "signedKeyList_minEpochId");
          final int _cursorIndexOfMaxEpochId = CursorUtil.getColumnIndexOrThrow(_cursor, "signedKeyList_maxEpochId");
          final int _cursorIndexOfExpectedMinEpochId = CursorUtil.getColumnIndexOrThrow(_cursor, "signedKeyList_expectedMinEpochId");
          final AddressEntity _result;
          if(_cursor.moveToFirst()) {
            final UserId _tmpUserId;
            final String _tmp_1;
            if (_cursor.isNull(_cursorIndexOfUserId)) {
              _tmp_1 = null;
            } else {
              _tmp_1 = _cursor.getString(_cursorIndexOfUserId);
            }
            _tmpUserId = __commonConverters.fromStringToUserId(_tmp_1);
            final AddressId _tmpAddressId;
            final String _tmp_2;
            if (_cursor.isNull(_cursorIndexOfAddressId)) {
              _tmp_2 = null;
            } else {
              _tmp_2 = _cursor.getString(_cursorIndexOfAddressId);
            }
            _tmpAddressId = __userConverters.fromStringToAddressId(_tmp_2);
            final String _tmpEmail;
            if (_cursor.isNull(_cursorIndexOfEmail)) {
              _tmpEmail = null;
            } else {
              _tmpEmail = _cursor.getString(_cursorIndexOfEmail);
            }
            final String _tmpDisplayName;
            if (_cursor.isNull(_cursorIndexOfDisplayName)) {
              _tmpDisplayName = null;
            } else {
              _tmpDisplayName = _cursor.getString(_cursorIndexOfDisplayName);
            }
            final String _tmpSignature;
            if (_cursor.isNull(_cursorIndexOfSignature)) {
              _tmpSignature = null;
            } else {
              _tmpSignature = _cursor.getString(_cursorIndexOfSignature);
            }
            final String _tmpDomainId;
            if (_cursor.isNull(_cursorIndexOfDomainId)) {
              _tmpDomainId = null;
            } else {
              _tmpDomainId = _cursor.getString(_cursorIndexOfDomainId);
            }
            final boolean _tmpCanSend;
            final int _tmp_3;
            _tmp_3 = _cursor.getInt(_cursorIndexOfCanSend);
            _tmpCanSend = _tmp_3 != 0;
            final boolean _tmpCanReceive;
            final int _tmp_4;
            _tmp_4 = _cursor.getInt(_cursorIndexOfCanReceive);
            _tmpCanReceive = _tmp_4 != 0;
            final boolean _tmpEnabled;
            final int _tmp_5;
            _tmp_5 = _cursor.getInt(_cursorIndexOfEnabled);
            _tmpEnabled = _tmp_5 != 0;
            final Integer _tmpType;
            if (_cursor.isNull(_cursorIndexOfType)) {
              _tmpType = null;
            } else {
              _tmpType = _cursor.getInt(_cursorIndexOfType);
            }
            final int _tmpOrder;
            _tmpOrder = _cursor.getInt(_cursorIndexOfOrder);
            final SignedKeyListEntity _tmpSignedKeyList;
            if (! (_cursor.isNull(_cursorIndexOfData) && _cursor.isNull(_cursorIndexOfSignature_1) && _cursor.isNull(_cursorIndexOfMinEpochId) && _cursor.isNull(_cursorIndexOfMaxEpochId) && _cursor.isNull(_cursorIndexOfExpectedMinEpochId))) {
              final String _tmpData;
              if (_cursor.isNull(_cursorIndexOfData)) {
                _tmpData = null;
              } else {
                _tmpData = _cursor.getString(_cursorIndexOfData);
              }
              final String _tmpSignature_1;
              if (_cursor.isNull(_cursorIndexOfSignature_1)) {
                _tmpSignature_1 = null;
              } else {
                _tmpSignature_1 = _cursor.getString(_cursorIndexOfSignature_1);
              }
              final Integer _tmpMinEpochId;
              if (_cursor.isNull(_cursorIndexOfMinEpochId)) {
                _tmpMinEpochId = null;
              } else {
                _tmpMinEpochId = _cursor.getInt(_cursorIndexOfMinEpochId);
              }
              final Integer _tmpMaxEpochId;
              if (_cursor.isNull(_cursorIndexOfMaxEpochId)) {
                _tmpMaxEpochId = null;
              } else {
                _tmpMaxEpochId = _cursor.getInt(_cursorIndexOfMaxEpochId);
              }
              final Integer _tmpExpectedMinEpochId;
              if (_cursor.isNull(_cursorIndexOfExpectedMinEpochId)) {
                _tmpExpectedMinEpochId = null;
              } else {
                _tmpExpectedMinEpochId = _cursor.getInt(_cursorIndexOfExpectedMinEpochId);
              }
              _tmpSignedKeyList = new SignedKeyListEntity(_tmpData,_tmpSignature_1,_tmpMinEpochId,_tmpMaxEpochId,_tmpExpectedMinEpochId);
            }  else  {
              _tmpSignedKeyList = null;
            }
            _result = new AddressEntity(_tmpUserId,_tmpAddressId,_tmpEmail,_tmpDisplayName,_tmpSignature,_tmpDomainId,_tmpCanSend,_tmpCanReceive,_tmpEnabled,_tmpType,_tmpOrder,_tmpSignedKeyList);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, arg1);
  }

  @Override
  public Object getByUserId(final UserId userId,
      final Continuation<? super List<AddressEntity>> arg1) {
    final String _sql = "SELECT * FROM AddressEntity WHERE userId = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    final String _tmp = __commonConverters.fromUserIdToString(userId);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp);
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<AddressEntity>>() {
      @Override
      public List<AddressEntity> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
          final int _cursorIndexOfAddressId = CursorUtil.getColumnIndexOrThrow(_cursor, "addressId");
          final int _cursorIndexOfEmail = CursorUtil.getColumnIndexOrThrow(_cursor, "email");
          final int _cursorIndexOfDisplayName = CursorUtil.getColumnIndexOrThrow(_cursor, "displayName");
          final int _cursorIndexOfSignature = CursorUtil.getColumnIndexOrThrow(_cursor, "signature");
          final int _cursorIndexOfDomainId = CursorUtil.getColumnIndexOrThrow(_cursor, "domainId");
          final int _cursorIndexOfCanSend = CursorUtil.getColumnIndexOrThrow(_cursor, "canSend");
          final int _cursorIndexOfCanReceive = CursorUtil.getColumnIndexOrThrow(_cursor, "canReceive");
          final int _cursorIndexOfEnabled = CursorUtil.getColumnIndexOrThrow(_cursor, "enabled");
          final int _cursorIndexOfType = CursorUtil.getColumnIndexOrThrow(_cursor, "type");
          final int _cursorIndexOfOrder = CursorUtil.getColumnIndexOrThrow(_cursor, "order");
          final int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow(_cursor, "signedKeyList_data");
          final int _cursorIndexOfSignature_1 = CursorUtil.getColumnIndexOrThrow(_cursor, "signedKeyList_signature");
          final int _cursorIndexOfMinEpochId = CursorUtil.getColumnIndexOrThrow(_cursor, "signedKeyList_minEpochId");
          final int _cursorIndexOfMaxEpochId = CursorUtil.getColumnIndexOrThrow(_cursor, "signedKeyList_maxEpochId");
          final int _cursorIndexOfExpectedMinEpochId = CursorUtil.getColumnIndexOrThrow(_cursor, "signedKeyList_expectedMinEpochId");
          final List<AddressEntity> _result = new ArrayList<AddressEntity>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final AddressEntity _item;
            final UserId _tmpUserId;
            final String _tmp_1;
            if (_cursor.isNull(_cursorIndexOfUserId)) {
              _tmp_1 = null;
            } else {
              _tmp_1 = _cursor.getString(_cursorIndexOfUserId);
            }
            _tmpUserId = __commonConverters.fromStringToUserId(_tmp_1);
            final AddressId _tmpAddressId;
            final String _tmp_2;
            if (_cursor.isNull(_cursorIndexOfAddressId)) {
              _tmp_2 = null;
            } else {
              _tmp_2 = _cursor.getString(_cursorIndexOfAddressId);
            }
            _tmpAddressId = __userConverters.fromStringToAddressId(_tmp_2);
            final String _tmpEmail;
            if (_cursor.isNull(_cursorIndexOfEmail)) {
              _tmpEmail = null;
            } else {
              _tmpEmail = _cursor.getString(_cursorIndexOfEmail);
            }
            final String _tmpDisplayName;
            if (_cursor.isNull(_cursorIndexOfDisplayName)) {
              _tmpDisplayName = null;
            } else {
              _tmpDisplayName = _cursor.getString(_cursorIndexOfDisplayName);
            }
            final String _tmpSignature;
            if (_cursor.isNull(_cursorIndexOfSignature)) {
              _tmpSignature = null;
            } else {
              _tmpSignature = _cursor.getString(_cursorIndexOfSignature);
            }
            final String _tmpDomainId;
            if (_cursor.isNull(_cursorIndexOfDomainId)) {
              _tmpDomainId = null;
            } else {
              _tmpDomainId = _cursor.getString(_cursorIndexOfDomainId);
            }
            final boolean _tmpCanSend;
            final int _tmp_3;
            _tmp_3 = _cursor.getInt(_cursorIndexOfCanSend);
            _tmpCanSend = _tmp_3 != 0;
            final boolean _tmpCanReceive;
            final int _tmp_4;
            _tmp_4 = _cursor.getInt(_cursorIndexOfCanReceive);
            _tmpCanReceive = _tmp_4 != 0;
            final boolean _tmpEnabled;
            final int _tmp_5;
            _tmp_5 = _cursor.getInt(_cursorIndexOfEnabled);
            _tmpEnabled = _tmp_5 != 0;
            final Integer _tmpType;
            if (_cursor.isNull(_cursorIndexOfType)) {
              _tmpType = null;
            } else {
              _tmpType = _cursor.getInt(_cursorIndexOfType);
            }
            final int _tmpOrder;
            _tmpOrder = _cursor.getInt(_cursorIndexOfOrder);
            final SignedKeyListEntity _tmpSignedKeyList;
            if (! (_cursor.isNull(_cursorIndexOfData) && _cursor.isNull(_cursorIndexOfSignature_1) && _cursor.isNull(_cursorIndexOfMinEpochId) && _cursor.isNull(_cursorIndexOfMaxEpochId) && _cursor.isNull(_cursorIndexOfExpectedMinEpochId))) {
              final String _tmpData;
              if (_cursor.isNull(_cursorIndexOfData)) {
                _tmpData = null;
              } else {
                _tmpData = _cursor.getString(_cursorIndexOfData);
              }
              final String _tmpSignature_1;
              if (_cursor.isNull(_cursorIndexOfSignature_1)) {
                _tmpSignature_1 = null;
              } else {
                _tmpSignature_1 = _cursor.getString(_cursorIndexOfSignature_1);
              }
              final Integer _tmpMinEpochId;
              if (_cursor.isNull(_cursorIndexOfMinEpochId)) {
                _tmpMinEpochId = null;
              } else {
                _tmpMinEpochId = _cursor.getInt(_cursorIndexOfMinEpochId);
              }
              final Integer _tmpMaxEpochId;
              if (_cursor.isNull(_cursorIndexOfMaxEpochId)) {
                _tmpMaxEpochId = null;
              } else {
                _tmpMaxEpochId = _cursor.getInt(_cursorIndexOfMaxEpochId);
              }
              final Integer _tmpExpectedMinEpochId;
              if (_cursor.isNull(_cursorIndexOfExpectedMinEpochId)) {
                _tmpExpectedMinEpochId = null;
              } else {
                _tmpExpectedMinEpochId = _cursor.getInt(_cursorIndexOfExpectedMinEpochId);
              }
              _tmpSignedKeyList = new SignedKeyListEntity(_tmpData,_tmpSignature_1,_tmpMinEpochId,_tmpMaxEpochId,_tmpExpectedMinEpochId);
            }  else  {
              _tmpSignedKeyList = null;
            }
            _item = new AddressEntity(_tmpUserId,_tmpAddressId,_tmpEmail,_tmpDisplayName,_tmpSignature,_tmpDomainId,_tmpCanSend,_tmpCanReceive,_tmpEnabled,_tmpType,_tmpOrder,_tmpSignedKeyList);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, arg1);
  }

  @Override
  public Object delete(final List<AddressId> addressIds, final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("DELETE FROM AddressEntity WHERE addressId IN (");
        final int _inputSize = addressIds.size();
        StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
        _stringBuilder.append(")");
        final String _sql = _stringBuilder.toString();
        final SupportSQLiteStatement _stmt = __db.compileStatement(_sql);
        int _argIndex = 1;
        for (AddressId _item : addressIds) {
          final String _tmp = __userConverters.fromAddressIdToString(_item);
          if (_tmp == null) {
            _stmt.bindNull(_argIndex);
          } else {
            _stmt.bindString(_argIndex, _tmp);
          }
          _argIndex ++;
        }
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
