package me.proton.core.telemetry.data.db;

import android.database.Cursor;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import me.proton.core.data.room.db.CommonConverters;
import me.proton.core.domain.entity.UserId;
import me.proton.core.telemetry.data.entity.TelemetryEventEntity;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class TelemetryDao_Impl extends TelemetryDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<TelemetryEventEntity> __insertionAdapterOfTelemetryEventEntity;

  private final CommonConverters __commonConverters = new CommonConverters();

  private final EntityDeletionOrUpdateAdapter<TelemetryEventEntity> __deletionAdapterOfTelemetryEventEntity;

  private final EntityDeletionOrUpdateAdapter<TelemetryEventEntity> __updateAdapterOfTelemetryEventEntity;

  private final SharedSQLiteStatement __preparedStmtOfDeleteAllUnAuth$telemetry_data_release;

  private final SharedSQLiteStatement __preparedStmtOfDeleteAll$telemetry_data_release;

  public TelemetryDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfTelemetryEventEntity = new EntityInsertionAdapter<TelemetryEventEntity>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR IGNORE INTO `TelemetryEventEntity` (`id`,`userId`,`group`,`name`,`values`,`dimensions`,`timestamp`) VALUES (nullif(?, 0),?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, TelemetryEventEntity value) {
        stmt.bindLong(1, value.getId());
        final String _tmp = __commonConverters.fromUserIdToString(value.getUserId());
        if (_tmp == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, _tmp);
        }
        if (value.getGroup() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getGroup());
        }
        if (value.getName() == null) {
          stmt.bindNull(4);
        } else {
          stmt.bindString(4, value.getName());
        }
        if (value.getValues() == null) {
          stmt.bindNull(5);
        } else {
          stmt.bindString(5, value.getValues());
        }
        if (value.getDimensions() == null) {
          stmt.bindNull(6);
        } else {
          stmt.bindString(6, value.getDimensions());
        }
        stmt.bindLong(7, value.getTimestamp());
      }
    };
    this.__deletionAdapterOfTelemetryEventEntity = new EntityDeletionOrUpdateAdapter<TelemetryEventEntity>(__db) {
      @Override
      public String createQuery() {
        return "DELETE FROM `TelemetryEventEntity` WHERE `id` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, TelemetryEventEntity value) {
        stmt.bindLong(1, value.getId());
      }
    };
    this.__updateAdapterOfTelemetryEventEntity = new EntityDeletionOrUpdateAdapter<TelemetryEventEntity>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `TelemetryEventEntity` SET `id` = ?,`userId` = ?,`group` = ?,`name` = ?,`values` = ?,`dimensions` = ?,`timestamp` = ? WHERE `id` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, TelemetryEventEntity value) {
        stmt.bindLong(1, value.getId());
        final String _tmp = __commonConverters.fromUserIdToString(value.getUserId());
        if (_tmp == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, _tmp);
        }
        if (value.getGroup() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getGroup());
        }
        if (value.getName() == null) {
          stmt.bindNull(4);
        } else {
          stmt.bindString(4, value.getName());
        }
        if (value.getValues() == null) {
          stmt.bindNull(5);
        } else {
          stmt.bindString(5, value.getValues());
        }
        if (value.getDimensions() == null) {
          stmt.bindNull(6);
        } else {
          stmt.bindString(6, value.getDimensions());
        }
        stmt.bindLong(7, value.getTimestamp());
        stmt.bindLong(8, value.getId());
      }
    };
    this.__preparedStmtOfDeleteAllUnAuth$telemetry_data_release = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "DELETE FROM TelemetryEventEntity WHERE userId IS NULL";
        return _query;
      }
    };
    this.__preparedStmtOfDeleteAll$telemetry_data_release = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "DELETE FROM TelemetryEventEntity WHERE userId = ?";
        return _query;
      }
    };
  }

  @Override
  public Object insertOrIgnore(final TelemetryEventEntity[] entities,
      final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfTelemetryEventEntity.insert(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object delete(final TelemetryEventEntity[] entities,
      final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __deletionAdapterOfTelemetryEventEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object update(final TelemetryEventEntity[] entities,
      final Continuation<? super Integer> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      public Integer call() throws Exception {
        int _total = 0;
        __db.beginTransaction();
        try {
          _total +=__updateAdapterOfTelemetryEventEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return _total;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object insertOrUpdate(final TelemetryEventEntity[] entities,
      final Continuation<? super Unit> $completion) {
    return RoomDatabaseKt.withTransaction(__db, (__cont) -> TelemetryDao_Impl.super.insertOrUpdate(entities, __cont), $completion);
  }

  @Override
  public Object deleteAllUnAuth$telemetry_data_release(final Continuation<? super Unit> arg0) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteAllUnAuth$telemetry_data_release.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfDeleteAllUnAuth$telemetry_data_release.release(_stmt);
        }
      }
    }, arg0);
  }

  @Override
  public Object deleteAll$telemetry_data_release(final UserId userId,
      final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteAll$telemetry_data_release.acquire();
        int _argIndex = 1;
        final String _tmp = __commonConverters.fromUserIdToString(userId);
        if (_tmp == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, _tmp);
        }
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfDeleteAll$telemetry_data_release.release(_stmt);
        }
      }
    }, arg1);
  }

  @Override
  public List<TelemetryEventEntity> getAllUnAuth$telemetry_data_release(final int limit) {
    final String _sql = "SELECT * FROM TelemetryEventEntity WHERE userId IS NULL ORDER BY timestamp DESC LIMIT ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, limit);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow(_cursor, "id");
      final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
      final int _cursorIndexOfGroup = CursorUtil.getColumnIndexOrThrow(_cursor, "group");
      final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "name");
      final int _cursorIndexOfValues = CursorUtil.getColumnIndexOrThrow(_cursor, "values");
      final int _cursorIndexOfDimensions = CursorUtil.getColumnIndexOrThrow(_cursor, "dimensions");
      final int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow(_cursor, "timestamp");
      final List<TelemetryEventEntity> _result = new ArrayList<TelemetryEventEntity>(_cursor.getCount());
      while(_cursor.moveToNext()) {
        final TelemetryEventEntity _item;
        final long _tmpId;
        _tmpId = _cursor.getLong(_cursorIndexOfId);
        final UserId _tmpUserId;
        final String _tmp;
        if (_cursor.isNull(_cursorIndexOfUserId)) {
          _tmp = null;
        } else {
          _tmp = _cursor.getString(_cursorIndexOfUserId);
        }
        _tmpUserId = __commonConverters.fromStringToUserId(_tmp);
        final String _tmpGroup;
        if (_cursor.isNull(_cursorIndexOfGroup)) {
          _tmpGroup = null;
        } else {
          _tmpGroup = _cursor.getString(_cursorIndexOfGroup);
        }
        final String _tmpName;
        if (_cursor.isNull(_cursorIndexOfName)) {
          _tmpName = null;
        } else {
          _tmpName = _cursor.getString(_cursorIndexOfName);
        }
        final String _tmpValues;
        if (_cursor.isNull(_cursorIndexOfValues)) {
          _tmpValues = null;
        } else {
          _tmpValues = _cursor.getString(_cursorIndexOfValues);
        }
        final String _tmpDimensions;
        if (_cursor.isNull(_cursorIndexOfDimensions)) {
          _tmpDimensions = null;
        } else {
          _tmpDimensions = _cursor.getString(_cursorIndexOfDimensions);
        }
        final long _tmpTimestamp;
        _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
        _item = new TelemetryEventEntity(_tmpId,_tmpUserId,_tmpGroup,_tmpName,_tmpValues,_tmpDimensions,_tmpTimestamp);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public List<TelemetryEventEntity> getAll$telemetry_data_release(final UserId userId,
      final int limit) {
    final String _sql = "SELECT * FROM TelemetryEventEntity WHERE userId = ? ORDER BY timestamp DESC LIMIT ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    final String _tmp = __commonConverters.fromUserIdToString(userId);
    if (_tmp == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, _tmp);
    }
    _argIndex = 2;
    _statement.bindLong(_argIndex, limit);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow(_cursor, "id");
      final int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow(_cursor, "userId");
      final int _cursorIndexOfGroup = CursorUtil.getColumnIndexOrThrow(_cursor, "group");
      final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "name");
      final int _cursorIndexOfValues = CursorUtil.getColumnIndexOrThrow(_cursor, "values");
      final int _cursorIndexOfDimensions = CursorUtil.getColumnIndexOrThrow(_cursor, "dimensions");
      final int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow(_cursor, "timestamp");
      final List<TelemetryEventEntity> _result = new ArrayList<TelemetryEventEntity>(_cursor.getCount());
      while(_cursor.moveToNext()) {
        final TelemetryEventEntity _item;
        final long _tmpId;
        _tmpId = _cursor.getLong(_cursorIndexOfId);
        final UserId _tmpUserId;
        final String _tmp_1;
        if (_cursor.isNull(_cursorIndexOfUserId)) {
          _tmp_1 = null;
        } else {
          _tmp_1 = _cursor.getString(_cursorIndexOfUserId);
        }
        _tmpUserId = __commonConverters.fromStringToUserId(_tmp_1);
        final String _tmpGroup;
        if (_cursor.isNull(_cursorIndexOfGroup)) {
          _tmpGroup = null;
        } else {
          _tmpGroup = _cursor.getString(_cursorIndexOfGroup);
        }
        final String _tmpName;
        if (_cursor.isNull(_cursorIndexOfName)) {
          _tmpName = null;
        } else {
          _tmpName = _cursor.getString(_cursorIndexOfName);
        }
        final String _tmpValues;
        if (_cursor.isNull(_cursorIndexOfValues)) {
          _tmpValues = null;
        } else {
          _tmpValues = _cursor.getString(_cursorIndexOfValues);
        }
        final String _tmpDimensions;
        if (_cursor.isNull(_cursorIndexOfDimensions)) {
          _tmpDimensions = null;
        } else {
          _tmpDimensions = _cursor.getString(_cursorIndexOfDimensions);
        }
        final long _tmpTimestamp;
        _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
        _item = new TelemetryEventEntity(_tmpId,_tmpUserId,_tmpGroup,_tmpName,_tmpValues,_tmpDimensions,_tmpTimestamp);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
