package me.proton.core.key.data.db;

import android.database.Cursor;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomDatabaseKt;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;
import me.proton.core.key.data.entity.PublicAddressEntity;
import me.proton.core.key.data.entity.SignedKeyListEntity;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class PublicAddressDao_Impl extends PublicAddressDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<PublicAddressEntity> __insertionAdapterOfPublicAddressEntity;

  private final EntityDeletionOrUpdateAdapter<PublicAddressEntity> __deletionAdapterOfPublicAddressEntity;

  private final EntityDeletionOrUpdateAdapter<PublicAddressEntity> __updateAdapterOfPublicAddressEntity;

  private final SharedSQLiteStatement __preparedStmtOfDeleteByEmail;

  private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

  public PublicAddressDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfPublicAddressEntity = new EntityInsertionAdapter<PublicAddressEntity>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR IGNORE INTO `PublicAddressEntity` (`email`,`recipientType`,`mimeType`,`ignoreKT`,`signedKeyList_data`,`signedKeyList_signature`,`signedKeyList_minEpochId`,`signedKeyList_maxEpochId`,`signedKeyList_expectedMinEpochId`) VALUES (?,?,?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, PublicAddressEntity value) {
        if (value.getEmail() == null) {
          stmt.bindNull(1);
        } else {
          stmt.bindString(1, value.getEmail());
        }
        stmt.bindLong(2, value.getRecipientType());
        if (value.getMimeType() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getMimeType());
        }
        if (value.getIgnoreKT() == null) {
          stmt.bindNull(4);
        } else {
          stmt.bindLong(4, value.getIgnoreKT());
        }
        final SignedKeyListEntity _tmpSignedKeyListEntity = value.getSignedKeyListEntity();
        if(_tmpSignedKeyListEntity != null) {
          if (_tmpSignedKeyListEntity.getData() == null) {
            stmt.bindNull(5);
          } else {
            stmt.bindString(5, _tmpSignedKeyListEntity.getData());
          }
          if (_tmpSignedKeyListEntity.getSignature() == null) {
            stmt.bindNull(6);
          } else {
            stmt.bindString(6, _tmpSignedKeyListEntity.getSignature());
          }
          if (_tmpSignedKeyListEntity.getMinEpochId() == null) {
            stmt.bindNull(7);
          } else {
            stmt.bindLong(7, _tmpSignedKeyListEntity.getMinEpochId());
          }
          if (_tmpSignedKeyListEntity.getMaxEpochId() == null) {
            stmt.bindNull(8);
          } else {
            stmt.bindLong(8, _tmpSignedKeyListEntity.getMaxEpochId());
          }
          if (_tmpSignedKeyListEntity.getExpectedMinEpochId() == null) {
            stmt.bindNull(9);
          } else {
            stmt.bindLong(9, _tmpSignedKeyListEntity.getExpectedMinEpochId());
          }
        } else {
          stmt.bindNull(5);
          stmt.bindNull(6);
          stmt.bindNull(7);
          stmt.bindNull(8);
          stmt.bindNull(9);
        }
      }
    };
    this.__deletionAdapterOfPublicAddressEntity = new EntityDeletionOrUpdateAdapter<PublicAddressEntity>(__db) {
      @Override
      public String createQuery() {
        return "DELETE FROM `PublicAddressEntity` WHERE `email` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, PublicAddressEntity value) {
        if (value.getEmail() == null) {
          stmt.bindNull(1);
        } else {
          stmt.bindString(1, value.getEmail());
        }
      }
    };
    this.__updateAdapterOfPublicAddressEntity = new EntityDeletionOrUpdateAdapter<PublicAddressEntity>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `PublicAddressEntity` SET `email` = ?,`recipientType` = ?,`mimeType` = ?,`ignoreKT` = ?,`signedKeyList_data` = ?,`signedKeyList_signature` = ?,`signedKeyList_minEpochId` = ?,`signedKeyList_maxEpochId` = ?,`signedKeyList_expectedMinEpochId` = ? WHERE `email` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, PublicAddressEntity value) {
        if (value.getEmail() == null) {
          stmt.bindNull(1);
        } else {
          stmt.bindString(1, value.getEmail());
        }
        stmt.bindLong(2, value.getRecipientType());
        if (value.getMimeType() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getMimeType());
        }
        if (value.getIgnoreKT() == null) {
          stmt.bindNull(4);
        } else {
          stmt.bindLong(4, value.getIgnoreKT());
        }
        final SignedKeyListEntity _tmpSignedKeyListEntity = value.getSignedKeyListEntity();
        if(_tmpSignedKeyListEntity != null) {
          if (_tmpSignedKeyListEntity.getData() == null) {
            stmt.bindNull(5);
          } else {
            stmt.bindString(5, _tmpSignedKeyListEntity.getData());
          }
          if (_tmpSignedKeyListEntity.getSignature() == null) {
            stmt.bindNull(6);
          } else {
            stmt.bindString(6, _tmpSignedKeyListEntity.getSignature());
          }
          if (_tmpSignedKeyListEntity.getMinEpochId() == null) {
            stmt.bindNull(7);
          } else {
            stmt.bindLong(7, _tmpSignedKeyListEntity.getMinEpochId());
          }
          if (_tmpSignedKeyListEntity.getMaxEpochId() == null) {
            stmt.bindNull(8);
          } else {
            stmt.bindLong(8, _tmpSignedKeyListEntity.getMaxEpochId());
          }
          if (_tmpSignedKeyListEntity.getExpectedMinEpochId() == null) {
            stmt.bindNull(9);
          } else {
            stmt.bindLong(9, _tmpSignedKeyListEntity.getExpectedMinEpochId());
          }
        } else {
          stmt.bindNull(5);
          stmt.bindNull(6);
          stmt.bindNull(7);
          stmt.bindNull(8);
          stmt.bindNull(9);
        }
        if (value.getEmail() == null) {
          stmt.bindNull(10);
        } else {
          stmt.bindString(10, value.getEmail());
        }
      }
    };
    this.__preparedStmtOfDeleteByEmail = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "DELETE FROM PublicAddressEntity WHERE email = ?";
        return _query;
      }
    };
    this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "DELETE FROM PublicAddressEntity";
        return _query;
      }
    };
  }

  @Override
  public Object insertOrIgnore(final PublicAddressEntity[] entities,
      final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfPublicAddressEntity.insert(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object delete(final PublicAddressEntity[] entities,
      final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __deletionAdapterOfPublicAddressEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object update(final PublicAddressEntity[] entities,
      final Continuation<? super Integer> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      public Integer call() throws Exception {
        int _total = 0;
        __db.beginTransaction();
        try {
          _total +=__updateAdapterOfPublicAddressEntity.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return _total;
        } finally {
          __db.endTransaction();
        }
      }
    }, arg1);
  }

  @Override
  public Object insertOrUpdate(final PublicAddressEntity[] entities,
      final Continuation<? super Unit> $completion) {
    return RoomDatabaseKt.withTransaction(__db, (__cont) -> PublicAddressDao_Impl.super.insertOrUpdate(entities, __cont), $completion);
  }

  @Override
  public Object deleteByEmail(final String email, final Continuation<? super Unit> arg1) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteByEmail.acquire();
        int _argIndex = 1;
        if (email == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, email);
        }
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfDeleteByEmail.release(_stmt);
        }
      }
    }, arg1);
  }

  @Override
  public Object deleteAll(final Continuation<? super Unit> arg0) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteAll.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfDeleteAll.release(_stmt);
        }
      }
    }, arg0);
  }

  @Override
  public Flow<PublicAddressEntity> findByEmail(final String email) {
    final String _sql = "SELECT * FROM PublicAddressEntity WHERE email = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    if (email == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, email);
    }
    return CoroutinesRoom.createFlow(__db, false, new String[]{"PublicAddressEntity"}, new Callable<PublicAddressEntity>() {
      @Override
      public PublicAddressEntity call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfEmail = CursorUtil.getColumnIndexOrThrow(_cursor, "email");
          final int _cursorIndexOfRecipientType = CursorUtil.getColumnIndexOrThrow(_cursor, "recipientType");
          final int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow(_cursor, "mimeType");
          final int _cursorIndexOfIgnoreKT = CursorUtil.getColumnIndexOrThrow(_cursor, "ignoreKT");
          final int _cursorIndexOfData = CursorUtil.getColumnIndexOrThrow(_cursor, "signedKeyList_data");
          final int _cursorIndexOfSignature = CursorUtil.getColumnIndexOrThrow(_cursor, "signedKeyList_signature");
          final int _cursorIndexOfMinEpochId = CursorUtil.getColumnIndexOrThrow(_cursor, "signedKeyList_minEpochId");
          final int _cursorIndexOfMaxEpochId = CursorUtil.getColumnIndexOrThrow(_cursor, "signedKeyList_maxEpochId");
          final int _cursorIndexOfExpectedMinEpochId = CursorUtil.getColumnIndexOrThrow(_cursor, "signedKeyList_expectedMinEpochId");
          final PublicAddressEntity _result;
          if(_cursor.moveToFirst()) {
            final String _tmpEmail;
            if (_cursor.isNull(_cursorIndexOfEmail)) {
              _tmpEmail = null;
            } else {
              _tmpEmail = _cursor.getString(_cursorIndexOfEmail);
            }
            final int _tmpRecipientType;
            _tmpRecipientType = _cursor.getInt(_cursorIndexOfRecipientType);
            final String _tmpMimeType;
            if (_cursor.isNull(_cursorIndexOfMimeType)) {
              _tmpMimeType = null;
            } else {
              _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
            }
            final Integer _tmpIgnoreKT;
            if (_cursor.isNull(_cursorIndexOfIgnoreKT)) {
              _tmpIgnoreKT = null;
            } else {
              _tmpIgnoreKT = _cursor.getInt(_cursorIndexOfIgnoreKT);
            }
            final SignedKeyListEntity _tmpSignedKeyListEntity;
            if (! (_cursor.isNull(_cursorIndexOfData) && _cursor.isNull(_cursorIndexOfSignature) && _cursor.isNull(_cursorIndexOfMinEpochId) && _cursor.isNull(_cursorIndexOfMaxEpochId) && _cursor.isNull(_cursorIndexOfExpectedMinEpochId))) {
              final String _tmpData;
              if (_cursor.isNull(_cursorIndexOfData)) {
                _tmpData = null;
              } else {
                _tmpData = _cursor.getString(_cursorIndexOfData);
              }
              final String _tmpSignature;
              if (_cursor.isNull(_cursorIndexOfSignature)) {
                _tmpSignature = null;
              } else {
                _tmpSignature = _cursor.getString(_cursorIndexOfSignature);
              }
              final Integer _tmpMinEpochId;
              if (_cursor.isNull(_cursorIndexOfMinEpochId)) {
                _tmpMinEpochId = null;
              } else {
                _tmpMinEpochId = _cursor.getInt(_cursorIndexOfMinEpochId);
              }
              final Integer _tmpMaxEpochId;
              if (_cursor.isNull(_cursorIndexOfMaxEpochId)) {
                _tmpMaxEpochId = null;
              } else {
                _tmpMaxEpochId = _cursor.getInt(_cursorIndexOfMaxEpochId);
              }
              final Integer _tmpExpectedMinEpochId;
              if (_cursor.isNull(_cursorIndexOfExpectedMinEpochId)) {
                _tmpExpectedMinEpochId = null;
              } else {
                _tmpExpectedMinEpochId = _cursor.getInt(_cursorIndexOfExpectedMinEpochId);
              }
              _tmpSignedKeyListEntity = new SignedKeyListEntity(_tmpData,_tmpSignature,_tmpMinEpochId,_tmpMaxEpochId,_tmpExpectedMinEpochId);
            }  else  {
              _tmpSignedKeyListEntity = null;
            }
            _result = new PublicAddressEntity(_tmpEmail,_tmpRecipientType,_tmpMimeType,_tmpSignedKeyListEntity,_tmpIgnoreKT);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
